/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.datatables.SkillLearnData;
import com.l2jserver.gameserver.datatables.StringIntern;
import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.enums.AISkillScope;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.drops.DropListScope;
import com.l2jserver.gameserver.model.drops.GeneralDropItem;
import com.l2jserver.gameserver.model.drops.GroupedGeneralDropItem;
import com.l2jserver.gameserver.model.drops.IDropItem;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.holders.MinionHolder;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.util.FilenameSortComparator;
import com.l2jserver.gameserver.util.UnmodifiableArrayList;
import com.l2jserver.util.Util;
import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jp.sf.l2j.troja.FastIntObjectMap;
import jp.sf.l2j.troja.IntObjectMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NpcData
extends DocumentParser {
    private final FastIntObjectMap<L2NpcTemplate> _npcs = new FastIntObjectMap();
    private final HashMap<String, Integer> _clans = new HashMap();
    FastIntObjectMap<MinionHolder[]> minionData;
    public static final int CLAN_ALL = 0;

    protected NpcData() {
        this._clans.put("ALL", 0);
        this.load();
    }

    @Override
    public synchronized void load() {
        StringIntern.begin(this.getClass().getSimpleName());
        StringIntern.intern("L2Npc");
        StringIntern.intern("ALL");
        long started = System.currentTimeMillis();
        this.minionData = (NpcData)this.new MinionData().minionData;
        this.parseDatapackDirectory("data/stats/npcs", false);
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + this._npcs.size() + " NPCs. (" + Util.strMillTime(System.currentTimeMillis() - started) + ")");
        if (Config.CUSTOM_NPC_DATA) {
            int npcCount = this._npcs.size();
            started = System.currentTimeMillis();
            this.parseDatapackDirectory("data/stats/npcs/custom", true);
            this._log.info(this.getClass().getSimpleName() + ": Loaded " + (this._npcs.size() - npcCount) + " Custom NPCs. (" + Util.strMillTime(System.currentTimeMillis() - started) + ")");
        }
        StringIntern.end();
        this.loadNpcsSkillLearn();
    }

    public void load(String file) {
        StringIntern.begin(this.getClass().getSimpleName());
        this.parseDatapackFile(file);
        StringIntern.end();
    }

    @Override
    protected void parseDocument() {
        for (Node node = this.getCurrentDocument().getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!"list".equalsIgnoreCase(node.getNodeName())) continue;
            for (Node list_node = node.getFirstChild(); list_node != null; list_node = list_node.getNextSibling()) {
                if (!"npc".equalsIgnoreCase(list_node.getNodeName())) continue;
                NamedNodeMap attrs = list_node.getAttributes();
                StatsSet set = new StatsSet();
                int npcId = this.parseInt(attrs, "id");
                HashMap<String, Object> parameters = null;
                ArrayList<Skill> skills = null;
                EnumMap<AISkillScope, ArrayList<Skill>> aiSkillLists = null;
                TIntArrayList clans = null;
                TIntArrayList ignoreClanNpcIds = null;
                EnumMap<DropListScope, List<IDropItem>> dropLists = null;
                set.set("id", npcId);
                set.set("displayId", this.parseInteger(attrs, "displayId"));
                set.set("level", this.parseByte(attrs, "level"));
                set.set("type", this.parseString(attrs, "type"));
                set.set("name", this.parseString(attrs, "name"));
                set.set("usingServerSideName", this.parseBoolean(attrs, "usingServerSideName"));
                set.set("title", this.parseString(attrs, "title"));
                set.set("usingServerSideTitle", this.parseBoolean(attrs, "usingServerSideTitle"));
                int displayId = set.getInt("displayId", npcId);
                if (displayId != npcId) {
                    L2NpcTemplate v = (L2NpcTemplate)this._npcs.get(displayId);
                    if (v != null) {
                        set.set("collision_radius", v.getCollisionRadius());
                        set.set("collisionRadiusGrown", v.getCollisionRadiusGrown());
                        set.set("collision_height", v.getCollisionHeight());
                        set.set("collisionHeightGrown", v.getCollisionHeightGrown());
                        set.set("canMove", v.canMove());
                        set.set("chestId", v.getChestId());
                        set.set("rhandId", v.getRHandId());
                        set.set("lhandId", v.getLHandId());
                        if (set.getString("name", null) == null) {
                            set.set("name", v.getName());
                        } else {
                            set.set("usingServerSideName", true);
                        }
                        if (set.getString("title", null) == null) {
                            set.set("title", v.getTitle());
                        } else {
                            set.set("usingServerSideTitle", true);
                        }
                    } else {
                        this._log.warning("NpcData: Undefined displayId in " + this.getCurrentFile().getName() + " <npc id=" + npcId + " displayId=" + displayId + " ...>");
                    }
                }
                block119: for (Node npc_node = list_node.getFirstChild(); npc_node != null; npc_node = npc_node.getNextSibling()) {
                    attrs = npc_node.getAttributes();
                    switch (npc_node.getNodeName().toLowerCase()) {
                        case "parameters": {
                            if (parameters == null) {
                                parameters = new HashMap<String, Object>();
                            }
                            block120: for (Node parameters_node = npc_node.getFirstChild(); parameters_node != null; parameters_node = parameters_node.getNextSibling()) {
                                attrs = parameters_node.getAttributes();
                                switch (parameters_node.getNodeName().toLowerCase()) {
                                    case "param": {
                                        parameters.put(this.parseString(attrs, "name"), this.parseString(attrs, "value"));
                                        continue block120;
                                    }
                                    case "skill": {
                                        parameters.put(this.parseString(attrs, "name"), new SkillHolder(this.parseInt(attrs, "id"), this.parseInt(attrs, "level")));
                                        continue block120;
                                    }
                                    case "minions": {
                                        ArrayList<MinionHolder> minions = new ArrayList<MinionHolder>(1);
                                        for (Object minions_node = parameters_node.getFirstChild(); minions_node != null; minions_node = minions_node.getNextSibling()) {
                                            if (!minions_node.getNodeName().equalsIgnoreCase("npc")) continue;
                                            attrs = minions_node.getAttributes();
                                            minions.add(new MinionHolder(this.parseInt(attrs, "id"), this.parseInt(attrs, "count"), this.parseInt(attrs, "respawnTime"), this.parseInt(attrs, "weightPoint")));
                                        }
                                        if (minions.isEmpty()) continue block120;
                                        parameters.put(this.parseString(parameters_node.getAttributes(), "name"), minions.toArray(new MinionHolder[minions.size()]));
                                        continue block120;
                                    }
                                }
                            }
                            continue block119;
                        }
                        case "race": 
                        case "sex": {
                            set.set(npc_node.getNodeName(), npc_node.getTextContent().toUpperCase());
                            continue block119;
                        }
                        case "equipment": {
                            set.set("chestId", this.parseInteger(attrs, "chest"));
                            set.set("rhandId", this.parseInteger(attrs, "rhand"));
                            set.set("lhandId", this.parseInteger(attrs, "lhand"));
                            set.set("weaponEnchant", this.parseInteger(attrs, "weaponEnchant"));
                            continue block119;
                        }
                        case "acquire": {
                            set.set("expRate", this.parseDouble(attrs, "expRate"));
                            set.set("sp", this.parseDouble(attrs, "sp"));
                            set.set("raidPoints", this.parseDouble(attrs, "raidPoints"));
                            continue block119;
                        }
                        case "stats": {
                            set.set("baseSTR", this.parseInteger(attrs, "str"));
                            set.set("baseINT", this.parseInteger(attrs, "int"));
                            set.set("baseDEX", this.parseInteger(attrs, "dex"));
                            set.set("baseWIT", this.parseInteger(attrs, "wit"));
                            set.set("baseCON", this.parseInteger(attrs, "con"));
                            set.set("baseMEN", this.parseInteger(attrs, "men"));
                            block122: for (Node stats_node = npc_node.getFirstChild(); stats_node != null; stats_node = stats_node.getNextSibling()) {
                                attrs = stats_node.getAttributes();
                                switch (stats_node.getNodeName().toLowerCase()) {
                                    case "vitals": {
                                        set.set("baseHpMax", this.parseDouble(attrs, "hp"));
                                        set.set("baseHpReg", this.parseDouble(attrs, "hpRegen"));
                                        set.set("baseMpMax", this.parseDouble(attrs, "mp"));
                                        set.set("baseMpReg", this.parseDouble(attrs, "mpRegen"));
                                        continue block122;
                                    }
                                    case "attack": {
                                        set.set("basePAtk", this.parseDouble(attrs, "physical"));
                                        set.set("baseMAtk", this.parseDouble(attrs, "magical"));
                                        set.set("baseRndDam", this.parseInteger(attrs, "random"));
                                        set.set("baseCritRate", this.parseInteger(attrs, "critical"));
                                        set.set("accuracy", this.parseDouble(attrs, "accuracy"));
                                        set.set("basePAtkSpd", this.parseInteger(attrs, "attackSpeed"));
                                        set.set("reuseDelay", this.parseInteger(attrs, "reuseDelay"));
                                        set.set("baseAtkType", this.parseString(attrs, "type"));
                                        set.set("baseAtkRange", this.parseInteger(attrs, "range"));
                                        set.set("distance", this.parseInteger(attrs, "distance"));
                                        set.set("width", this.parseInteger(attrs, "width"));
                                        continue block122;
                                    }
                                    case "defence": {
                                        set.set("basePDef", this.parseDouble(attrs, "physical"));
                                        set.set("baseMDef", this.parseDouble(attrs, "magical"));
                                        set.set("evasion", this.parseInteger(attrs, "evasion"));
                                        set.set("baseShldDef", this.parseInteger(attrs, "shield"));
                                        set.set("baseShldRate", this.parseInteger(attrs, "shieldRate"));
                                        continue block122;
                                    }
                                    case "attribute": {
                                        block123: for (Node attribute_node = stats_node.getFirstChild(); attribute_node != null; attribute_node = attribute_node.getNextSibling()) {
                                            attrs = attribute_node.getAttributes();
                                            switch (attribute_node.getNodeName().toLowerCase()) {
                                                case "attack": {
                                                    String attackAttributeType = this.parseString(attrs, "type");
                                                    switch (attackAttributeType.toUpperCase()) {
                                                        case "FIRE": {
                                                            set.set("baseFire", this.parseInteger(attrs, "value"));
                                                            break;
                                                        }
                                                        case "WATER": {
                                                            set.set("baseWater", this.parseInteger(attrs, "value"));
                                                            break;
                                                        }
                                                        case "WIND": {
                                                            set.set("baseWind", this.parseInteger(attrs, "value"));
                                                            break;
                                                        }
                                                        case "EARTH": {
                                                            set.set("baseEarth", this.parseInteger(attrs, "value"));
                                                            break;
                                                        }
                                                        case "DARK": {
                                                            set.set("baseDark", this.parseInteger(attrs, "value"));
                                                            break;
                                                        }
                                                        case "HOLY": {
                                                            set.set("baseHoly", this.parseInteger(attrs, "value"));
                                                        }
                                                    }
                                                    continue block123;
                                                }
                                                case "defence": {
                                                    set.set("baseFireRes", this.parseInteger(attrs, "fire"));
                                                    set.set("baseWaterRes", this.parseInteger(attrs, "water"));
                                                    set.set("baseWindRes", this.parseInteger(attrs, "wind"));
                                                    set.set("baseEarthRes", this.parseInteger(attrs, "earth"));
                                                    set.set("baseHolyRes", this.parseInteger(attrs, "holy"));
                                                    set.set("baseDarkRes", this.parseInteger(attrs, "dark"));
                                                    set.set("baseElementRes", this.parseInteger(attrs, "default"));
                                                }
                                            }
                                        }
                                        continue block122;
                                    }
                                    case "speed": {
                                        block124: for (Node speed_node = stats_node.getFirstChild(); speed_node != null; speed_node = speed_node.getNextSibling()) {
                                            attrs = speed_node.getAttributes();
                                            switch (speed_node.getNodeName().toLowerCase()) {
                                                case "walk": {
                                                    set.set("baseWalkSpd", this.parseDouble(attrs, "ground"));
                                                    set.set("baseSwimWalkSpd", this.parseDouble(attrs, "swim"));
                                                    set.set("baseFlyWalkSpd", this.parseDouble(attrs, "fly"));
                                                    continue block124;
                                                }
                                                case "run": {
                                                    set.set("baseRunSpd", this.parseDouble(attrs, "ground"));
                                                    set.set("baseSwimRunSpd", this.parseDouble(attrs, "swim"));
                                                    set.set("baseFlyRunSpd", this.parseDouble(attrs, "fly"));
                                                }
                                            }
                                        }
                                        continue block122;
                                    }
                                    case "hit_time": {
                                        set.set("hit_time", npc_node.getTextContent());
                                    }
                                }
                            }
                            continue block119;
                        }
                        case "status": {
                            set.set("unique", this.parseBoolean(attrs, "unique"));
                            set.set("attackable", this.parseBoolean(attrs, "attackable"));
                            set.set("targetable", this.parseBoolean(attrs, "targetable"));
                            set.set("undying", this.parseBoolean(attrs, "undying"));
                            set.set("showName", this.parseBoolean(attrs, "showName"));
                            set.set("flying", this.parseBoolean(attrs, "flying"));
                            set.set("canMove", this.parseBoolean(attrs, "canMove"));
                            set.set("noSleepMode", this.parseBoolean(attrs, "noSleepMode"));
                            set.set("passableDoor", this.parseBoolean(attrs, "passableDoor"));
                            set.set("hasSummoner", this.parseBoolean(attrs, "hasSummoner"));
                            set.set("canBeSown", this.parseBoolean(attrs, "canBeSown"));
                            continue block119;
                        }
                        case "skill_list": {
                            skills = new ArrayList<Skill>();
                            for (Node skill_list_node = npc_node.getFirstChild(); skill_list_node != null; skill_list_node = skill_list_node.getNextSibling()) {
                                if (!"skill".equalsIgnoreCase(skill_list_node.getNodeName())) continue;
                                attrs = skill_list_node.getAttributes();
                                int skillId = this.parseInt(attrs, "id");
                                int skillLevel = this.parseInt(attrs, "level");
                                Skill skill = SkillData.getInstance().getSkill(skillId, skillLevel);
                                if (skill != null) {
                                    skills.add(skill);
                                    continue;
                                }
                                this._log.warning("[" + this.getCurrentFile().getName() + "] skill not found. NPC ID: " + npcId + " Skill ID:" + skillId + " Skill Level: " + skillLevel);
                            }
                            continue block119;
                        }
                        case "shots": {
                            set.set("soulShot", this.parseInteger(attrs, "soul"));
                            set.set("spiritShot", this.parseInteger(attrs, "spirit"));
                            set.set("shotShotChance", this.parseInteger(attrs, "shotChance"));
                            set.set("spiritShotChance", this.parseInteger(attrs, "spiritChance"));
                            continue block119;
                        }
                        case "corpse_time": {
                            set.set("corpseTime", npc_node.getTextContent());
                            continue block119;
                        }
                        case "ex_crt_effect": {
                            set.set("ex_crt_effect", npc_node.getTextContent());
                            continue block119;
                        }
                        case "s_npc_prop_hp_rate": {
                            set.set("s_npc_prop_hp_rate", npc_node.getTextContent());
                            continue block119;
                        }
                        case "ai": {
                            set.set("aiType", this.parseString(attrs, "type"));
                            set.set("aggroRange", this.parseInteger(attrs, "aggroRange"));
                            set.set("clanHelpRange", this.parseInteger(attrs, "clanHelpRange"));
                            set.set("dodge", this.parseInteger(attrs, "dodge"));
                            set.set("isChaos", this.parseBoolean(attrs, "isChaos"));
                            set.set("isAggressive", this.parseBoolean(attrs, "isAggressive"));
                            block126: for (Node ai_node = npc_node.getFirstChild(); ai_node != null; ai_node = ai_node.getNextSibling()) {
                                attrs = ai_node.getAttributes();
                                switch (ai_node.getNodeName().toLowerCase()) {
                                    case "skill": {
                                        set.set("minSkillChance", this.parseInteger(attrs, "minChance"));
                                        set.set("maxSkillChance", this.parseInteger(attrs, "maxChance"));
                                        set.set("primarySkillId", this.parseInteger(attrs, "primaryId"));
                                        set.set("shortRangeSkillId", this.parseInteger(attrs, "shortRangeId"));
                                        set.set("shortRangeSkillChance", this.parseInteger(attrs, "shortRangeChance"));
                                        set.set("longRangeSkillId", this.parseInteger(attrs, "longRangeId"));
                                        set.set("longRangeSkillChance", this.parseInteger(attrs, "longRangeChance"));
                                        continue block126;
                                    }
                                    case "clan_list": {
                                        block127: for (Node clan_list_node = ai_node.getFirstChild(); clan_list_node != null; clan_list_node = clan_list_node.getNextSibling()) {
                                            attrs = clan_list_node.getAttributes();
                                            switch (clan_list_node.getNodeName().toLowerCase()) {
                                                case "clan": {
                                                    if (clan_list_node.getTextContent().equals("ALL")) continue block127;
                                                    if (clans == null) {
                                                        clans = new TIntArrayList();
                                                    }
                                                    clans.add(this.getOrCreateClanId(clan_list_node.getTextContent()));
                                                    continue block127;
                                                }
                                                case "ignore_npc_id": {
                                                    if (clan_list_node.getTextContent().equals("ALL")) continue block127;
                                                    if (ignoreClanNpcIds == null) {
                                                        ignoreClanNpcIds = new TIntArrayList();
                                                    }
                                                    ignoreClanNpcIds.add(Integer.parseInt(clan_list_node.getTextContent()));
                                                }
                                            }
                                        }
                                        continue block126;
                                    }
                                }
                            }
                            continue block119;
                        }
                        case "drop_lists": {
                            for (Node drop_lists_node = npc_node.getFirstChild(); drop_lists_node != null; drop_lists_node = drop_lists_node.getNextSibling()) {
                                DropListScope dropListScope = null;
                                try {
                                    dropListScope = Enum.valueOf(DropListScope.class, drop_lists_node.getNodeName().toUpperCase());
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                if (dropListScope == null) continue;
                                if (dropLists == null) {
                                    dropLists = new EnumMap<DropListScope, List<IDropItem>>(DropListScope.class);
                                }
                                ArrayList<IDropItem> dropList = new ArrayList<IDropItem>();
                                this.parseDropList(drop_lists_node, dropListScope, dropList);
                                dropLists.put(dropListScope, new UnmodifiableArrayList<IDropItem>(dropList));
                            }
                            continue block119;
                        }
                        case "collision": {
                            block129: for (Node collision_node = npc_node.getFirstChild(); collision_node != null; collision_node = collision_node.getNextSibling()) {
                                attrs = collision_node.getAttributes();
                                switch (collision_node.getNodeName().toLowerCase()) {
                                    case "radius": {
                                        set.set("collision_radius", this.parseDouble(attrs, "normal"));
                                        set.set("collisionRadiusGrown", this.parseDouble(attrs, "grown"));
                                        continue block129;
                                    }
                                    case "height": {
                                        set.set("collision_height", this.parseDouble(attrs, "normal"));
                                        set.set("collisionHeightGrown", this.parseDouble(attrs, "grown"));
                                    }
                                }
                            }
                            continue block119;
                        }
                    }
                }
                L2NpcTemplate template = (L2NpcTemplate)this._npcs.get(npcId);
                if (template == null) {
                    template = new L2NpcTemplate(set);
                    this._npcs.put(template.getId(), (Object)template);
                } else {
                    template.set(set);
                }
                MinionHolder[] minions = (MinionHolder[])this.minionData.get(npcId);
                if (minions != null) {
                    if (parameters == null) {
                        parameters = new HashMap();
                    }
                    parameters.putIfAbsent("Privates", minions);
                }
                if (parameters != null) {
                    template.setParameters(new StatsSet(Collections.unmodifiableMap(parameters)));
                } else {
                    template.setParameters(StatsSet.EMPTY_STATSET);
                }
                if (skills != null) {
                    for (Skill skill : skills) {
                        AISkillScope shortOrLongRangeScope;
                        if (skill.isPassive()) continue;
                        ArrayList<AISkillScope> aiSkillScopes = new ArrayList<AISkillScope>();
                        AISkillScope aISkillScope = shortOrLongRangeScope = skill.getCastRange() <= 150 ? AISkillScope.SHORT_RANGE : AISkillScope.LONG_RANGE;
                        if (skill.isSuicideAttack()) {
                            aiSkillScopes.add(AISkillScope.SUICIDE);
                        } else {
                            aiSkillScopes.add(AISkillScope.GENERAL);
                            if (skill.isContinuous()) {
                                if (!skill.isDebuff()) {
                                    aiSkillScopes.add(AISkillScope.BUFF);
                                } else {
                                    aiSkillScopes.add(AISkillScope.DEBUFF);
                                    aiSkillScopes.add(AISkillScope.COT);
                                    aiSkillScopes.add(shortOrLongRangeScope);
                                }
                            } else if (skill.hasEffectType(L2EffectType.DISPEL, L2EffectType.DISPEL_BY_SLOT)) {
                                aiSkillScopes.add(AISkillScope.NEGATIVE);
                                aiSkillScopes.add(shortOrLongRangeScope);
                            } else if (skill.hasEffectType(L2EffectType.HEAL)) {
                                aiSkillScopes.add(AISkillScope.HEAL);
                            } else if (skill.hasEffectType(L2EffectType.PHYSICAL_ATTACK, L2EffectType.PHYSICAL_ATTACK_HP_LINK, L2EffectType.MAGICAL_ATTACK, L2EffectType.DEATH_LINK, L2EffectType.HP_DRAIN)) {
                                aiSkillScopes.add(AISkillScope.ATTACK);
                                aiSkillScopes.add(AISkillScope.UNIVERSAL);
                                aiSkillScopes.add(shortOrLongRangeScope);
                            } else if (skill.hasEffectType(L2EffectType.SLEEP)) {
                                aiSkillScopes.add(AISkillScope.IMMOBILIZE);
                            } else if (skill.hasEffectType(L2EffectType.STUN, L2EffectType.ROOT)) {
                                aiSkillScopes.add(AISkillScope.IMMOBILIZE);
                                aiSkillScopes.add(shortOrLongRangeScope);
                            } else if (skill.hasEffectType(L2EffectType.MUTE, L2EffectType.FEAR)) {
                                aiSkillScopes.add(AISkillScope.COT);
                                aiSkillScopes.add(shortOrLongRangeScope);
                            } else if (skill.hasEffectType(L2EffectType.PARALYZE)) {
                                aiSkillScopes.add(AISkillScope.IMMOBILIZE);
                                aiSkillScopes.add(shortOrLongRangeScope);
                            } else if (skill.hasEffectType(L2EffectType.DMG_OVER_TIME, L2EffectType.DMG_OVER_TIME_PERCENT)) {
                                aiSkillScopes.add(shortOrLongRangeScope);
                            } else if (skill.hasEffectType(L2EffectType.RESURRECTION)) {
                                aiSkillScopes.add(AISkillScope.RES);
                            } else {
                                aiSkillScopes.add(AISkillScope.UNIVERSAL);
                            }
                        }
                        for (AISkillScope aiSkillScope : aiSkillScopes) {
                            ArrayList<Skill> aiSkills;
                            if (aiSkillLists == null) {
                                aiSkillLists = new EnumMap<AISkillScope, ArrayList<Skill>>(AISkillScope.class);
                            }
                            if ((aiSkills = (ArrayList<Skill>)aiSkillLists.get((Object)aiSkillScope)) == null) {
                                aiSkills = new ArrayList<Skill>();
                                aiSkillLists.put(aiSkillScope, aiSkills);
                            }
                            aiSkills.add(skill);
                        }
                    }
                }
                template.setSkills(skills);
                template.setAISkillLists(aiSkillLists);
                template.setClans(clans == null ? null : this.findClans(clans.toArray()));
                template.setIgnoreClanNpcIds(ignoreClanNpcIds == null ? null : this.findClans(ignoreClanNpcIds.toArray()));
                template.setDropLists(dropLists);
            }
        }
    }

    private void parseDropList(Node drop_list_node, DropListScope dropListScope, List<IDropItem> drops) {
        block6: for (Node drop_node = drop_list_node.getFirstChild(); drop_node != null; drop_node = drop_node.getNextSibling()) {
            NamedNodeMap attrs = drop_node.getAttributes();
            switch (drop_node.getNodeName().toLowerCase()) {
                case "group": {
                    GroupedGeneralDropItem dropItem = dropListScope.newGroupedDropItem(this.parseDouble(attrs, "chance"));
                    ArrayList<IDropItem> groupedDropList = new ArrayList<IDropItem>(2);
                    for (Node group_node = drop_node.getFirstChild(); group_node != null; group_node = group_node.getNextSibling()) {
                        this.parseDropListItem(group_node, dropListScope, groupedDropList);
                    }
                    ArrayList<GeneralDropItem> items = new ArrayList<GeneralDropItem>(groupedDropList.size());
                    for (IDropItem item : groupedDropList) {
                        if (item instanceof GeneralDropItem) {
                            items.add((GeneralDropItem)item);
                            continue;
                        }
                        this._log.warning("[" + this.getCurrentFile() + "] grouped general drop item supports only general drop item.");
                    }
                    dropItem.setItems(items);
                    drops.add(dropItem);
                    continue block6;
                }
                default: {
                    this.parseDropListItem(drop_node, dropListScope, drops);
                }
            }
        }
    }

    private void parseDropListItem(Node drop_list_item, DropListScope dropListScope, List<IDropItem> drops) {
        NamedNodeMap attrs = drop_list_item.getAttributes();
        switch (drop_list_item.getNodeName().toLowerCase()) {
            case "item": {
                IDropItem dropItem = dropListScope.newDropItem(this.parseInt(attrs, "id"), this.parseLong(attrs, "min"), this.parseLong(attrs, "max"), this.parseDouble(attrs, "chance"));
                if (dropItem == null) break;
                drops.add(dropItem);
                break;
            }
        }
    }

    private int getOrCreateClanId(String clanName) {
        Integer id = this._clans.get(clanName);
        if (id == null) {
            id = this._clans.size();
            this._clans.put(clanName, id);
        }
        return id;
    }

    private int[] findClans(int[] clans) {
        for (L2NpcTemplate t : this._npcs.values()) {
            int[] result = t.getClans();
            if (!Arrays.equals(clans, result) && !Arrays.equals(clans, result = t.getIgnoreClanNpcIds())) continue;
            return result;
        }
        return clans;
    }

    public String toClanNames(int[] clans) {
        if (clans == null || clans.length == 0) {
            return null;
        }
        if (clans.length == 1) {
            return this.toClanName(clans[0]);
        }
        StringBuilder sb = new StringBuilder(256);
        for (int id : clans) {
            sb.append(this.toClanName(id)).append(';');
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    public String toClanName(int id) {
        for (Map.Entry<String, Integer> e : this._clans.entrySet()) {
            if (e.getValue() != id) continue;
            return e.getKey();
        }
        return null;
    }

    public L2NpcTemplate getTemplate(int id) {
        return (L2NpcTemplate)this._npcs.get(id);
    }

    public L2NpcTemplate getTemplateByName(String name) {
        for (L2NpcTemplate npcTemplate : this._npcs.values()) {
            if (!npcTemplate.getName().equalsIgnoreCase(name)) continue;
            return npcTemplate;
        }
        return null;
    }

    public ArrayList<L2NpcTemplate> toArrayList() {
        return new ArrayList<L2NpcTemplate>(this._npcs.values());
    }

    public IntObjectMap<L2NpcTemplate> getAll() {
        return this._npcs.unmodifiable();
    }

    public List<L2NpcTemplate> getTemplates(Predicate<L2NpcTemplate> filter) {
        return this._npcs.values().stream().filter(filter).collect(Collectors.toList());
    }

    public List<L2NpcTemplate> getAllOfLevel(int lvl) {
        return this.getTemplates(template -> lvl == template.getLevel());
    }

    public List<L2NpcTemplate> getAllOfLevel(int ... lvls) {
        return this.getTemplates(template -> com.l2jserver.gameserver.util.Util.contains(lvls, template.getLevel()));
    }

    public List<L2NpcTemplate> getAllMonstersOfLevel(int lvl) {
        return this.getTemplates(template -> lvl == template.getLevel() && template.isType("L2Monster"));
    }

    public List<L2NpcTemplate> getAllMonstersOfLevel(int ... lvls) {
        return this.getTemplates(template -> com.l2jserver.gameserver.util.Util.contains(lvls, template.getLevel()) && template.isType("L2Monster"));
    }

    public List<L2NpcTemplate> getAllNpcStartingWith(String text) {
        return this.getTemplates(template -> template.isType("L2Npc") && template.getName().startsWith(text));
    }

    public List<L2NpcTemplate> getAllNpcOfClassType(String classType) {
        return this.getTemplates(template -> classType.equalsIgnoreCase(template.getType()));
    }

    public List<L2NpcTemplate> getAllNpcOfClassType(String ... classTypes) {
        return this.getTemplates(template -> com.l2jserver.gameserver.util.Util.contains(classTypes, template.getType(), true));
    }

    public void loadNpcsSkillLearn() {
        this._npcs.values().forEach(template -> {
            List<ClassId> teachInfo = SkillLearnData.getInstance().getSkillLearnData(template.getId());
            if (teachInfo != null) {
                template.setTeachInfo(teachInfo);
            }
        });
    }

    public static NpcData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final NpcData _instance = new NpcData();

        private SingletonHolder() {
        }
    }

    private final class MinionData
    extends DocumentParser {
        final FastIntObjectMap<MinionHolder[]> minionData = new FastIntObjectMap();

        protected MinionData() {
            this.load();
        }

        @Override
        public void load() {
            long started = System.currentTimeMillis();
            this.minionData.clear();
            Pattern pattern = Pattern.compile("minionData.*\\.xml");
            File[] minionDataFiles = new File(Config.DATAPACK_ROOT, "data").listFiles(file -> file.isFile() && pattern.matcher(file.getName()).matches());
            FilenameSortComparator c = new FilenameSortComparator();
            Arrays.sort(minionDataFiles, (a, b) -> c.compare(a.getName(), b.getName()));
            for (File file2 : minionDataFiles) {
                this._log.info(this.getClass().getSimpleName() + ": Loading " + file2.getName());
                this.parseFile(file2);
            }
            this._log.info(this.getClass().getSimpleName() + ": Loaded " + this.minionData.size() + " minions data. (" + Util.strMillTime(System.currentTimeMillis() - started) + ")");
        }

        @Override
        protected void parseDocument() {
            ArrayList<MinionHolder> minions = new ArrayList<MinionHolder>();
            for (Node node = this.getCurrentDocument().getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"list".equals(node.getNodeName())) continue;
                for (Node list_node = node.getFirstChild(); list_node != null; list_node = list_node.getNextSibling()) {
                    if (!"npc".equals(list_node.getNodeName())) continue;
                    minions.clear();
                    NamedNodeMap attrs = list_node.getAttributes();
                    int id = this.parseInt(attrs, "id");
                    for (Node npc_node = list_node.getFirstChild(); npc_node != null; npc_node = npc_node.getNextSibling()) {
                        if (!"minion".equals(npc_node.getNodeName())) continue;
                        attrs = npc_node.getAttributes();
                        minions.add(new MinionHolder(this.parseInt(attrs, "id"), this.parseInt(attrs, "count"), this.parseInt(attrs, "respawnTime"), 0));
                    }
                    this.minionData.put(id, (Object)minions.toArray(new MinionHolder[minions.size()]));
                }
            }
        }
    }
}

