/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NpcPersonalAIData {
    private final Map<String, Map<String, Integer>> _AIData = new HashMap<String, Map<String, Integer>>();
    private long randomName;

    protected NpcPersonalAIData() {
    }

    public void storeData(L2Spawn spawnDat, Map<String, Integer> data) {
        if (data != null && !data.isEmpty()) {
            if (spawnDat.getName() == null) {
                String spawnName;
                while (this._AIData.containsKey(spawnName = Long.toString(++this.randomName))) {
                }
                spawnDat.setName(spawnName);
            }
            this._AIData.put(spawnDat.getName(), data);
        }
    }

    public int getAIValue(String spawnName, String paramName) {
        return this.getAIValue(spawnName, paramName, -1);
    }

    public int getAIValue(String spawnName, String paramName, int defaultValue) {
        if (spawnName == null) {
            return defaultValue;
        }
        Map<String, Integer> map = this._AIData.get(spawnName);
        if (map == null) {
            return defaultValue;
        }
        Integer val = map.get(paramName);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public boolean hasAIValue(String spawnName, String paramName) {
        Map<String, Integer> map;
        return spawnName != null && (map = this._AIData.get(spawnName)) != null && map.get(paramName) != null;
    }

    public void initializeNpcParameters(L2Npc npc, L2Spawn spawn, String spawnName) {
        Map<String, Integer> map = this._AIData.get(spawnName);
        if (map != null) {
            try {
                Iterator<String> iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String key;
                    switch (key = iterator.next()) {
                        case "disableRandomAnimation": {
                            int val = map.get(key);
                            npc.setRandomAnimationEnabled(val == 0);
                            break;
                        }
                        case "disableRandomWalk": {
                            int val = map.get(key);
                            npc.setIsNoRndWalk(val == 1);
                            spawn.setIsNoRndWalk(val == 1);
                        }
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static NpcPersonalAIData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final NpcPersonalAIData _instance = new NpcPersonalAIData();

        private SingletonHolder() {
        }
    }
}

