/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.options.Options;
import com.l2jserver.gameserver.model.options.OptionsSkillHolder;
import com.l2jserver.gameserver.model.options.OptionsSkillType;
import com.l2jserver.gameserver.model.skills.funcs.FuncTemplate;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.util.Util;
import java.util.logging.Level;
import jp.sf.l2j.troja.FastIntObjectMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class OptionsData
extends DocumentParser {
    private final FastIntObjectMap<Options> _data = new FastIntObjectMap();

    protected OptionsData() {
        this.load();
    }

    @Override
    public synchronized void load() {
        long started = System.currentTimeMillis();
        this._data.clear();
        this.parseDatapackDirectory("data/stats/options", false);
        this._log.log(Level.INFO, this.getClass().getSimpleName() + ": Loaded: " + this._data.size() + " Options. (" + Util.strMillTime(System.currentTimeMillis() - started) + ")");
    }

    @Override
    protected void parseDocument() {
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"option".equalsIgnoreCase(d.getNodeName())) continue;
                int id = this.parseInteger(d.getAttributes(), "id");
                Options op = new Options(id);
                block34: for (Node cd = d.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                    switch (cd.getNodeName()) {
                        case "for": {
                            block35: for (Node fd = cd.getFirstChild(); fd != null; fd = fd.getNextSibling()) {
                                switch (fd.getNodeName()) {
                                    case "add": {
                                        this.parseFuncs(fd.getAttributes(), "Add", op);
                                        continue block35;
                                    }
                                    case "mul": {
                                        this.parseFuncs(fd.getAttributes(), "Mul", op);
                                        continue block35;
                                    }
                                    case "basemul": {
                                        this.parseFuncs(fd.getAttributes(), "BaseMul", op);
                                        continue block35;
                                    }
                                    case "sub": {
                                        this.parseFuncs(fd.getAttributes(), "Sub", op);
                                        continue block35;
                                    }
                                    case "div": {
                                        this.parseFuncs(fd.getAttributes(), "Div", op);
                                        continue block35;
                                    }
                                    case "set": {
                                        this.parseFuncs(fd.getAttributes(), "Set", op);
                                    }
                                }
                            }
                            continue block34;
                        }
                        case "active_skill": {
                            op.setActiveSkill(this.parseInteger(cd.getAttributes(), "id"), this.parseInteger(cd.getAttributes(), "level"));
                            continue block34;
                        }
                        case "passive_skill": {
                            op.setPassiveSkill(this.parseInteger(cd.getAttributes(), "id"), this.parseInteger(cd.getAttributes(), "level"));
                            continue block34;
                        }
                        case "attack_skill": {
                            op.addActivationSkill(new OptionsSkillHolder(this.parseInteger(cd.getAttributes(), "id"), this.parseInteger(cd.getAttributes(), "level"), this.parseDouble(cd.getAttributes(), "chance"), OptionsSkillType.ATTACK));
                            continue block34;
                        }
                        case "magic_skill": {
                            op.addActivationSkill(new OptionsSkillHolder(this.parseInteger(cd.getAttributes(), "id"), this.parseInteger(cd.getAttributes(), "level"), this.parseDouble(cd.getAttributes(), "chance"), OptionsSkillType.MAGIC));
                            continue block34;
                        }
                        case "critical_skill": {
                            op.addActivationSkill(new OptionsSkillHolder(this.parseInteger(cd.getAttributes(), "id"), this.parseInteger(cd.getAttributes(), "level"), this.parseDouble(cd.getAttributes(), "chance"), OptionsSkillType.CRITICAL));
                        }
                    }
                }
                this._data.put(op.getId(), (Object)op);
            }
        }
    }

    private void parseFuncs(NamedNodeMap attrs, String func, Options op) {
        Stats stat = Stats.valueOfXml(this.parseString(attrs, "stat"));
        int ord = Integer.decode(this.parseString(attrs, "order"));
        double val = this.parseDouble(attrs, "val");
        op.addFunc(new FuncTemplate(null, null, func, stat, ord, val));
    }

    public Options getOptions(int id) {
        return (Options)this._data.get(id);
    }

    public static final OptionsData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final OptionsData _instance = new OptionsData();

        private SingletonHolder() {
        }
    }
}

