/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.enums.MountType;
import com.l2jserver.gameserver.model.L2PetData;
import com.l2jserver.gameserver.model.L2PetLevelData;
import com.l2jserver.gameserver.model.StatsSet;
import jp.sf.l2j.arrayMaps.SortedIntObjectArrayMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class PetDataTable
extends DocumentParser {
    private static final SortedIntObjectArrayMap<L2PetData> _pets = new SortedIntObjectArrayMap((Object[])new L2PetData[0]);

    protected PetDataTable() {
        this.load();
    }

    @Override
    public void load() {
        _pets.clear();
        this.parseDatapackDirectory("data/stats/pets", false);
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + _pets.size() + " Pets.");
    }

    @Override
    protected void parseDocument() {
        Node n = this.getCurrentDocument().getFirstChild();
        for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
            if (!d.getNodeName().equals("pet")) continue;
            int npcId = this.parseInt(d.getAttributes(), "id");
            int itemId = this.parseInt(d.getAttributes(), "itemId");
            L2PetData data = new L2PetData(npcId, itemId);
            for (Node p = d.getFirstChild(); p != null; p = p.getNextSibling()) {
                Node s;
                NamedNodeMap attrs;
                if (p.getNodeName().equals("set")) {
                    attrs = p.getAttributes();
                    String type = attrs.getNamedItem("name").getNodeValue();
                    if ("food".equals(type)) {
                        for (String foodId : attrs.getNamedItem("val").getNodeValue().split(";")) {
                            data.addFood(Integer.valueOf(foodId));
                        }
                        continue;
                    }
                    if ("load".equals(type)) {
                        data.setLoad(this.parseInt(attrs, "val"));
                        continue;
                    }
                    if ("hungry_limit".equals(type)) {
                        data.setHungryLimit(this.parseInt(attrs, "val"));
                        continue;
                    }
                    if (!"sync_level".equals(type)) continue;
                    data.setSyncLevel(this.parseInt(attrs, "val") == 1);
                    continue;
                }
                if (p.getNodeName().equals("skills")) {
                    for (s = p.getFirstChild(); s != null; s = s.getNextSibling()) {
                        if (!s.getNodeName().equals("skill")) continue;
                        attrs = s.getAttributes();
                        data.addNewSkill(this.parseInt(attrs, "skillId"), this.parseInt(attrs, "skillLvl"), this.parseInt(attrs, "minLvl"));
                    }
                    continue;
                }
                if (!p.getNodeName().equals("stats")) continue;
                for (s = p.getFirstChild(); s != null; s = s.getNextSibling()) {
                    if (!s.getNodeName().equals("stat")) continue;
                    int level = Integer.parseInt(s.getAttributes().getNamedItem("level").getNodeValue());
                    StatsSet set = new StatsSet();
                    for (Node bean = s.getFirstChild(); bean != null; bean = bean.getNextSibling()) {
                        if (!bean.getNodeName().equals("set")) continue;
                        attrs = bean.getAttributes();
                        if (attrs.getNamedItem("name").getNodeValue().equals("speed_on_ride")) {
                            set.set("walkSpeedOnRide", attrs.getNamedItem("walk").getNodeValue());
                            set.set("runSpeedOnRide", attrs.getNamedItem("run").getNodeValue());
                            set.set("slowSwimSpeedOnRide", attrs.getNamedItem("slowSwim").getNodeValue());
                            set.set("fastSwimSpeedOnRide", attrs.getNamedItem("fastSwim").getNodeValue());
                            if (attrs.getNamedItem("slowFly") != null) {
                                set.set("slowFlySpeedOnRide", attrs.getNamedItem("slowFly").getNodeValue());
                            }
                            if (attrs.getNamedItem("fastFly") == null) continue;
                            set.set("fastFlySpeedOnRide", attrs.getNamedItem("fastFly").getNodeValue());
                            continue;
                        }
                        set.set(attrs.getNamedItem("name").getNodeValue(), attrs.getNamedItem("val").getNodeValue());
                    }
                    data.addNewStat(level, new L2PetLevelData(set));
                }
            }
            _pets.append(npcId, (Object)data);
        }
    }

    public L2PetData getPetDataByItemId(int itemId) {
        for (L2PetData data : (L2PetData[])_pets.values()) {
            if (data.getItemId() != itemId) continue;
            return data;
        }
        return null;
    }

    public L2PetLevelData getPetLevelData(int petId, int petLevel) {
        L2PetData pd = this.getPetData(petId);
        if (pd != null) {
            return pd.getPetLevelData(petLevel);
        }
        return null;
    }

    public L2PetData getPetData(int petId) {
        L2PetData data = (L2PetData)_pets.get(petId);
        if (data == null) {
            this._log.info(this.getClass().getSimpleName() + ": Missing pet data for npcid: " + petId);
        }
        return data;
    }

    public int getPetMinLevel(int petId) {
        return ((L2PetData)_pets.get(petId)).getMinLevel();
    }

    public static int getPetItemsByNpc(int npcId) {
        return ((L2PetData)_pets.get(npcId)).getItemId();
    }

    public static boolean isMountable(int npcId) {
        return MountType.findByNpcId(npcId) != MountType.NONE;
    }

    public static PetDataTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final PetDataTable _instance = new PetDataTable();

        private SingletonHolder() {
        }
    }
}

