/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.SiegeScheduleDate;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.util.Util;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SiegeScheduleData
extends DocumentParser {
    private final List<SiegeScheduleDate> _scheduleData = new ArrayList<SiegeScheduleDate>();

    protected SiegeScheduleData() {
        this.load();
    }

    @Override
    public synchronized void load() {
        this._scheduleData.clear();
        this.parseDatapackFile("config/SiegeSchedule.xml");
        this._log.log(Level.INFO, this.getClass().getSimpleName() + ": Loaded: " + this._scheduleData.size() + " siege schedulers.");
        if (this._scheduleData.isEmpty()) {
            this._scheduleData.add(new SiegeScheduleDate(new StatsSet()));
            this._log.log(Level.INFO, this.getClass().getSimpleName() + ": Emergency Loaded: " + this._scheduleData.size() + " default siege schedulers.");
        }
    }

    @Override
    protected void parseDocument() {
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            block7: for (Node cd = n.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                switch (cd.getNodeName()) {
                    case "schedule": {
                        StatsSet set = new StatsSet();
                        NamedNodeMap attrs = cd.getAttributes();
                        for (int i = 0; i < attrs.getLength(); ++i) {
                            Node node = attrs.item(i);
                            String key = node.getNodeName();
                            String val = node.getNodeValue();
                            if ("day".equals(key) && !Util.isDigit(val)) {
                                val = Integer.toString(this.getValueForField(val));
                            }
                            set.set(key, val);
                        }
                        this._scheduleData.add(new SiegeScheduleDate(set));
                        continue block7;
                    }
                }
            }
        }
    }

    private int getValueForField(String field) {
        try {
            return Calendar.class.getField(field).getInt(Calendar.class);
        }
        catch (Exception e) {
            this._log.log(Level.WARNING, "", e);
            return -1;
        }
    }

    public List<SiegeScheduleDate> getScheduleDates() {
        return this._scheduleData;
    }

    public static final SiegeScheduleData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final SiegeScheduleData _instance = new SiegeScheduleData();

        private SingletonHolder() {
        }
    }
}

