/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.util.Util;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.l2j.troja.FastIntObjectMap;

public class SummonSkillsTable {
    private static Logger _log = Logger.getLogger(SummonSkillsTable.class.getName());
    private final FastIntObjectMap<FastIntObjectMap<L2PetSkillLearn>> _skillTrees = new FastIntObjectMap();

    protected SummonSkillsTable() {
        this.load();
    }

    public void load() {
        long started = System.currentTimeMillis();
        this._skillTrees.clear();
        int count = 0;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery("SELECT templateId, minLvl, skillId, skillLvl FROM pets_skills");){
            while (rs.next()) {
                int npcId = rs.getInt("templateId");
                FastIntObjectMap skillTree = (FastIntObjectMap)this._skillTrees.get(npcId);
                if (skillTree == null) {
                    skillTree = new FastIntObjectMap();
                    this._skillTrees.put(npcId, (Object)skillTree);
                }
                int id = rs.getInt("skillId");
                int lvl = rs.getInt("skillLvl");
                skillTree.put(SkillData.getSkillHashCode(id, lvl + 1), (Object)new L2PetSkillLearn(id, lvl, rs.getInt("minLvl")));
                ++count;
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error while loading pet skill tree:", e);
        }
        _log.info(this.getClass().getSimpleName() + ": Loaded " + count + " skills. (" + Util.strMillTime(System.currentTimeMillis() - started) + ")");
    }

    public int getAvailableLevel(L2Summon cha, int skillId) {
        int lvl = 0;
        FastIntObjectMap v = (FastIntObjectMap)this._skillTrees.get(cha.getId());
        if (v == null) {
            _log.warning(this.getClass().getSimpleName() + ": Pet id " + cha.getId() + " does not have any skills assigned.");
            return lvl;
        }
        for (L2PetSkillLearn temp : v.values()) {
            if (temp.getId() != skillId) continue;
            if (temp.getLevel() == 0) {
                int maxLvl;
                if (cha.getLevel() < 70) {
                    lvl = cha.getLevel() / 10;
                    if (lvl <= 0) {
                        lvl = 1;
                    }
                } else {
                    lvl = 7 + (cha.getLevel() - 70) / 5;
                }
                if (lvl <= (maxLvl = SkillData.getInstance().getMaxLevel(temp.getId()))) break;
                lvl = maxLvl;
                break;
            }
            if (temp.getMinLevel() > cha.getLevel() || temp.getLevel() <= lvl) continue;
            lvl = temp.getLevel();
        }
        return lvl;
    }

    public List<Integer> getAvailableSkills(L2Summon cha) {
        ArrayList<Integer> skillIds = new ArrayList<Integer>();
        FastIntObjectMap v = (FastIntObjectMap)this._skillTrees.get(cha.getId());
        if (v == null) {
            _log.warning(this.getClass().getSimpleName() + ": Pet id " + cha.getId() + " does not have any skills assigned.");
            return skillIds;
        }
        for (L2PetSkillLearn temp : v.values()) {
            if (skillIds.contains(temp.getId())) continue;
            skillIds.add(temp.getId());
        }
        return skillIds;
    }

    public static SummonSkillsTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final SummonSkillsTable _instance = new SummonSkillsTable();

        private SingletonHolder() {
        }
    }

    public static final class L2PetSkillLearn {
        private final int _id;
        private final int _level;
        private final int _minLevel;

        public L2PetSkillLearn(int id, int lvl, int minLvl) {
            this._id = id;
            this._level = lvl;
            this._minLevel = minLvl;
        }

        public int getId() {
            return this._id;
        }

        public int getLevel() {
            return this._level;
        }

        public int getMinLevel() {
            return this._minLevel;
        }
    }
}

