/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.engines;

import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.StringIntern;
import com.l2jserver.gameserver.enums.CategoryType;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.enums.Race;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.base.PlayerState;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.conditions.ConditionCategoryType;
import com.l2jserver.gameserver.model.conditions.ConditionChangeWeapon;
import com.l2jserver.gameserver.model.conditions.ConditionGameChance;
import com.l2jserver.gameserver.model.conditions.ConditionGameTime;
import com.l2jserver.gameserver.model.conditions.ConditionLogicAnd;
import com.l2jserver.gameserver.model.conditions.ConditionLogicNot;
import com.l2jserver.gameserver.model.conditions.ConditionLogicOr;
import com.l2jserver.gameserver.model.conditions.ConditionMinDistance;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerActiveEffectId;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerActiveSkillId;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerAgathionId;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCallPc;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCanCreateBase;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCanCreateOutpost;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCanEscape;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCanRefuelAirship;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCanResurrect;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCanSummon;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCanSummonSiegeGolem;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCanSweep;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCanTakeCastle;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCanTakeFort;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCanTransform;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCanUntransform;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCharges;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCheckAbnormal;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerClassIdRestriction;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCloakStatus;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerCp;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerFlyMounted;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerGrade;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerHasCastle;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerHasClanHall;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerHasFort;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerHasPet;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerHp;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerInsideZoneId;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerInstanceId;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerInvSize;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerIsClanLeader;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerIsHero;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerLandingZone;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerLevel;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerLevelRange;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerMp;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerPkCount;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerPledgeClass;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerRace;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerRangeFromNpc;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerServitorNpcId;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerSex;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerSiegeSide;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerSouls;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerState;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerSubclass;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerTransformationId;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerTvTEvent;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerVehicleMounted;
import com.l2jserver.gameserver.model.conditions.ConditionPlayerWeight;
import com.l2jserver.gameserver.model.conditions.ConditionSiegeZone;
import com.l2jserver.gameserver.model.conditions.ConditionSlotItemId;
import com.l2jserver.gameserver.model.conditions.ConditionTargetAbnormal;
import com.l2jserver.gameserver.model.conditions.ConditionTargetActiveEffectId;
import com.l2jserver.gameserver.model.conditions.ConditionTargetActiveSkillId;
import com.l2jserver.gameserver.model.conditions.ConditionTargetAggro;
import com.l2jserver.gameserver.model.conditions.ConditionTargetClassIdRestriction;
import com.l2jserver.gameserver.model.conditions.ConditionTargetInvSize;
import com.l2jserver.gameserver.model.conditions.ConditionTargetLevel;
import com.l2jserver.gameserver.model.conditions.ConditionTargetLevelRange;
import com.l2jserver.gameserver.model.conditions.ConditionTargetMyPartyExceptMe;
import com.l2jserver.gameserver.model.conditions.ConditionTargetNpcId;
import com.l2jserver.gameserver.model.conditions.ConditionTargetNpcType;
import com.l2jserver.gameserver.model.conditions.ConditionTargetPlayable;
import com.l2jserver.gameserver.model.conditions.ConditionTargetRace;
import com.l2jserver.gameserver.model.conditions.ConditionTargetUsesWeaponKind;
import com.l2jserver.gameserver.model.conditions.ConditionTargetWeight;
import com.l2jserver.gameserver.model.conditions.ConditionUsingItemType;
import com.l2jserver.gameserver.model.conditions.ConditionUsingSkill;
import com.l2jserver.gameserver.model.conditions.ConditionUsingSlotType;
import com.l2jserver.gameserver.model.conditions.ConditionWithSkill;
import com.l2jserver.gameserver.model.effects.AbstractEffect;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.type.ArmorType;
import com.l2jserver.gameserver.model.items.type.WeaponType;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.EffectScope;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.skills.funcs.FuncTemplate;
import com.l2jserver.gameserver.model.stats.Stats;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javolution.util.FastMap;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class DocumentBase {
    protected final Logger _log = Logger.getLogger(this.getClass().getName());
    private File _file;
    protected Map<String, String[]> _tables;

    protected DocumentBase(File pFile) {
        this._file = pFile;
        this._tables = new FastMap();
    }

    public Document parse() {
        try {
            Document doc = null;
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setIgnoringComments(true);
                doc = factory.newDocumentBuilder().parse(this._file);
                this.parseDocument(doc);
            }
            catch (Exception e) {
                this._log.log(Level.SEVERE, "Error loading file " + this._file, e);
            }
            Document document = doc;
            return document;
        }
        finally {
            this._file = null;
            this._tables = null;
        }
    }

    protected abstract void parseDocument(Document var1);

    protected abstract StatsSet getStatsSet();

    protected abstract String getTableValue(String var1);

    protected abstract String getTableValue(String var1, int var2);

    protected void resetTable() {
        this._tables = new FastMap();
    }

    protected void setTable(String name, String[] table) {
        this._tables.put(name, table);
    }

    protected void parseTemplate(Node n, Object template) {
        this.parseTemplate(n, template, null);
    }

    protected void parseTemplate(Node n, Object template, EffectScope effectScope) {
        Condition condition = null;
        if ((n = n.getFirstChild()) == null) {
            return;
        }
        if ("cond".equalsIgnoreCase(n.getNodeName())) {
            condition = this.parseCondition(n.getFirstChild(), template);
            Node msg = n.getAttributes().getNamedItem("msg");
            Node msgId = n.getAttributes().getNamedItem("msgId");
            if (condition != null && msg != null) {
                condition.setMessage(msg.getNodeValue());
            } else if (condition != null && msgId != null) {
                condition.setMessageId(Integer.decode(this.getValue(msgId.getNodeValue(), null)));
                Node addName = n.getAttributes().getNamedItem("addName");
                if (addName != null && Integer.decode(this.getValue(msgId.getNodeValue(), null)) > 0) {
                    condition.addName();
                }
            }
            n = n.getNextSibling();
        }
        while (n != null) {
            switch (n.getNodeName().toLowerCase()) {
                case "add": {
                    this.attachFunc(n, template, "Add", condition);
                    break;
                }
                case "sub": {
                    this.attachFunc(n, template, "Sub", condition);
                    break;
                }
                case "mul": {
                    this.attachFunc(n, template, "Mul", condition);
                    break;
                }
                case "basemul": {
                    this.attachFunc(n, template, "BaseMul", condition);
                    break;
                }
                case "div": {
                    this.attachFunc(n, template, "Div", condition);
                    break;
                }
                case "set": {
                    this.attachFunc(n, template, "Set", condition);
                    break;
                }
                case "share": {
                    this.attachFunc(n, template, "Share", condition);
                    break;
                }
                case "enchant": {
                    this.attachFunc(n, template, "Enchant", condition);
                    break;
                }
                case "enchanthp": {
                    this.attachFunc(n, template, "EnchantHp", condition);
                    break;
                }
                case "effect": {
                    if (template instanceof AbstractEffect) {
                        throw new RuntimeException("Nested effects");
                    }
                    this.attachEffect(n, template, condition, effectScope);
                }
            }
            n = n.getNextSibling();
        }
    }

    protected void attachFunc(Node n, Object template, String name, Condition attachCond) {
        Stats stat = Stats.valueOfXml(n.getAttributes().getNamedItem("stat").getNodeValue());
        String order = n.getAttributes().getNamedItem("order").getNodeValue();
        String valueString = n.getAttributes().getNamedItem("val").getNodeValue();
        double value = valueString.charAt(0) == '#' ? Double.parseDouble(this.getTableValue(valueString)) : Double.parseDouble(valueString);
        int ord = Integer.decode(this.getValue(order, template));
        Condition applayCond = this.parseCondition(n.getFirstChild(), template);
        FuncTemplate ft = new FuncTemplate(attachCond, applayCond, name, stat, ord, value);
        if (template instanceof L2Item) {
            ((L2Item)template).attach(ft);
        } else if (template instanceof Skill) {
            ((Skill)template).attach(ft);
        } else if (template instanceof AbstractEffect) {
            ((AbstractEffect)template).attach(ft);
        }
    }

    protected void attachEffect(Node n, Object template, Condition attachCond) {
        this.attachEffect(n, template, attachCond, null);
    }

    protected void attachEffect(Node n, Object template, Condition attachCond, EffectScope effectScope) {
        NamedNodeMap attrs = n.getAttributes();
        StatsSet set = new StatsSet();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node att = attrs.item(i);
            set.set(att.getNodeName(), this.getValue(att.getNodeValue(), template));
        }
        StatsSet parameters = this.parseParameters(n.getFirstChild(), template);
        Condition applayCond = this.parseCondition(n.getFirstChild(), template);
        if (template instanceof IIdentifiable) {
            set.set("id", ((IIdentifiable)template).getId());
        }
        AbstractEffect effect = AbstractEffect.createEffect(attachCond, applayCond, set, parameters);
        this.parseTemplate(n, effect);
        if (template instanceof L2Item) {
            ((L2Item)template).attach(effect);
        } else if (template instanceof Skill) {
            Skill skill = (Skill)template;
            if (effectScope != null) {
                skill.addEffect(effectScope, effect);
            } else if (skill.isPassive()) {
                skill.addEffect(EffectScope.PASSIVE, effect);
            } else {
                skill.addEffect(EffectScope.GENERAL, effect);
            }
        }
    }

    private StatsSet parseParameters(Node n, Object template) {
        StatsSet parameters = null;
        while (n != null) {
            if (n.getNodeType() == 1 && "param".equals(n.getNodeName())) {
                if (parameters == null) {
                    parameters = new StatsSet();
                }
                NamedNodeMap params = n.getAttributes();
                for (int i = 0; i < params.getLength(); ++i) {
                    Node att = params.item(i);
                    parameters.set(StringIntern.intern(att.getNodeName()), StringIntern.intern(this.getValue(att.getNodeValue(), template)));
                }
            }
            n = n.getNextSibling();
        }
        return parameters == null ? StatsSet.EMPTY_STATSET : parameters;
    }

    protected Condition parseCondition(Node n, Object template) {
        while (n != null && n.getNodeType() != 1) {
            n = n.getNextSibling();
        }
        Condition condition = null;
        if (n != null) {
            switch (n.getNodeName().toLowerCase()) {
                case "and": {
                    condition = this.parseLogicAnd(n, template);
                    break;
                }
                case "or": {
                    condition = this.parseLogicOr(n, template);
                    break;
                }
                case "not": {
                    condition = this.parseLogicNot(n, template);
                    break;
                }
                case "player": {
                    condition = this.parsePlayerCondition(n, template);
                    break;
                }
                case "target": {
                    condition = this.parseTargetCondition(n, template);
                    break;
                }
                case "using": {
                    condition = this.parseUsingCondition(n);
                    break;
                }
                case "game": {
                    condition = this.parseGameCondition(n);
                }
            }
        }
        return condition;
    }

    protected Condition parseLogicAnd(Node n, Object template) {
        ConditionLogicAnd cond = new ConditionLogicAnd();
        for (n = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            cond.add(this.parseCondition(n, template));
        }
        if (cond.conditions == null || cond.conditions.length == 0) {
            this._log.severe("Empty <and> condition in " + this._file);
        }
        return cond;
    }

    protected Condition parseLogicOr(Node n, Object template) {
        ConditionLogicOr cond = new ConditionLogicOr();
        for (n = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            cond.add(this.parseCondition(n, template));
        }
        if (cond.conditions == null || cond.conditions.length == 0) {
            this._log.severe("Empty <or> condition in " + this._file);
        }
        return cond;
    }

    protected Condition parseLogicNot(Node n, Object template) {
        for (n = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return new ConditionLogicNot(this.parseCondition(n, template));
        }
        this._log.severe("Empty <not> condition in " + this._file);
        return null;
    }

    protected Condition parsePlayerCondition(Node n, Object template) {
        Condition cond = null;
        NamedNodeMap attrs = n.getAttributes();
        block130: for (int i = 0; i < attrs.getLength(); ++i) {
            Node a = attrs.item(i);
            switch (a.getNodeName().toLowerCase()) {
                case "races": {
                    String[] racesVal = a.getNodeValue().split(",");
                    Race[] races = new Race[racesVal.length];
                    for (int r = 0; r < racesVal.length; ++r) {
                        races[r] = Race.valueOf(racesVal[r]);
                    }
                    cond = this.joinAnd(cond, new ConditionPlayerRace(races));
                    continue block130;
                }
                case "level": {
                    int lvl = Integer.decode(this.getValue(a.getNodeValue(), template));
                    cond = this.joinAnd(cond, new ConditionPlayerLevel(lvl));
                    continue block130;
                }
                case "levelrange": {
                    String[] range = this.getValue(a.getNodeValue(), template).split(";");
                    if (range.length != 2) continue block130;
                    int[] lvlRange = new int[]{Integer.decode(range[0]), Integer.decode(range[1])};
                    cond = this.joinAnd(cond, new ConditionPlayerLevelRange(lvlRange));
                    continue block130;
                }
                case "resting": {
                    boolean val = Boolean.parseBoolean(a.getNodeValue());
                    cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.RESTING, val));
                    continue block130;
                }
                case "flying": {
                    boolean val = Boolean.parseBoolean(a.getNodeValue());
                    cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.FLYING, val));
                    continue block130;
                }
                case "moving": {
                    boolean val = Boolean.parseBoolean(a.getNodeValue());
                    cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.MOVING, val));
                    continue block130;
                }
                case "running": {
                    boolean val = Boolean.parseBoolean(a.getNodeValue());
                    cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.RUNNING, val));
                    continue block130;
                }
                case "standing": {
                    boolean val = Boolean.parseBoolean(a.getNodeValue());
                    cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.STANDING, val));
                    continue block130;
                }
                case "behind": {
                    boolean val = Boolean.parseBoolean(a.getNodeValue());
                    cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.BEHIND, val));
                    continue block130;
                }
                case "front": {
                    boolean val = Boolean.parseBoolean(a.getNodeValue());
                    cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.FRONT, val));
                    continue block130;
                }
                case "chaotic": {
                    boolean val = Boolean.parseBoolean(a.getNodeValue());
                    cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.CHAOTIC, val));
                    continue block130;
                }
                case "olympiad": {
                    boolean val = Boolean.parseBoolean(a.getNodeValue());
                    cond = this.joinAnd(cond, new ConditionPlayerState(PlayerState.OLYMPIAD, val));
                    continue block130;
                }
                case "ishero": {
                    boolean val = Boolean.parseBoolean(a.getNodeValue());
                    cond = this.joinAnd(cond, new ConditionPlayerIsHero(val));
                    continue block130;
                }
                case "transformationid": {
                    int id = Integer.parseInt(a.getNodeValue());
                    cond = this.joinAnd(cond, new ConditionPlayerTransformationId(id));
                    continue block130;
                }
                case "hp": {
                    int hp = Integer.decode(this.getValue(a.getNodeValue(), null));
                    cond = this.joinAnd(cond, new ConditionPlayerHp(hp));
                    continue block130;
                }
                case "mp": {
                    int hp = Integer.decode(this.getValue(a.getNodeValue(), null));
                    cond = this.joinAnd(cond, new ConditionPlayerMp(hp));
                    continue block130;
                }
                case "cp": {
                    int cp = Integer.decode(this.getValue(a.getNodeValue(), null));
                    cond = this.joinAnd(cond, new ConditionPlayerCp(cp));
                    continue block130;
                }
                case "grade": {
                    int expIndex = Integer.decode(this.getValue(a.getNodeValue(), template));
                    cond = this.joinAnd(cond, new ConditionPlayerGrade(expIndex));
                    continue block130;
                }
                case "pkcount": {
                    int expIndex = Integer.decode(this.getValue(a.getNodeValue(), template));
                    cond = this.joinAnd(cond, new ConditionPlayerPkCount(expIndex));
                    continue block130;
                }
                case "siegezone": {
                    int value = Integer.decode(this.getValue(a.getNodeValue(), null));
                    cond = this.joinAnd(cond, new ConditionSiegeZone(value, true));
                    continue block130;
                }
                case "siegeside": {
                    int value = Integer.decode(this.getValue(a.getNodeValue(), null));
                    cond = this.joinAnd(cond, new ConditionPlayerSiegeSide(value));
                    continue block130;
                }
                case "charges": {
                    int value = Integer.decode(this.getValue(a.getNodeValue(), template));
                    cond = this.joinAnd(cond, new ConditionPlayerCharges(value));
                    continue block130;
                }
                case "souls": {
                    int value = Integer.decode(this.getValue(a.getNodeValue(), template));
                    cond = this.joinAnd(cond, new ConditionPlayerSouls(value));
                    continue block130;
                }
                case "weight": {
                    int weight = Integer.decode(this.getValue(a.getNodeValue(), null));
                    cond = this.joinAnd(cond, new ConditionPlayerWeight(weight));
                    continue block130;
                }
                case "invsize": {
                    int size = Integer.decode(this.getValue(a.getNodeValue(), null));
                    cond = this.joinAnd(cond, new ConditionPlayerInvSize(size));
                    continue block130;
                }
                case "isclanleader": {
                    boolean val = Boolean.parseBoolean(a.getNodeValue());
                    cond = this.joinAnd(cond, new ConditionPlayerIsClanLeader(val));
                    continue block130;
                }
                case "ontvtevent": {
                    boolean val = Boolean.parseBoolean(a.getNodeValue());
                    cond = this.joinAnd(cond, new ConditionPlayerTvTEvent(val));
                    continue block130;
                }
                case "pledgeclass": {
                    int pledgeClass = Integer.decode(this.getValue(a.getNodeValue(), null));
                    cond = this.joinAnd(cond, new ConditionPlayerPledgeClass(pledgeClass));
                    continue block130;
                }
                case "clanhall": {
                    StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                    ArrayList<Integer> array = new ArrayList<Integer>(st.countTokens());
                    while (st.hasMoreTokens()) {
                        String item = st.nextToken().trim();
                        array.add(Integer.decode(this.getValue(item, null)));
                    }
                    cond = this.joinAnd(cond, new ConditionPlayerHasClanHall(array));
                    continue block130;
                }
                case "fort": {
                    int fort = Integer.decode(this.getValue(a.getNodeValue(), null));
                    cond = this.joinAnd(cond, new ConditionPlayerHasFort(fort));
                    continue block130;
                }
                case "castle": {
                    int castle = Integer.decode(this.getValue(a.getNodeValue(), null));
                    cond = this.joinAnd(cond, new ConditionPlayerHasCastle(castle));
                    continue block130;
                }
                case "sex": {
                    int sex = Integer.decode(this.getValue(a.getNodeValue(), null));
                    cond = this.joinAnd(cond, new ConditionPlayerSex(sex));
                    continue block130;
                }
                case "flymounted": {
                    boolean val = Boolean.parseBoolean(a.getNodeValue());
                    cond = this.joinAnd(cond, new ConditionPlayerFlyMounted(val));
                    continue block130;
                }
                case "vehiclemounted": {
                    boolean val = Boolean.parseBoolean(a.getNodeValue());
                    cond = this.joinAnd(cond, new ConditionPlayerVehicleMounted(val));
                    continue block130;
                }
                case "landingzone": {
                    boolean val = Boolean.parseBoolean(a.getNodeValue());
                    cond = this.joinAnd(cond, new ConditionPlayerLandingZone(val));
                    continue block130;
                }
                case "active_effect_id": {
                    int effect_id = Integer.decode(this.getValue(a.getNodeValue(), template));
                    cond = this.joinAnd(cond, new ConditionPlayerActiveEffectId(effect_id));
                    continue block130;
                }
                case "active_effect_id_lvl": {
                    String[] values = this.getValue(a.getNodeValue(), template).split(",");
                    int effect_id = Integer.decode(this.getValue(values[0], template));
                    int effect_lvl = Integer.decode(this.getValue(values[1], template));
                    cond = this.joinAnd(cond, new ConditionPlayerActiveEffectId(effect_id, effect_lvl));
                    continue block130;
                }
                case "active_skill_id": {
                    int skill_id = Integer.decode(this.getValue(a.getNodeValue(), template));
                    cond = this.joinAnd(cond, new ConditionPlayerActiveSkillId(skill_id));
                    continue block130;
                }
                case "active_skill_id_lvl": {
                    String[] v = this.getValue(a.getNodeValue(), template).split(",");
                    int skill_id = Integer.decode(this.getValue(v[0], template));
                    int skill_lvl = Integer.decode(this.getValue(v[1], template));
                    cond = this.joinAnd(cond, new ConditionPlayerActiveSkillId(skill_id, skill_lvl));
                    continue block130;
                }
                case "class_id_restriction": {
                    StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                    ArrayList<Integer> array = new ArrayList<Integer>(st.countTokens());
                    while (st.hasMoreTokens()) {
                        String item = st.nextToken().trim();
                        array.add(Integer.decode(this.getValue(item, null)));
                    }
                    cond = this.joinAnd(cond, new ConditionPlayerClassIdRestriction(array));
                    continue block130;
                }
                case "subclass": {
                    boolean val = Boolean.parseBoolean(a.getNodeValue());
                    cond = this.joinAnd(cond, new ConditionPlayerSubclass(val));
                    continue block130;
                }
                case "instanceid": {
                    StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                    ArrayList<Integer> array = new ArrayList<Integer>(st.countTokens());
                    while (st.hasMoreTokens()) {
                        String item = st.nextToken().trim();
                        array.add(Integer.decode(this.getValue(item, null)));
                    }
                    cond = this.joinAnd(cond, new ConditionPlayerInstanceId(array));
                    continue block130;
                }
                case "agathionid": {
                    int agathionId = Integer.decode(a.getNodeValue());
                    cond = this.joinAnd(cond, new ConditionPlayerAgathionId(agathionId));
                    continue block130;
                }
                case "cloakstatus": {
                    boolean val = Boolean.parseBoolean(a.getNodeValue());
                    cond = this.joinAnd(cond, new ConditionPlayerCloakStatus(val));
                    continue block130;
                }
                case "haspet": {
                    StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                    ArrayList<Integer> array = new ArrayList<Integer>(st.countTokens());
                    while (st.hasMoreTokens()) {
                        String item = st.nextToken().trim();
                        array.add(Integer.decode(this.getValue(item, null)));
                    }
                    cond = this.joinAnd(cond, new ConditionPlayerHasPet(array));
                    continue block130;
                }
                case "servitornpcid": {
                    StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                    ArrayList<Integer> array = new ArrayList<Integer>(st.countTokens());
                    while (st.hasMoreTokens()) {
                        String item = st.nextToken().trim();
                        array.add(Integer.decode(this.getValue(item, null)));
                    }
                    cond = this.joinAnd(cond, new ConditionPlayerServitorNpcId(array));
                    continue block130;
                }
                case "npcidradius": {
                    StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                    if (st.countTokens() != 3) continue block130;
                    String[] ids = st.nextToken().split(";");
                    int[] npcIds = new int[ids.length];
                    for (int index = 0; index < ids.length; ++index) {
                        npcIds[index] = Integer.parseInt(this.getValue(ids[index], template));
                    }
                    int radius = Integer.parseInt(st.nextToken());
                    boolean val = Boolean.parseBoolean(st.nextToken());
                    cond = this.joinAnd(cond, new ConditionPlayerRangeFromNpc(npcIds, radius, val));
                    continue block130;
                }
                case "callpc": {
                    cond = this.joinAnd(cond, new ConditionPlayerCallPc(Boolean.parseBoolean(a.getNodeValue())));
                    continue block130;
                }
                case "cancreatebase": {
                    cond = this.joinAnd(cond, new ConditionPlayerCanCreateBase(Boolean.parseBoolean(a.getNodeValue())));
                    continue block130;
                }
                case "cancreateoutpost": {
                    cond = this.joinAnd(cond, new ConditionPlayerCanCreateOutpost(Boolean.parseBoolean(a.getNodeValue())));
                    continue block130;
                }
                case "canescape": {
                    cond = this.joinAnd(cond, new ConditionPlayerCanEscape(Boolean.parseBoolean(a.getNodeValue())));
                    continue block130;
                }
                case "canrefuelairship": {
                    cond = this.joinAnd(cond, new ConditionPlayerCanRefuelAirship(Integer.parseInt(a.getNodeValue())));
                    continue block130;
                }
                case "canresurrect": {
                    cond = this.joinAnd(cond, new ConditionPlayerCanResurrect(Boolean.parseBoolean(a.getNodeValue())));
                    continue block130;
                }
                case "cansummon": {
                    cond = this.joinAnd(cond, new ConditionPlayerCanSummon(Boolean.parseBoolean(a.getNodeValue())));
                    continue block130;
                }
                case "cansummonsiegegolem": {
                    cond = this.joinAnd(cond, new ConditionPlayerCanSummonSiegeGolem(Boolean.parseBoolean(a.getNodeValue())));
                    continue block130;
                }
                case "cansweep": {
                    cond = this.joinAnd(cond, new ConditionPlayerCanSweep(Boolean.parseBoolean(a.getNodeValue())));
                    continue block130;
                }
                case "cantakecastle": {
                    cond = this.joinAnd(cond, new ConditionPlayerCanTakeCastle(Boolean.parseBoolean(a.getNodeValue())));
                    continue block130;
                }
                case "cantakefort": {
                    cond = this.joinAnd(cond, new ConditionPlayerCanTakeFort(Boolean.parseBoolean(a.getNodeValue())));
                    continue block130;
                }
                case "cantransform": {
                    cond = this.joinAnd(cond, new ConditionPlayerCanTransform(Boolean.parseBoolean(a.getNodeValue())));
                    continue block130;
                }
                case "canuntransform": {
                    cond = this.joinAnd(cond, new ConditionPlayerCanUntransform(Boolean.parseBoolean(a.getNodeValue())));
                    continue block130;
                }
                case "insidezoneid": {
                    StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                    ArrayList<Integer> array = new ArrayList<Integer>(st.countTokens());
                    while (st.hasMoreTokens()) {
                        String item = st.nextToken().trim();
                        array.add(Integer.decode(this.getValue(item, null)));
                    }
                    cond = this.joinAnd(cond, new ConditionPlayerInsideZoneId(array));
                    continue block130;
                }
                case "checkabnormal": {
                    String value = a.getNodeValue();
                    if (value.contains(",")) {
                        String[] values = value.split(",");
                        cond = this.joinAnd(cond, new ConditionPlayerCheckAbnormal(AbnormalType.valueOf(values[0]), Integer.decode(this.getValue(values[1], template))));
                        continue block130;
                    }
                    cond = this.joinAnd(cond, new ConditionPlayerCheckAbnormal(AbnormalType.valueOf(value)));
                    continue block130;
                }
                case "categorytype": {
                    String[] values = a.getNodeValue().split(",");
                    CategoryType[] array = new CategoryType[values.length];
                    for (int v = 0; v < values.length; ++v) {
                        array[v] = CategoryType.valueOf(this.getValue(values[v], null));
                    }
                    cond = this.joinAnd(cond, new ConditionCategoryType(array));
                    continue block130;
                }
            }
        }
        if (cond == null) {
            this._log.severe("Unrecognized <player> condition in " + this._file);
        }
        return cond;
    }

    protected Condition parseTargetCondition(Node n, Object template) {
        Condition cond = null;
        NamedNodeMap attrs = n.getAttributes();
        block42: for (int i = 0; i < attrs.getLength(); ++i) {
            Node a = attrs.item(i);
            switch (a.getNodeName().toLowerCase()) {
                case "aggro": {
                    boolean val = Boolean.parseBoolean(a.getNodeValue());
                    cond = this.joinAnd(cond, new ConditionTargetAggro(val));
                    continue block42;
                }
                case "siegezone": {
                    int value = Integer.decode(this.getValue(a.getNodeValue(), null));
                    cond = this.joinAnd(cond, new ConditionSiegeZone(value, false));
                    continue block42;
                }
                case "level": {
                    int lvl = Integer.decode(this.getValue(a.getNodeValue(), template));
                    cond = this.joinAnd(cond, new ConditionTargetLevel(lvl));
                    continue block42;
                }
                case "levelrange": {
                    String[] range = this.getValue(a.getNodeValue(), template).split(";");
                    if (range.length != 2) continue block42;
                    int[] lvlRange = new int[]{Integer.decode(range[0]), Integer.decode(range[1])};
                    cond = this.joinAnd(cond, new ConditionTargetLevelRange(lvlRange));
                    continue block42;
                }
                case "mypartyexceptme": {
                    cond = this.joinAnd(cond, new ConditionTargetMyPartyExceptMe(Boolean.parseBoolean(a.getNodeValue())));
                    continue block42;
                }
                case "playable": {
                    cond = this.joinAnd(cond, new ConditionTargetPlayable());
                    continue block42;
                }
                case "class_id_restriction": {
                    StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                    ArrayList<Integer> array = new ArrayList<Integer>(st.countTokens());
                    while (st.hasMoreTokens()) {
                        String item = st.nextToken().trim();
                        array.add(Integer.decode(this.getValue(item, null)));
                    }
                    cond = this.joinAnd(cond, new ConditionTargetClassIdRestriction(array));
                    continue block42;
                }
                case "active_effect_id": {
                    int effect_id = Integer.decode(this.getValue(a.getNodeValue(), template));
                    cond = this.joinAnd(cond, new ConditionTargetActiveEffectId(effect_id));
                    continue block42;
                }
                case "active_effect_id_lvl": {
                    String[] values = this.getValue(a.getNodeValue(), template).split(",");
                    int effect_id = Integer.decode(this.getValue(values[0], template));
                    int effect_lvl = Integer.decode(this.getValue(values[1], template));
                    cond = this.joinAnd(cond, new ConditionTargetActiveEffectId(effect_id, effect_lvl));
                    continue block42;
                }
                case "active_skill_id": {
                    int skill_id = Integer.decode(this.getValue(a.getNodeValue(), template));
                    cond = this.joinAnd(cond, new ConditionTargetActiveSkillId(skill_id));
                    continue block42;
                }
                case "active_skill_id_lvl": {
                    String[] values = this.getValue(a.getNodeValue(), template).split(",");
                    int skill_id = Integer.decode(this.getValue(values[0], template));
                    int skill_lvl = Integer.decode(this.getValue(values[1], template));
                    cond = this.joinAnd(cond, new ConditionTargetActiveSkillId(skill_id, skill_lvl));
                    continue block42;
                }
                case "abnormal": {
                    int abnormalId = Integer.decode(this.getValue(a.getNodeValue(), template));
                    cond = this.joinAnd(cond, new ConditionTargetAbnormal(abnormalId));
                    continue block42;
                }
                case "mindistance": {
                    int distance = Integer.decode(this.getValue(a.getNodeValue(), null));
                    cond = this.joinAnd(cond, new ConditionMinDistance(distance * distance));
                    continue block42;
                }
                case "race": {
                    cond = this.joinAnd(cond, new ConditionTargetRace(Race.valueOf(a.getNodeValue())));
                    continue block42;
                }
                case "using": {
                    int mask = 0;
                    StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                    block44: while (st.hasMoreTokens()) {
                        String item = st.nextToken().trim();
                        for (WeaponType weaponType : WeaponType.values()) {
                            if (!weaponType.name().equals(item)) continue;
                            mask |= weaponType.mask();
                            break;
                        }
                        for (Enum enum_ : ArmorType.values()) {
                            if (!enum_.name().equals(item)) continue;
                            mask |= ((ArmorType)enum_).mask();
                            continue block44;
                        }
                    }
                    cond = this.joinAnd(cond, new ConditionTargetUsesWeaponKind(mask));
                    continue block42;
                }
                case "npcid": {
                    StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                    ArrayList<Integer> array = new ArrayList<Integer>(st.countTokens());
                    while (st.hasMoreTokens()) {
                        String item = st.nextToken().trim();
                        array.add(Integer.decode(this.getValue(item, null)));
                    }
                    cond = this.joinAnd(cond, new ConditionTargetNpcId(array));
                    continue block42;
                }
                case "npctype": {
                    String values = this.getValue(a.getNodeValue(), template).trim();
                    String[] valuesSplit = values.split(",");
                    InstanceType[] types = new InstanceType[valuesSplit.length];
                    for (int j = 0; j < valuesSplit.length; ++j) {
                        InstanceType type = Enum.valueOf(InstanceType.class, valuesSplit[j]);
                        if (type == null) {
                            throw new IllegalArgumentException("Instance type not recognized: " + valuesSplit[j]);
                        }
                        types[j] = type;
                    }
                    cond = this.joinAnd(cond, new ConditionTargetNpcType(types));
                    continue block42;
                }
                case "weight": {
                    int weight = Integer.decode(this.getValue(a.getNodeValue(), null));
                    cond = this.joinAnd(cond, new ConditionTargetWeight(weight));
                    continue block42;
                }
                case "invsize": {
                    int size = Integer.decode(this.getValue(a.getNodeValue(), null));
                    cond = this.joinAnd(cond, new ConditionTargetInvSize(size));
                    continue block42;
                }
            }
        }
        if (cond == null) {
            this._log.severe("Unrecognized <target> condition in " + this._file);
        }
        return cond;
    }

    protected Condition parseUsingCondition(Node n) {
        Condition cond = null;
        NamedNodeMap attrs = n.getAttributes();
        block14: for (int i = 0; i < attrs.getLength(); ++i) {
            Node a = attrs.item(i);
            switch (a.getNodeName().toLowerCase()) {
                case "kind": {
                    int old;
                    int mask = 0;
                    StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                    while (st.hasMoreTokens()) {
                        old = mask;
                        String item = st.nextToken().trim();
                        for (WeaponType weaponType : WeaponType.values()) {
                            if (!weaponType.name().equals(item)) continue;
                            mask |= weaponType.mask();
                        }
                        for (Enum enum_ : ArmorType.values()) {
                            if (!enum_.name().equals(item)) continue;
                            mask |= ((ArmorType)enum_).mask();
                        }
                        if (old != mask) continue;
                        this._log.info("[parseUsingCondition=\"kind\"] Unknown item type name: " + item);
                    }
                    cond = this.joinAnd(cond, new ConditionUsingItemType(mask));
                    continue block14;
                }
                case "slot": {
                    int old;
                    int mask = 0;
                    StringTokenizer st = new StringTokenizer(a.getNodeValue(), ",");
                    while (st.hasMoreTokens()) {
                        old = mask;
                        String item = st.nextToken().trim();
                        Integer slot = ItemTable._slots.get(item);
                        if (slot != null) {
                            mask |= slot.intValue();
                        }
                        if (old != mask) continue;
                        this._log.info("[parseUsingCondition=\"slot\"] Unknown item slot name: " + item);
                    }
                    cond = this.joinAnd(cond, new ConditionUsingSlotType(mask));
                    continue block14;
                }
                case "skill": {
                    int id = Integer.parseInt(a.getNodeValue());
                    cond = this.joinAnd(cond, new ConditionUsingSkill(id));
                    continue block14;
                }
                case "slotitem": {
                    StringTokenizer st = new StringTokenizer(a.getNodeValue(), ";");
                    int id = Integer.parseInt(st.nextToken().trim());
                    int slot = Integer.parseInt(st.nextToken().trim());
                    int enchant = 0;
                    if (st.hasMoreTokens()) {
                        enchant = Integer.parseInt(st.nextToken().trim());
                    }
                    cond = this.joinAnd(cond, new ConditionSlotItemId(slot, id, enchant));
                    continue block14;
                }
                case "weaponchange": {
                    boolean val = Boolean.parseBoolean(a.getNodeValue());
                    cond = this.joinAnd(cond, new ConditionChangeWeapon(val));
                    continue block14;
                }
            }
        }
        if (cond == null) {
            this._log.severe("Unrecognized <using> condition in " + this._file);
        }
        return cond;
    }

    protected Condition parseGameCondition(Node n) {
        Condition cond = null;
        NamedNodeMap attrs = n.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            int val;
            Node a = attrs.item(i);
            if ("skill".equalsIgnoreCase(a.getNodeName())) {
                val = Boolean.parseBoolean(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionWithSkill(val != 0));
            }
            if ("night".equalsIgnoreCase(a.getNodeName())) {
                val = Boolean.parseBoolean(a.getNodeValue());
                cond = this.joinAnd(cond, new ConditionGameTime(ConditionGameTime.CheckGameTime.NIGHT, val != 0));
            }
            if (!"chance".equalsIgnoreCase(a.getNodeName())) continue;
            val = Integer.decode(this.getValue(a.getNodeValue(), null));
            cond = this.joinAnd(cond, new ConditionGameChance(val));
        }
        if (cond == null) {
            this._log.severe("Unrecognized <game> condition in " + this._file);
        }
        return cond;
    }

    protected void parseTable(Node n) {
        NamedNodeMap attrs = n.getAttributes();
        String name = attrs.getNamedItem("name").getNodeValue();
        if (name.charAt(0) != '#') {
            throw new IllegalArgumentException("Table name must start with #");
        }
        StringTokenizer data = new StringTokenizer(n.getFirstChild().getNodeValue());
        ArrayList<String> array = new ArrayList<String>(data.countTokens());
        while (data.hasMoreTokens()) {
            array.add(StringIntern.intern(data.nextToken()));
        }
        this.setTable(name, array.toArray(new String[array.size()]));
    }

    protected void parseBeanSet(Node n, StatsSet set, Integer level) {
        char ch;
        String name = n.getAttributes().getNamedItem("name").getNodeValue().trim();
        String value = n.getAttributes().getNamedItem("val").getNodeValue().trim();
        char c = ch = value.isEmpty() ? (char)' ' : (char)value.charAt(0);
        if (ch == '#' || ch == '-' || Character.isDigit(ch)) {
            set.set(name, String.valueOf(this.getValue(value, level)));
        } else {
            set.set(name, value);
        }
    }

    protected void setExtractableSkillData(StatsSet set, String value) {
        set.set("capsuled_items_skill", value);
    }

    protected String getValue(String value, Object template) {
        if (value.charAt(0) == '#') {
            if (template instanceof Skill) {
                return this.getTableValue(value);
            }
            if (template instanceof Integer) {
                return this.getTableValue(value, (Integer)template);
            }
            throw new IllegalStateException();
        }
        return value;
    }

    protected Condition joinAnd(Condition cond, Condition c) {
        if (cond == null) {
            return c;
        }
        if (cond instanceof ConditionLogicAnd) {
            ((ConditionLogicAnd)cond).add(c);
            return cond;
        }
        ConditionLogicAnd and = new ConditionLogicAnd();
        and.add(cond);
        and.add(c);
        return and;
    }
}

