/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.enums;

import javolution.util.FastMap;

public enum InstanceType {
    L2Object(null),
    L2ItemInstance(L2Object),
    L2Character(L2Object),
    L2Npc(L2Character),
    L2Playable(L2Character),
    L2Summon(L2Playable),
    L2Decoy(L2Character),
    L2PcInstance(L2Playable),
    L2NpcInstance(L2Npc),
    L2MerchantInstance(L2NpcInstance),
    L2WarehouseInstance(L2NpcInstance),
    L2StaticObjectInstance(L2Character),
    L2DoorInstance(L2Character),
    L2TerrainObjectInstance(L2Npc),
    L2EffectPointInstance(L2Npc),
    L2ServitorInstance(L2Summon),
    L2PetInstance(L2Summon),
    L2BabyPetInstance(L2PetInstance),
    L2DecoyInstance(L2Decoy),
    L2TrapInstance(L2Npc),
    L2Attackable(L2Npc),
    L2GuardInstance(L2Attackable),
    L2QuestGuardInstance(L2GuardInstance),
    L2MonsterInstance(L2Attackable),
    L2ChestInstance(L2MonsterInstance),
    L2ControllableMobInstance(L2MonsterInstance),
    L2FeedableBeastInstance(L2MonsterInstance),
    L2TamedBeastInstance(L2FeedableBeastInstance),
    L2FriendlyMobInstance(L2Attackable),
    L2RiftInvaderInstance(L2MonsterInstance),
    L2RaidBossInstance(L2MonsterInstance),
    L2GrandBossInstance(L2RaidBossInstance),
    L2FlyNpcInstance(L2NpcInstance),
    L2FlyMonsterInstance(L2MonsterInstance),
    L2FlyRaidBossInstance(L2RaidBossInstance),
    L2FlyTerrainObjectInstance(L2Npc),
    L2SepulcherNpcInstance(L2NpcInstance),
    L2SepulcherMonsterInstance(L2MonsterInstance),
    L2FestivalGiudeInstance(L2Npc),
    L2FestivalMonsterInstance(L2MonsterInstance),
    L2Vehicle(L2Character),
    L2BoatInstance(L2Vehicle),
    L2AirShipInstance(L2Vehicle),
    L2ControllableAirShipInstance(L2AirShipInstance),
    L2DefenderInstance(L2Attackable),
    L2ArtefactInstance(L2NpcInstance),
    L2ControlTowerInstance(L2Npc),
    L2FlameTowerInstance(L2Npc),
    L2SiegeFlagInstance(L2Npc),
    L2FortCommanderInstance(L2DefenderInstance),
    L2FortLogisticsInstance(L2MerchantInstance),
    L2FortManagerInstance(L2MerchantInstance),
    L2SignsPriestInstance(L2Npc),
    L2DawnPriestInstance(L2SignsPriestInstance),
    L2DuskPriestInstance(L2SignsPriestInstance),
    L2DungeonGatekeeperInstance(L2Npc),
    L2AdventurerInstance(L2NpcInstance),
    L2AuctioneerInstance(L2Npc),
    L2ClanHallManagerInstance(L2MerchantInstance),
    L2FishermanInstance(L2MerchantInstance),
    L2ObservationInstance(L2Npc),
    L2OlympiadManagerInstance(L2Npc),
    L2PetManagerInstance(L2MerchantInstance),
    L2RaceManagerInstance(L2Npc),
    L2TeleporterInstance(L2Npc),
    L2TrainerInstance(L2NpcInstance),
    L2VillageMasterInstance(L2NpcInstance),
    L2DoormenInstance(L2NpcInstance),
    L2CastleDoormenInstance(L2DoormenInstance),
    L2FortDoormenInstance(L2DoormenInstance),
    L2ClanHallDoormenInstance(L2DoormenInstance),
    L2ClassMasterInstance(L2NpcInstance),
    L2NpcBufferInstance(L2Npc),
    L2EventMobInstance(L2Npc);

    private final InstanceType _parent;
    private final long _typeL;
    private final long _typeH;
    private final long _maskL;
    private final long _maskH;
    private static final FastMap<String, InstanceType> _templateTypes;

    private InstanceType(InstanceType parent) {
        this._parent = parent;
        int ordinal = this.ordinal();
        if (ordinal < 64) {
            this._typeL = 1L << ordinal;
            this._typeH = 0L;
        } else if (ordinal < 128) {
            this._typeL = 0L;
            this._typeH = 1L << ordinal;
        } else {
            throw new Error("Too many instance types, failed to load " + this.name());
        }
        if (parent != null) {
            this._maskL = this._typeL | parent._maskL;
            this._maskH = this._typeH | parent._maskH;
        } else {
            this._maskL = this._typeL;
            this._maskH = this._typeH;
        }
    }

    public final InstanceType getParent() {
        return this._parent;
    }

    public final boolean isType(InstanceType it) {
        return (it._typeL & this._maskL) != 0L || (it._typeH & this._maskH) != 0L;
    }

    public final boolean isTypes(InstanceType ... it) {
        for (InstanceType i : it) {
            if (!this.isType(i)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isType(String type, InstanceType it) {
        InstanceType me = (InstanceType)((Object)_templateTypes.get((Object)type));
        return me != null && me.isType(it);
    }

    public static final boolean isTypes(String type, InstanceType it1, InstanceType it2) {
        InstanceType me = (InstanceType)((Object)_templateTypes.get((Object)type));
        return me != null && (me.isType(it1) || me.isType(it2));
    }

    public static final boolean isTypes(String type, InstanceType it1, InstanceType it2, InstanceType it3) {
        InstanceType me = (InstanceType)((Object)_templateTypes.get((Object)type));
        return me != null && (me.isType(it1) || me.isType(it2) || me.isType(it3));
    }

    public static final boolean isTypes(String type, InstanceType ... it) {
        InstanceType me = (InstanceType)((Object)_templateTypes.get((Object)type));
        return me != null && me.isTypes(it);
    }

    static {
        _templateTypes = new FastMap();
        for (InstanceType it : InstanceType.values()) {
            String name = it.name();
            if (!name.endsWith("Instance")) continue;
            _templateTypes.put((Object)name.substring(0, name.length() - 8), (Object)it);
        }
    }
}

