/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import java.util.concurrent.atomic.AtomicInteger;
import jp.sf.l2j.troja.FastIntObjectMap;

public final class AntiFeedManager {
    public static final int GAME_ID = 0;
    public static final int OLYMPIAD_ID = 1;
    public static final int TVT_ID = 2;
    public static final int L2EVENT_ID = 3;
    private final FastIntObjectMap<Long> _lastDeathTimes = new FastIntObjectMap().shared();
    private final FastIntObjectMap<FastIntObjectMap<AtomicInteger>> _eventIPs = new FastIntObjectMap().shared();

    protected AntiFeedManager() {
    }

    public final void setLastDeathTime(int objectId) {
        this._lastDeathTimes.put(objectId, (Object)System.currentTimeMillis());
    }

    public final boolean check(L2Character attacker, L2Character target) {
        Long v;
        if (!Config.L2JMOD_ANTIFEED_ENABLE) {
            return true;
        }
        if (target == null) {
            return false;
        }
        L2PcInstance targetPlayer = target.getActingPlayer();
        if (targetPlayer == null) {
            return false;
        }
        if (Config.L2JMOD_ANTIFEED_INTERVAL > 0 && (v = (Long)this._lastDeathTimes.get(targetPlayer.getObjectId())) != null && System.currentTimeMillis() - v < (long)Config.L2JMOD_ANTIFEED_INTERVAL) {
            return false;
        }
        if (Config.L2JMOD_ANTIFEED_DUALBOX && attacker != null) {
            L2PcInstance attackerPlayer = attacker.getActingPlayer();
            if (attackerPlayer == null) {
                return false;
            }
            L2GameClient targetClient = targetPlayer.getClient();
            L2GameClient attackerClient = attackerPlayer.getClient();
            if (targetClient == null || attackerClient == null || targetClient.isDetached() || attackerClient.isDetached()) {
                return !Config.L2JMOD_ANTIFEED_DISCONNECTED_AS_DUALBOX;
            }
            return !targetClient.getConnectionAddress().equals(attackerClient.getConnectionAddress());
        }
        return true;
    }

    public final void clear() {
        this._lastDeathTimes.clear();
    }

    public final void registerEvent(int eventId) {
        this._eventIPs.computeIfAbsent(eventId, v -> new FastIntObjectMap().shared());
    }

    public final boolean tryAddPlayer(int eventId, L2PcInstance player, int max) {
        return this.tryAddClient(eventId, player.getClient(), max);
    }

    public final boolean tryAddClient(int eventId, L2GameClient client, int max) {
        AtomicInteger connectionCount;
        if (client == null) {
            return false;
        }
        FastIntObjectMap event = (FastIntObjectMap)this._eventIPs.get(eventId);
        if (event == null) {
            return false;
        }
        Integer addrHash = client.getConnectionAddress().hashCode();
        int limit = max;
        if (Config.L2JMOD_DUALBOX_CHECK_WHITELIST.containsKey(addrHash)) {
            limit += Config.L2JMOD_DUALBOX_CHECK_WHITELIST.get(addrHash).intValue();
        }
        return (connectionCount = (AtomicInteger)event.computeIfAbsent(addrHash.intValue(), k -> new AtomicInteger())).getAndIncrement() < limit;
    }

    public final boolean removePlayer(int eventId, L2PcInstance player) {
        return this.removeClient(eventId, player.getClient());
    }

    public final boolean removeClient(int eventId, L2GameClient client) {
        if (client == null) {
            return false;
        }
        FastIntObjectMap event = (FastIntObjectMap)this._eventIPs.get(eventId);
        if (event == null) {
            return false;
        }
        Integer addrHash = client.getConnectionAddress().hashCode();
        return event.computeIfPresent(addrHash.intValue(), (k, v) -> {
            if (v == null || v.decrementAndGet() == 0) {
                return null;
            }
            return v;
        }) != null;
    }

    public final void onDisconnect(L2GameClient client) {
        if (client == null) {
            return;
        }
        this._eventIPs.forEach((k, v) -> this.removeClient(k, client));
    }

    public final void clear(int eventId) {
        FastIntObjectMap event = (FastIntObjectMap)this._eventIPs.get(eventId);
        if (event != null) {
            event.clear();
        }
    }

    public final int getLimit(L2PcInstance player, int max) {
        return this.getLimit(player.getClient(), max);
    }

    public final int getLimit(L2GameClient client, int max) {
        if (client == null) {
            return max;
        }
        Integer addrHash = client.getConnectionAddress().hashCode();
        int limit = max;
        if (Config.L2JMOD_DUALBOX_CHECK_WHITELIST.containsKey(addrHash)) {
            limit += Config.L2JMOD_DUALBOX_CHECK_WHITELIST.get(addrHash).intValue();
        }
        return limit;
    }

    public static final AntiFeedManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final AntiFeedManager _instance = new AntiFeedManager();

        private SingletonHolder() {
        }
    }
}

