/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.enums.ManorMode;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.CropProcure;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.L2Seed;
import com.l2jserver.gameserver.model.SeedProduction;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.interfaces.IStorable;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.util.Rnd;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import jp.sf.l2j.troja.FastIntObjectMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class CastleManorManager
extends DocumentParser
implements IStorable {
    private static final String INSERT_PRODUCT = "INSERT INTO castle_manor_production VALUES (?, ?, ?, ?, ?, ?)";
    private static final String INSERT_CROP = "INSERT INTO castle_manor_procure VALUES (?, ?, ?, ?, ?, ?, ?)";
    private ManorMode _mode = ManorMode.APPROVED;
    private Calendar _nextModeChange = null;
    private static final FastIntObjectMap<L2Seed> _seeds = new FastIntObjectMap();
    private static final FastIntObjectMap<L2Seed> _crops = new FastIntObjectMap();
    private final FastIntObjectMap<List<CropProcure>> _procure = new FastIntObjectMap();
    private final FastIntObjectMap<List<CropProcure>> _procureNext = new FastIntObjectMap();
    private final FastIntObjectMap<List<SeedProduction>> _production = new FastIntObjectMap();
    private final FastIntObjectMap<List<SeedProduction>> _productionNext = new FastIntObjectMap();

    public CastleManorManager() {
        if (Config.ALLOW_MANOR) {
            this.load();
            this.loadDb();
            Calendar currentTime = Calendar.getInstance();
            int hour = currentTime.get(11);
            int min = currentTime.get(12);
            int maintenanceMin = Config.ALT_MANOR_REFRESH_MIN + Config.ALT_MANOR_MAINTENANCE_MIN;
            if (hour >= Config.ALT_MANOR_REFRESH_TIME && min >= maintenanceMin || hour < Config.ALT_MANOR_APPROVE_TIME || hour == Config.ALT_MANOR_APPROVE_TIME && min <= Config.ALT_MANOR_APPROVE_MIN) {
                this._mode = ManorMode.MODIFIABLE;
            } else if (hour == Config.ALT_MANOR_REFRESH_TIME && min >= Config.ALT_MANOR_REFRESH_MIN && min < maintenanceMin) {
                this._mode = ManorMode.MAINTENANCE;
            }
            this.scheduleModeChange();
            if (!Config.ALT_MANOR_SAVE_ALL_ACTIONS) {
                ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(this::storeMe, Config.ALT_MANOR_SAVE_PERIOD_RATE, Config.ALT_MANOR_SAVE_PERIOD_RATE, TimeUnit.HOURS);
            }
            if (Config.DEBUG) {
                this._log.info(this.getClass().getSimpleName() + ": Current mode " + this._mode.toString());
            }
        } else {
            this._mode = ManorMode.DISABLED;
            this._log.info(this.getClass().getSimpleName() + ": Manor system is deactivated.");
        }
    }

    @Override
    public final void load() {
        this.parseDatapackFile("data/seeds.xml");
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + _seeds.size() + " seeds.");
    }

    @Override
    protected final void parseDocument() {
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"castle".equalsIgnoreCase(d.getNodeName())) continue;
                int castleId = this.parseInt(d.getAttributes(), "id");
                for (Node c = d.getFirstChild(); c != null; c = c.getNextSibling()) {
                    if (!"crop".equalsIgnoreCase(c.getNodeName())) continue;
                    StatsSet set = new StatsSet();
                    set.set("castleId", castleId);
                    NamedNodeMap attrs = c.getAttributes();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        Node att = attrs.item(i);
                        set.set(att.getNodeName(), att.getNodeValue());
                    }
                    L2Seed seed = new L2Seed(set);
                    _seeds.put(seed.getSeedId(), (Object)seed);
                    _crops.putIfAbsent(seed.getCropId(), (Object)seed);
                }
            }
        }
    }

    private final void loadDb() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement stProduction = con.prepareStatement("SELECT * FROM castle_manor_production WHERE castle_id=?");
             PreparedStatement stProcure = con.prepareStatement("SELECT * FROM castle_manor_procure WHERE castle_id=?");){
            for (Castle castle : CastleManager.getInstance().getCastles()) {
                int castleId = castle.getResidenceId();
                stProduction.clearParameters();
                stProcure.clearParameters();
                ArrayList<SeedProduction> pCurrent = new ArrayList<SeedProduction>();
                ArrayList<SeedProduction> pNext = new ArrayList<SeedProduction>();
                stProduction.setInt(1, castleId);
                try (ResultSet rs = stProduction.executeQuery();){
                    while (rs.next()) {
                        int seedId = rs.getInt("seed_id");
                        if (_seeds.containsKey(seedId)) {
                            SeedProduction sp = new SeedProduction(seedId, rs.getLong("amount"), rs.getLong("price"), rs.getInt("start_amount"));
                            if (rs.getBoolean("next_period")) {
                                pNext.add(sp);
                                continue;
                            }
                            pCurrent.add(sp);
                            continue;
                        }
                        this._log.warning(this.getClass().getSimpleName() + ": Unknown seed id: " + seedId + "!");
                    }
                }
                this._production.put(castleId, pCurrent);
                this._productionNext.put(castleId, pNext);
                ArrayList<CropProcure> current = new ArrayList<CropProcure>();
                ArrayList<CropProcure> next = new ArrayList<CropProcure>();
                stProcure.setInt(1, castleId);
                try (ResultSet rs = stProcure.executeQuery();){
                    while (rs.next()) {
                        int cropId = rs.getInt("crop_id");
                        if (_crops.containsKey(cropId)) {
                            CropProcure cp = new CropProcure(cropId, rs.getLong("amount"), rs.getInt("reward_type"), rs.getLong("start_amount"), rs.getLong("price"));
                            if (rs.getBoolean("next_period")) {
                                next.add(cp);
                                continue;
                            }
                            current.add(cp);
                            continue;
                        }
                        this._log.warning(this.getClass().getSimpleName() + ": Unknown crop id: " + cropId + "!");
                    }
                }
                this._procure.put(castleId, current);
                this._procureNext.put(castleId, next);
            }
            this._log.info(this.getClass().getSimpleName() + ": Manor data loaded.");
        }
        catch (Exception e) {
            this._log.warning(this.getClass().getSimpleName() + ": Unable to load manor data! " + e.getMessage());
        }
    }

    private final void scheduleModeChange() {
        this._nextModeChange = Calendar.getInstance();
        this._nextModeChange.set(14, 0);
        this._nextModeChange.set(13, 0);
        switch (this._mode) {
            case MODIFIABLE: {
                this._nextModeChange.set(11, Config.ALT_MANOR_APPROVE_TIME);
                this._nextModeChange.set(12, Config.ALT_MANOR_APPROVE_MIN);
                if (!this._nextModeChange.before(Calendar.getInstance())) break;
                this._nextModeChange.add(5, 1);
                break;
            }
            case MAINTENANCE: {
                this._nextModeChange.set(11, Config.ALT_MANOR_REFRESH_TIME);
                this._nextModeChange.set(12, Config.ALT_MANOR_REFRESH_MIN + Config.ALT_MANOR_MAINTENANCE_MIN);
                break;
            }
            case APPROVED: {
                this._nextModeChange.set(11, Config.ALT_MANOR_REFRESH_TIME);
                this._nextModeChange.set(12, Config.ALT_MANOR_REFRESH_MIN);
            }
        }
        ThreadPoolManager.getInstance().scheduleGeneral(this::changeMode, this._nextModeChange.getTimeInMillis() - System.currentTimeMillis());
    }

    public final void changeMode() {
        switch (this._mode) {
            case APPROVED: {
                this._mode = ManorMode.MAINTENANCE;
                for (Castle castle : CastleManager.getInstance().getCastles()) {
                    L2Clan owner = castle.getOwner();
                    if (owner == null) continue;
                    int castleId = castle.getResidenceId();
                    ItemContainer cwh = owner.getWarehouse();
                    for (CropProcure crop : (List)this._procure.get(castleId)) {
                        if (crop.getStartAmount() <= 0L) continue;
                        if (crop.getStartAmount() != crop.getAmount()) {
                            long count = (long)((double)(crop.getStartAmount() - crop.getAmount()) * 0.9);
                            if (count < 1L && Rnd.nextInt(99) < 90) {
                                count = 1L;
                            }
                            if (count > 0L) {
                                cwh.addItem("Manor", this.getSeedByCrop(crop.getId()).getMatureId(), count, null, null);
                            }
                        }
                        if (crop.getAmount() <= 0L) continue;
                        castle.addToTreasuryNoTax(crop.getAmount() * crop.getPrice());
                    }
                    List _nextProduction = (List)this._productionNext.get(castleId);
                    List _nextProcure = (List)this._procureNext.get(castleId);
                    this._production.put(castleId, (Object)_nextProduction);
                    this._procure.put(castleId, (Object)_nextProcure);
                    if (castle.getTreasury() < this.getManorCost(castleId, false)) {
                        this._productionNext.put(castleId, Collections.emptyList());
                        this._procureNext.put(castleId, Collections.emptyList());
                        continue;
                    }
                    ArrayList production = new ArrayList(_nextProduction);
                    for (SeedProduction s : production) {
                        s.setAmount(s.getStartAmount());
                    }
                    this._productionNext.put(castleId, production);
                    ArrayList procure = new ArrayList(_nextProcure);
                    for (CropProcure cr : procure) {
                        cr.setAmount(cr.getStartAmount());
                    }
                    this._procureNext.put(castleId, procure);
                }
                this.storeMe();
                break;
            }
            case MAINTENANCE: {
                for (Castle castle : CastleManager.getInstance().getCastles()) {
                    L2ClanMember clanLeader;
                    L2Clan owner = castle.getOwner();
                    if (owner == null || (clanLeader = owner.getLeader()) == null || !clanLeader.isOnline()) continue;
                    clanLeader.getPlayerInstance().sendPacket(SystemMessageId.THE_MANOR_INFORMATION_HAS_BEEN_UPDATED);
                }
                this._mode = ManorMode.MODIFIABLE;
                break;
            }
            case MODIFIABLE: {
                this._mode = ManorMode.APPROVED;
                for (Castle castle : CastleManager.getInstance().getCastles()) {
                    L2Clan owner = castle.getOwner();
                    if (owner == null) continue;
                    int slots = 0;
                    int castleId = castle.getResidenceId();
                    ItemContainer cwh = owner.getWarehouse();
                    for (CropProcure crop : (List)this._procureNext.get(castleId)) {
                        if (crop.getStartAmount() <= 0L || cwh.getItemsByItemId(this.getSeedByCrop(crop.getId()).getMatureId()) != null) continue;
                        ++slots;
                    }
                    long manorCost = this.getManorCost(castleId, true);
                    if (!cwh.validateCapacity(slots) && castle.getTreasury() < manorCost) {
                        ((List)this._productionNext.get(castleId)).clear();
                        ((List)this._procureNext.get(castleId)).clear();
                        L2ClanMember clanLeader = owner.getLeader();
                        if (clanLeader == null || !clanLeader.isOnline()) continue;
                        clanLeader.getPlayerInstance().sendPacket(SystemMessageId.THE_AMOUNT_IS_NOT_SUFFICIENT_AND_SO_THE_MANOR_IS_NOT_IN_OPERATION);
                        continue;
                    }
                    castle.addToTreasuryNoTax(-manorCost);
                }
                if (!Config.ALT_MANOR_SAVE_ALL_ACTIONS) break;
                this.storeMe();
            }
        }
        this.scheduleModeChange();
        if (Config.DEBUG) {
            this._log.info(this.getClass().getName() + ": Manor mode changed to " + this._mode.toString() + "!");
        }
    }

    public final void setNextSeedProduction(List<SeedProduction> list, int castleId) {
        this._productionNext.put(castleId, list);
        if (Config.ALT_MANOR_SAVE_ALL_ACTIONS) {
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement dps = con.prepareStatement("DELETE FROM castle_manor_production WHERE castle_id = ? AND next_period = 1");
                 PreparedStatement ips = con.prepareStatement(INSERT_PRODUCT);){
                dps.setInt(1, castleId);
                dps.executeUpdate();
                if (!list.isEmpty()) {
                    for (SeedProduction sp : list) {
                        ips.setInt(1, castleId);
                        ips.setInt(2, sp.getId());
                        ips.setLong(3, sp.getAmount());
                        ips.setLong(4, sp.getStartAmount());
                        ips.setLong(5, sp.getPrice());
                        ips.setBoolean(6, true);
                        ips.addBatch();
                    }
                    ips.executeBatch();
                }
            }
            catch (Exception e) {
                this._log.severe(this.getClass().getSimpleName() + ": Unable to store manor data! " + e.getMessage());
            }
        }
    }

    public final void setNextCropProcure(List<CropProcure> list, int castleId) {
        this._procureNext.put(castleId, list);
        if (Config.ALT_MANOR_SAVE_ALL_ACTIONS) {
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement dps = con.prepareStatement("DELETE FROM castle_manor_procure WHERE castle_id = ? AND next_period = 1");
                 PreparedStatement ips = con.prepareStatement(INSERT_CROP);){
                dps.setInt(1, castleId);
                dps.executeUpdate();
                if (!list.isEmpty()) {
                    for (CropProcure cp : list) {
                        ips.setInt(1, castleId);
                        ips.setInt(2, cp.getId());
                        ips.setLong(3, cp.getAmount());
                        ips.setLong(4, cp.getStartAmount());
                        ips.setLong(5, cp.getPrice());
                        ips.setInt(6, cp.getReward());
                        ips.setBoolean(7, true);
                        ips.addBatch();
                    }
                    ips.executeBatch();
                }
            }
            catch (Exception e) {
                this._log.severe(this.getClass().getSimpleName() + ": Unable to store manor data! " + e.getMessage());
            }
        }
    }

    public final void updateCurrentProduction(int castleId, Collection<SeedProduction> items) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("UPDATE castle_manor_production SET amount = ? WHERE castle_id = ? AND seed_id = ? AND next_period = 0");){
            for (SeedProduction sp : items) {
                ps.setLong(1, sp.getAmount());
                ps.setInt(2, castleId);
                ps.setInt(3, sp.getId());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (Exception e) {
            this._log.info(this.getClass().getSimpleName() + ": Unable to store manor data! " + e.getMessage());
        }
    }

    public final void updateCurrentProcure(int castleId, Collection<CropProcure> items) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("UPDATE castle_manor_procure SET amount = ? WHERE castle_id = ? AND crop_id = ? AND next_period = 0");){
            for (CropProcure sp : items) {
                ps.setLong(1, sp.getAmount());
                ps.setInt(2, castleId);
                ps.setInt(3, sp.getId());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (Exception e) {
            this._log.info(this.getClass().getSimpleName() + ": Unable to store manor data! " + e.getMessage());
        }
    }

    public final List<SeedProduction> getSeedProduction(int castleId, boolean nextPeriod) {
        return nextPeriod ? (List)this._productionNext.get(castleId) : (List)this._production.get(castleId);
    }

    public final SeedProduction getSeedProduct(int castleId, int seedId, boolean nextPeriod) {
        for (SeedProduction sp : this.getSeedProduction(castleId, nextPeriod)) {
            if (sp.getId() != seedId) continue;
            return sp;
        }
        return null;
    }

    public final List<CropProcure> getCropProcure(int castleId, boolean nextPeriod) {
        return nextPeriod ? (List)this._procureNext.get(castleId) : (List)this._procure.get(castleId);
    }

    public final CropProcure getCropProcure(int castleId, int cropId, boolean nextPeriod) {
        for (CropProcure cp : this.getCropProcure(castleId, nextPeriod)) {
            if (cp.getId() != cropId) continue;
            return cp;
        }
        return null;
    }

    public final long getManorCost(int castleId, boolean nextPeriod) {
        List<CropProcure> procure = this.getCropProcure(castleId, nextPeriod);
        List<SeedProduction> production = this.getSeedProduction(castleId, nextPeriod);
        long total = 0L;
        for (SeedProduction seed : production) {
            L2Seed s = this.getSeed(seed.getId());
            total += s == null ? 1L : (long)s.getSeedReferencePrice() * seed.getStartAmount();
        }
        for (CropProcure crop : procure) {
            total += crop.getPrice() * crop.getStartAmount();
        }
        return total;
    }

    /*
     * Exception decompiling
     */
    @Override
    public final boolean storeMe() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 8 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final void resetManorData(int castleId) {
        ((List)this._procure.get(castleId)).clear();
        ((List)this._procureNext.get(castleId)).clear();
        ((List)this._production.get(castleId)).clear();
        ((List)this._productionNext.get(castleId)).clear();
        if (Config.ALT_MANOR_SAVE_ALL_ACTIONS) {
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement ds = con.prepareStatement("DELETE FROM castle_manor_production WHERE castle_id = ?");
                 PreparedStatement dc = con.prepareStatement("DELETE FROM castle_manor_procure WHERE castle_id = ?");){
                ds.setInt(1, castleId);
                ds.executeUpdate();
                dc.setInt(1, castleId);
                dc.executeUpdate();
            }
            catch (Exception e) {
                this._log.severe(this.getClass().getSimpleName() + ": Unable to store manor data! " + e.getMessage());
            }
        }
    }

    public final boolean isUnderMaintenance() {
        return this._mode.equals((Object)ManorMode.MAINTENANCE);
    }

    public final boolean isManorApproved() {
        return this._mode.equals((Object)ManorMode.APPROVED);
    }

    public final boolean isModifiablePeriod() {
        return this._mode.equals((Object)ManorMode.MODIFIABLE);
    }

    public final String getCurrentModeName() {
        return this._mode.toString();
    }

    public final String getNextModeChange() {
        return new SimpleDateFormat("MM\u6708dd\u65e5 HH:mm:ss").format(this._nextModeChange.getTime());
    }

    public final Collection<L2Seed> getCrops() {
        return _crops.values();
    }

    public final ArrayList<L2Seed> getSeedsForCastle(int castleId) {
        ArrayList<L2Seed> seeds = new ArrayList<L2Seed>();
        for (L2Seed s : _seeds.values()) {
            if (s.getCastleId() != castleId) continue;
            seeds.add(s);
        }
        return seeds;
    }

    public final L2Seed getSeed(int seedId) {
        return (L2Seed)_seeds.get(seedId);
    }

    public final L2Seed getSeedByCrop(int cropId, int castleId) {
        for (L2Seed s : _seeds.values()) {
            if (s.getCropId() != cropId || s.getCastleId() != castleId) continue;
            return s;
        }
        return null;
    }

    public final L2Seed getSeedByCrop(int cropId) {
        return (L2Seed)_crops.get(cropId);
    }

    public static final CastleManorManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final CastleManorManager _instance = new CastleManorManager();

        private SingletonHolder() {
        }
    }
}

