/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.instancemanager.tasks.GrandBossManagerStoreTask;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.interfaces.IStorable;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.type.L2BossZone;
import com.l2jserver.gameserver.util.FastIntSet;
import com.l2jserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import jp.sf.l2j.troja.FastIntObjectMap;
import jp.sf.l2j.troja.IntIterator;
import jp.sf.l2j.troja.IntObjectMap;

public final class GrandBossManager
implements IStorable {
    private static final String DELETE_GRAND_BOSS_LIST = "TRUNCATE TABLE grandboss_list";
    private static final String INSERT_GRAND_BOSS_LIST = "INSERT INTO grandboss_list (player_id,zone) VALUES (?,?)";
    private static final String UPDATE_GRAND_BOSS_DATA = "UPDATE grandboss_data set loc_x = ?, loc_y = ?, loc_z = ?, heading = ?, respawn_time = ?, currentHP = ?, currentMP = ?, status = ? where boss_id = ?";
    private static final String UPDATE_GRAND_BOSS_DATA2 = "UPDATE grandboss_data set status = ? where boss_id = ?";
    private static final String UPDATE_GRAND_BOSS_DATA3 = "UPDATE grandboss_data set respawn_time = ?, status = ? where boss_id = ?";
    protected static Logger _log = Logger.getLogger(GrandBossManager.class.getName());
    protected static FastIntObjectMap<L2GrandBossInstance> _bosses = new FastIntObjectMap();
    protected static FastIntObjectMap<StatsSet> _storedInfo = new FastIntObjectMap();
    private final FastIntObjectMap<Integer> _bossStatus = new FastIntObjectMap();
    private final FastList<L2BossZone> _zones = new FastList();

    protected GrandBossManager() {
        this.init();
    }

    private void init() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery("SELECT * from grandboss_data ORDER BY boss_id");){
            while (rs.next()) {
                StatsSet info = new StatsSet();
                int bossId = rs.getInt("boss_id");
                info.set("loc_x", rs.getInt("loc_x"));
                info.set("loc_y", rs.getInt("loc_y"));
                info.set("loc_z", rs.getInt("loc_z"));
                info.set("heading", rs.getInt("heading"));
                info.set("respawn_time", rs.getLong("respawn_time"));
                double HP = rs.getDouble("currentHP");
                int true_HP = (int)HP;
                info.set("currentHP", true_HP);
                double MP = rs.getDouble("currentMP");
                int true_MP = (int)MP;
                info.set("currentMP", true_MP);
                int status = rs.getInt("status");
                this._bossStatus.put(bossId, (Object)status);
                _storedInfo.put(bossId, (Object)info);
                _log.info(this.getClass().getSimpleName() + ": " + NpcData.getInstance().getTemplate(bossId).getName() + "(" + bossId + ") status is " + status + ".");
                if (status <= 0) continue;
                _log.info(this.getClass().getSimpleName() + ": Next spawn date of " + NpcData.getInstance().getTemplate(bossId).getName() + " is " + GrandBossManager.respawnTimeFormat(info) + ".");
            }
            _log.info(this.getClass().getSimpleName() + ": Loaded " + _storedInfo.size() + " Instances");
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Could not load grandboss_data table: " + e.getMessage(), e);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while initializing GrandBossManager: " + e.getMessage(), e);
        }
        ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new GrandBossManagerStoreTask(), 300000L, 300000L);
    }

    public void initZones() {
        FastIntObjectMap zones = new FastIntObjectMap();
        if (this._zones == null) {
            _log.warning(this.getClass().getSimpleName() + ": Could not read Grand Boss zone data");
            return;
        }
        for (Object zone : this._zones) {
            if (zone == null) continue;
            zones.put(((L2ZoneType)zone).getId(), (Object)new FastIntSet());
        }
        try {
            Object zone;
            Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
            zone = null;
            try (Statement s = con.createStatement();
                 ResultSet rs = s.executeQuery("SELECT * from grandboss_list");){
                while (rs.next()) {
                    int id = rs.getInt("player_id");
                    int zone_id = rs.getInt("zone");
                    ((FastIntSet)zones.get(zone_id)).add(id);
                }
                _log.info(this.getClass().getSimpleName() + ": Initialized " + this._zones.size() + " Grand Boss Zones");
            }
            catch (Throwable throwable) {
                zone = throwable;
                throw throwable;
            }
            finally {
                if (con != null) {
                    if (zone != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)zone).addSuppressed(throwable);
                        }
                    } else {
                        con.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Could not load grandboss_list table: " + e.getMessage(), e);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while initializing GrandBoss zones: " + e.getMessage(), e);
        }
        for (Object zone : this._zones) {
            if (zone == null) continue;
            ((L2BossZone)zone).setAllowedPlayers((FastIntSet)zones.get(((L2ZoneType)zone).getId()));
        }
        zones.clear();
    }

    public void addZone(L2BossZone zone) {
        if (this._zones != null) {
            this._zones.add((Object)zone);
        }
    }

    public final L2BossZone getZone(int zoneId) {
        if (this._zones != null) {
            for (L2BossZone temp : this._zones) {
                if (temp.getId() != zoneId) continue;
                return temp;
            }
        }
        return null;
    }

    public final L2BossZone getZone(L2Character character) {
        if (this._zones != null) {
            for (L2BossZone temp : this._zones) {
                if (!temp.isCharacterInZone(character)) continue;
                return temp;
            }
        }
        return null;
    }

    public final L2BossZone getZone(Location loc) {
        return this.getZone(loc.getX(), loc.getY(), loc.getZ());
    }

    public final L2BossZone getZone(int x, int y, int z) {
        if (this._zones != null) {
            for (L2BossZone temp : this._zones) {
                if (!temp.isInsideZone(x, y, z)) continue;
                return temp;
            }
        }
        return null;
    }

    @Deprecated
    public boolean checkIfInZone(String zoneType, L2Object obj) {
        L2BossZone temp = this.getZone(obj.getX(), obj.getY(), obj.getZ());
        if (temp == null) {
            return false;
        }
        return temp.getName().equalsIgnoreCase(zoneType);
    }

    public boolean checkIfInZone(L2PcInstance player) {
        if (player == null) {
            return false;
        }
        L2BossZone temp = this.getZone(player.getX(), player.getY(), player.getZ());
        return temp != null;
    }

    public int getBossStatus(int bossId) {
        return (Integer)this._bossStatus.get(bossId);
    }

    public void setBossStatus(int bossId, int status) {
        this._bossStatus.put(bossId, (Object)status);
        _log.info(this.getClass().getSimpleName() + ": Updated " + NpcData.getInstance().getTemplate(bossId).getName() + "(" + bossId + ") status to " + status);
        this.updateDb(bossId, true);
    }

    public void addBoss(L2GrandBossInstance boss) {
        if (boss != null) {
            _bosses.put(boss.getId(), (Object)boss);
        }
    }

    public L2GrandBossInstance getBoss(int bossId) {
        return (L2GrandBossInstance)_bosses.get(bossId);
    }

    public StatsSet getStatsSet(int bossId) {
        return (StatsSet)_storedInfo.get(bossId);
    }

    public void setStatsSet(int bossId, StatsSet info) {
        _storedInfo.put(bossId, (Object)info);
        this.updateDb(bossId, false);
    }

    @Override
    public boolean storeMe() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            try (PreparedStatement delete = con.prepareStatement(DELETE_GRAND_BOSS_LIST);){
                delete.executeUpdate();
            }
            var4_7 = null;
            try (PreparedStatement insert = con.prepareStatement(INSERT_GRAND_BOSS_LIST);){
                for (L2BossZone zone : this._zones) {
                    if (zone == null) continue;
                    int id = zone.getId();
                    FastIntSet list = zone.getAllowedPlayers();
                    if (list == null || list.isEmpty()) continue;
                    IntIterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        insert.setInt(1, iterator.next());
                        insert.setInt(2, id);
                        insert.executeUpdate();
                        insert.clearParameters();
                    }
                }
            }
            catch (Throwable throwable) {
                var4_7 = throwable;
                throw throwable;
            }
            var4_7 = null;
            try (PreparedStatement update_grand_boss_data2 = con.prepareStatement(UPDATE_GRAND_BOSS_DATA2);
                 PreparedStatement update_grand_boss_data3 = con.prepareStatement(UPDATE_GRAND_BOSS_DATA3);
                 PreparedStatement update_grand_boss_data1 = con.prepareStatement(UPDATE_GRAND_BOSS_DATA);){
                for (IntObjectMap.Entry e : _storedInfo.entrySet()) {
                    PreparedStatement update;
                    int bossId = e.getKey();
                    StatsSet info = (StatsSet)e.getValue();
                    L2GrandBossInstance boss = (L2GrandBossInstance)_bosses.get(bossId);
                    if (boss == null && info == null) {
                        update = update_grand_boss_data2;
                        update.setInt(1, (Integer)this._bossStatus.get(bossId));
                        update.setInt(2, bossId);
                        update.executeUpdate();
                        update.clearParameters();
                        continue;
                    }
                    if (boss == null && info != null) {
                        update = update_grand_boss_data3;
                        update.setLong(1, info.getLong("respawn_time"));
                        update.setInt(2, (Integer)this._bossStatus.get(bossId));
                        update.setInt(3, bossId);
                        update.executeUpdate();
                        update.clearParameters();
                        continue;
                    }
                    if (boss != null && info != null) {
                        update = update_grand_boss_data1;
                        update.setInt(1, boss.getX());
                        update.setInt(2, boss.getY());
                        update.setInt(3, boss.getZ());
                        update.setInt(4, boss.getHeading());
                        update.setLong(5, info.getLong("respawn_time"));
                        double hp = boss.getCurrentHp();
                        double mp = boss.getCurrentMp();
                        if (boss.isDead()) {
                            hp = boss.getMaxHp();
                            mp = boss.getMaxMp();
                        }
                        update.setDouble(6, hp);
                        update.setDouble(7, mp);
                        update.setInt(8, (Integer)this._bossStatus.get(bossId));
                        update.setInt(9, bossId);
                        update.executeUpdate();
                        update.clearParameters();
                        continue;
                    }
                    throw new RuntimeException();
                }
            }
            catch (Throwable throwable) {
                var4_7 = throwable;
                throw throwable;
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Couldn't store grandbosses to database:" + e.getMessage(), e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void updateDb(int bossId, boolean statusOnly) {
        block54: {
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
                L2GrandBossInstance boss = (L2GrandBossInstance)_bosses.get(bossId);
                StatsSet info = (StatsSet)_storedInfo.get(bossId);
                if (statusOnly || boss == null && info == null) {
                    try (PreparedStatement ps = con.prepareStatement(UPDATE_GRAND_BOSS_DATA2);){
                        ps.setInt(1, (Integer)this._bossStatus.get(bossId));
                        ps.setInt(2, bossId);
                        ps.executeUpdate();
                        break block54;
                    }
                }
                if (boss == null && info != null) {
                    try (PreparedStatement statement = con.prepareStatement(UPDATE_GRAND_BOSS_DATA3);){
                        statement.setLong(1, info.getLong("respawn_time"));
                        statement.setInt(2, (Integer)this._bossStatus.get(bossId));
                        statement.setInt(3, bossId);
                        statement.executeUpdate();
                        break block54;
                    }
                }
                if (boss != null && info != null) {
                    try (PreparedStatement ps = con.prepareStatement(UPDATE_GRAND_BOSS_DATA);){
                        ps.setInt(1, boss.getX());
                        ps.setInt(2, boss.getY());
                        ps.setInt(3, boss.getZ());
                        ps.setInt(4, boss.getHeading());
                        ps.setLong(5, info.getLong("respawn_time"));
                        double hp = boss.getCurrentHp();
                        double mp = boss.getCurrentMp();
                        if (boss.isDead()) {
                            hp = boss.getMaxHp();
                            mp = boss.getMaxMp();
                        }
                        ps.setDouble(6, hp);
                        ps.setDouble(7, mp);
                        ps.setInt(8, (Integer)this._bossStatus.get(bossId));
                        ps.setInt(9, bossId);
                        ps.executeUpdate();
                        break block54;
                    }
                }
                throw new RuntimeException();
            }
            catch (SQLException e) {
                _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Couldn't update grandbosses to database:" + e.getMessage(), e);
                e.printStackTrace();
            }
        }
    }

    public void cleanUp() {
        this.storeMe();
        _bosses.clear();
        _storedInfo.clear();
        this._bossStatus.clear();
        this._zones.clear();
    }

    public List<L2BossZone> getZones() {
        return this._zones;
    }

    public static String respawnTimeFormat(StatsSet info) {
        return Util.dateFormat(info.getLong("respawn_time"));
    }

    public static GrandBossManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final GrandBossManager _instance = new GrandBossManager();

        private SingletonHolder() {
        }
    }
}

