/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.enums.Team;
import com.l2jserver.gameserver.instancemanager.tasks.PenaltyRemoveTask;
import com.l2jserver.gameserver.model.ArenaParticipantsHolder;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.BlockCheckerEngine;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.model.olympiad.OlympiadManager;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExCubeGameAddPlayer;
import com.l2jserver.gameserver.network.serverpackets.ExCubeGameChangeTeam;
import com.l2jserver.gameserver.network.serverpackets.ExCubeGameRemovePlayer;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.FastIntSet;
import com.l2jserver.util.Rnd;

public final class HandysBlockCheckerManager {
    private static final ArenaParticipantsHolder[] _arenaPlayers = new ArenaParticipantsHolder[4];
    private static final int[] _arenaVotes = new int[4];
    private static final boolean[] _arenaStatus = new boolean[4];
    protected static FastIntSet _registrationPenalty = new FastIntSet().shared();

    public synchronized int getArenaVotes(int arenaId) {
        return _arenaVotes[arenaId];
    }

    public synchronized void increaseArenaVotes(int arena) {
        int newVotes = _arenaVotes[arena] + 1;
        ArenaParticipantsHolder holder = _arenaPlayers[arena];
        if (newVotes > holder.getAllPlayerSize() / 2 && !holder.getEvent().isStarted()) {
            this.clearArenaVotes(arena);
            if (holder.getBlueTeamSize() == 0 || holder.getRedTeamSize() == 0) {
                return;
            }
            if (Config.HBCE_FAIR_PLAY) {
                holder.checkAndShuffle();
            }
            ThreadPoolManager.getInstance().executeGeneral(new BlockCheckerEngine.StartEvent(holder.getEvent()));
        } else {
            HandysBlockCheckerManager._arenaVotes[arena] = newVotes;
        }
    }

    public synchronized void clearArenaVotes(int arena) {
        HandysBlockCheckerManager._arenaVotes[arena] = 0;
    }

    protected HandysBlockCheckerManager() {
        for (int i = 0; i < 4; ++i) {
            HandysBlockCheckerManager._arenaPlayers[i] = new ArenaParticipantsHolder(i);
        }
    }

    public ArenaParticipantsHolder getHolder(int arena) {
        return _arenaPlayers[arena];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPlayerToArena(L2PcInstance player, int arena) {
        ArenaParticipantsHolder holder;
        ArenaParticipantsHolder arenaParticipantsHolder = holder = _arenaPlayers[arena];
        synchronized (arenaParticipantsHolder) {
            for (int i = 0; i < 4; ++i) {
                if (!_arenaPlayers[i].contains(player)) continue;
                SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_ALREADY_REGISTERED_ON_THE_MATCH_WAITING_LIST);
                msg.addCharName(player);
                player.sendPacket(msg);
                return false;
            }
            if (player.isCursedWeaponEquipped()) {
                player.sendPacket(SystemMessageId.CANNOT_REGISTER_PROCESSING_CURSED_WEAPON);
                return false;
            }
            if (player.isOnEvent() || player.isInOlympiadMode()) {
                player.sendMessage("\u4ed6\u306e\u30a4\u30d9\u30f3\u30c8\u306b\u7533\u3057\u8fbc\u307f\u4e2d\u306f\u767b\u9332\u3067\u304d\u307e\u305b\u3093\u3002");
                return false;
            }
            if (OlympiadManager.getInstance().isRegistered(player)) {
                OlympiadManager.getInstance().unRegisterNoble(player);
                player.sendPacket(SystemMessageId.COLISEUM_OLYMPIAD_KRATEIS_APPLICANTS_CANNOT_PARTICIPATE);
            }
            if (_registrationPenalty.contains(player.getObjectId())) {
                player.sendPacket(SystemMessageId.CANNOT_REQUEST_REGISTRATION_10_SECS_AFTER);
                return false;
            }
            int team = holder.getBlueTeamSize() < holder.getRedTeamSize() ? 0 : 1;
            holder.addPlayer(player, team);
            holder.broadCastPacketToTeam(new ExCubeGameAddPlayer(player, team));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(L2PcInstance player, int arena, int team) {
        ArenaParticipantsHolder holder;
        ArenaParticipantsHolder arenaParticipantsHolder = holder = _arenaPlayers[arena];
        synchronized (arenaParticipantsHolder) {
            int teamSize;
            holder.removePlayer(player, team);
            holder.broadCastPacketToTeam(new ExCubeGameRemovePlayer(player, team));
            int n = teamSize = team == 1 ? holder.getRedTeamSize() : holder.getBlueTeamSize();
            if (teamSize == 0) {
                holder.getEvent().endEventAbnormally();
            }
            _registrationPenalty.add(player.getObjectId());
            this.schedulePenaltyRemoval(player.getObjectId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePlayerToTeam(L2PcInstance player, int arena, int team) {
        ArenaParticipantsHolder holder;
        ArenaParticipantsHolder arenaParticipantsHolder = holder = _arenaPlayers[arena];
        synchronized (arenaParticipantsHolder) {
            int toTeam;
            int fromTeam;
            if (holder.getRedPlayers().contains(player)) {
                fromTeam = 1;
                toTeam = 0;
                if (holder.getBlueTeamSize() == 6) {
                    player.sendPacket(SystemMessageId.CANNOT_REGISTER_CAUSE_QUEUE_FULL);
                    return;
                }
            } else if (holder.getBluePlayers().contains(player)) {
                fromTeam = 0;
                toTeam = 1;
                if (holder.getRedTeamSize() == 6) {
                    player.sendPacket(SystemMessageId.CANNOT_REGISTER_CAUSE_QUEUE_FULL);
                    return;
                }
            } else {
                return;
            }
            holder.addPlayer(player, toTeam);
            holder.removePlayer(player, fromTeam);
            holder.broadCastPacketToTeam(new ExCubeGameChangeTeam(player, fromTeam, toTeam));
        }
    }

    public synchronized void clearPaticipantQueueByArenaId(int arena) {
        _arenaPlayers[arena].clearPlayers();
    }

    public boolean arenaIsBeingUsed(int arena) {
        return _arenaStatus[arena];
    }

    public void setArenaBeingUsed(int arena) {
        HandysBlockCheckerManager._arenaStatus[arena] = true;
    }

    public void setArenaFree(int arena) {
        HandysBlockCheckerManager._arenaStatus[arena] = false;
    }

    public void onDisconnect(L2PcInstance player) {
        int arena = player.getBlockCheckerArena();
        int team = this.getHolder(arena).getPlayerTeam(player);
        this.removePlayer(player, arena, team);
        if (player.getTeam() != Team.NONE) {
            long count;
            player.stopAllEffects();
            player.setTeam(Team.NONE);
            PcInventory inv = player.getInventory();
            if (inv.getItemByItemId(13787) != null) {
                count = inv.getInventoryItemCount(13787, 0);
                inv.destroyItemByItemId("Handys Block Checker", 13787, count, player, player);
            }
            if (inv.getItemByItemId(13788) != null) {
                count = inv.getInventoryItemCount(13788, 0);
                inv.destroyItemByItemId("Handys Block Checker", 13788, count, player, player);
            }
            player.setInsideZone(ZoneId.PVP, false);
            player.teleToLocation(-57478 + Rnd.get(-200, 200), -60367 + Rnd.get(-200, 200), -2370);
        }
    }

    public void onPlayerEnter(L2PcInstance player) {
        long count;
        player.stopSkillEffects(true, 6034);
        player.stopSkillEffects(true, 6035);
        player.stopSkillEffects(true, 6036);
        PcInventory inv = player.getInventory();
        if (inv.getItemByItemId(13787) != null) {
            count = inv.getInventoryItemCount(13787, 0);
            inv.destroyItemByItemId("Handys Block Checker", 13787, count, player, player);
        }
        if (inv.getItemByItemId(13788) != null) {
            count = inv.getInventoryItemCount(13788, 0);
            inv.destroyItemByItemId("Handys Block Checker", 13788, count, player, player);
        }
    }

    public void removePenalty(int objectId) {
        _registrationPenalty.remove(objectId);
    }

    private void schedulePenaltyRemoval(int objId) {
        ThreadPoolManager.getInstance().scheduleGeneral(new PenaltyRemoveTask(objId), 10000L);
    }

    public static HandysBlockCheckerManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final HandysBlockCheckerManager _instance = new HandysBlockCheckerManager();

        private SingletonHolder() {
        }
    }
}

