/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.scripting.L2ScriptEngineManager;
import com.l2jserver.gameserver.scripting.ScriptManager;
import com.l2jserver.util.ConcurrentFastMap;
import com.l2jserver.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class QuestManager
extends ScriptManager<Quest> {
    protected static final Logger _log = Logger.getLogger(QuestManager.class.getName());
    private final ConcurrentFastMap<String, Quest> _quests = new ConcurrentFastMap();
    private final ConcurrentFastMap<String, Quest> _scripts = new ConcurrentFastMap();

    protected QuestManager() {
    }

    @Override
    public boolean reload(String questFolder) {
        Quest q = this.getQuest(questFolder);
        if (q == null) {
            return false;
        }
        return q.reload();
    }

    @Override
    public boolean reload(int questId) {
        Quest q = this.getQuest(questId);
        if (q == null) {
            return false;
        }
        return q.reload();
    }

    public void reloadAllScripts() {
        _log.info(this.getClass().getSimpleName() + ": Reloading all server scripts.");
        for (Quest quest : this._quests.values()) {
            if (quest == null) continue;
            quest.unload(false);
        }
        this._quests.clear();
        for (Quest script : this._scripts.values()) {
            if (script == null) continue;
            script.unload(false);
        }
        this._scripts.clear();
        try {
            L2ScriptEngineManager.getInstance().executeScriptList(new File(Config.DATAPACK_ROOT, "data/scripts.cfg"));
        }
        catch (IOException e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Failed loading scripts.cfg, no script going to be loaded!", e);
        }
        QuestManager.getInstance().report();
    }

    public void report() {
        _log.info(this.getClass().getSimpleName() + ": Loaded: " + this._quests.size() + " quests.");
        _log.info(this.getClass().getSimpleName() + ": Loaded: " + this._scripts.size() + " scripts.");
    }

    public void save() {
        for (Quest quest : this._quests.values()) {
            quest.saveGlobalData();
        }
        for (Quest script : this._scripts.values()) {
            script.saveGlobalData();
        }
    }

    public Quest getQuest(String name) {
        Quest q = (Quest)this._quests.get(name);
        if (q != null) {
            return q;
        }
        return (Quest)this._scripts.get(name);
    }

    public Quest getQuest(int questId) {
        for (Quest q : this._quests.values()) {
            if (q.getId() != questId) continue;
            return q;
        }
        return null;
    }

    public void addQuest(Quest quest) {
        if (quest == null) {
            throw new IllegalArgumentException("Quest argument cannot be null");
        }
        Quest old = (Quest)this._quests.put(quest.getName(), quest);
        if (old != null) {
            old.unload();
            _log.info(this.getClass().getSimpleName() + ": Replaced quest " + old.getName() + " (" + old.getId() + ") with a new version!");
        }
        if (Config.ALT_DEV_SHOW_QUESTS_LOAD_IN_LOGS) {
            String questName = quest.getName().contains("_") ? quest.getName().substring(quest.getName().indexOf(95) + 1) : quest.getName();
            _log.info("Loaded quest " + Util.splitWords(questName) + ".");
        }
    }

    public boolean removeScript(Quest script) {
        return this._quests.remove(script.getName()) != null || this._scripts.remove(script.getName()) != null;
    }

    public Map<String, Quest> getQuests() {
        return this._quests;
    }

    @Override
    public boolean unload(Quest ms) {
        ms.saveGlobalData();
        return this.removeScript(ms);
    }

    @Override
    public String getScriptManagerName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Map<String, Quest> getScripts() {
        return this._scripts;
    }

    public void addScript(Quest script) {
        Quest old = (Quest)this._scripts.put(script.getClass().getSimpleName(), script);
        if (old != null) {
            old.unload();
            _log.info(this.getClass().getSimpleName() + ": Replaced script " + old.getName() + " with a new version!");
        }
        if (Config.ALT_DEV_SHOW_SCRIPTS_LOAD_IN_LOGS) {
            _log.info("Loaded script " + Util.splitWords(script.getClass().getSimpleName()) + ".");
        }
    }

    public static QuestManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final QuestManager _instance = new QuestManager();

        private SingletonHolder() {
        }
    }
}

