/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class RaidBossPointsManager {
    private static final Logger _log = Logger.getLogger(RaidBossPointsManager.class.getName());
    private FastMap<Integer, Map<Integer, Integer>> _list;

    public RaidBossPointsManager() {
        this.init();
    }

    private final void init() {
        this._list = new FastMap();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery("SELECT `charId`,`boss_id`,`points` FROM `character_raid_points`");){
            while (rs.next()) {
                int charId = rs.getInt("charId");
                int bossId = rs.getInt("boss_id");
                int points = rs.getInt("points");
                Map values = (Map)this._list.get((Object)charId);
                if (values == null) {
                    values = new FastMap();
                }
                values.put(bossId, points);
                this._list.put((Object)charId, (Object)values);
            }
            _log.info(this.getClass().getSimpleName() + ": Loaded " + this._list.size() + " Characters Raid Points.");
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Couldnt load raid points ", e);
        }
    }

    public final void updatePointsInDB(L2PcInstance player, int raidId, int points) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("REPLACE INTO character_raid_points (`charId`,`boss_id`,`points`) VALUES (?,?,?)");){
            ps.setInt(1, player.getObjectId());
            ps.setInt(2, raidId);
            ps.setInt(3, points);
            ps.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Couldn't update char raid points for player: " + player, e);
        }
    }

    public final void addPoints(L2PcInstance player, int bossId, int points) {
        int ownerId = player.getObjectId();
        Map tmpPoint = (Map)this._list.get((Object)ownerId);
        if (tmpPoint == null) {
            tmpPoint = new FastMap();
            tmpPoint.put(bossId, points);
            this.updatePointsInDB(player, bossId, points);
        } else {
            int currentPoins = tmpPoint.containsKey(bossId) ? (Integer)tmpPoint.get(bossId) : 0;
            tmpPoint.put(bossId, currentPoins += points);
            this.updatePointsInDB(player, bossId, currentPoins);
        }
        this._list.put((Object)ownerId, (Object)tmpPoint);
    }

    public final int getPointsByOwnerId(int ownerId) {
        Map tmpPoint = (Map)this._list.get((Object)ownerId);
        int totalPoints = 0;
        if (tmpPoint == null || tmpPoint.isEmpty()) {
            return 0;
        }
        Iterator iterator = tmpPoint.values().iterator();
        while (iterator.hasNext()) {
            int points = (Integer)iterator.next();
            totalPoints += points;
        }
        return totalPoints;
    }

    public final Map<Integer, Integer> getList(L2PcInstance player) {
        return (Map)this._list.get((Object)player.getObjectId());
    }

    public final void cleanUp() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("DELETE from character_raid_points WHERE charId > 0");){
            statement.executeUpdate();
            this._list.clear();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Couldn't clean raid points", e);
        }
    }

    public final int calculateRanking(int playerObjId) {
        Map<Integer, Integer> rank = this.getRankList();
        if (rank.containsKey(playerObjId)) {
            return rank.get(playerObjId);
        }
        return 0;
    }

    public Map<Integer, Integer> getRankList() {
        FastMap tmpRanking = new FastMap();
        FastMap tmpPoints = new FastMap();
        Iterator iterator = this._list.keySet().iterator();
        while (iterator.hasNext()) {
            int ownerId = (Integer)iterator.next();
            int totalPoints = this.getPointsByOwnerId(ownerId);
            if (totalPoints == 0) continue;
            tmpPoints.put(ownerId, totalPoints);
        }
        ArrayList list = new ArrayList(tmpPoints.entrySet());
        list.sort(Comparator.comparing(Map.Entry::getValue).reversed());
        int ranking = 1;
        for (Map.Entry entry : list) {
            tmpRanking.put(entry.getKey(), ranking++);
        }
        return tmpRanking;
    }

    public static final RaidBossPointsManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final RaidBossPointsManager _instance = new RaidBossPointsManager();

        private SingletonHolder() {
        }
    }
}

