/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.type.L2TownZone;

public final class TownManager {
    public static final int getTownCastle(int townId) {
        switch (townId) {
            case 912: {
                return 1;
            }
            case 916: {
                return 2;
            }
            case 918: {
                return 3;
            }
            case 922: {
                return 4;
            }
            case 924: {
                return 5;
            }
            case 926: {
                return 6;
            }
            case 1538: {
                return 7;
            }
            case 1537: {
                return 8;
            }
            case 1714: {
                return 9;
            }
        }
        return 0;
    }

    public static final boolean townHasCastleInSiege(int townId) {
        Castle castle;
        int castleIndex = TownManager.getTownCastle(townId);
        if (castleIndex > 0 && (castle = CastleManager.getInstance().getCastles().get(CastleManager.getInstance().getCastleIndex(castleIndex))) != null) {
            return castle.getSiege().isInProgress();
        }
        return false;
    }

    public static final boolean townHasCastleInSiege(int x, int y) {
        return TownManager.townHasCastleInSiege(MapRegionManager.getInstance().getMapRegionLocId(x, y));
    }

    public static final L2TownZone getTown(int townId) {
        for (L2TownZone temp : ZoneManager.getInstance().getAllZones(L2TownZone.class)) {
            if (temp.getTownId() != townId) continue;
            return temp;
        }
        return null;
    }

    public static final L2TownZone getTown(int x, int y, int z) {
        for (L2ZoneType temp : ZoneManager.getInstance().getZones(x, y, z)) {
            if (!(temp instanceof L2TownZone)) continue;
            return (L2TownZone)temp;
        }
        return null;
    }
}

