/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.model.BlockList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.util.Rnd;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public abstract class AbstractPlayerGroup {
    public abstract List<L2PcInstance> getMembers();

    public List<Integer> getMembersObjectId() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        this.forEachMember(m -> {
            ids.add(m.getObjectId());
            return true;
        });
        return ids;
    }

    public abstract L2PcInstance getLeader();

    public abstract void setLeader(L2PcInstance var1);

    public int getLeaderObjectId() {
        return this.getLeader().getObjectId();
    }

    public boolean isLeader(L2PcInstance player) {
        return this.getLeaderObjectId() == player.getObjectId();
    }

    public int getMemberCount() {
        return this.getMembers().size();
    }

    public abstract int getLevel();

    public void broadcastPacket(L2GameServerPacket packet) {
        this.forEachMember(m -> {
            if (m != null) {
                m.sendPacket(packet);
            }
            return true;
        });
    }

    public void broadcastMessage(SystemMessageId message) {
        this.broadcastPacket(SystemMessage.getSystemMessage(message));
    }

    public void broadcastString(String text) {
        this.broadcastPacket(SystemMessage.sendString(text));
    }

    public void broadcastCreatureSay(CreatureSay msg, L2PcInstance broadcaster) {
        this.forEachMember(m -> {
            if (m != null && !BlockList.isBlocked(m, broadcaster)) {
                m.sendPacket(msg);
            }
            return true;
        });
    }

    public boolean containsPlayer(L2PcInstance player) {
        return this.getMembers().contains(player);
    }

    public L2PcInstance getRandomPlayer() {
        return this.getMembers().get(Rnd.get(this.getMemberCount()));
    }

    public boolean forEachMember(Function<L2PcInstance, Boolean> procedure) {
        for (L2PcInstance player : this.getMembers()) {
            if (procedure.apply(player).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

