/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.Skill;

public class TimeStamp {
    private final int _id1;
    private final int _id2;
    private final long _reuse;
    private final long _stamp;
    private final int _group;

    public TimeStamp(Skill skill, long reuse, long systime) {
        this._id1 = skill.getId();
        this._id2 = skill.getLevel();
        this._reuse = reuse;
        this._stamp = systime > 0L ? systime : System.currentTimeMillis() + reuse;
        this._group = -1;
    }

    public TimeStamp(L2ItemInstance item, long reuse, long systime) {
        this._id1 = item.getId();
        this._id2 = item.getObjectId();
        this._reuse = reuse;
        this._stamp = systime > 0L ? systime : System.currentTimeMillis() + reuse;
        this._group = item.getSharedReuseGroup();
    }

    public long getStamp() {
        return this._stamp;
    }

    public int getItemId() {
        return this._id1;
    }

    public int getItemObjectId() {
        return this._id2;
    }

    public int getSkillId() {
        return this._id1;
    }

    public int getSkillLvl() {
        return this._id2;
    }

    public long getReuse() {
        return this._reuse;
    }

    public int getSharedReuseGroup() {
        return this._group;
    }

    public long getRemaining() {
        return Math.max(this._stamp - System.currentTimeMillis(), 0L);
    }

    public boolean hasNotPassed() {
        return System.currentTimeMillis() < this._stamp;
    }
}

