/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2AttackableAI;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.ai.L2FortSiegeGuardAI;
import com.l2jserver.gameserver.ai.L2SiegeGuardAI;
import com.l2jserver.gameserver.datatables.EventDroplist;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.instancemanager.WalkingManager;
import com.l2jserver.gameserver.model.AbsorberInfo;
import com.l2jserver.gameserver.model.AggroInfo;
import com.l2jserver.gameserver.model.DamageDoneInfo;
import com.l2jserver.gameserver.model.L2CommandChannel;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2Seed;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2ServitorInstance;
import com.l2jserver.gameserver.model.actor.knownlist.AttackableKnownList;
import com.l2jserver.gameserver.model.actor.status.AttackableStatus;
import com.l2jserver.gameserver.model.actor.tasks.attackable.CommandChannelTimer;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.drops.DropListScope;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.OnAttackableAggroRangeEnter;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.OnAttackableAttack;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.OnAttackableKill;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.taskmanager.DecayTaskManager;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.ConcurrentFastMap;
import com.l2jserver.util.Rnd;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javolution.util.FastMap;
import jp.sf.l2j.troja.FastIntObjectMap;

public class L2Attackable
extends L2Npc {
    private boolean _isRaid = false;
    private boolean _isRaidMinion = false;
    private boolean _champion = false;
    private final Map<L2Character, AggroInfo> _aggroList = new ConcurrentFastMap();
    private boolean _isReturningToSpawnPoint = false;
    private boolean _canReturnToSpawnPoint = true;
    private boolean _seeThroughSilentMove = false;
    private boolean _seeded = false;
    private L2Seed _seed = null;
    private int _seederObjId = 0;
    private ItemHolder _harvestItem;
    private boolean _isSpoil = false;
    private int _isSpoiledBy = 0;
    private ItemHolder[] _sweepItems;
    private boolean _overhit;
    private double _overhitDamage;
    private L2Character _overhitAttacker;
    private volatile L2CommandChannel _firstCommandChannelAttacked = null;
    private CommandChannelTimer _commandChannelTimer = null;
    private long _commandChannelLastAttack = 0L;
    private boolean _absorbed;
    private final FastIntObjectMap<AbsorberInfo> _absorbersList = new FastIntObjectMap().shared();
    private boolean _mustGiveExpSp;
    protected int _onKillDelay = 5000;

    public L2Attackable(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2Attackable);
        this.setIsInvul(false);
        this._mustGiveExpSp = true;
    }

    @Override
    public AttackableKnownList getKnownList() {
        return (AttackableKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new AttackableKnownList(this));
    }

    @Override
    public AttackableStatus getStatus() {
        return (AttackableStatus)super.getStatus();
    }

    @Override
    public void initCharStatus() {
        this.setStatus(new AttackableStatus(this));
    }

    @Override
    protected L2CharacterAI initAI() {
        return new L2AttackableAI(new L2Character.AIAccessor(this));
    }

    public final Map<L2Character, AggroInfo> getAggroList() {
        return this._aggroList;
    }

    public final boolean isReturningToSpawnPoint() {
        return this._isReturningToSpawnPoint;
    }

    public final void setisReturningToSpawnPoint(boolean value) {
        this._isReturningToSpawnPoint = value;
    }

    public final boolean canReturnToSpawnPoint() {
        return this._canReturnToSpawnPoint;
    }

    public final void setCanReturnToSpawnPoint(boolean value) {
        this._canReturnToSpawnPoint = value;
    }

    public boolean canSeeThroughSilentMove() {
        return this._seeThroughSilentMove;
    }

    public void setSeeThroughSilentMove(boolean val) {
        this._seeThroughSilentMove = val;
    }

    public void useMagic(Skill skill) {
        if (skill == null || this.isAlikeDead() || skill.isPassive() || this.isCastingNow() || this.isSkillDisabled(skill)) {
            return;
        }
        if (this.getCurrentMp() < (double)(this.getStat().getMpConsume(skill) + this.getStat().getMpInitialConsume(skill)) || this.getCurrentHp() <= (double)skill.getHpConsume()) {
            return;
        }
        if (!skill.isStatic() && (skill.isMagic() ? this.isMuted() : this.isPhysicalMuted())) {
            return;
        }
        L2Object target = skill.getFirstOfTargetList(this);
        if (target != null) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_CAST, skill, target);
        }
    }

    @Override
    public void reduceCurrentHp(double damage, L2Character attacker, Skill skill) {
        this.reduceCurrentHp(damage, attacker, true, false, skill);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reduceCurrentHp(double damage, L2Character attacker, boolean awake, boolean isDOT, Skill skill) {
        if (this.isRaid() && !this.isMinion() && attacker != null && attacker.getParty() != null && attacker.getParty().isInCommandChannel() && attacker.getParty().getCommandChannel().meetRaidWarCondition(this)) {
            if (this._firstCommandChannelAttacked == null) {
                L2Attackable l2Attackable = this;
                synchronized (l2Attackable) {
                    if (this._firstCommandChannelAttacked == null) {
                        this._firstCommandChannelAttacked = attacker.getParty().getCommandChannel();
                        if (this._firstCommandChannelAttacked != null) {
                            this._commandChannelTimer = new CommandChannelTimer(this);
                            this._commandChannelLastAttack = System.currentTimeMillis();
                            ThreadPoolManager.getInstance().scheduleGeneral(this._commandChannelTimer, 10000L);
                            this._firstCommandChannelAttacked.broadcastPacket(new CreatureSay(0, 16, "", "You have looting rights!"));
                        }
                    }
                }
            } else if (attacker.getParty().getCommandChannel().equals(this._firstCommandChannelAttacked)) {
                this._commandChannelLastAttack = System.currentTimeMillis();
            }
        }
        if (this.isEventMob()) {
            return;
        }
        if (attacker != null) {
            this.addDamage(attacker, (int)damage, skill);
        }
        if (this instanceof L2MonsterInstance) {
            L2MonsterInstance master = (L2MonsterInstance)this;
            if (master.hasMinions()) {
                master.getMinionList().onAssist(this, attacker);
            }
            if ((master = master.getLeader()) != null && master.hasMinions()) {
                master.getMinionList().onAssist(this, attacker);
            }
        }
        super.reduceCurrentHp(damage, attacker, awake, isDOT, skill);
    }

    public synchronized void setMustRewardExpSp(boolean value) {
        this._mustGiveExpSp = value;
    }

    public synchronized boolean getMustRewardExpSP() {
        return this._mustGiveExpSp;
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        if (killer != null && killer.isPlayable()) {
            EventDispatcher.getInstance().notifyEventAsyncDelayed(new OnAttackableKill(killer.getActingPlayer(), this, killer.isSummon()), this, this._onKillDelay);
        }
        if (this.isMonster()) {
            L2MonsterInstance mob = (L2MonsterInstance)this;
            if (mob.getLeader() != null && mob.getLeader().hasMinions()) {
                Integer v = Config.MINIONS_RESPAWN_TIME.get(this.getId());
                int respawnTime = v != null ? v * 1000 : -1;
                mob.getLeader().getMinionList().onMinionDie(mob, respawnTime);
            }
            if (mob.hasMinions()) {
                mob.getMinionList().onMasterDie(false);
            }
        }
        return true;
    }

    @Override
    protected void calculateRewards(L2Character lastAttacker) {
        try {
            int damage;
            L2PcInstance attacker;
            if (this.getAggroList().isEmpty()) {
                return;
            }
            FastMap rewards = new FastMap();
            L2PcInstance maxDealer = null;
            int maxDamage = 0;
            long totalDamage = 0L;
            for (AggroInfo info : this.getAggroList().values()) {
                if (info == null || (attacker = info.getAttacker().getActingPlayer()) == null || (damage = info.getDamage()) <= 1 || !Util.checkIfInRange(Config.ALT_PARTY_RANGE, this, attacker, true)) continue;
                totalDamage += (long)damage;
                DamageDoneInfo reward = (DamageDoneInfo)rewards.get((Object)attacker);
                if (reward == null) {
                    reward = new DamageDoneInfo(attacker, damage);
                    rewards.put((Object)attacker, (Object)reward);
                } else {
                    reward.addDamage(damage);
                }
                if (reward.getDamage() <= maxDamage) continue;
                maxDealer = attacker;
                maxDamage = reward.getDamage();
            }
            this.doItemDrop(maxDealer != null && maxDealer.isOnline() ? maxDealer : lastAttacker);
            this.doEventDrop(lastAttacker);
            if (!this.getMustRewardExpSP()) {
                return;
            }
            if (!rewards.isEmpty()) {
                for (DamageDoneInfo reward : rewards.values()) {
                    L2Character overhitAttacker;
                    Object overhitAttacker2;
                    float penalty;
                    if (reward == null) continue;
                    attacker = reward.getAttacker();
                    damage = reward.getDamage();
                    L2Party attackerParty = attacker.getParty();
                    float f = penalty = attacker.hasServitor() ? ((L2ServitorInstance)attacker.getSummon()).getExpMultiplier() : 1.0f;
                    if (attackerParty == null) {
                        if (!attacker.getKnownList().knowsObject(this)) continue;
                        int levelDiff = attacker.getLevel() - this.getLevel();
                        int[] expSp = this.calculateExpAndSp(levelDiff, damage, totalDamage);
                        long exp = expSp[0];
                        int sp = expSp[1];
                        if (Config.L2JMOD_CHAMPION_ENABLE && this.isChampion()) {
                            exp *= (long)Config.L2JMOD_CHAMPION_REWARDS;
                            sp *= Config.L2JMOD_CHAMPION_REWARDS;
                        }
                        exp = (long)((float)exp * penalty);
                        if (this.isOverhit() && (overhitAttacker2 = this.getOverhitAttacker()) != null && ((L2Object)overhitAttacker2).getActingPlayer() == attacker) {
                            attacker.sendPacket(SystemMessageId.OVER_HIT);
                            exp += this.calculateOverhitExp(exp);
                        }
                        if (attacker.isDead()) continue;
                        long addexp = Math.round(attacker.calcStat(Stats.EXPSP_RATE, exp, null, null));
                        int addsp = (int)attacker.calcStat(Stats.EXPSP_RATE, sp, null, null);
                        attacker.addExpAndSp(addexp, addsp, this.useVitalityRate());
                        if (addexp <= 0L) continue;
                        attacker.updateVitalityPoints(this.getVitalityPoints(damage), true, false);
                        continue;
                    }
                    int partyDmg = 0;
                    float partyMul = 1.0f;
                    int partyLvl = 0;
                    ArrayList<L2PcInstance> rewardedMembers = new ArrayList<L2PcInstance>();
                    List<L2PcInstance> groupMembers = attackerParty.isInCommandChannel() ? attackerParty.getCommandChannel().getMembers() : attackerParty.getMembers();
                    overhitAttacker2 = groupMembers.iterator();
                    while (overhitAttacker2.hasNext()) {
                        L2PcInstance partyPlayer = overhitAttacker2.next();
                        if (partyPlayer == null || partyPlayer.isDead()) continue;
                        DamageDoneInfo reward2 = (DamageDoneInfo)rewards.put((Object)partyPlayer, null);
                        if (!Util.checkIfInRange(Config.ALT_PARTY_RANGE, this, partyPlayer, true)) continue;
                        if (reward2 != null) {
                            partyDmg += reward2.getDamage();
                        }
                        rewardedMembers.add(partyPlayer);
                        if (partyPlayer.getLevel() <= partyLvl) continue;
                        if (attackerParty.isInCommandChannel()) {
                            partyLvl = attackerParty.getCommandChannel().getLevel();
                            continue;
                        }
                        partyLvl = partyPlayer.getLevel();
                    }
                    if ((long)partyDmg < totalDamage) {
                        partyMul = (float)partyDmg / (float)totalDamage;
                    }
                    int levelDiff = partyLvl - this.getLevel();
                    int[] expSp = this.calculateExpAndSp(levelDiff, partyDmg, totalDamage);
                    long exp = expSp[0];
                    int sp = expSp[1];
                    if (Config.L2JMOD_CHAMPION_ENABLE && this.isChampion()) {
                        exp *= (long)Config.L2JMOD_CHAMPION_REWARDS;
                        sp *= Config.L2JMOD_CHAMPION_REWARDS;
                    }
                    exp = (long)((float)exp * partyMul);
                    sp = (int)((float)sp * partyMul);
                    if (this.isOverhit() && (overhitAttacker = this.getOverhitAttacker()) != null && overhitAttacker.getActingPlayer() == attacker) {
                        attacker.sendPacket(SystemMessageId.OVER_HIT);
                        exp += this.calculateOverhitExp(exp);
                    }
                    if (partyDmg <= 0) continue;
                    attackerParty.distributeXpAndSp(exp, sp, rewardedMembers, partyLvl, partyDmg, this);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "", e);
        }
    }

    @Override
    public void addAttackerToAttackByList(L2Character player) {
        if (player == null || player == this || this.getAttackByList().contains(player)) {
            return;
        }
        this.getAttackByList().add(player);
    }

    public void addDamage(L2Character attacker, int damage, Skill skill) {
        if (attacker == null) {
            return;
        }
        if (!this.isDead()) {
            try {
                if (this.isWalker() && !this.isCoreAIDisabled() && WalkingManager.getInstance().isOnWalk(this)) {
                    WalkingManager.getInstance().stopMoving(this, false, true);
                }
                this.getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, attacker);
                this.addDamageHate(attacker, damage, damage * 100 / (this.getLevel() + 7));
                L2PcInstance player = attacker.getActingPlayer();
                if (player != null) {
                    EventDispatcher.getInstance().notifyEventAsync(new OnAttackableAttack(player, this, damage, skill, attacker.isSummon()), this);
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    public void addDamageHate(L2Character attacker, int damage, int aggro) {
        if (attacker == null) {
            return;
        }
        L2PcInstance targetPlayer = attacker.getActingPlayer();
        AggroInfo ai = this.getAggroList().get(attacker);
        if (ai == null) {
            ai = new AggroInfo(attacker);
            this.getAggroList().put(attacker, ai);
        }
        ai.addDamage(damage);
        if (targetPlayer == null || targetPlayer.getTrap() == null || !targetPlayer.getTrap().isTriggered()) {
            ai.addHate(aggro);
        }
        if (targetPlayer != null && aggro == 0) {
            this.addDamageHate(attacker, 0, 1);
            if (this.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            }
            EventDispatcher.getInstance().notifyEventAsync(new OnAttackableAggroRangeEnter(this, targetPlayer, attacker.isSummon()), this);
        } else if (targetPlayer == null && aggro == 0) {
            aggro = 1;
            ai.addHate(1);
        }
        if (aggro != 0 && this.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
    }

    public void reduceHate(L2Character target, int amount) {
        if (this.getAI() instanceof L2SiegeGuardAI || this.getAI() instanceof L2FortSiegeGuardAI) {
            this.stopHating(target);
            this.setTarget(null);
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
            return;
        }
        if (target == null) {
            L2Character mostHated = this.getMostHated();
            if (mostHated == null) {
                ((L2AttackableAI)this.getAI()).setGlobalAggro(-25);
                return;
            }
            for (AggroInfo ai : this.getAggroList().values()) {
                if (ai == null) {
                    return;
                }
                ai.addHate(amount);
            }
            amount = this.getHating(mostHated);
            if (amount >= 0) {
                ((L2AttackableAI)this.getAI()).setGlobalAggro(-25);
                this.clearAggroList();
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                this.setWalking();
            }
            return;
        }
        AggroInfo ai = this.getAggroList().get(target);
        if (ai == null) {
            _log.info("target " + target + " not present in aggro list of " + this);
            return;
        }
        ai.addHate(amount);
        if (ai.getHate() >= 0 && this.getMostHated() == null) {
            ((L2AttackableAI)this.getAI()).setGlobalAggro(-25);
            this.clearAggroList();
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            this.setWalking();
        }
    }

    public void stopHating(L2Character target) {
        if (target == null) {
            return;
        }
        AggroInfo ai = this.getAggroList().get(target);
        if (ai != null) {
            ai.stopHate();
        }
    }

    public L2Character getMostHated() {
        if (this.getAggroList().isEmpty() || this.isAlikeDead()) {
            return null;
        }
        L2Character mostHated = null;
        int maxHate = 0;
        for (AggroInfo ai : this.getAggroList().values()) {
            if (ai == null || ai.checkHate(this) <= maxHate) continue;
            mostHated = ai.getAttacker();
            maxHate = ai.getHate();
        }
        return mostHated;
    }

    public List<L2Character> get2MostHated() {
        if (this.getAggroList().isEmpty() || this.isAlikeDead()) {
            return null;
        }
        L2Character mostHated = null;
        L2Character secondMostHated = null;
        int maxHate = 0;
        ArrayList<L2Character> result = new ArrayList<L2Character>();
        for (AggroInfo ai : this.getAggroList().values()) {
            if (ai == null || ai.checkHate(this) <= maxHate) continue;
            secondMostHated = mostHated;
            mostHated = ai.getAttacker();
            maxHate = ai.getHate();
        }
        result.add(mostHated);
        if (this.getAttackByList().contains(secondMostHated)) {
            result.add(secondMostHated);
        } else {
            result.add(null);
        }
        return result;
    }

    public List<L2Character> getHateList() {
        if (this.getAggroList().isEmpty() || this.isAlikeDead()) {
            return null;
        }
        ArrayList<L2Character> result = new ArrayList<L2Character>();
        for (AggroInfo ai : this.getAggroList().values()) {
            if (ai == null) continue;
            ai.checkHate(this);
            result.add(ai.getAttacker());
        }
        return result;
    }

    public int getHating(L2Character target) {
        L2PcInstance act;
        if (this.getAggroList().isEmpty() || target == null) {
            return 0;
        }
        AggroInfo ai = this.getAggroList().get(target);
        if (ai == null) {
            return 0;
        }
        if (ai.getAttacker() instanceof L2PcInstance && ((act = (L2PcInstance)ai.getAttacker()).isInvisible() || ai.getAttacker().isInvul() || act.isSpawnProtected())) {
            this.getAggroList().remove(target);
            return 0;
        }
        if (!ai.getAttacker().isVisible() || ai.getAttacker().isInvisible()) {
            this.getAggroList().remove(target);
            return 0;
        }
        if (ai.getAttacker().isAlikeDead()) {
            ai.stopHate();
            return 0;
        }
        return ai.getHate();
    }

    public void doItemDrop(L2Character mainDamageDealer) {
        this.doItemDrop(this.getTemplate(), mainDamageDealer);
    }

    public void doItemDrop(L2NpcTemplate npcTemplate, L2Character mainDamageDealer) {
        List<ItemHolder> deathItems;
        List<ItemHolder> sweepItems;
        if (mainDamageDealer == null) {
            return;
        }
        L2PcInstance player = mainDamageDealer.getActingPlayer();
        if (player == null) {
            return;
        }
        CursedWeaponsManager.getInstance().checkDrop(this, player);
        if (this.isSpoil() && (sweepItems = npcTemplate.calculateDrops(DropListScope.CORPSE, this, player)) != null && !sweepItems.isEmpty()) {
            this._sweepItems = sweepItems.toArray(new ItemHolder[sweepItems.size()]);
        }
        if ((deathItems = npcTemplate.calculateDrops(DropListScope.DEATH, this, player)) != null) {
            for (ItemHolder drop : deathItems) {
                L2Item item = ItemTable.getInstance().getTemplate(drop.getId());
                if (this.isFlying() || !item.hasExImmediateEffect() && (!this.isRaid() && Config.AUTO_LOOT || this.isRaid() && Config.AUTO_LOOT_RAIDS) || item.hasExImmediateEffect() && Config.AUTO_LOOT_HERBS) {
                    player.doAutoLoot(this, drop);
                } else {
                    this.dropItem(player, drop);
                }
                if (!this.isRaid() || this.isRaidMinion()) continue;
                if (item.getId() == 57) {
                    this.broadcastPacket((L2GameServerPacket)((Object)((SystemMessage)((Object)SystemMessage.getSystemMessage(SystemMessageId.C1_DIED_DROPPED_S2_ADENA).addCharName(this))).addItemNumber(drop.getCount())));
                    continue;
                }
                this.broadcastPacket((L2GameServerPacket)((Object)((SystemMessage)((Object)((SystemMessage)((Object)SystemMessage.getSystemMessage(SystemMessageId.C1_DIED_DROPPED_S3_S2).addCharName(this))).addItemName(item))).addItemNumber(drop.getCount())));
            }
        }
        if (Config.L2JMOD_CHAMPION_ENABLE && this.isChampion() && (Config.L2JMOD_CHAMPION_REWARD_LOWER_LVL_ITEM_CHANCE > 0 || Config.L2JMOD_CHAMPION_REWARD_HIGHER_LVL_ITEM_CHANCE > 0)) {
            int champqty = Rnd.get(Config.L2JMOD_CHAMPION_REWARD_QTY);
            ItemHolder item = new ItemHolder(Config.L2JMOD_CHAMPION_REWARD_ID, ++champqty);
            if (player.getLevel() <= this.getLevel() && Rnd.get(100) < Config.L2JMOD_CHAMPION_REWARD_LOWER_LVL_ITEM_CHANCE) {
                if (Config.AUTO_LOOT || this.isFlying()) {
                    player.addItem("ChampionLoot", item.getId(), item.getCount(), this, true);
                } else {
                    this.dropItem(player, item);
                }
            } else if (player.getLevel() > this.getLevel() && Rnd.get(100) < Config.L2JMOD_CHAMPION_REWARD_HIGHER_LVL_ITEM_CHANCE) {
                if (Config.AUTO_LOOT || this.isFlying()) {
                    player.addItem("ChampionLoot", item.getId(), item.getCount(), this, true);
                } else {
                    this.dropItem(player, item);
                }
            }
        }
    }

    public void doEventDrop(L2Character lastAttacker) {
        if (lastAttacker == null) {
            return;
        }
        L2PcInstance player = lastAttacker.getActingPlayer();
        if (player == null) {
            return;
        }
        if (player.getLevel() - this.getLevel() > 9) {
            return;
        }
        for (EventDroplist.DateDrop drop : EventDroplist.getInstance().getAllDrops()) {
            if (Rnd.get(1000000) >= drop.getEventDrop().getDropChance()) continue;
            int itemId = drop.getEventDrop().getItemIdList()[Rnd.get(drop.getEventDrop().getItemIdList().length)];
            long itemCount = Rnd.get(drop.getEventDrop().getMinCount(), drop.getEventDrop().getMaxCount());
            if (Config.AUTO_LOOT || this.isFlying()) {
                player.doAutoLoot(this, itemId, itemCount);
                continue;
            }
            this.dropItem(player, itemId, itemCount);
        }
    }

    public L2ItemInstance getActiveWeapon() {
        return null;
    }

    public boolean containsTarget(L2Character player) {
        return this.getAggroList().containsKey(player);
    }

    public void clearAggroList() {
        this.getAggroList().clear();
        this._overhit = false;
        this._overhitDamage = 0.0;
        this._overhitAttacker = null;
    }

    @Override
    public boolean isSweepActive() {
        return this._sweepItems != null;
    }

    public List<L2Item> getSpoilLootItems() {
        ArrayList<L2Item> lootItems = new ArrayList<L2Item>();
        if (this.isSweepActive()) {
            for (ItemHolder item : this._sweepItems) {
                lootItems.add(ItemTable.getInstance().createDummyItem(item.getId()).getItem());
            }
        }
        return lootItems;
    }

    public synchronized ItemHolder[] takeSweep() {
        ItemHolder[] sweep = this._sweepItems;
        this._sweepItems = null;
        return sweep;
    }

    public synchronized ItemHolder takeHarvest() {
        ItemHolder harvest = this._harvestItem;
        this._harvestItem = null;
        return harvest;
    }

    public boolean isOldCorpse(L2PcInstance attacker, int remainingTime, boolean sendMessage) {
        if (this.isDead() && DecayTaskManager.getInstance().getRemainingTime(this) < (long)remainingTime) {
            if (sendMessage && attacker != null) {
                attacker.sendPacket(SystemMessageId.CORPSE_TOO_OLD_SKILL_NOT_USED);
            }
            return true;
        }
        return false;
    }

    public boolean checkSpoilOwner(L2PcInstance sweeper, boolean sendMessage) {
        if (sweeper.getObjectId() != this.getIsSpoiledBy() && !sweeper.isInLooterParty(this.getIsSpoiledBy())) {
            if (sendMessage) {
                sweeper.sendPacket(SystemMessageId.SWEEP_NOT_ALLOWED);
            }
            return false;
        }
        return true;
    }

    public void overhitEnabled(boolean status) {
        this._overhit = status;
    }

    public void setOverhitValues(L2Character attacker, double damage) {
        double overhitDmg = damage - this.getCurrentHp();
        if (overhitDmg < 0.0) {
            this.overhitEnabled(false);
            this._overhitDamage = 0.0;
            this._overhitAttacker = null;
            return;
        }
        this.overhitEnabled(true);
        this._overhitDamage = overhitDmg;
        this._overhitAttacker = attacker;
    }

    public L2Character getOverhitAttacker() {
        return this._overhitAttacker;
    }

    public double getOverhitDamage() {
        return this._overhitDamage;
    }

    public boolean isOverhit() {
        return this._overhit;
    }

    public void absorbSoul() {
        this._absorbed = true;
    }

    public boolean isAbsorbed() {
        return this._absorbed;
    }

    public void addAbsorber(L2PcInstance attacker) {
        AbsorberInfo ai = (AbsorberInfo)this._absorbersList.get(attacker.getObjectId());
        if (ai == null) {
            this._absorbersList.put(attacker.getObjectId(), (Object)new AbsorberInfo(attacker.getObjectId(), this.getCurrentHp()));
        } else {
            ai.setAbsorbedHp(this.getCurrentHp());
        }
        this.absorbSoul();
    }

    public void resetAbsorbList() {
        this._absorbed = false;
        this._absorbersList.clear();
    }

    public FastIntObjectMap<AbsorberInfo> getAbsorbersList() {
        return this._absorbersList;
    }

    private int[] calculateExpAndSp(int diff, int damage, long totalDamage) {
        if (diff < -5) {
            diff = -5;
        }
        double xp = (double)this.getExpReward() * (double)damage / (double)totalDamage;
        if (Config.ALT_GAME_EXPONENT_XP != 0.0f) {
            xp *= Math.pow(2.0, (float)(-diff) / Config.ALT_GAME_EXPONENT_XP);
        }
        double sp = (double)this.getSpReward() * (double)damage / (double)totalDamage;
        if (Config.ALT_GAME_EXPONENT_SP != 0.0f) {
            sp *= Math.pow(2.0, (float)(-diff) / Config.ALT_GAME_EXPONENT_SP);
        }
        if (Config.ALT_GAME_EXPONENT_XP == 0.0f && Config.ALT_GAME_EXPONENT_SP == 0.0f) {
            if (diff > 5) {
                double pow = Math.pow(0.8333333333333334, diff - 5);
                xp *= pow;
                sp *= pow;
            }
            if (xp <= 0.0) {
                xp = 0.0;
                sp = 0.0;
            } else if (sp <= 0.0) {
                sp = 0.0;
            }
        }
        int[] tmp = new int[]{(int)xp, (int)sp};
        return tmp;
    }

    public long calculateOverhitExp(long normalExp) {
        double overhitPercentage = this.getOverhitDamage() * 100.0 / (double)this.getMaxHp();
        if (overhitPercentage > 25.0) {
            overhitPercentage = 25.0;
        }
        double overhitExp = overhitPercentage / 100.0 * (double)normalExp;
        long bonusOverhit = Math.round(overhitExp);
        return bonusOverhit;
    }

    @Override
    public boolean canBeAttacked() {
        return true;
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this.setSpoil(false);
        this.clearAggroList();
        this._harvestItem = null;
        this._seeded = false;
        this._seed = null;
        this._seederObjId = 0;
        this.overhitEnabled(false);
        this._sweepItems = null;
        this.resetAbsorbList();
        this.setWalking();
        if (!this.isInActiveRegion() && this.hasAI()) {
            this.getAI().stopAITask();
        }
    }

    public boolean isSpoil() {
        return this._isSpoil;
    }

    public void setSpoil(boolean isSpoil) {
        this._isSpoil = isSpoil;
    }

    public final int getIsSpoiledBy() {
        return this._isSpoiledBy;
    }

    public final void setIsSpoiledBy(int value) {
        this._isSpoiledBy = value;
    }

    public final void setSeeded(L2PcInstance seeder) {
        if (this._seed != null && this._seederObjId == seeder.getObjectId()) {
            int diff;
            this._seeded = true;
            int count = 1;
            block24: for (Skill skill : this.getTemplate().getSkills()) {
                switch (skill.getId()) {
                    case 4303: {
                        count *= 2;
                        break block24;
                    }
                    case 4304: {
                        count *= 3;
                        break block24;
                    }
                    case 4305: {
                        count *= 4;
                        break block24;
                    }
                    case 4306: {
                        count *= 5;
                        break block24;
                    }
                    case 4307: {
                        count *= 6;
                        break block24;
                    }
                    case 4308: {
                        count *= 7;
                        break block24;
                    }
                    case 4309: {
                        count *= 8;
                        break block24;
                    }
                    case 4310: {
                        count *= 9;
                        break block24;
                    }
                    case 4408: {
                        switch (skill.getLevel()) {
                            case 10: {
                                count *= 2;
                                break block24;
                            }
                            case 11: {
                                count *= 3;
                                break block24;
                            }
                            case 12: {
                                count *= 4;
                                break block24;
                            }
                            case 13: {
                                count *= 5;
                                break block24;
                            }
                            case 14: {
                                count *= 6;
                                break block24;
                            }
                            case 15: {
                                count *= 7;
                                break block24;
                            }
                            case 16: {
                                count *= 8;
                                break block24;
                            }
                            case 17: {
                                count *= 9;
                                break block24;
                            }
                            case 18: {
                                count *= 10;
                                break block24;
                            }
                            case 19: {
                                count *= 11;
                                break block24;
                            }
                            case 20: {
                                count *= 12;
                                break block24;
                            }
                        }
                        break block24;
                    }
                    default: {
                        continue block24;
                    }
                }
            }
            if ((diff = this.getLevel() - this._seed.getLevel() - 5) > 0) {
                count += diff;
            }
            this._harvestItem = new ItemHolder(this._seed.getCropId(), count * Config.RATE_DROP_MANOR);
        }
    }

    public final void setSeeded(L2Seed seed, L2PcInstance seeder) {
        if (!this._seeded) {
            this._seed = seed;
            this._seederObjId = seeder.getObjectId();
        }
    }

    public final int getSeederId() {
        return this._seederObjId;
    }

    public final L2Seed getSeed() {
        return this._seed;
    }

    public final boolean isSeeded() {
        return this._seeded;
    }

    public final void setOnKillDelay(int delay) {
        this._onKillDelay = delay;
    }

    public final int getOnKillDelay() {
        return this._onKillDelay;
    }

    @Override
    public boolean hasRandomAnimation() {
        return Config.MAX_MONSTER_ANIMATION > 0 && this.isRandomAnimationEnabled();
    }

    @Override
    public boolean isMob() {
        return true;
    }

    public void setCommandChannelTimer(CommandChannelTimer commandChannelTimer) {
        this._commandChannelTimer = commandChannelTimer;
    }

    public CommandChannelTimer getCommandChannelTimer() {
        return this._commandChannelTimer;
    }

    public L2CommandChannel getFirstCommandChannelAttacked() {
        return this._firstCommandChannelAttacked;
    }

    public void setFirstCommandChannelAttacked(L2CommandChannel firstCommandChannelAttacked) {
        this._firstCommandChannelAttacked = firstCommandChannelAttacked;
    }

    public long getCommandChannelLastAttack() {
        return this._commandChannelLastAttack;
    }

    public void setCommandChannelLastAttack(long channelLastAttack) {
        this._commandChannelLastAttack = channelLastAttack;
    }

    public void returnHome() {
        this.clearAggroList();
        if (this.hasAI() && this.getSpawn() != null) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, this.getSpawn().getLocation(this));
        }
    }

    public float getVitalityPoints(int damage) {
        float divider;
        if (damage <= 0) {
            return 0.0f;
        }
        float f = divider = this.getLevel() > 0 && this.getExpReward() > 0L ? this.getTemplate().getBaseHpMax() * 9.0f * (float)this.getLevel() * (float)this.getLevel() / (float)(100L * this.getExpReward()) : 0.0f;
        if (divider == 0.0f) {
            return 0.0f;
        }
        return (float)(-Math.min(damage, this.getMaxHp())) / divider;
    }

    public boolean useVitalityRate() {
        return !this.isChampion() || Config.L2JMOD_CHAMPION_ENABLE_VITALITY;
    }

    @Override
    public boolean isRaid() {
        return this._isRaid;
    }

    public void setIsRaid(boolean isRaid) {
        this._isRaid = isRaid;
    }

    public void setIsRaidMinion(boolean val) {
        this._isRaid = val;
        this._isRaidMinion = val;
    }

    @Override
    public boolean isRaidMinion() {
        return this._isRaidMinion;
    }

    @Override
    public boolean isMinion() {
        return this.getLeader() != null;
    }

    public L2Attackable getLeader() {
        return null;
    }

    public void setChampion(boolean champ) {
        this._champion = champ;
    }

    @Override
    public boolean isChampion() {
        return this._champion;
    }

    @Override
    public boolean isAttackable() {
        return true;
    }
}

