/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.ai.L2SummonAI;
import com.l2jserver.gameserver.datatables.ExperienceTable;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.enums.Race;
import com.l2jserver.gameserver.enums.ShotType;
import com.l2jserver.gameserver.enums.Team;
import com.l2jserver.gameserver.handler.IItemHandler;
import com.l2jserver.gameserver.handler.ItemHandler;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.AggroInfo;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.SummonKnownList;
import com.l2jserver.gameserver.model.actor.stat.SummonStat;
import com.l2jserver.gameserver.model.actor.status.SummonStatus;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.character.player.OnPlayerSummonSpawn;
import com.l2jserver.gameserver.model.itemcontainer.PetInventory;
import com.l2jserver.gameserver.model.items.L2EtcItem;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.ActionType;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameManager;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.skills.targets.L2TargetType;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExPartyPetWindowAdd;
import com.l2jserver.gameserver.network.serverpackets.ExPartyPetWindowDelete;
import com.l2jserver.gameserver.network.serverpackets.ExPartyPetWindowUpdate;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.PetDelete;
import com.l2jserver.gameserver.network.serverpackets.PetInfo;
import com.l2jserver.gameserver.network.serverpackets.PetItemList;
import com.l2jserver.gameserver.network.serverpackets.PetStatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.RelationChanged;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.TeleportToLocation;
import com.l2jserver.gameserver.taskmanager.DecayTaskManager;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;

public abstract class L2Summon
extends L2Playable {
    private L2PcInstance _owner;
    private int _attackRange = 36;
    private boolean _follow = true;
    private boolean _previousFollowStatus = true;
    protected boolean _restoreSummon = true;
    private int _shotsMask = 0;
    private static final int[] PASSIVE_SUMMONS = new int[]{12564, 12621, 14702, 14703, 14704, 14705, 14706, 14707, 14708, 14709, 14710, 14711, 14712, 14713, 14714, 14715, 14716, 14717, 14718, 14719, 14720, 14721, 14722, 14723, 14724, 14725, 14726, 14727, 14728, 14729, 14730, 14731, 14732, 14733, 14734, 14735, 14736};

    public L2Summon(int objectId, L2NpcTemplate template, L2PcInstance owner) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2Summon);
        this.setInstanceId(owner.getInstanceId());
        this._showSummonAnimation = true;
        this._owner = owner;
        this.getAI();
        this.setXYZInvisible(owner.getX() + Rnd.get(-100, 100), owner.getY() + Rnd.get(-100, 100), owner.getZ());
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        if (Config.SUMMON_STORE_SKILL_COOLTIME && !this.isTeleporting()) {
            this.restoreEffects();
        }
        this.setFollowStatus(true);
        this.updateAndBroadcastStatus(0);
        this.sendPacket(new RelationChanged(this, this.getOwner().getRelation(this.getOwner()), false));
        for (L2PcInstance player : this.getOwner().getKnownList().getKnownPlayersInRadius(800L)) {
            player.sendPacket(new RelationChanged(this, this.getOwner().getRelation(player), this.isAutoAttackable(player)));
        }
        L2Party party = this.getOwner().getParty();
        if (party != null) {
            party.broadcastToPartyMembers(this.getOwner(), new ExPartyPetWindowAdd(this));
        }
        this.setShowSummonAnimation(false);
        this._restoreSummon = false;
        EventDispatcher.getInstance().notifyEventAsync(new OnPlayerSummonSpawn(this), this);
    }

    @Override
    public final SummonKnownList getKnownList() {
        return (SummonKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new SummonKnownList(this));
    }

    @Override
    public SummonStat getStat() {
        return (SummonStat)super.getStat();
    }

    @Override
    public void initCharStat() {
        this.setStat(new SummonStat(this));
    }

    @Override
    public SummonStatus getStatus() {
        return (SummonStatus)super.getStatus();
    }

    @Override
    public void initCharStatus() {
        this.setStatus(new SummonStatus(this));
    }

    @Override
    protected L2CharacterAI initAI() {
        return new L2SummonAI(new AIAccessor());
    }

    @Override
    public L2NpcTemplate getTemplate() {
        return (L2NpcTemplate)super.getTemplate();
    }

    public abstract int getSummonType();

    @Override
    public final void stopAllEffects() {
        super.stopAllEffects();
        this.updateAndBroadcastStatus(1);
    }

    @Override
    public final void stopAllEffectsExceptThoseThatLastThroughDeath() {
        super.stopAllEffectsExceptThoseThatLastThroughDeath();
        this.updateAndBroadcastStatus(1);
    }

    @Override
    public void updateAbnormalEffect() {
        for (L2PcInstance player : this.getKnownList().getKnownPlayers().values()) {
            player.sendPacket(new AbstractNpcInfo.SummonInfo(this, player, 1));
        }
    }

    public boolean isMountable() {
        return false;
    }

    public long getExpForThisLevel() {
        if (this.getLevel() >= ExperienceTable.getInstance().getMaxPetLevel()) {
            return 0L;
        }
        return ExperienceTable.getInstance().getExpForLevel(this.getLevel());
    }

    public long getExpForNextLevel() {
        if (this.getLevel() >= ExperienceTable.getInstance().getMaxPetLevel() - 1) {
            return 0L;
        }
        return ExperienceTable.getInstance().getExpForLevel(this.getLevel() + 1);
    }

    @Override
    public final int getKarma() {
        return this.getOwner() != null ? this.getOwner().getKarma() : 0;
    }

    @Override
    public final byte getPvpFlag() {
        return this.getOwner() != null ? this.getOwner().getPvpFlag() : (byte)0;
    }

    @Override
    public final Team getTeam() {
        return this.getOwner() != null ? this.getOwner().getTeam() : Team.NONE;
    }

    public final L2PcInstance getOwner() {
        return this._owner;
    }

    @Override
    public final int getId() {
        return this.getTemplate().getId();
    }

    public final int getNpcId() {
        return this.getId();
    }

    public short getSoulShotsPerHit() {
        if (this.getTemplate().getSoulShot() > 0) {
            return (short)this.getTemplate().getSoulShot();
        }
        return 1;
    }

    public short getSpiritShotsPerHit() {
        if (this.getTemplate().getSpiritShot() > 0) {
            return (short)this.getTemplate().getSpiritShot();
        }
        return 1;
    }

    public void followOwner() {
        this.setFollowStatus(true);
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (this.isNoblesseBlessedAffected()) {
            this.stopEffects(L2EffectType.NOBLESSE_BLESSING);
            this.storeEffect(true);
        } else {
            this.storeEffect(false);
        }
        if (!super.doDie(killer)) {
            return false;
        }
        L2PcInstance owner = this.getOwner();
        if (owner != null) {
            for (L2Character TgMob : this.getKnownList().getKnownCharacters()) {
                AggroInfo info;
                if (!(TgMob instanceof L2Attackable) || ((L2Attackable)TgMob).isDead() || (info = ((L2Attackable)TgMob).getAggroList().get(this)) == null) continue;
                ((L2Attackable)TgMob).addDamageHate(owner, info.getDamage(), info.getHate());
            }
        }
        DecayTaskManager.getInstance().add(this);
        return true;
    }

    public boolean doDie(L2Character killer, boolean decayed) {
        if (!super.doDie(killer)) {
            return false;
        }
        if (!decayed) {
            DecayTaskManager.getInstance().add(this);
        }
        return true;
    }

    public void stopDecay() {
        DecayTaskManager.getInstance().cancel(this);
    }

    @Override
    public void onDecay() {
        this.deleteMe(this._owner);
    }

    @Override
    public void broadcastStatusUpdate() {
        super.broadcastStatusUpdate();
        this.updateAndBroadcastStatus(1);
    }

    public void deleteMe(L2PcInstance owner) {
        if (owner != null) {
            owner.sendPacket(new PetDelete(this.getSummonType(), this.getObjectId()));
            L2Party party = owner.getParty();
            if (party != null) {
                party.broadcastToPartyMembers(owner, new ExPartyPetWindowDelete(this));
            }
        }
        if (this.getInventory() != null) {
            this.getInventory().destroyAllItems("pet deleted", this.getOwner(), this);
        }
        this.decayMe();
        this.getKnownList().removeAllKnownObjects();
        if (owner != null) {
            owner.setPet(null);
        }
        super.deleteMe();
    }

    public void unSummon(L2PcInstance owner) {
        if (this.isVisible() && !this.isDead()) {
            this.getAI().stopFollow();
            if (owner != null) {
                owner.sendPacket(new PetDelete(this.getSummonType(), this.getObjectId()));
                L2Party party = owner.getParty();
                if (party != null) {
                    party.broadcastToPartyMembers(owner, new ExPartyPetWindowDelete(this));
                }
                if (this.getInventory() != null && this.getInventory().getSize() > 0) {
                    this.getOwner().setPetInvItems(true);
                    this.sendPacket(SystemMessageId.ITEMS_IN_PET_INVENTORY);
                } else {
                    this.getOwner().setPetInvItems(false);
                }
            }
            this.abortAttack();
            this.abortCast();
            this.storeMe();
            this.storeEffect(true);
            if (owner != null) {
                owner.setPet(null);
            }
            if (this.hasAI()) {
                this.getAI().stopAITask();
            }
            this.stopAllEffects();
            L2WorldRegion oldRegion = this.getWorldRegion();
            this.decayMe();
            if (oldRegion != null) {
                oldRegion.removeFromZones(this);
            }
            this.getKnownList().removeAllKnownObjects();
            this.setTarget(null);
            if (owner != null) {
                for (int itemId : owner.getAutoSoulShot()) {
                    String handler = ((L2EtcItem)ItemTable.getInstance().getTemplate(itemId)).getHandlerName();
                    if (handler == null || !handler.contains("Beast")) continue;
                    owner.disableAutoShot(itemId);
                }
            }
        }
    }

    public int getAttackRange() {
        return this._attackRange;
    }

    public void setAttackRange(int range) {
        this._attackRange = range < 36 ? 36 : range;
    }

    public void setFollowStatus(boolean state) {
        this._follow = state;
        if (this._follow) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_FOLLOW, this.getOwner());
        } else {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE, null);
        }
    }

    public boolean getFollowStatus() {
        return this._follow;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return this._owner != null && this._owner.isAutoAttackable(attacker);
    }

    public int getControlObjectId() {
        return 0;
    }

    public L2Weapon getActiveWeapon() {
        return null;
    }

    @Override
    public PetInventory getInventory() {
        return null;
    }

    protected void doPickupItem(L2Object object) {
    }

    public void setRestoreSummon(boolean val) {
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        return null;
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getSecondaryWeaponItem() {
        return null;
    }

    @Override
    public boolean isInvul() {
        return super.isInvul() || this.getOwner().isSpawnProtected();
    }

    @Override
    public L2Party getParty() {
        if (this._owner == null) {
            return null;
        }
        return this._owner.getParty();
    }

    @Override
    public boolean isInParty() {
        return this._owner != null && this._owner.isInParty();
    }

    @Override
    public boolean useMagic(Skill skill, boolean forceUse, boolean dontMove) {
        if (skill == null || this.isDead() || this.getOwner() == null) {
            return false;
        }
        if (skill.isPassive()) {
            return false;
        }
        if (this.isCastingNow()) {
            return false;
        }
        this.getOwner().setCurrentPetSkill(skill, forceUse, dontMove);
        L2Object target = null;
        switch (skill.getTargetType()) {
            case OWNER_PET: {
                target = this.getOwner();
                break;
            }
            case PARTY: 
            case AURA: 
            case FRONT_AURA: 
            case BEHIND_AURA: 
            case SELF: 
            case AURA_CORPSE_MOB: 
            case COMMAND_CHANNEL: {
                target = this;
                break;
            }
            default: {
                target = skill.getFirstOfTargetList(this);
            }
        }
        if (target == null) {
            this.sendPacket(SystemMessageId.TARGET_CANT_FOUND);
            return false;
        }
        if (this.isSkillDisabled(skill)) {
            this.sendPacket(SystemMessageId.PET_SKILL_CANNOT_BE_USED_RECHARCHING);
            return false;
        }
        if (this.getCurrentMp() < (double)(this.getStat().getMpConsume(skill) + this.getStat().getMpInitialConsume(skill))) {
            this.sendPacket(SystemMessageId.NOT_ENOUGH_MP);
            return false;
        }
        if (this.getCurrentHp() <= (double)skill.getHpConsume()) {
            this.sendPacket(SystemMessageId.NOT_ENOUGH_HP);
            return false;
        }
        if (skill.isBad()) {
            if (this.getOwner() == target) {
                return false;
            }
            if (this.isInsidePeaceZone(this, target) && !this.getOwner().getAccessLevel().allowPeaceAttack()) {
                this.sendPacket(SystemMessageId.TARGET_IN_PEACEZONE);
                return false;
            }
            if (this.getOwner().isInOlympiadMode() && !this.getOwner().isOlympiadStart()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (target.getActingPlayer() != null && this.getOwner().getSiegeState() > 0 && this.getOwner().isInsideZone(ZoneId.SIEGE) && target.getActingPlayer().getSiegeState() == this.getOwner().getSiegeState() && target.getActingPlayer() != this.getOwner() && target.getActingPlayer().getSiegeSide() == this.getOwner().getSiegeSide()) {
                if (TerritoryWarManager.getInstance().isTWInProgress()) {
                    this.sendPacket(SystemMessageId.YOU_CANNOT_ATTACK_A_MEMBER_OF_THE_SAME_TERRITORY);
                } else {
                    this.sendPacket(SystemMessageId.FORCED_ATTACK_IS_IMPOSSIBLE_AGAINST_SIEGE_SIDE_TEMPORARY_ALLIED_MEMBERS);
                }
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (target.isDoor()) {
                if (!target.isAutoAttackable(this.getOwner())) {
                    return false;
                }
            } else {
                if (!target.canBeAttacked() && !this.getOwner().getAccessLevel().allowPeaceAttack()) {
                    return false;
                }
                if (!(target.isAutoAttackable(this) || forceUse || target.isNpc() || skill.getTargetType() == L2TargetType.AURA || skill.getTargetType() == L2TargetType.FRONT_AURA || skill.getTargetType() == L2TargetType.BEHIND_AURA || skill.getTargetType() == L2TargetType.CLAN || skill.getTargetType() == L2TargetType.PARTY || skill.getTargetType() == L2TargetType.SELF)) {
                    return false;
                }
            }
        }
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_CAST, skill, target);
        return true;
    }

    @Override
    public void setIsImmobilized(boolean value) {
        super.setIsImmobilized(value);
        if (value) {
            this._previousFollowStatus = this.getFollowStatus();
            if (this._previousFollowStatus) {
                this.setFollowStatus(false);
            }
        } else {
            this.setFollowStatus(this._previousFollowStatus);
        }
    }

    public void setOwner(L2PcInstance newOwner) {
        this._owner = newOwner;
    }

    @Override
    public void sendDamageMessage(L2Character target, int damage, boolean mcrit, boolean pcrit, boolean miss) {
        if (miss || this.getOwner() == null) {
            return;
        }
        if (target.getObjectId() != this.getOwner().getObjectId()) {
            SystemMessage sm;
            if (pcrit || mcrit) {
                if (this.isServitor()) {
                    this.sendPacket(SystemMessageId.CRITICAL_HIT_BY_SUMMONED_MOB);
                } else {
                    this.sendPacket(SystemMessageId.CRITICAL_HIT_BY_PET);
                }
            }
            if (this.getOwner().isInOlympiadMode() && target instanceof L2PcInstance && ((L2PcInstance)target).isInOlympiadMode() && ((L2PcInstance)target).getOlympiadGameId() == this.getOwner().getOlympiadGameId()) {
                OlympiadGameManager.getInstance().notifyCompetitorDamage(this.getOwner(), damage);
            }
            if (target.isInvul() && !(target instanceof L2NpcInstance)) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.ATTACK_WAS_BLOCKED);
            } else {
                sm = SystemMessage.getSystemMessage(SystemMessageId.C1_DONE_S3_DAMAGE_TO_C2);
                sm.addNpcName(this);
                sm.addCharName(target);
                sm.addInt(damage);
            }
            this.sendPacket(sm);
        }
    }

    @Override
    public void reduceCurrentHp(double damage, L2Character attacker, Skill skill) {
        super.reduceCurrentHp(damage, attacker, skill);
        if (this.getOwner() != null && attacker != null) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_RECEIVED_DAMAGE_OF_S3_FROM_C2);
            sm.addNpcName(this);
            sm.addCharName(attacker);
            sm.addInt((int)damage);
            this.sendPacket(sm);
        }
    }

    @Override
    public void doCast(Skill skill) {
        L2PcInstance actingPlayer = this.getActingPlayer();
        if (!actingPlayer.checkPvpSkill(this.getTarget(), skill) && !actingPlayer.getAccessLevel().allowPeaceAttack()) {
            actingPlayer.sendPacket(SystemMessageId.TARGET_IS_INCORRECT);
            actingPlayer.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        super.doCast(skill);
    }

    @Override
    public boolean isInCombat() {
        return this.getOwner() != null && this.getOwner().isInCombat();
    }

    @Override
    public L2PcInstance getActingPlayer() {
        return this.getOwner();
    }

    @Override
    public final void broadcastPacket(L2GameServerPacket mov) {
        if (this.getOwner() != null) {
            mov.setInvisible(this.getOwner().isInvisible());
        }
        super.broadcastPacket(mov);
    }

    @Override
    public final void broadcastPacket(L2GameServerPacket mov, int radiusInKnownlist) {
        if (this.getOwner() != null) {
            mov.setInvisible(this.getOwner().isInvisible());
        }
        super.broadcastPacket(mov, radiusInKnownlist);
    }

    public void updateAndBroadcastStatus(int val) {
        L2Party party;
        if (this.getOwner() == null) {
            return;
        }
        this.sendPacket(new PetInfo(this, val));
        this.sendPacket(new PetStatusUpdate(this));
        if (this.isVisible()) {
            this.broadcastNpcInfo(val);
        }
        if ((party = this.getOwner().getParty()) != null) {
            party.broadcastToPartyMembers(this.getOwner(), new ExPartyPetWindowUpdate(this));
        }
        this.updateEffectIcons(true);
    }

    public void broadcastNpcInfo(int val) {
        for (L2PcInstance player : this.getKnownList().getKnownPlayers().values()) {
            if (player == null || player == this.getOwner()) continue;
            player.sendPacket(new AbstractNpcInfo.SummonInfo(this, player, val));
        }
    }

    public boolean isHungry() {
        return false;
    }

    public int getWeapon() {
        return 0;
    }

    public int getArmor() {
        return 0;
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        if (activeChar == this.getOwner()) {
            activeChar.sendPacket(new PetInfo(this, 0));
            this.updateEffectIcons(true);
            if (this.isPet()) {
                activeChar.sendPacket(new PetItemList(this.getInventory().getItems()));
            }
        } else {
            activeChar.sendPacket(new AbstractNpcInfo.SummonInfo(this, activeChar, 0));
        }
    }

    @Override
    public void onTeleported() {
        super.onTeleported();
        this.sendPacket(new TeleportToLocation(this, this.getX(), this.getY(), this.getZ(), this.getHeading()));
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.getId() + ") Owner: " + this.getOwner();
    }

    @Override
    public boolean isUndead() {
        return this.getTemplate().getRace() == Race.UNDEAD;
    }

    public void switchMode() {
    }

    public void cancelAction() {
        if (!this.isMovementDisabled()) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null);
        }
    }

    public void doAttack() {
        L2Object target;
        if (this.getOwner() != null && (target = this.getOwner().getTarget()) != null) {
            this.setTarget(target);
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, target);
        }
    }

    public final boolean canAttack(boolean ctrlPressed) {
        if (this.getOwner() == null) {
            return false;
        }
        L2Object target = this.getOwner().getTarget();
        if (target == null || this == target || this.getOwner() == target) {
            return false;
        }
        int npcId = this.getId();
        if (Util.contains(PASSIVE_SUMMONS, npcId)) {
            this.getOwner().sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.isBetrayed()) {
            this.sendPacket(SystemMessageId.PET_REFUSING_ORDER);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.isAttackingDisabled()) {
            if (!this.isAttackingNow()) {
                return false;
            }
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, target);
        }
        if (this.isPet() && this.getLevel() - this.getOwner().getLevel() > 20) {
            this.sendPacket(SystemMessageId.PET_TOO_HIGH_TO_CONTROL);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.getOwner().isInOlympiadMode() && !this.getOwner().isOlympiadStart()) {
            this.getOwner().sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (target.getActingPlayer() != null && this.getOwner().getSiegeState() > 0 && this.getOwner().isInsideZone(ZoneId.SIEGE) && target.getActingPlayer().getSiegeSide() == this.getOwner().getSiegeSide()) {
            if (TerritoryWarManager.getInstance().isTWInProgress()) {
                this.sendPacket(SystemMessageId.YOU_CANNOT_ATTACK_A_MEMBER_OF_THE_SAME_TERRITORY);
            } else {
                this.sendPacket(SystemMessageId.FORCED_ATTACK_IS_IMPOSSIBLE_AGAINST_SIEGE_SIDE_TEMPORARY_ALLIED_MEMBERS);
            }
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (!this.getOwner().getAccessLevel().allowPeaceAttack() && this.getOwner().isInsidePeaceZone(this, target)) {
            this.sendPacket(SystemMessageId.TARGET_IN_PEACEZONE);
            return false;
        }
        if (this.isLockedTarget()) {
            this.sendPacket(SystemMessageId.FAILED_CHANGE_TARGET);
            return false;
        }
        if (!(target.isAutoAttackable(this.getOwner()) || ctrlPressed || target.isNpc())) {
            this.setFollowStatus(false);
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_FOLLOW, target);
            this.sendPacket(SystemMessageId.INCORRECT_TARGET);
            return false;
        }
        return !target.isDoor() || this.getTemplate().getRace() == Race.SIEGE_WEAPON;
    }

    @Override
    public void sendPacket(L2GameServerPacket mov) {
        if (this.getOwner() != null) {
            this.getOwner().sendPacket(mov);
        }
    }

    @Override
    public void sendPacket(SystemMessageId id) {
        if (this.getOwner() != null) {
            this.getOwner().sendPacket(id);
        }
    }

    @Override
    public boolean isSummon() {
        return true;
    }

    @Override
    public L2Summon getSummon() {
        return this;
    }

    @Override
    public boolean isChargedShot(ShotType type) {
        return (this._shotsMask & type.getMask()) != 0;
    }

    @Override
    public void setChargedShot(ShotType type, boolean charged) {
        this._shotsMask = charged ? (this._shotsMask |= type.getMask()) : (this._shotsMask &= ~type.getMask());
    }

    @Override
    public void rechargeShots(boolean physical, boolean magic) {
        if (this.getOwner().getAutoSoulShot() == null || this.getOwner().getAutoSoulShot().isEmpty()) {
            return;
        }
        for (int itemId : this.getOwner().getAutoSoulShot()) {
            L2ItemInstance item = this.getOwner().getInventory().getItemByItemId(itemId);
            if (item != null) {
                IItemHandler handler;
                if (magic && item.getItem().getDefaultAction() == ActionType.SUMMON_SPIRITSHOT && (handler = ItemHandler.getInstance().getHandler(item.getEtcItem())) != null) {
                    handler.useItem(this.getOwner(), item, false);
                }
                if (!physical || item.getItem().getDefaultAction() != ActionType.SUMMON_SOULSHOT || (handler = ItemHandler.getInstance().getHandler(item.getEtcItem())) == null) continue;
                handler.useItem(this.getOwner(), item, false);
                continue;
            }
            this.getOwner().removeAutoSoulShot(itemId);
        }
    }

    @Override
    public int getClanId() {
        return this.getOwner() != null ? this.getOwner().getClanId() : 0;
    }

    @Override
    public int getAllyId() {
        return this.getOwner() != null ? this.getOwner().getAllyId() : 0;
    }

    public int getFormId() {
        int formId = 0;
        int npcId = this.getId();
        if (npcId == 16041 || npcId == 16042) {
            if (this.getLevel() > 69) {
                formId = 3;
            } else if (this.getLevel() > 64) {
                formId = 2;
            } else if (this.getLevel() > 59) {
                formId = 1;
            }
        } else if (npcId == 16025 || npcId == 16037) {
            if (this.getLevel() > 69) {
                formId = 3;
            } else if (this.getLevel() > 64) {
                formId = 2;
            } else if (this.getLevel() > 59) {
                formId = 1;
            }
        }
        return formId;
    }

    public class AIAccessor
    extends L2Character.AIAccessor {
        public L2Summon getSummon() {
            return L2Summon.this;
        }

        public boolean isAutoFollow() {
            return L2Summon.this.getFollowStatus();
        }

        public void doPickupItem(L2Object object) {
            L2Summon.this.doPickupItem(object);
        }
    }
}

