/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor;

import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;

public abstract class L2Tower
extends L2Npc {
    public L2Tower(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setIsInvul(false);
    }

    @Override
    public boolean canBeAttacked() {
        return this.getCastle() != null && this.getCastle().getResidenceId() > 0 && this.getCastle().getSiege().isInProgress();
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return attacker != null && attacker.isPlayer() && this.getCastle() != null && this.getCastle().getResidenceId() > 0 && this.getCastle().getSiege().isInProgress() && this.getCastle().getSiege().checkIsAttacker(((L2PcInstance)attacker).getClan());
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (!this.canTarget(player)) {
            return;
        }
        if (this != player.getTarget()) {
            player.setTarget(this);
        } else if (interact && this.isAutoAttackable(player) && Math.abs(player.getZ() - this.getZ()) < 100 && GeoData.getInstance().canSeeTarget((L2Object)player, this)) {
            player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    @Override
    public void onForcedAttack(L2PcInstance player) {
        this.onAction(player);
    }
}

