/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;

public final class L2ChestInstance
extends L2MonsterInstance {
    private volatile boolean _specialDrop;

    public L2ChestInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2ChestInstance);
        this._specialDrop = false;
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this._specialDrop = false;
        this.setMustRewardExpSp(true);
        this.getSpawn().setIsNoRndWalk(true);
        this.setIsNoRndWalk(true);
    }

    public synchronized void setSpecialDrop() {
        this._specialDrop = true;
    }

    @Override
    public void doItemDrop(L2NpcTemplate npcTemplate, L2Character lastAttacker) {
        int id = this.getTemplate().getId();
        if (!this._specialDrop) {
            if (id >= 18265 && id <= 18286) {
                id += 3536;
            } else if (id == 18287 || id == 18288) {
                id = 21671;
            } else if (id == 18289 || id == 18290) {
                id = 21694;
            } else if (id == 18291 || id == 18292) {
                id = 21717;
            } else if (id == 18293 || id == 18294) {
                id = 21740;
            } else if (id == 18295 || id == 18296) {
                id = 21763;
            } else if (id == 18297 || id == 18298) {
                id = 21786;
            }
        }
        super.doItemDrop(NpcData.getInstance().getTemplate(id), lastAttacker);
    }

    @Override
    public boolean isMovementDisabled() {
        return true;
    }

    @Override
    public boolean hasRandomAnimation() {
        return false;
    }
}

