/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.FourSepulchersManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.util.Rnd;
import java.util.Collection;
import java.util.concurrent.Future;

public class L2SepulcherMonsterInstance
extends L2MonsterInstance {
    @Deprecated
    static final boolean DEBUG = false;
    static final long TIME_VICTIM_SPAWN_KEYBOX = 300000L;
    public int mysteriousBoxId = 0;
    boolean victimKeyBoxSpawned;
    L2Spawn _spawn2;
    protected Future<?> _victimSpawnKeyBoxTask = null;
    protected Future<?> _victimShout = null;
    protected Future<?> _onDeadEventTask = null;

    public L2SepulcherMonsterInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2SepulcherMonsterInstance);
        this.setShowSummonAnimation(true);
        switch (template.getId()) {
            case 25339: 
            case 25342: 
            case 25346: 
            case 25349: {
                this.setIsRaid(true);
            }
        }
    }

    @Override
    public void onSpawn() {
        this.setShowSummonAnimation(false);
        switch (this.getId()) {
            case 18150: 
            case 18151: 
            case 18152: 
            case 18153: 
            case 18154: 
            case 18155: 
            case 18156: 
            case 18157: {
                this.setRandomAnimationEnabled(false);
                this.setRunning();
                if (this._victimSpawnKeyBoxTask != null) {
                    this._victimSpawnKeyBoxTask.cancel(true);
                }
                this._victimSpawnKeyBoxTask = ThreadPoolManager.getInstance().scheduleEffect(new VictimSpawnKeyBox(), 300000L);
                if (this._victimShout != null) {
                    this._victimShout.cancel(true);
                }
                this._victimShout = ThreadPoolManager.getInstance().scheduleEffect(new VictimShout(System.currentTimeMillis() + 300000L), 5000L);
                break;
            }
            case 18196: 
            case 18197: 
            case 18198: 
            case 18199: 
            case 18200: 
            case 18201: 
            case 18202: 
            case 18203: 
            case 18204: 
            case 18205: 
            case 18206: 
            case 18207: 
            case 18208: 
            case 18209: 
            case 18210: 
            case 18211: {
                break;
            }
            case 18231: 
            case 18232: 
            case 18233: 
            case 18234: 
            case 18235: 
            case 18236: 
            case 18237: 
            case 18238: 
            case 18239: 
            case 18240: 
            case 18241: 
            case 18242: 
            case 18243: {
                this.getSpawn().setIsNoRndWalk(true);
                this.setIsNoRndWalk(true);
                SkillData.getInstance().getSkill(4616, 1).applyEffects(this, this);
                break;
            }
            case 18256: {
                this.getSpawn().setIsNoRndWalk(true);
                this.setIsNoRndWalk(true);
                break;
            }
            case 25339: 
            case 25342: 
            case 25346: 
            case 25349: {
                this.setIsRaid(true);
            }
        }
        super.onSpawn();
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        switch (this.getId()) {
            case 18120: 
            case 18121: 
            case 18122: 
            case 18123: 
            case 18124: 
            case 18125: 
            case 18126: 
            case 18127: 
            case 18128: 
            case 18129: 
            case 18130: 
            case 18131: 
            case 18149: 
            case 18158: 
            case 18159: 
            case 18160: 
            case 18161: 
            case 18162: 
            case 18163: 
            case 18164: 
            case 18165: 
            case 18183: 
            case 18184: 
            case 18212: 
            case 18213: 
            case 18214: 
            case 18215: 
            case 18216: 
            case 18217: 
            case 18218: 
            case 18219: {
                if (this._onDeadEventTask != null) {
                    this._onDeadEventTask.cancel(true);
                }
                this._onDeadEventTask = ThreadPoolManager.getInstance().scheduleEffect(new OnDeadEvent(this), 3500L);
                break;
            }
            case 18150: 
            case 18151: 
            case 18152: 
            case 18153: 
            case 18154: 
            case 18155: 
            case 18156: 
            case 18157: {
                if (this._victimSpawnKeyBoxTask != null) {
                    this._victimSpawnKeyBoxTask.cancel(true);
                    this._victimSpawnKeyBoxTask = null;
                }
                if (this._victimShout != null) {
                    this._victimShout.cancel(true);
                    this._victimShout = null;
                }
                if (this._onDeadEventTask != null) {
                    this._onDeadEventTask.cancel(true);
                }
                this._onDeadEventTask = ThreadPoolManager.getInstance().scheduleEffect(new OnDeadEvent(this), 3500L);
                break;
            }
            case 18141: 
            case 18142: 
            case 18143: 
            case 18144: 
            case 18145: 
            case 18146: 
            case 18147: 
            case 18148: {
                if (!FourSepulchersManager.getInstance().isViscountMobsAnnihilated(this.mysteriousBoxId)) break;
                if (this._onDeadEventTask != null) {
                    this._onDeadEventTask.cancel(true);
                }
                this._onDeadEventTask = ThreadPoolManager.getInstance().scheduleEffect(new OnDeadEvent(this), 3500L);
                break;
            }
            case 18220: 
            case 18221: 
            case 18222: 
            case 18223: 
            case 18224: 
            case 18225: 
            case 18226: 
            case 18227: 
            case 18228: 
            case 18229: 
            case 18230: 
            case 18231: 
            case 18232: 
            case 18233: 
            case 18234: 
            case 18235: 
            case 18236: 
            case 18237: 
            case 18238: 
            case 18239: 
            case 18240: {
                if (!FourSepulchersManager.getInstance().isDukeMobsAnnihilated(this.mysteriousBoxId)) break;
                if (this._onDeadEventTask != null) {
                    this._onDeadEventTask.cancel(true);
                }
                this._onDeadEventTask = ThreadPoolManager.getInstance().scheduleEffect(new OnDeadEvent(this), 3500L);
                break;
            }
            case 25339: 
            case 25342: 
            case 25346: 
            case 25349: {
                this.giveCup(killer);
                if (this._onDeadEventTask != null) {
                    this._onDeadEventTask.cancel(true);
                }
                this._onDeadEventTask = ThreadPoolManager.getInstance().scheduleEffect(new OnDeadEvent(this), 8500L);
            }
        }
        return true;
    }

    @Override
    public boolean deleteMe() {
        if (this._victimSpawnKeyBoxTask != null) {
            this._victimSpawnKeyBoxTask.cancel(true);
            this._victimSpawnKeyBoxTask = null;
        }
        if (this._onDeadEventTask != null) {
            this._onDeadEventTask.cancel(true);
            this._onDeadEventTask = null;
        }
        return super.deleteMe();
    }

    private void giveCup(L2Character killer) {
        String questId = "620_FourGoblets";
        int cupId = 0;
        int ANTIQUE_BROOCH = 7262;
        switch (this.getId()) {
            case 25339: {
                cupId = 7256;
                break;
            }
            case 25342: {
                cupId = 7257;
                break;
            }
            case 25346: {
                cupId = 7258;
                break;
            }
            case 25349: {
                cupId = 7259;
            }
        }
        L2PcInstance player = killer.getActingPlayer();
        if (player == null) {
            return;
        }
        if (player.getParty() != null) {
            for (L2PcInstance mem : player.getParty().getMembers()) {
                QuestState qs = mem.getQuestState(questId);
                if (qs == null || !qs.isStarted() && !qs.isCompleted() || mem.getInventory().getItemByItemId(7262) != null) continue;
                mem.addItem("Quest", cupId, 1L, mem, true);
            }
        } else {
            QuestState qs = player.getQuestState(questId);
            if (qs != null && (qs.isStarted() || qs.isCompleted()) && player.getInventory().getItemByItemId(7262) == null) {
                player.addItem("Quest", cupId, 1L, player, true);
            }
        }
    }

    L2PcInstance getRandomPlayer(boolean isBusy) {
        Collection knowns = this.getKnownList().getKnownPlayers().values();
        L2PcInstance[] knownPlayers = new L2PcInstance[knowns.size()];
        int count = 0;
        for (L2PcInstance player : knowns) {
            if (player == null || player.isDead() || player.isInCombat() != isBusy) continue;
            knownPlayers[count++] = player;
        }
        if (count > 0) {
            return knownPlayers[Rnd.get(count)];
        }
        return null;
    }

    L2SepulcherMonsterInstance getClosestMonster() {
        L2SepulcherMonsterInstance attacker = null;
        long distanceSq = Long.MAX_VALUE;
        for (L2Object o : this.getKnownList().getKnownObjects().values()) {
            long d;
            L2SepulcherMonsterInstance a;
            if (!(o instanceof L2SepulcherMonsterInstance) || (a = (L2SepulcherMonsterInstance)o).isAttackingDisabled() || (d = (long)this.getPlanDistanceSq(a)) >= distanceSq) continue;
            distanceSq = d;
            attacker = a;
        }
        return attacker;
    }

    @Override
    protected void doAttack(L2Character target) {
        super.doAttack(target);
    }

    @Override
    public void addDamageHate(L2Character attacker, int damage, int aggro) {
        switch (this.getId()) {
            case 18150: 
            case 18151: 
            case 18152: 
            case 18153: 
            case 18154: 
            case 18155: 
            case 18156: 
            case 18157: {
                return;
            }
        }
        super.addDamageHate(attacker, damage, aggro);
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return true;
    }

    private static class OnDeadEvent
    implements Runnable {
        L2SepulcherMonsterInstance _activeChar;

        public OnDeadEvent(L2SepulcherMonsterInstance activeChar) {
            this._activeChar = activeChar;
        }

        @Override
        public void run() {
            switch (this._activeChar.getId()) {
                case 18120: 
                case 18121: 
                case 18122: 
                case 18123: 
                case 18124: 
                case 18125: 
                case 18126: 
                case 18127: 
                case 18128: 
                case 18129: 
                case 18130: 
                case 18131: 
                case 18149: 
                case 18158: 
                case 18159: 
                case 18160: 
                case 18161: 
                case 18162: 
                case 18163: 
                case 18164: 
                case 18165: 
                case 18183: 
                case 18184: 
                case 18212: 
                case 18213: 
                case 18214: 
                case 18215: 
                case 18216: 
                case 18217: 
                case 18218: 
                case 18219: {
                    FourSepulchersManager.getInstance().spawnKeyBox(this._activeChar);
                    break;
                }
                case 18150: 
                case 18151: 
                case 18152: 
                case 18153: 
                case 18154: 
                case 18155: 
                case 18156: 
                case 18157: {
                    if (this._activeChar.victimKeyBoxSpawned) break;
                    FourSepulchersManager.getInstance().spawnExecutionerOfHalisha(this._activeChar);
                    break;
                }
                case 18141: 
                case 18142: 
                case 18143: 
                case 18144: 
                case 18145: 
                case 18146: 
                case 18147: 
                case 18148: {
                    FourSepulchersManager.getInstance().spawnMonster(this._activeChar.mysteriousBoxId);
                    break;
                }
                case 18220: 
                case 18221: 
                case 18222: 
                case 18223: 
                case 18224: 
                case 18225: 
                case 18226: 
                case 18227: 
                case 18228: 
                case 18229: 
                case 18230: 
                case 18231: 
                case 18232: 
                case 18233: 
                case 18234: 
                case 18235: 
                case 18236: 
                case 18237: 
                case 18238: 
                case 18239: 
                case 18240: {
                    FourSepulchersManager.getInstance().spawnArchonOfHalisha(this._activeChar.mysteriousBoxId);
                    break;
                }
                case 25339: 
                case 25342: 
                case 25346: 
                case 25349: {
                    FourSepulchersManager.getInstance().spawnEmperorsGraveNpc(this._activeChar.mysteriousBoxId);
                }
            }
        }
    }

    private class VictimSpawnKeyBox
    implements Runnable {
        private long _effectPeriod;

        @Override
        public void run() {
            L2SepulcherMonsterInstance activeChar = L2SepulcherMonsterInstance.this;
            if (L2SepulcherMonsterInstance.this._victimShout != null) {
                L2SepulcherMonsterInstance.this._victimShout.cancel(true);
                L2SepulcherMonsterInstance.this._victimShout = null;
            }
            if (L2SepulcherMonsterInstance.this.isDead()) {
                return;
            }
            if (!L2SepulcherMonsterInstance.this.isVisible()) {
                return;
            }
            if (!L2SepulcherMonsterInstance.this.victimKeyBoxSpawned) {
                L2SepulcherMonsterInstance.this.victimKeyBoxSpawned = true;
                FourSepulchersManager.getInstance().spawnKeyBox(activeChar);
                L2SepulcherMonsterInstance.this.broadcastPacket(new NpcSay(L2SepulcherMonsterInstance.this.getObjectId(), 0, L2SepulcherMonsterInstance.this.getId(), 1000503));
                L2SepulcherMonsterInstance.this.broadcastPacket(new SocialAction(L2SepulcherMonsterInstance.this.getObjectId(), 1));
                L2SepulcherMonsterInstance.this.setWalking();
                L2SepulcherMonsterInstance.this.setRandomAnimationEnabled(true);
            }
            if (System.currentTimeMillis() > this._effectPeriod) {
                this._effectPeriod = System.currentTimeMillis() + 110000L;
                for (L2PcInstance player : L2SepulcherMonsterInstance.this.getKnownList().getKnownPlayers().values()) {
                    if (player == null || player.isDead()) continue;
                    int skillId = Rnd.get(4384, 4387);
                    int skillLevel = 1;
                    Skill skill = SkillData.getInstance().getSkill(skillId, skillLevel);
                    L2SepulcherMonsterInstance.this.setTarget(player);
                    L2SepulcherMonsterInstance.this.doCast(skill);
                    L2SepulcherMonsterInstance.this.broadcastPacket(new MagicSkillUse(activeChar, player, skillId, skillLevel, 0, 0));
                }
            }
            long delay = L2SepulcherMonsterInstance.this.isMoving() ? 10000L : 30000L;
            switch (L2SepulcherMonsterInstance.this.getAI().getIntention()) {
                case AI_INTENTION_ACTIVE: {
                    L2PcInstance player = L2SepulcherMonsterInstance.this.getRandomPlayer(false);
                    if (player == null) break;
                    L2SepulcherMonsterInstance.this.setRunning();
                    L2SepulcherMonsterInstance.this.getAI().setIntention(CtrlIntention.AI_INTENTION_INTERACT, player);
                    delay = 10000L;
                    break;
                }
                case AI_INTENTION_INTERACT: {
                    L2PcInstance player = L2SepulcherMonsterInstance.this.getRandomPlayer(false);
                    if (player == null) break;
                    L2SepulcherMonsterInstance.this.setRunning();
                    L2SepulcherMonsterInstance.this.getAI().setIntention(CtrlIntention.AI_INTENTION_FOLLOW, player);
                    delay = 10000L;
                    break;
                }
                case AI_INTENTION_FOLLOW: {
                    if (L2SepulcherMonsterInstance.this.isMoving() && (!(L2SepulcherMonsterInstance.this.getTarget() instanceof L2PcInstance) || !((L2PcInstance)L2SepulcherMonsterInstance.this.getTarget()).isInCombat())) break;
                    L2SepulcherMonsterInstance.this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                    delay = 60000L;
                }
            }
            L2SepulcherMonsterInstance.this._victimSpawnKeyBoxTask = ThreadPoolManager.getInstance().scheduleEffect(this, delay);
        }
    }

    private class VictimShout
    implements Runnable {
        long _victimSpawnKeyBoxTime;
        long _nextShoutTime;

        public VictimShout(long victimSpawnKeyBoxTime) {
            this._victimSpawnKeyBoxTime = victimSpawnKeyBoxTime;
        }

        @Override
        public void run() {
            try {
                L2SepulcherMonsterInstance attacker;
                if (L2SepulcherMonsterInstance.this.isDead()) {
                    return;
                }
                if (!L2SepulcherMonsterInstance.this.isVisible()) {
                    return;
                }
                long timeLeft = this._victimSpawnKeyBoxTime - System.currentTimeMillis();
                if (timeLeft <= 0L) {
                    return;
                }
                if (L2SepulcherMonsterInstance.this.getCurrentHp() - 777.0 > (double)L2SepulcherMonsterInstance.this.getMaxHp() * (double)timeLeft / 300000.0 && (attacker = L2SepulcherMonsterInstance.this.getClosestMonster()) != null) {
                    attacker.doAttack(L2SepulcherMonsterInstance.this);
                }
                if (this._nextShoutTime < System.currentTimeMillis()) {
                    this._nextShoutTime = System.currentTimeMillis() + (long)Rnd.get(15000, 45000);
                    L2PcInstance player = L2SepulcherMonsterInstance.this.getRandomPlayer(false);
                    if (player != null) {
                        L2SepulcherMonsterInstance.this.broadcastPacket(new NpcSay(L2SepulcherMonsterInstance.this.getObjectId(), 0, L2SepulcherMonsterInstance.this.getId(), 1010483).addPcName(player));
                        L2SepulcherMonsterInstance.this.getAI().setIntention(CtrlIntention.AI_INTENTION_INTERACT, player);
                        L2SepulcherMonsterInstance.this.setCanReturnToSpawnPoint(false);
                        L2SepulcherMonsterInstance.this.setIsNoRndWalk(true);
                        ThreadPoolManager.getInstance().scheduleEffect(() -> {
                            if (L2SepulcherMonsterInstance.this.getAI().getIntention() == CtrlIntention.AI_INTENTION_INTERACT) {
                                L2SepulcherMonsterInstance.this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                            }
                        }, 5000L);
                    } else {
                        player = L2SepulcherMonsterInstance.this.getRandomPlayer(true);
                        if (player != null) {
                            L2SepulcherMonsterInstance.this.broadcastPacket(new NpcSay(L2SepulcherMonsterInstance.this.getObjectId(), 0, L2SepulcherMonsterInstance.this.getId(), 1010483).addPcName(player));
                            if (!L2SepulcherMonsterInstance.this.isMoving()) {
                                L2SepulcherMonsterInstance.this.broadcastPacket(new SocialAction(L2SepulcherMonsterInstance.this.getObjectId(), 1));
                            }
                        } else {
                            L2SepulcherMonsterInstance.this.broadcastPacket(new NpcSay(L2SepulcherMonsterInstance.this.getObjectId(), 0, L2SepulcherMonsterInstance.this.getId(), 1010484));
                            if (!L2SepulcherMonsterInstance.this.isMoving()) {
                                L2SepulcherMonsterInstance.this.broadcastPacket(new SocialAction(L2SepulcherMonsterInstance.this.getObjectId(), 1));
                            }
                        }
                    }
                }
                L2SepulcherMonsterInstance.this._victimShout = ThreadPoolManager.getInstance().scheduleEffect(this, Rnd.get(500, 5000));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

