/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.FourSepulchersManager;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.EventType;
import com.l2jserver.gameserver.model.events.impl.character.npc.OnNpcFirstTalk;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.AbnormalVisualEffect;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.util.concurrent.Future;

public class L2SepulcherNpcInstance
extends L2Npc {
    protected Future<?> _closeTask = null;
    protected Future<?> _spawnNextMysteriousBoxTask = null;
    protected Future<?> _spawnMonsterTask = null;
    private static final String HTML_FILE_PATH = "data/html/SepulcherNpc/";
    private static final int HALLS_KEY = 7260;

    public L2SepulcherNpcInstance(int objectID, L2NpcTemplate template) {
        super(objectID, template);
        this.setInstanceType(InstanceType.L2SepulcherNpcInstance);
        this.setShowSummonAnimation(true);
        if (this._closeTask != null) {
            this._closeTask.cancel(true);
        }
        if (this._spawnNextMysteriousBoxTask != null) {
            this._spawnNextMysteriousBoxTask.cancel(true);
        }
        if (this._spawnMonsterTask != null) {
            this._spawnMonsterTask.cancel(true);
        }
        this._closeTask = null;
        this._spawnNextMysteriousBoxTask = null;
        this._spawnMonsterTask = null;
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this.setShowSummonAnimation(false);
    }

    @Override
    public boolean deleteMe() {
        if (this._closeTask != null) {
            this._closeTask.cancel(true);
            this._closeTask = null;
        }
        if (this._spawnNextMysteriousBoxTask != null) {
            this._spawnNextMysteriousBoxTask.cancel(true);
            this._spawnNextMysteriousBoxTask = null;
        }
        if (this._spawnMonsterTask != null) {
            this._spawnMonsterTask.cancel(true);
            this._spawnMonsterTask = null;
        }
        return super.deleteMe();
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (!this.canTarget(player)) {
            return;
        }
        if (this != player.getTarget()) {
            if (Config.DEBUG) {
                _log.info("new target selected:" + this.getObjectId());
            }
            player.setTarget(this);
        } else if (interact) {
            if (this.isAutoAttackable(player) && !this.isAlikeDead()) {
                if (Math.abs(player.getZ() - this.getZ()) < 400) {
                    player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
                } else {
                    player.sendPacket(ActionFailed.STATIC_PACKET);
                }
            }
            if (!this.isAutoAttackable(player)) {
                if (!this.canInteract(player)) {
                    player.getAI().setIntention(CtrlIntention.AI_INTENTION_INTERACT, this);
                } else {
                    SocialAction sa = new SocialAction(this.getObjectId(), Rnd.get(8));
                    this.broadcastPacket(sa);
                    this.doAction(player);
                }
            }
            player.sendPacket(ActionFailed.STATIC_PACKET);
        }
    }

    private void doAction(L2PcInstance player) {
        if (this.isDead()) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        switch (this.getId()) {
            case 31468: 
            case 31469: 
            case 31470: 
            case 31471: 
            case 31472: 
            case 31473: 
            case 31474: 
            case 31475: 
            case 31476: 
            case 31477: 
            case 31478: 
            case 31479: 
            case 31480: 
            case 31481: 
            case 31482: 
            case 31483: 
            case 31484: 
            case 31485: 
            case 31486: 
            case 31487: {
                this.setIsInvul(false);
                new BoxAction();
                if (this._spawnMonsterTask != null) {
                    this._spawnMonsterTask.cancel(true);
                }
                this._spawnMonsterTask = ThreadPoolManager.getInstance().scheduleEffect(new SpawnMonster(this.getId()), 3500L);
                this.doDie(null);
                break;
            }
            case 31455: 
            case 31456: 
            case 31457: 
            case 31458: 
            case 31459: 
            case 31460: 
            case 31461: 
            case 31462: 
            case 31463: 
            case 31464: 
            case 31465: 
            case 31466: 
            case 31467: {
                this.setIsInvul(false);
                new BoxAction();
                if (player.getParty() != null && !player.getParty().isLeader(player)) {
                    player = player.getParty().getLeader();
                }
                player.addItem("Quest", 7260, 1L, player, true);
                this.doDie(null);
                break;
            }
            default: {
                if (this.hasListener(EventType.ON_NPC_QUEST_START)) {
                    player.setLastQuestNpcObject(this.getObjectId());
                }
                if (this.hasListener(EventType.ON_NPC_FIRST_TALK)) {
                    EventDispatcher.getInstance().notifyEventAsync(new OnNpcFirstTalk(this, player), this);
                    break;
                }
                this.showChatWindow(player, 0);
            }
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        return this.getHtmlPath(HTML_FILE_PATH, npcId, val);
    }

    @Override
    public void showChatWindow(L2PcInstance player, int val) {
        String filename = this.getHtmlPath(this.getId(), val);
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        player.sendPacket(html);
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (this.isBusy()) {
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            html.setFile(player.getHtmlPrefix(), "data/html/npcbusy.htm");
            html.replace((CharSequence)"%busymessage%", this.getBusyMessage());
            html.replace((CharSequence)"%npcname%", this.getName());
            html.replace((CharSequence)"%playername%", player.getName());
            player.sendPacket(html);
        } else if (command.startsWith("Chat")) {
            int val = 0;
            try {
                val = Integer.parseInt(command.substring(5));
            }
            catch (IndexOutOfBoundsException ioobe) {
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            this.showChatWindow(player, val);
        } else if (command.startsWith("open_gate")) {
            L2ItemInstance hallsKey = player.getInventory().getItemByItemId(7260);
            if (hallsKey == null) {
                this.showHtmlFile(player, "Gatekeeper-no.htm");
            } else if (FourSepulchersManager.getInstance().isAttackTime()) {
                switch (this.getId()) {
                    case 31929: 
                    case 31934: 
                    case 31939: 
                    case 31944: {
                        FourSepulchersManager.getInstance().spawnShadow(this.getId());
                    }
                }
                this.openNextDoor(this.getId());
                if (player.getParty() != null) {
                    for (L2PcInstance mem : player.getParty().getMembers()) {
                        if (mem == null || mem.getInventory().getItemByItemId(7260) == null) continue;
                        mem.destroyItemByItemId("Quest", 7260, mem.getInventory().getItemByItemId(7260).getCount(), mem, true);
                    }
                } else {
                    player.destroyItemByItemId("Quest", 7260, hallsKey.getCount(), player, true);
                }
            }
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    public void openNextDoor(int npcId) {
        int doorId = FourSepulchersManager.getInstance().getHallGateKeepers().get(npcId);
        DoorTable _doorTable = DoorTable.getInstance();
        _doorTable.getDoor(doorId).openMe();
        if (this._closeTask != null) {
            this._closeTask.cancel(true);
        }
        this._closeTask = ThreadPoolManager.getInstance().scheduleEffect(new CloseNextDoor(doorId), 10000L);
        if (this._spawnNextMysteriousBoxTask != null) {
            this._spawnNextMysteriousBoxTask.cancel(true);
        }
        this._spawnNextMysteriousBoxTask = ThreadPoolManager.getInstance().scheduleEffect(new SpawnNextMysteriousBox(npcId), 0L);
    }

    public void sayInShout(String msg) {
        this.sayInShout(new NpcSay(this.getObjectId(), 23, this.getId(), msg));
    }

    public void sayInShout(int npcstring) {
        this.sayInShout(new NpcSay(this.getObjectId(), 23, this.getId(), npcstring));
    }

    public void sayInShout(NpcStringId msg) {
        if (msg == null) {
            return;
        }
        this.sayInShout(new NpcSay(this.getObjectId(), 23, this.getId(), msg));
    }

    private void sayInShout(L2GameServerPacket packet) {
        for (L2PcInstance player : L2World.getInstance().getPlayers()) {
            if (!Util.checkIfInRange(15000, player, this, true)) continue;
            player.sendPacket(packet);
        }
    }

    public void showHtmlFile(L2PcInstance player, String file) {
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), HTML_FILE_PATH + file);
        html.replace((CharSequence)"%npcname%", this.getName());
        player.sendPacket(html);
    }

    private static class SpawnMonster
    implements Runnable {
        private final int _NpcId;

        public SpawnMonster(int npcId) {
            this._NpcId = npcId;
        }

        @Override
        public void run() {
            FourSepulchersManager.getInstance().spawnMonster(this._NpcId);
        }
    }

    private static class SpawnNextMysteriousBox
    implements Runnable {
        private final int _NpcId;

        public SpawnNextMysteriousBox(int npcId) {
            this._NpcId = npcId;
        }

        @Override
        public void run() {
            FourSepulchersManager.getInstance().spawnMysteriousBox(this._NpcId);
        }
    }

    private static class CloseNextDoor
    implements Runnable {
        final DoorTable _DoorTable = DoorTable.getInstance();
        private final int _DoorId;

        public CloseNextDoor(int doorId) {
            this._DoorId = doorId;
        }

        @Override
        public void run() {
            try {
                this._DoorTable.getDoor(this._DoorId).closeMe();
            }
            catch (Exception e) {
                L2Character._log.warning(e.getMessage());
            }
        }
    }

    class BoxAction
    implements Runnable {
        BoxAction() {
            L2SepulcherNpcInstance.this.startAbnormalVisualEffect(true, AbnormalVisualEffect.STUN);
            ThreadPoolManager.getInstance().scheduleEffect(this, 3000L);
        }

        @Override
        public void run() {
            L2SepulcherNpcInstance.this.stopAbnormalVisualEffect(true, AbnormalVisualEffect.STUN);
        }
    }
}

