/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.knownlist;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.WalkingManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2FestivalGuideInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.CharKnownList;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.character.npc.OnNpcCreatureSee;
import java.util.Collection;
import java.util.concurrent.ScheduledFuture;

public class NpcKnownList
extends CharKnownList {
    private ScheduledFuture<?> _trackingTask = null;
    public int distanceToWatchObject;
    public int distanceToForgetObject;

    public NpcKnownList(L2Npc activeChar) {
        super(activeChar);
    }

    @Override
    public boolean addKnownObject(L2Object object) {
        if (!super.addKnownObject(object)) {
            return false;
        }
        if (object instanceof L2Character) {
            L2Npc npc = this.getActiveChar();
            EventDispatcher.getInstance().notifyEventAsync(new OnNpcCreatureSee(npc, (L2Character)object, object.isSummon()), npc);
        }
        return true;
    }

    @Override
    public L2Npc getActiveChar() {
        return (L2Npc)this._activeObject;
    }

    @Override
    public int getDistanceToForgetObject(L2Object object) {
        if (this.distanceToForgetObject > 0) {
            return this.distanceToForgetObject;
        }
        return 2 * this.getDistanceToWatchObject(object);
    }

    @Override
    public int getDistanceToWatchObject(L2Object object) {
        if (!(object instanceof L2Character)) {
            return 0;
        }
        if (object instanceof L2FestivalGuideInstance) {
            return 4000;
        }
        if (object.isPlayable()) {
            if (this.distanceToWatchObject > 0) {
                return this.distanceToWatchObject;
            }
            return 1500;
        }
        return 500;
    }

    public void startTrackingTask() {
        if (this._trackingTask == null && this.getActiveChar().getAggroRange() > 0 && this.getActiveObject().isAttackable()) {
            this._trackingTask = ThreadPoolManager.getInstance().scheduleAiAtFixedRate(new TrackingTask(), 2000L, 2000L);
        }
    }

    public void stopTrackingTask() {
        if (this._trackingTask != null) {
            this._trackingTask.cancel(true);
            this._trackingTask = null;
        }
    }

    protected class TrackingTask
    implements Runnable {
        protected TrackingTask() {
        }

        @Override
        public void run() {
            L2Attackable monster = (L2Attackable)NpcKnownList.this.getActiveObject();
            if (monster.getAI().getIntention() == CtrlIntention.AI_INTENTION_MOVE_TO) {
                Collection players = NpcKnownList.this.getKnownPlayers().values();
                for (L2PcInstance pl : players) {
                    if (pl.isDead() || pl.isInvul() || !pl.isInsideRadius(monster, monster.getAggroRange(), true, false) || (!monster.isMonster() || !this.autoAttackCondition(pl)) && (!monster.isInstanceTypes(InstanceType.L2GuardInstance) || pl.getKarma() <= 0)) continue;
                    if (monster.getHating(pl) == 0) {
                        monster.addDamageHate(pl, 0, 0);
                    }
                    if (monster.getAI().getIntention() == CtrlIntention.AI_INTENTION_ATTACK || monster.isCoreAIDisabled()) continue;
                    WalkingManager.getInstance().stopMoving(monster, false, true);
                    monster.addDamageHate(pl, 0, 100);
                    monster.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, pl, null);
                }
            }
        }

        private boolean autoAttackCondition(L2PcInstance target) {
            if (target.isSpawnProtected() || target.isTeleportProtected()) {
                return false;
            }
            L2MonsterInstance me = (L2MonsterInstance)NpcKnownList.this.getActiveObject();
            return me.isRaid() || me.canSeeThroughSilentMove() || !target.isSilentMovingAffected();
        }
    }
}

