/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.stat;

import com.l2jserver.gameserver.datatables.ExperienceTable;
import com.l2jserver.gameserver.datatables.PetDataTable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.stat.SummonStat;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public class PetStat
extends SummonStat {
    public PetStat(L2PetInstance activeChar) {
        super(activeChar);
    }

    public boolean addExp(int value) {
        if (this.getActiveChar().isUncontrollable() || !super.addExp(value)) {
            return false;
        }
        this.getActiveChar().updateAndBroadcastStatus(1);
        this.getActiveChar().updateEffectIcons(true);
        return true;
    }

    public boolean addExpAndSp(long addToExp, int addToSp) {
        if (this.getActiveChar().isUncontrollable() || !this.addExp(addToExp)) {
            return false;
        }
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.PET_EARNED_S1_EXP);
        sm.addLong(addToExp);
        this.getActiveChar().updateAndBroadcastStatus(1);
        this.getActiveChar().sendPacket(sm);
        return true;
    }

    @Override
    public final boolean addLevel(byte value) {
        if (this.getLevel() + value > this.getMaxLevel() - 1) {
            return false;
        }
        boolean levelIncreased = super.addLevel(value);
        if (levelIncreased) {
            this.getActiveChar().broadcastPacket(new SocialAction(this.getActiveChar(), 15));
        }
        StatusUpdate su = new StatusUpdate(this.getActiveChar());
        su.addAttribute(1, this.getLevel());
        su.addAttribute(10, this.getMaxHp());
        su.addAttribute(12, this.getMaxMp());
        this.getActiveChar().broadcastPacket(su);
        if (levelIncreased) {
            this.getActiveChar().broadcastPacket(new SocialAction(this.getActiveChar().getObjectId(), 2122));
        }
        this.getActiveChar().updateAndBroadcastStatus(1);
        if (this.getActiveChar().getControlItem() != null) {
            this.getActiveChar().getControlItem().setEnchantLevel(this.getLevel());
        }
        return levelIncreased;
    }

    @Override
    public final long getExpForLevel(int level) {
        try {
            return PetDataTable.getInstance().getPetLevelData(this.getActiveChar().getId(), level).getPetMaxExp();
        }
        catch (NullPointerException e) {
            if (this.getActiveChar() != null) {
                _log.warning("Pet objectId:" + this.getActiveChar().getObjectId() + ", NpcId:" + this.getActiveChar().getId() + ", level:" + level + " is missing data from pets_stats table!");
            }
            throw e;
        }
    }

    @Override
    public L2PetInstance getActiveChar() {
        return (L2PetInstance)this._activeChar;
    }

    public final int getFeedBattle() {
        return this.getActiveChar().getPetLevelData().getPetFeedBattle();
    }

    public final int getFeedNormal() {
        return this.getActiveChar().getPetLevelData().getPetFeedNormal();
    }

    @Override
    public void setLevel(byte value) {
        this.getActiveChar().setPetData(PetDataTable.getInstance().getPetLevelData(this.getActiveChar().getTemplate().getId(), value));
        if (this.getActiveChar().getPetLevelData() == null) {
            throw new IllegalArgumentException("No pet data for npc: " + this.getActiveChar().getTemplate().getId() + " level: " + value);
        }
        this.getActiveChar().stopFeed();
        super.setLevel(value);
        this.getActiveChar().startFeed();
        if (this.getActiveChar().getControlItem() != null) {
            this.getActiveChar().getControlItem().setEnchantLevel(this.getLevel());
        }
    }

    public final int getMaxFeed() {
        return this.getActiveChar().getPetLevelData().getPetMaxFeed();
    }

    @Override
    public int getMaxHp() {
        return (int)this.calcStat(Stats.MAX_HP, this.getActiveChar().getPetLevelData().getPetMaxHP(), null, null);
    }

    @Override
    public int getMaxMp() {
        return (int)this.calcStat(Stats.MAX_MP, this.getActiveChar().getPetLevelData().getPetMaxMP(), null, null);
    }

    @Override
    public int getMAtk(L2Character target, Skill skill) {
        return (int)this.calcStat(Stats.MAGIC_ATTACK, this.getActiveChar().getPetLevelData().getPetMAtk(), target, skill);
    }

    @Override
    public int getMDef(L2Character target, Skill skill) {
        return (int)this.calcStat(Stats.MAGIC_DEFENCE, this.getActiveChar().getPetLevelData().getPetMDef(), target, skill);
    }

    @Override
    public int getPAtk(L2Character target) {
        return (int)this.calcStat(Stats.POWER_ATTACK, this.getActiveChar().getPetLevelData().getPetPAtk(), target, null);
    }

    @Override
    public int getPDef(L2Character target) {
        return (int)this.calcStat(Stats.POWER_DEFENCE, this.getActiveChar().getPetLevelData().getPetPDef(), target, null);
    }

    @Override
    public int getPAtkSpd() {
        int val = super.getPAtkSpd();
        if (this.getActiveChar().isHungry()) {
            val /= 2;
        }
        return val;
    }

    @Override
    public int getMAtkSpd() {
        int val = super.getMAtkSpd();
        if (this.getActiveChar().isHungry()) {
            val /= 2;
        }
        return val;
    }

    @Override
    public int getMaxLevel() {
        return ExperienceTable.getInstance().getMaxPetLevel();
    }
}

