/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.transform;

import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.transform.TransformLevelData;
import com.l2jserver.gameserver.model.actor.transform.TransformTemplate;
import com.l2jserver.gameserver.model.actor.transform.TransformType;
import com.l2jserver.gameserver.model.holders.AdditionalItemHolder;
import com.l2jserver.gameserver.model.holders.AdditionalSkillHolder;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.network.serverpackets.ExBasicActionList;
import java.util.ArrayList;

public final class Transform
implements IIdentifiable {
    private final int _id;
    private final int _displayId;
    private final TransformType _type;
    private final boolean _canSwim;
    private final int _spawnHeight;
    private final boolean _canAttack;
    private final String _name;
    private final String _title;
    private TransformTemplate _maleTemplate;
    private TransformTemplate _femaleTemplate;

    public Transform(StatsSet set) {
        this._id = set.getInt("id");
        this._displayId = set.getInt("displayId", this._id);
        this._type = set.getEnum("type", TransformType.class, TransformType.COMBAT);
        this._canSwim = set.getInt("can_swim", 0) == 1;
        this._canAttack = set.getInt("normal_attackable", 1) == 1;
        this._spawnHeight = set.getInt("spawn_height", 0);
        this._name = set.getString("setName", null);
        this._title = set.getString("setTitle", null);
    }

    @Override
    public int getId() {
        return this._id;
    }

    public int getDisplayId() {
        return this._displayId;
    }

    public TransformType getType() {
        return this._type;
    }

    public boolean canSwim() {
        return this._canSwim;
    }

    public boolean canAttack() {
        return this._canAttack;
    }

    public int getSpawnHeight() {
        return this._spawnHeight;
    }

    public String getName() {
        return this._name;
    }

    public String getTitle() {
        return this._title;
    }

    public TransformTemplate getTemplate(L2PcInstance player) {
        return player != null ? (player.getAppearance().getSex() ? this._femaleTemplate : this._maleTemplate) : null;
    }

    public void setTemplate(int sex, TransformTemplate template) {
        if (sex == 1) {
            this._maleTemplate = template;
        } else if (sex == 2) {
            this._femaleTemplate = template;
        } else {
            this._maleTemplate = this._femaleTemplate = template;
        }
    }

    public boolean isStance() {
        return this._type == TransformType.MODE_CHANGE;
    }

    public boolean isCombat() {
        return this._type == TransformType.COMBAT;
    }

    public boolean isNonCombat() {
        return this._type == TransformType.NON_COMBAT;
    }

    public boolean isFlying() {
        return this._type == TransformType.FLYING;
    }

    public boolean isCursed() {
        return this._type == TransformType.CURSED;
    }

    public boolean isRiding() {
        return this._type == TransformType.RIDING_MODE;
    }

    public boolean isPureStats() {
        return this._type == TransformType.PURE_STAT;
    }

    public double getCollisionHeight(L2PcInstance player) {
        TransformTemplate template = this.getTemplate(player);
        return template != null ? template.getCollisionHeight() : player.getCollisionHeight();
    }

    public double getCollisionRadius(L2PcInstance player) {
        TransformTemplate template = this.getTemplate(player);
        return template != null ? template.getCollisionRadius() : player.getCollisionRadius();
    }

    public int getBaseAttackRange(L2PcInstance player) {
        TransformTemplate template = this.getTemplate(player);
        return template != null ? template.getBaseAttackRange() : player.getTemplate().getBaseAttackRange();
    }

    public void onTransform(L2PcInstance player) {
        TransformTemplate template = this.getTemplate(player);
        if (template != null) {
            if (this.isFlying()) {
                player.setIsFlying(true);
            }
            if (this.getName() != null) {
                player.getAppearance().setVisibleName(this.getName());
            }
            if (this.getTitle() != null) {
                player.getAppearance().setVisibleTitle(this.getTitle());
            }
            for (SkillHolder skillHolder : template.getSkills()) {
                if (player.getSkillLevel(skillHolder.getSkillId()) < skillHolder.getSkillLvl()) {
                    player.addSkill(skillHolder.getSkill(), false);
                }
                player.addTransformSkill(skillHolder.getSkillId());
            }
            for (AdditionalSkillHolder additionalSkillHolder : template.getAdditionalSkills()) {
                if (player.getLevel() < additionalSkillHolder.getMinLevel()) continue;
                if (player.getSkillLevel(additionalSkillHolder.getSkillId()) < additionalSkillHolder.getSkillLvl()) {
                    player.addSkill(additionalSkillHolder.getSkill(), false);
                }
                player.addTransformSkill(additionalSkillHolder.getSkillId());
            }
            for (L2SkillLearn l2SkillLearn : SkillTreesData.getInstance().getCollectSkillTree().values()) {
                if (player.getKnownSkill(l2SkillLearn.getSkillId()) == null) continue;
                player.addTransformSkill(l2SkillLearn.getSkillId());
            }
            if (!template.getAdditionalItems().isEmpty()) {
                int[] items;
                ArrayList<Integer> allowed = new ArrayList<Integer>();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (AdditionalItemHolder holder : template.getAdditionalItems()) {
                    if (holder.isAllowedToUse()) {
                        allowed.add(holder.getId());
                        continue;
                    }
                    arrayList.add(holder.getId());
                }
                if (!allowed.isEmpty()) {
                    items = new int[allowed.size()];
                    for (int i = 0; i < items.length; ++i) {
                        items[i] = (Integer)allowed.get(i);
                    }
                    player.getInventory().setInventoryBlock(items, 1);
                }
                if (!arrayList.isEmpty()) {
                    items = new int[arrayList.size()];
                    for (int i = 0; i < items.length; ++i) {
                        items[i] = (Integer)arrayList.get(i);
                    }
                    player.getInventory().setInventoryBlock(items, 2);
                }
            }
            if (template.hasBasicActionList()) {
                player.sendPacket(template.getBasicActionList());
            }
        }
    }

    public void onUntransform(L2PcInstance player) {
        TransformTemplate template = this.getTemplate(player);
        if (template != null) {
            Skill skill;
            if (this.isFlying()) {
                player.setIsFlying(false);
            }
            if (this.getName() != null) {
                player.getAppearance().setVisibleName(null);
            }
            if (this.getTitle() != null) {
                player.getAppearance().setVisibleTitle(null);
            }
            if (!template.getSkills().isEmpty()) {
                for (SkillHolder skillHolder : template.getSkills()) {
                    skill = skillHolder.getSkill();
                    if (SkillTreesData.getInstance().isSkillAllowed(player, skill)) continue;
                    player.removeSkill(skill, false, skill.isPassive());
                }
            }
            if (!template.getAdditionalSkills().isEmpty()) {
                for (AdditionalSkillHolder additionalSkillHolder : template.getAdditionalSkills()) {
                    skill = additionalSkillHolder.getSkill();
                    if (player.getLevel() < additionalSkillHolder.getMinLevel() || SkillTreesData.getInstance().isSkillAllowed(player, skill)) continue;
                    player.removeSkill(skill, false, skill.isPassive());
                }
            }
            player.removeAllTransformSkills();
            if (!template.getAdditionalItems().isEmpty()) {
                player.getInventory().unblock();
            }
            player.sendPacket(ExBasicActionList.STATIC_PACKET);
        }
    }

    public void onLevelUp(L2PcInstance player) {
        TransformTemplate template = this.getTemplate(player);
        if (template != null && !template.getAdditionalSkills().isEmpty()) {
            for (AdditionalSkillHolder holder : template.getAdditionalSkills()) {
                if (player.getLevel() < holder.getMinLevel() || player.getSkillLevel(holder.getSkillId()) >= holder.getSkillLvl()) continue;
                player.addSkill(holder.getSkill(), false);
                player.addTransformSkill(holder.getSkillId());
            }
        }
    }

    public double getStat(L2PcInstance player, Stats stats) {
        double val = 0.0;
        TransformTemplate template = this.getTemplate(player);
        if (template != null) {
            val = template.getStats(stats);
            TransformLevelData data = template.getData(player.getLevel());
            if (data != null) {
                val = data.getStats(stats);
            }
        }
        return val;
    }

    public int getBaseDefBySlot(L2PcInstance player, int slot) {
        TransformTemplate template = this.getTemplate(player);
        if (template != null) {
            return template.getDefense(slot);
        }
        return player.getTemplate().getBaseDefBySlot(slot);
    }

    public double getLevelMod(L2PcInstance player) {
        TransformLevelData data;
        double val = -1.0;
        TransformTemplate template = this.getTemplate(player);
        if (template != null && (data = template.getData(player.getLevel())) != null) {
            val = data.getLevelMod();
        }
        return val;
    }
}

