/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.stats.Env;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public class ConditionPlayerCanResurrect
extends Condition {
    private final boolean _val;

    public ConditionPlayerCanResurrect(boolean val) {
        this._val = val;
    }

    @Override
    public boolean testImpl(Env env) {
        if (env.getSkill().getAffectRange() > 0) {
            return true;
        }
        boolean canResurrect = true;
        L2Character caster = env.getCharacter();
        L2Character target = env.getTarget();
        if (target.isPlayer()) {
            L2PcInstance player = target.getActingPlayer();
            if (!player.isDead()) {
                canResurrect = false;
                if (caster.isPlayer()) {
                    SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
                    msg.addSkillName(env.getSkill());
                    caster.sendPacket(msg);
                }
            } else if (player.isResurrectionBlocked()) {
                canResurrect = false;
                if (caster.isPlayer()) {
                    caster.sendPacket(SystemMessageId.REJECT_RESURRECTION);
                }
            } else if (player.isReviveRequested()) {
                canResurrect = false;
                if (caster.isPlayer()) {
                    caster.sendPacket(SystemMessageId.RES_HAS_ALREADY_BEEN_PROPOSED);
                }
            }
        } else if (target.isSummon()) {
            L2Summon summon = (L2Summon)target;
            L2PcInstance player = summon.getOwner();
            if (!summon.isDead()) {
                canResurrect = false;
                if (caster.isPlayer()) {
                    SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
                    msg.addSkillName(env.getSkill());
                    caster.sendPacket(msg);
                }
            } else if (summon.isResurrectionBlocked()) {
                canResurrect = false;
                if (caster.isPlayer()) {
                    caster.sendPacket(SystemMessageId.REJECT_RESURRECTION);
                }
            } else if (player != null && player.isRevivingPet()) {
                canResurrect = false;
                if (caster.isPlayer()) {
                    caster.sendPacket(SystemMessageId.RES_HAS_ALREADY_BEEN_PROPOSED);
                }
            }
        }
        return this._val == canResurrect;
    }
}

