/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.stats.Env;
import com.l2jserver.gameserver.network.SystemMessageId;

public class ConditionPlayerCanSummonSiegeGolem
extends Condition {
    private final boolean _val;

    public ConditionPlayerCanSummonSiegeGolem(boolean val) {
        this._val = val;
    }

    @Override
    public boolean testImpl(Env env) {
        boolean canSummonSiegeGolem = true;
        if (env.getPlayer() == null || env.getPlayer().isAlikeDead() || env.getPlayer().isCursedWeaponEquipped() || env.getPlayer().getClan() == null) {
            canSummonSiegeGolem = false;
        }
        Castle castle = CastleManager.getInstance().getCastle(env.getPlayer());
        Fort fort = FortManager.getInstance().getFort(env.getPlayer());
        if (castle == null && fort == null) {
            canSummonSiegeGolem = false;
        }
        L2PcInstance player = env.getPlayer().getActingPlayer();
        if (fort != null && fort.getResidenceId() == 0 || castle != null && castle.getResidenceId() == 0) {
            player.sendPacket(SystemMessageId.INCORRECT_TARGET);
            canSummonSiegeGolem = false;
        } else if (castle != null && !castle.getSiege().isInProgress() || fort != null && !fort.getSiege().isInProgress()) {
            player.sendPacket(SystemMessageId.INCORRECT_TARGET);
            canSummonSiegeGolem = false;
        } else if (player.getClanId() != 0 && (castle != null && castle.getSiege().getAttackerClan(player.getClanId()) == null || fort != null && fort.getSiege().getAttackerClan(player.getClanId()) == null)) {
            player.sendPacket(SystemMessageId.INCORRECT_TARGET);
            canSummonSiegeGolem = false;
        } else if (SevenSigns.getInstance().checkSummonConditions(env.getPlayer())) {
            canSummonSiegeGolem = false;
        }
        return this._val == canSummonSiegeGolem;
    }
}

