/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.stats.Env;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;

public class ConditionPlayerCanTakeCastle
extends Condition {
    private final boolean _val;

    public ConditionPlayerCanTakeCastle(boolean val) {
        this._val = val;
    }

    @Override
    public boolean testImpl(Env env) {
        boolean canTakeCastle = true;
        if (env.getPlayer() == null || env.getPlayer().isAlikeDead() || env.getPlayer().isCursedWeaponEquipped()) {
            canTakeCastle = false;
        } else if (env.getPlayer().getClan() == null || env.getPlayer().getClan().getLeaderId() != env.getPlayer().getObjectId()) {
            canTakeCastle = false;
        }
        Castle castle = CastleManager.getInstance().getCastle(env.getPlayer());
        if (castle == null || castle.getResidenceId() <= 0 || !castle.getSiege().isInProgress() || castle.getSiege().getAttackerClan(env.getPlayer().getClan()) == null) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addSkillName(env.getSkill());
            env.getPlayer().sendPacket(sm);
            canTakeCastle = false;
        } else if (!castle.getArtefacts().contains(env.getTarget())) {
            env.getPlayer().sendPacket(SystemMessageId.INCORRECT_TARGET);
            canTakeCastle = false;
        } else if (!Util.checkIfInRange(env.getSkill().getCastRange(), env.getPlayer(), env.getTarget(), true)) {
            env.getPlayer().sendPacket(SystemMessageId.DIST_TOO_FAR_CASTING_STOPPED);
            canTakeCastle = false;
        }
        return this._val == canTakeCastle;
    }
}

