/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.base.PlayerState;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.stats.Env;

public class ConditionPlayerState
extends Condition {
    private final PlayerState _check;
    private final boolean _required;

    public ConditionPlayerState(PlayerState check, boolean required) {
        this._check = check;
        this._required = required;
    }

    @Override
    public boolean testImpl(Env env) {
        L2Character character = env.getCharacter();
        L2PcInstance player = env.getPlayer();
        switch (this._check) {
            case RESTING: {
                if (player != null) {
                    return player.isSitting() == this._required;
                }
                return !this._required;
            }
            case MOVING: {
                return character.isMoving() == this._required;
            }
            case RUNNING: {
                return character.isRunning() == this._required;
            }
            case STANDING: {
                if (player != null) {
                    return this._required != (player.isSitting() || player.isMoving());
                }
                return this._required != character.isMoving();
            }
            case FLYING: {
                return character.isFlying() == this._required;
            }
            case BEHIND: {
                return character.isBehindTarget() == this._required;
            }
            case FRONT: {
                return character.isInFrontOfTarget() == this._required;
            }
            case CHAOTIC: {
                if (player != null) {
                    return player.getKarma() > 0 == this._required;
                }
                return !this._required;
            }
            case OLYMPIAD: {
                if (player != null) {
                    return player.isInOlympiadMode() == this._required;
                }
                return !this._required;
            }
        }
        return !this._required;
    }
}

