/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.drops;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.drops.GeneralDropItem;

public class CorpseDropItem
extends GeneralDropItem {
    public CorpseDropItem(int itemId, long min, long max, double chance) {
        super(itemId, min, max, chance);
    }

    @Override
    public long getMin(L2Character victim, L2Character killer) {
        long min = super.getMin(victim, killer);
        if (Config.RATE_DROP_AMOUNT_MULTIPLIER.containsKey(this.getItemId())) {
            return min;
        }
        return (long)((float)min * Config.RATE_CORPSE_DROP_AMOUNT_MULTIPLIER);
    }

    @Override
    public long getMax(L2Character victim, L2Character killer) {
        long max = super.getMax(victim, killer);
        if (Config.RATE_DROP_AMOUNT_MULTIPLIER.containsKey(this.getItemId())) {
            return max;
        }
        return (long)((float)max * Config.RATE_CORPSE_DROP_AMOUNT_MULTIPLIER);
    }

    @Override
    public double getChance(L2Character victim, L2Character killer) {
        double chance = super.getChance(victim, killer);
        if (Config.RATE_DROP_CHANCE_MULTIPLIER.containsKey(this.getItemId())) {
            return chance;
        }
        return chance * (double)Config.RATE_CORPSE_DROP_CHANCE_MULTIPLIER;
    }
}

