/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.drops;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.drops.GeneralDropItem;
import com.l2jserver.gameserver.model.items.L2Item;

public class DeathDropItem
extends GeneralDropItem {
    public DeathDropItem(int itemId, long min, long max, double chance) {
        super(itemId, min, max, chance);
    }

    @Override
    public long getMin(L2Character victim, L2Character killer) {
        long min = super.getMin(victim, killer);
        if (Config.RATE_DROP_AMOUNT_MULTIPLIER.containsKey(this.getItemId())) {
            return min;
        }
        L2Item item = ItemTable.getInstance().getTemplate(this.getItemId());
        if (item != null && item.hasExImmediateEffect()) {
            return (long)((float)min * Config.RATE_HERB_DROP_AMOUNT_MULTIPLIER);
        }
        return (long)((float)min * Config.RATE_DEATH_DROP_AMOUNT_MULTIPLIER);
    }

    @Override
    public long getMax(L2Character victim, L2Character killer) {
        long max = super.getMax(victim, killer);
        if (Config.RATE_DROP_AMOUNT_MULTIPLIER.containsKey(this.getItemId())) {
            return max;
        }
        L2Item item = ItemTable.getInstance().getTemplate(this.getItemId());
        if (item != null && item.hasExImmediateEffect()) {
            return (long)((float)max * Config.RATE_HERB_DROP_AMOUNT_MULTIPLIER);
        }
        return (long)((float)max * Config.RATE_DEATH_DROP_AMOUNT_MULTIPLIER);
    }

    @Override
    public double getChance(L2Character victim, L2Character killer) {
        double chance = super.getChance(victim, killer);
        if (Config.RATE_DROP_CHANCE_MULTIPLIER.containsKey(this.getItemId())) {
            return chance;
        }
        L2Item item = ItemTable.getInstance().getTemplate(this.getItemId());
        if (item != null && item.hasExImmediateEffect()) {
            return chance * (double)Config.RATE_HERB_DROP_CHANCE_MULTIPLIER;
        }
        return chance * (double)Config.RATE_DEATH_DROP_CHANCE_MULTIPLIER;
    }
}

