/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.enums.MountType;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.CastleManorManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.TowerSpawn;
import com.l2jserver.gameserver.model.actor.instance.L2ArtefactInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.AbstractResidence;
import com.l2jserver.gameserver.model.entity.Siege;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.zone.type.L2CastleZone;
import com.l2jserver.gameserver.model.zone.type.L2ResidenceTeleportZone;
import com.l2jserver.gameserver.model.zone.type.L2SiegeZone;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowInfoUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.l2j.troja.FastIntObjectMap;

public final class Castle
extends AbstractResidence {
    protected static final Logger _log = Logger.getLogger(Castle.class.getName());
    private final List<L2DoorInstance> _doors = new ArrayList<L2DoorInstance>();
    private String _castleName;
    private String _locName;
    private int _ownerId = 0;
    private Siege _siege = null;
    private Calendar _siegeDate;
    private boolean _isTimeRegistrationOver = true;
    private Calendar _siegeTimeRegistrationEndDate;
    private int _taxPercent = 0;
    private double _taxRate = 0.0;
    private long _treasury = 0L;
    private boolean _showNpcCrest = false;
    private L2SiegeZone _zone = null;
    private L2ResidenceTeleportZone _teleZone;
    private L2Clan _formerOwner = null;
    private final List<L2ArtefactInstance> _artefacts = new ArrayList<L2ArtefactInstance>(1);
    private final FastIntObjectMap<CastleFunction> _function;
    private int _ticketBuyCount = 0;
    public static final int FUNC_TELEPORT = 1;
    public static final int FUNC_RESTORE_HP = 2;
    public static final int FUNC_RESTORE_MP = 3;
    public static final int FUNC_RESTORE_EXP = 4;
    public static final int FUNC_SUPPORT = 5;

    public Castle(int castleId) {
        super(castleId);
        this.load();
        this._function = new FastIntObjectMap();
        this.initResidenceZone();
        if (this.getOwnerId() != 0) {
            this.loadFunctions();
            this.loadDoorUpgrade();
        }
    }

    public CastleFunction getFunction(int type) {
        return (CastleFunction)this._function.get(type);
    }

    public synchronized void engrave(L2Clan clan, L2Object target) {
        if (!this._artefacts.contains(target)) {
            return;
        }
        this.setOwner(clan);
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.CLAN_S1_ENGRAVED_RULER);
        msg.addString(clan.getName());
        this.getSiege().announceToPlayer(msg, true);
    }

    public void addToTreasury(long amount) {
        Castle aden;
        Castle rune;
        if (this.getOwnerId() <= 0) {
            return;
        }
        if ((this.getName().equalsIgnoreCase("Schuttgart") || this.getName().equalsIgnoreCase("Goddard")) && (rune = CastleManager.getInstance().getCastle("rune")) != null) {
            long runeTax = (long)((double)amount * rune.getTaxRate());
            if (rune.getOwnerId() > 0) {
                rune.addToTreasury(runeTax);
            }
            amount -= runeTax;
        }
        if (!(this.getName().equalsIgnoreCase("aden") || this.getName().equalsIgnoreCase("Rune") || this.getName().equalsIgnoreCase("Schuttgart") || this.getName().equalsIgnoreCase("Goddard") || (aden = CastleManager.getInstance().getCastle("aden")) == null)) {
            long adenTax = (long)((double)amount * aden.getTaxRate());
            if (aden.getOwnerId() > 0) {
                aden.addToTreasury(adenTax);
            }
            amount -= adenTax;
        }
        this.addToTreasuryNoTax(amount);
    }

    public boolean addToTreasuryNoTax(long amount) {
        if (this.getOwnerId() <= 0) {
            return false;
        }
        if (this._treasury + amount < 0L) {
            return false;
        }
        this._treasury = this._treasury + amount > Inventory.MAX_ADENA ? Inventory.MAX_ADENA : (this._treasury += amount);
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("UPDATE castle SET treasury = ? WHERE id = ?");){
            ps.setLong(1, this.getTreasury());
            ps.setInt(2, this.getResidenceId());
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
        return true;
    }

    public void banishForeigners() {
        this.getResidenceZone().banishForeigners(this.getOwnerId());
    }

    public boolean checkIfInZone(int x, int y, int z) {
        return this.getZone().isInsideZone(x, y, z);
    }

    public L2SiegeZone getZone() {
        if (this._zone == null) {
            for (L2SiegeZone zone : ZoneManager.getInstance().getAllZones(L2SiegeZone.class)) {
                if (zone.getSiegeObjectId() != this.getResidenceId()) continue;
                this._zone = zone;
                break;
            }
        }
        return this._zone;
    }

    @Override
    public L2CastleZone getResidenceZone() {
        return (L2CastleZone)super.getResidenceZone();
    }

    public L2ResidenceTeleportZone getTeleZone() {
        if (this._teleZone == null) {
            for (L2ResidenceTeleportZone zone : ZoneManager.getInstance().getAllZones(L2ResidenceTeleportZone.class)) {
                if (zone.getResidenceId() != this.getResidenceId()) continue;
                this._teleZone = zone;
                break;
            }
        }
        return this._teleZone;
    }

    public void oustAllPlayers() {
        this.getTeleZone().oustAllPlayers();
    }

    public double getDistance(L2Object obj) {
        return this.getZone().getDistanceToZone(obj);
    }

    public void closeDoor(L2PcInstance activeChar, int doorId) {
        this.openCloseDoor(activeChar, doorId, false);
    }

    public void openDoor(L2PcInstance activeChar, int doorId) {
        this.openCloseDoor(activeChar, doorId, true);
    }

    public void openCloseDoor(L2PcInstance activeChar, int doorId, boolean open) {
        if (activeChar.getClanId() != this.getOwnerId()) {
            return;
        }
        L2DoorInstance door = this.getDoor(doorId);
        if (door != null) {
            if (open) {
                door.openMe();
            } else {
                door.closeMe();
            }
        }
    }

    public void removeUpgrade() {
        this.removeDoorUpgrade();
        this.removeTrapUpgrade();
        for (int fc : this._function.keys()) {
            this.removeFunction(fc);
        }
        this._function.clear();
    }

    public void setOwner(L2Clan clan) {
        L2Clan oldOwner;
        if (this.getOwnerId() > 0 && (clan == null || clan.getId() != this.getOwnerId()) && (oldOwner = ClanTable.getInstance().getClan(this.getOwnerId())) != null) {
            if (this._formerOwner == null) {
                this._formerOwner = oldOwner;
                if (Config.REMOVE_CASTLE_CIRCLETS) {
                    CastleManager.getInstance().removeCirclet(this._formerOwner, this.getResidenceId());
                }
            }
            try {
                L2PcInstance oldleader = oldOwner.getLeader().getPlayerInstance();
                if (oldleader != null && oldleader.getMountType() == MountType.WYVERN) {
                    oldleader.dismount();
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception in setOwner: " + e.getMessage(), e);
            }
            oldOwner.setCastleId(0);
            for (L2PcInstance member : oldOwner.getOnlineMembers(0)) {
                this.removeResidentialSkills(member);
                member.sendSkillList();
            }
        }
        this.updateOwnerInDB(clan);
        this.setShowNpcCrest(false);
        if (clan != null && clan.getFortId() > 0) {
            FortManager.getInstance().getFortByOwner(clan).removeOwner(true);
        }
        if (this.getSiege().isInProgress()) {
            this.getSiege().midVictory();
        }
        TerritoryWarManager.getInstance().getTerritory(this.getResidenceId()).setOwnerClan(clan);
        if (clan != null) {
            for (L2PcInstance member : clan.getOnlineMembers(0)) {
                this.giveResidentialSkills(member);
                member.sendSkillList();
            }
        }
    }

    public void removeOwner(L2Clan clan) {
        if (clan != null) {
            this._formerOwner = clan;
            if (Config.REMOVE_CASTLE_CIRCLETS) {
                CastleManager.getInstance().removeCirclet(this._formerOwner, this.getResidenceId());
            }
            for (L2PcInstance member : clan.getOnlineMembers(0)) {
                this.removeResidentialSkills(member);
                member.sendSkillList();
            }
            clan.setCastleId(0);
            clan.broadcastToOnlineMembers(new PledgeShowInfoUpdate(clan));
        }
        this.updateOwnerInDB(null);
        if (this.getSiege().isInProgress()) {
            this.getSiege().midVictory();
        }
        for (Object fc : (Object)this._function.keys()) {
            this.removeFunction((int)fc);
        }
        this._function.clear();
    }

    public void setTaxPercent(int taxPercent) {
        this._taxPercent = taxPercent;
        this._taxRate = (double)this._taxPercent / 100.0;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("UPDATE castle SET taxPercent = ? WHERE id = ?");){
            ps.setInt(1, taxPercent);
            ps.setInt(2, this.getResidenceId());
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public void spawnDoor() {
        this.spawnDoor(false);
    }

    public void spawnDoor(boolean isDoorWeak) {
        for (L2DoorInstance door : this._doors) {
            if (door.isDead()) {
                door.doRevive();
                door.setCurrentHp(isDoorWeak ? (double)(door.getMaxHp() / 2) : (double)door.getMaxHp());
            }
            if (!door.getOpen()) continue;
            door.closeMe();
        }
    }

    @Override
    protected void load() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps1 = con.prepareStatement("SELECT castle.*,castlename_ja.name AS castleName,castlename_ja.locName FROM castle LEFT JOIN castlename_ja ON castle.id=castlename_ja.id WHERE castle.id = ?");
             PreparedStatement ps2 = con.prepareStatement("SELECT clan_id FROM clan_data WHERE hasCastle = ?");){
            ps1.setInt(1, this.getResidenceId());
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    this.setName(rs.getString("name"));
                    this._castleName = rs.getString("castleName");
                    this._locName = rs.getString("locName").intern();
                    this._siegeDate = Calendar.getInstance();
                    this._siegeDate.setTimeInMillis(rs.getLong("siegeDate"));
                    this._siegeTimeRegistrationEndDate = Calendar.getInstance();
                    this._siegeTimeRegistrationEndDate.setTimeInMillis(rs.getLong("regTimeEnd"));
                    this._isTimeRegistrationOver = rs.getBoolean("regTimeOver");
                    this._taxPercent = rs.getInt("taxPercent");
                    this._treasury = rs.getLong("treasury");
                    this._showNpcCrest = rs.getBoolean("showNpcCrest");
                    this._ticketBuyCount = rs.getInt("ticketBuyCount");
                }
            }
            this._taxRate = (double)this._taxPercent / 100.0;
            ps2.setInt(1, this.getResidenceId());
            rs = ps2.executeQuery();
            var8_15 = null;
            try {
                while (rs.next()) {
                    this._ownerId = rs.getInt("clan_id");
                }
            }
            catch (Throwable throwable) {
                var8_15 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var8_15 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var8_15.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: loadCastleData(): " + e.getMessage(), e);
        }
    }

    private void loadFunctions() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM castle_functions WHERE castle_id = ?");){
            ps.setInt(1, this.getResidenceId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    this._function.put(rs.getInt("type"), (Object)new CastleFunction(rs.getInt("type"), rs.getInt("lvl"), rs.getInt("lease"), 0, rs.getLong("rate"), rs.getLong("endTime"), true));
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Exception: Castle.loadFunctions(): " + e.getMessage(), e);
        }
    }

    public void removeFunction(int functionType) {
        this._function.remove(functionType);
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("DELETE FROM castle_functions WHERE castle_id=? AND type=?");){
            ps.setInt(1, this.getResidenceId());
            ps.setInt(2, functionType);
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Exception: Castle.removeFunctions(int functionType): " + e.getMessage(), e);
        }
    }

    public boolean updateFunctions(L2PcInstance player, int type, int lvl, int lease, long rate, boolean addNew) {
        if (player == null) {
            return false;
        }
        if (lease > 0 && !player.destroyItemByItemId("Consume", 57, lease, null, true)) {
            return false;
        }
        if (addNew) {
            this._function.put(type, (Object)new CastleFunction(type, lvl, lease, 0, rate, 0L, false));
        } else if (lvl == 0 && lease == 0) {
            this.removeFunction(type);
        } else {
            int diffLease = lease - ((CastleFunction)this._function.get(type)).getLease();
            if (diffLease > 0) {
                this._function.remove(type);
                this._function.put(type, (Object)new CastleFunction(type, lvl, lease, 0, rate, -1L, false));
            } else {
                ((CastleFunction)this._function.get(type)).setLease(lease);
                ((CastleFunction)this._function.get(type)).setLvl(lvl);
                ((CastleFunction)this._function.get(type)).dbSave();
            }
        }
        return true;
    }

    public void activateInstance() {
        this.loadDoor();
    }

    private void loadDoor() {
        for (L2DoorInstance door : DoorTable.getInstance().getDoors()) {
            if (door.getCastle() == null || door.getCastle().getResidenceId() != this.getResidenceId()) continue;
            this._doors.add(door);
        }
    }

    private void loadDoorUpgrade() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM castle_doorupgrade WHERE castleId=?");){
            ps.setInt(1, this.getResidenceId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    this.setDoorUpgrade(rs.getInt("doorId"), rs.getInt("ratio"), false);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: loadCastleDoorUpgrade(): " + e.getMessage(), e);
        }
    }

    private void removeDoorUpgrade() {
        for (L2DoorInstance door : this._doors) {
            door.getStat().setUpgradeHpRatio(1);
            door.setCurrentHp(door.getCurrentHp());
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("DELETE FROM castle_doorupgrade WHERE castleId=?");){
            ps.setInt(1, this.getResidenceId());
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: removeDoorUpgrade(): " + e.getMessage(), e);
        }
    }

    public void setDoorUpgrade(int doorId, int ratio, boolean save) {
        L2DoorInstance door;
        L2DoorInstance l2DoorInstance = door = this.getDoors().isEmpty() ? DoorTable.getInstance().getDoor(doorId) : this.getDoor(doorId);
        if (door == null) {
            return;
        }
        door.getStat().setUpgradeHpRatio(ratio);
        door.setCurrentHp(door.getMaxHp());
        if (save) {
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement ps = con.prepareStatement("REPLACE INTO castle_doorupgrade (doorId, ratio, castleId) values (?,?,?)");){
                ps.setInt(1, doorId);
                ps.setInt(2, ratio);
                ps.setInt(3, this.getResidenceId());
                ps.execute();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception: setDoorUpgrade(int doorId, int ratio, int castleId): " + e.getMessage(), e);
            }
        }
    }

    private void updateOwnerInDB(L2Clan clan) {
        if (clan != null) {
            this._ownerId = clan.getId();
        } else {
            this._ownerId = 0;
            CastleManorManager.getInstance().resetManorData(this.getResidenceId());
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            try (PreparedStatement ps = con.prepareStatement("UPDATE clan_data SET hasCastle = 0 WHERE hasCastle = ?");){
                ps.setInt(1, this.getResidenceId());
                ps.execute();
            }
            ps = con.prepareStatement("UPDATE clan_data SET hasCastle = ? WHERE clan_id = ?");
            var5_8 = null;
            try {
                ps.setInt(1, this.getResidenceId());
                ps.setInt(2, this.getOwnerId());
                ps.execute();
            }
            catch (Throwable throwable) {
                var5_8 = throwable;
                throw throwable;
            }
            finally {
                if (ps != null) {
                    if (var5_8 != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable) {
                            var5_8.addSuppressed(throwable);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
            if (clan != null) {
                clan.setCastleId(this.getResidenceId());
                clan.broadcastToOnlineMembers(new PledgeShowInfoUpdate(clan));
                clan.broadcastToOnlineMembers(new PlaySound(1, "Siege_Victory", 0, 0, 0, 0, 0));
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: updateOwnerInDB(L2Clan clan): " + e.getMessage(), e);
        }
    }

    public final int getCastleId() {
        return this.getResidenceId();
    }

    public final L2DoorInstance getDoor(int doorId) {
        if (doorId <= 0) {
            return null;
        }
        for (L2DoorInstance door : this.getDoors()) {
            if (door.getId() != doorId) continue;
            return door;
        }
        return null;
    }

    public final List<L2DoorInstance> getDoors() {
        return this._doors;
    }

    public final String getCastleName() {
        return this._castleName;
    }

    public final String getLocName() {
        return this._locName;
    }

    public final String getCastleNameHtm() {
        return this.getNameHtm();
    }

    public final String getLocNameHtm() {
        return "&^" + this.getResidenceId() + ";";
    }

    public final int getOwnerId() {
        return this._ownerId;
    }

    public final L2Clan getOwner() {
        return this._ownerId != 0 ? ClanTable.getInstance().getClan(this._ownerId) : null;
    }

    public final Siege getSiege() {
        if (this._siege == null) {
            this._siege = new Siege(this);
        }
        return this._siege;
    }

    public final Calendar getSiegeDate() {
        return this._siegeDate;
    }

    public boolean getIsTimeRegistrationOver() {
        return this._isTimeRegistrationOver;
    }

    public void setIsTimeRegistrationOver(boolean val) {
        this._isTimeRegistrationOver = val;
    }

    public Calendar getTimeRegistrationOverDate() {
        if (this._siegeTimeRegistrationEndDate == null) {
            this._siegeTimeRegistrationEndDate = Calendar.getInstance();
        }
        return this._siegeTimeRegistrationEndDate;
    }

    public final int getTaxPercent() {
        return this._taxPercent;
    }

    public final double getTaxRate() {
        return this._taxRate;
    }

    public final long getTreasury() {
        return this._treasury;
    }

    public final boolean getShowNpcCrest() {
        return this._showNpcCrest;
    }

    public final void setShowNpcCrest(boolean showNpcCrest) {
        if (this._showNpcCrest != showNpcCrest) {
            this._showNpcCrest = showNpcCrest;
            this.updateShowNpcCrest();
        }
    }

    public void updateClansReputation() {
        if (this._formerOwner != null) {
            if (this._formerOwner != ClanTable.getInstance().getClan(this.getOwnerId())) {
                int maxreward = Math.max(0, this._formerOwner.getReputationScore());
                this._formerOwner.takeReputationScore(Config.LOOSE_CASTLE_POINTS, true);
                L2Clan owner = ClanTable.getInstance().getClan(this.getOwnerId());
                if (owner != null) {
                    owner.addReputationScore(Math.min(Config.TAKE_CASTLE_POINTS, maxreward), true);
                }
            } else {
                this._formerOwner.addReputationScore(Config.CASTLE_DEFENDED_POINTS, true);
            }
        } else {
            L2Clan owner = ClanTable.getInstance().getClan(this.getOwnerId());
            if (owner != null) {
                owner.addReputationScore(Config.TAKE_CASTLE_POINTS, true);
            }
        }
    }

    public void updateShowNpcCrest() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("UPDATE castle SET showNpcCrest = ? WHERE id = ?");){
            ps.setString(1, String.valueOf(this.getShowNpcCrest()));
            ps.setInt(2, this.getResidenceId());
            ps.execute();
        }
        catch (Exception e) {
            _log.info("Error saving showNpcCrest for castle " + this.getName() + ": " + e.getMessage());
        }
    }

    @Override
    public void giveResidentialSkills(L2PcInstance player) {
        TerritoryWarManager.Territory territory = TerritoryWarManager.getInstance().getTerritory(this.getResidenceId());
        if (territory != null && territory.getOwnedWardIds().contains((Object)(this.getResidenceId() + 80))) {
            Iterator iterator = territory.getOwnedWardIds().iterator();
            while (iterator.hasNext()) {
                int wardId = (Integer)iterator.next();
                List<L2SkillLearn> territorySkills = SkillTreesData.getInstance().getAvailableResidentialSkills(wardId);
                for (L2SkillLearn s : territorySkills) {
                    Skill sk = SkillData.getInstance().getSkill(s.getSkillId(), s.getSkillLevel());
                    if (sk != null) {
                        player.addSkill(sk, false);
                        continue;
                    }
                    _log.warning("Trying to add a null skill for Territory Ward Id: " + wardId + ", skill Id: " + s.getSkillId() + " level: " + s.getSkillLevel() + "!");
                }
            }
        }
        super.giveResidentialSkills(player);
    }

    @Override
    public void removeResidentialSkills(L2PcInstance player) {
        if (TerritoryWarManager.getInstance().getTerritory(this.getResidenceId()) != null) {
            Iterator iterator = TerritoryWarManager.getInstance().getTerritory(this.getResidenceId()).getOwnedWardIds().iterator();
            while (iterator.hasNext()) {
                int wardId = (Integer)iterator.next();
                List<L2SkillLearn> territorySkills = SkillTreesData.getInstance().getAvailableResidentialSkills(wardId);
                for (L2SkillLearn s : territorySkills) {
                    Skill sk = SkillData.getInstance().getSkill(s.getSkillId(), s.getSkillLevel());
                    if (sk != null) {
                        player.removeSkill(sk, false, true);
                        continue;
                    }
                    _log.warning("Trying to remove a null skill for Territory Ward Id: " + wardId + ", skill Id: " + s.getSkillId() + " level: " + s.getSkillLevel() + "!");
                }
            }
        }
        super.removeResidentialSkills(player);
    }

    public void registerArtefact(L2ArtefactInstance artefact) {
        this._artefacts.add(artefact);
    }

    public List<L2ArtefactInstance> getArtefacts() {
        return this._artefacts;
    }

    public int getTicketBuyCount() {
        return this._ticketBuyCount;
    }

    public void setTicketBuyCount(int count) {
        this._ticketBuyCount = count;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("UPDATE castle SET ticketBuyCount = ? WHERE id = ?");){
            ps.setInt(1, this._ticketBuyCount);
            ps.setInt(2, this.getResidenceId());
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public int getTrapUpgradeLevel(int towerIndex) {
        TowerSpawn spawn = SiegeManager.getInstance().getFlameTowers(this.getResidenceId()).get(towerIndex);
        return spawn != null ? spawn.getUpgradeLevel() : 0;
    }

    public void setTrapUpgrade(int towerIndex, int level, boolean save) {
        TowerSpawn spawn;
        if (save) {
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement ps = con.prepareStatement("REPLACE INTO castle_trapupgrade (castleId, towerIndex, level) values (?,?,?)");){
                ps.setInt(1, this.getResidenceId());
                ps.setInt(2, towerIndex);
                ps.setInt(3, level);
                ps.execute();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception: setTrapUpgradeLevel(int towerIndex, int level, int castleId): " + e.getMessage(), e);
            }
        }
        if ((spawn = SiegeManager.getInstance().getFlameTowers(this.getResidenceId()).get(towerIndex)) != null) {
            spawn.setUpgradeLevel(level);
        }
    }

    private void removeTrapUpgrade() {
        for (TowerSpawn ts : SiegeManager.getInstance().getFlameTowers(this.getResidenceId())) {
            ts.setUpgradeLevel(0);
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("DELETE FROM castle_trapupgrade WHERE castleId=?");){
            ps.setInt(1, this.getResidenceId());
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: removeDoorUpgrade(): " + e.getMessage(), e);
        }
    }

    @Override
    protected void initResidenceZone() {
        for (L2CastleZone zone : ZoneManager.getInstance().getAllZones(L2CastleZone.class)) {
            if (zone.getResidenceId() != this.getResidenceId()) continue;
            this.setResidenceZone(zone);
            break;
        }
    }

    public class CastleFunction {
        private final int _type;
        private int _lvl;
        protected int _fee;
        protected int _tempFee;
        private final long _rate;
        private long _endDate;
        protected boolean _inDebt;
        public boolean _cwh;

        public CastleFunction(int type, int lvl, int lease, int tempLease, long rate, long time, boolean cwh) {
            this._type = type;
            this._lvl = lvl;
            this._fee = lease;
            this._tempFee = tempLease;
            this._rate = rate;
            this._endDate = time;
            this.initializeTask(cwh);
        }

        public int getType() {
            return this._type;
        }

        public int getLvl() {
            return this._lvl;
        }

        public int getLease() {
            return this._fee;
        }

        public long getRate() {
            return this._rate;
        }

        public long getEndTime() {
            return this._endDate;
        }

        public void setLvl(int lvl) {
            this._lvl = lvl;
        }

        public void setLease(int lease) {
            this._fee = lease;
        }

        public void setEndTime(long time) {
            this._endDate = time;
        }

        private void initializeTask(boolean cwh) {
            if (Castle.this.getOwnerId() <= 0) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (this._endDate > currentTime) {
                ThreadPoolManager.getInstance().scheduleGeneral(new FunctionTask(cwh), this._endDate - currentTime);
            } else {
                ThreadPoolManager.getInstance().scheduleGeneral(new FunctionTask(cwh), 0L);
            }
        }

        public void dbSave() {
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement ps = con.prepareStatement("REPLACE INTO castle_functions (castle_id, type, lvl, lease, rate, endTime) VALUES (?,?,?,?,?,?)");){
                ps.setInt(1, Castle.this.getResidenceId());
                ps.setInt(2, this.getType());
                ps.setInt(3, this.getLvl());
                ps.setInt(4, this.getLease());
                ps.setLong(5, this.getRate());
                ps.setLong(6, this.getEndTime());
                ps.execute();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Exception: Castle.updateFunctions(int type, int lvl, int lease, long rate, long time, boolean addNew): " + e.getMessage(), e);
            }
        }

        private class FunctionTask
        implements Runnable {
            public FunctionTask(boolean cwh) {
                CastleFunction.this._cwh = cwh;
            }

            @Override
            public void run() {
                try {
                    if (Castle.this.getOwnerId() <= 0) {
                        return;
                    }
                    if (ClanTable.getInstance().getClan(Castle.this.getOwnerId()).getWarehouse().getAdena() >= (long)CastleFunction.this._fee || !CastleFunction.this._cwh) {
                        int fee = CastleFunction.this._fee;
                        if (CastleFunction.this.getEndTime() == -1L) {
                            fee = CastleFunction.this._tempFee;
                        }
                        CastleFunction.this.setEndTime(System.currentTimeMillis() + CastleFunction.this.getRate());
                        CastleFunction.this.dbSave();
                        if (CastleFunction.this._cwh) {
                            ClanTable.getInstance().getClan(Castle.this.getOwnerId()).getWarehouse().destroyItemByItemId("CS_function_fee", 57, fee, null, null);
                        }
                        ThreadPoolManager.getInstance().scheduleGeneral(new FunctionTask(true), CastleFunction.this.getRate());
                    } else {
                        Castle.this.removeFunction(CastleFunction.this.getType());
                    }
                }
                catch (Exception e) {
                    _log.log(Level.SEVERE, "", e);
                }
            }
        }
    }
}

