/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Couple {
    private static final Logger _log = Logger.getLogger(Couple.class.getName());
    private int _Id = 0;
    private int _player1Id = 0;
    private int _player2Id = 0;
    private boolean _maried = false;
    private Calendar _affiancedDate;
    private Calendar _weddingDate;

    public Couple(int coupleId) {
        this._Id = coupleId;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM mods_wedding WHERE id = ?");){
            ps.setInt(1, this._Id);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    this._player1Id = rs.getInt("player1Id");
                    this._player2Id = rs.getInt("player2Id");
                    this._maried = rs.getBoolean("married");
                    this._affiancedDate = Calendar.getInstance();
                    this._affiancedDate.setTimeInMillis(rs.getLong("affianceDate"));
                    this._weddingDate = Calendar.getInstance();
                    this._weddingDate.setTimeInMillis(rs.getLong("weddingDate"));
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Exception: Couple.load(): " + e.getMessage(), e);
        }
    }

    public Couple(L2PcInstance player1, L2PcInstance player2) {
        int _tempPlayer1Id = player1.getObjectId();
        int _tempPlayer2Id = player2.getObjectId();
        this._player1Id = _tempPlayer1Id;
        this._player2Id = _tempPlayer2Id;
        this._affiancedDate = Calendar.getInstance();
        this._weddingDate = Calendar.getInstance();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("INSERT INTO mods_wedding (id, player1Id, player2Id, married, affianceDate, weddingDate) VALUES (?, ?, ?, ?, ?, ?)");){
            this._Id = IdFactory.getInstance().getNextId();
            ps.setInt(1, this._Id);
            ps.setInt(2, this._player1Id);
            ps.setInt(3, this._player2Id);
            ps.setBoolean(4, false);
            ps.setLong(5, this._affiancedDate.getTimeInMillis());
            ps.setLong(6, this._weddingDate.getTimeInMillis());
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not create couple: " + e.getMessage(), e);
        }
    }

    public void marry() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("UPDATE mods_wedding set married = ?, weddingDate = ? where id = ?");){
            ps.setBoolean(1, true);
            this._weddingDate = Calendar.getInstance();
            ps.setLong(2, this._weddingDate.getTimeInMillis());
            ps.setInt(3, this._Id);
            ps.execute();
            this._maried = true;
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not marry: " + e.getMessage(), e);
        }
    }

    public void divorce() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("DELETE FROM mods_wedding WHERE id=?");){
            ps.setInt(1, this._Id);
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Exception: Couple.divorce(): " + e.getMessage(), e);
        }
    }

    public final int getId() {
        return this._Id;
    }

    public final int getPlayer1Id() {
        return this._player1Id;
    }

    public final int getPlayer2Id() {
        return this._player2Id;
    }

    public final boolean getMaried() {
        return this._maried;
    }

    public final Calendar getAffiancedDate() {
        return this._affiancedDate;
    }

    public final Calendar getWeddingDate() {
        return this._weddingDate;
    }
}

