/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.enums.FortTeleportWhoType;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.FortSiegeGuardManager;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.CombatFlag;
import com.l2jserver.gameserver.model.FortSiegeSpawn;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2SiegeClan;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FortCommanderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.Siegable;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.sieges.fort.OnFortSiegeFinish;
import com.l2jserver.gameserver.model.events.impl.sieges.fort.OnFortSiegeStart;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class FortSiege
implements Siegable {
    protected static final Logger _log = Logger.getLogger(FortSiege.class.getName());
    private static final String DELETE_FORT_SIEGECLANS_BY_CLAN_ID = "DELETE FROM fortsiege_clans WHERE fort_id = ? AND clan_id = ?";
    private static final String DELETE_FORT_SIEGECLANS = "DELETE FROM fortsiege_clans WHERE fort_id = ?";
    private final List<L2SiegeClan> _attackerClans = new FastList();
    protected FastList<L2Spawn> _commanders = new FastList();
    protected final Fort _fort;
    private boolean _isInProgress = false;
    private FortSiegeGuardManager _siegeGuardManager;
    ScheduledFuture<?> _siegeEnd = null;
    ScheduledFuture<?> _siegeRestore = null;
    ScheduledFuture<?> _siegeStartTask = null;

    public FortSiege(Fort fort) {
        this._fort = fort;
        this.checkAutoTask();
        FortSiegeManager.getInstance().addSiege(this);
    }

    @Override
    public void endSiege() {
        if (this.isInProgress()) {
            this._isInProgress = false;
            this.removeFlags();
            this.unSpawnFlags();
            this.updatePlayerSiegeStateFlags(true);
            int ownerId = this.getFort().getOwnerClan() != null ? this.getFort().getOwnerClan().getId() : -1;
            this.getFort().getZone().banishForeigners(ownerId);
            this.getFort().getZone().setIsActive(false);
            this.getFort().getZone().updateZoneStatusForCharactersInside();
            this.getFort().getZone().setSiegeInstance(null);
            this.saveFortSiege();
            this.clearSiegeClan();
            this.removeCommanders();
            this.getFort().spawnNpcCommanders();
            this.getSiegeGuardManager().unspawnSiegeGuard();
            this.getFort().resetDoors();
            ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleSuspiciousMerchantSpawn(), (long)(FortSiegeManager.getInstance().getSuspiciousMerchantRespawnDelay() * 60) * 1000L);
            this.setSiegeDateTime(true);
            if (this._siegeEnd != null) {
                this._siegeEnd.cancel(true);
                this._siegeEnd = null;
            }
            if (this._siegeRestore != null) {
                this._siegeRestore.cancel(true);
                this._siegeRestore = null;
            }
            if (this.getFort().getOwnerClan() != null && this.getFort().getFlagPole().getMeshIndex() == 0) {
                this.getFort().setVisibleFlag(true);
            }
            _log.info("Siege of " + this.getFort().getName() + " fort finished.");
            EventDispatcher.getInstance().notifyEventAsync(new OnFortSiegeFinish(this), this.getFort());
        }
    }

    @Override
    public void startSiege() {
        if (!this.isInProgress()) {
            if (this._siegeStartTask != null) {
                this._siegeStartTask.cancel(true);
                this.getFort().despawnSuspiciousMerchant();
            }
            this._siegeStartTask = null;
            if (this.getAttackerClans().isEmpty()) {
                return;
            }
            this._isInProgress = true;
            this.loadSiegeClan();
            this.updatePlayerSiegeStateFlags(false);
            this.teleportPlayer(FortTeleportWhoType.Attacker, TeleportWhereType.TOWN);
            this.getFort().despawnNpcCommanders();
            this.spawnCommanders();
            this.getFort().resetDoors();
            this.spawnSiegeGuard();
            this.getFort().setVisibleFlag(false);
            this.getFort().getZone().setSiegeInstance(this);
            this.getFort().getZone().setIsActive(true);
            this.getFort().getZone().updateZoneStatusForCharactersInside();
            this._siegeEnd = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndSiegeTask(), (long)(FortSiegeManager.getInstance().getSiegeLength() * 60) * 1000L);
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_FORTRESS_BATTLE_S1_HAS_BEGUN);
            sm.addFortName(this.getFort());
            this.announceToPlayer(sm);
            this.saveFortSiege();
            _log.info("Siege of " + this.getFort().getName() + " fort started.");
            EventDispatcher.getInstance().notifyEventAsync(new OnFortSiegeStart(this), this.getFort());
        }
    }

    public void announceToPlayer(SystemMessage sm) {
        L2Clan clan;
        for (L2SiegeClan siegeclan : this.getAttackerClans()) {
            clan = ClanTable.getInstance().getClan(siegeclan.getClanId());
            for (L2PcInstance member : clan.getOnlineMembers(0)) {
                if (member == null) continue;
                member.sendPacket(sm);
            }
        }
        if (this.getFort().getOwnerClan() != null) {
            clan = ClanTable.getInstance().getClan(this.getFort().getOwnerClan().getId());
            for (L2PcInstance member : clan.getOnlineMembers(0)) {
                if (member == null) continue;
                member.sendPacket(sm);
            }
        }
    }

    public void announceToPlayer(SystemMessage sm, String s) {
        sm.addString(s);
        this.announceToPlayer(sm);
    }

    public void updatePlayerSiegeStateFlags(boolean clear) {
        L2Clan clan;
        for (L2SiegeClan siegeclan : this.getAttackerClans()) {
            clan = ClanTable.getInstance().getClan(siegeclan.getClanId());
            for (L2PcInstance member : clan.getOnlineMembers(0)) {
                if (member == null) continue;
                if (clear) {
                    member.setSiegeState((byte)0);
                    member.setSiegeSide(0);
                    member.setIsInSiege(false);
                    member.stopFameTask();
                } else {
                    member.setSiegeState((byte)1);
                    member.setSiegeSide(this.getFort().getResidenceId());
                    if (this.checkIfInZone(member)) {
                        member.setIsInSiege(true);
                        member.startFameTask(Config.FORTRESS_ZONE_FAME_TASK_FREQUENCY * 1000, Config.FORTRESS_ZONE_FAME_AQUIRE_POINTS);
                    }
                }
                member.broadcastUserInfo();
            }
        }
        if (this.getFort().getOwnerClan() != null) {
            clan = ClanTable.getInstance().getClan(this.getFort().getOwnerClan().getId());
            for (L2PcInstance member : clan.getOnlineMembers(0)) {
                if (member == null) continue;
                if (clear) {
                    member.setSiegeState((byte)0);
                    member.setSiegeSide(0);
                    member.setIsInSiege(false);
                    member.stopFameTask();
                } else {
                    member.setSiegeState((byte)2);
                    member.setSiegeSide(this.getFort().getResidenceId());
                    if (this.checkIfInZone(member)) {
                        member.setIsInSiege(true);
                        member.startFameTask(Config.FORTRESS_ZONE_FAME_TASK_FREQUENCY * 1000, Config.FORTRESS_ZONE_FAME_AQUIRE_POINTS);
                    }
                }
                member.broadcastUserInfo();
            }
        }
    }

    public boolean checkIfInZone(L2Object object) {
        return this.checkIfInZone(object.getX(), object.getY(), object.getZ());
    }

    public boolean checkIfInZone(int x, int y, int z) {
        return this.isInProgress() && this.getFort().checkIfInZone(x, y, z);
    }

    @Override
    public boolean checkIsAttacker(L2Clan clan) {
        return this.getAttackerClan(clan) != null;
    }

    @Override
    public boolean checkIsDefender(L2Clan clan) {
        return clan != null && this.getFort().getOwnerClan() == clan;
    }

    public void clearSiegeClan() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("DELETE FROM fortsiege_clans WHERE fort_id=?");){
            ps.setInt(1, this.getFort().getResidenceId());
            ps.execute();
            if (this.getFort().getOwnerClan() != null) {
                try (PreparedStatement delete = con.prepareStatement("DELETE FROM fortsiege_clans WHERE clan_id=?");){
                    delete.setInt(1, this.getFort().getOwnerClan().getId());
                    delete.execute();
                }
            }
            this.getAttackerClans().clear();
            if (this.isInProgress()) {
                this.endSiege();
            }
            if (this._siegeStartTask != null) {
                this._siegeStartTask.cancel(true);
                this._siegeStartTask = null;
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: clearSiegeClan(): " + e.getMessage(), e);
        }
    }

    private void clearSiegeDate() {
        this.getFort().getSiegeDate().setTimeInMillis(0L);
    }

    @Override
    public List<L2PcInstance> getAttackersInZone() {
        FastList players = new FastList();
        for (L2SiegeClan siegeclan : this.getAttackerClans()) {
            L2Clan clan = ClanTable.getInstance().getClan(siegeclan.getClanId());
            for (L2PcInstance player : clan.getOnlineMembers(0)) {
                if (player == null || !player.isInSiege()) continue;
                players.add(player);
            }
        }
        return players;
    }

    public List<L2PcInstance> getPlayersInZone() {
        return this.getFort().getZone().getPlayersInside();
    }

    public List<L2PcInstance> getOwnersInZone() {
        FastList players = new FastList();
        if (this.getFort().getOwnerClan() != null) {
            L2Clan clan = ClanTable.getInstance().getClan(this.getFort().getOwnerClan().getId());
            if (clan != this.getFort().getOwnerClan()) {
                return null;
            }
            for (L2PcInstance player : clan.getOnlineMembers(0)) {
                if (player == null || !player.isInSiege()) continue;
                players.add(player);
            }
        }
        return players;
    }

    public void killedCommander(L2FortCommanderInstance instance) {
        if (this._commanders != null && this.getFort() != null && this._commanders.size() != 0) {
            L2Spawn spawn = instance.getSpawn();
            if (spawn != null) {
                FastList<FortSiegeSpawn> commanders = FortSiegeManager.getInstance().getCommanderSpawnList(this.getFort().getResidenceId());
                for (FortSiegeSpawn spawn2 : commanders) {
                    if (spawn2.getId() != spawn.getId()) continue;
                    NpcStringId npcString = null;
                    switch (spawn2.getMessageId()) {
                        case 1: {
                            npcString = NpcStringId.YOU_MAY_HAVE_BROKEN_OUR_ARROWS_BUT_YOU_WILL_NEVER_BREAK_OUR_WILL_ARCHERS_RETREAT;
                            break;
                        }
                        case 2: {
                            npcString = NpcStringId.AIIEEEE_COMMAND_CENTER_THIS_IS_GUARD_UNIT_WE_NEED_BACKUP_RIGHT_AWAY;
                            break;
                        }
                        case 3: {
                            npcString = NpcStringId.AT_LAST_THE_MAGIC_FIELD_THAT_PROTECTS_THE_FORTRESS_HAS_WEAKENED_VOLUNTEERS_STAND_BACK;
                            break;
                        }
                        case 4: {
                            npcString = NpcStringId.I_FEEL_SO_MUCH_GRIEF_THAT_I_CANT_EVEN_TAKE_CARE_OF_MYSELF_THERE_ISNT_ANY_REASON_FOR_ME_TO_STAY_HERE_ANY_LONGER;
                        }
                    }
                    if (npcString == null) continue;
                    instance.broadcastPacket(new NpcSay(instance.getObjectId(), 23, instance.getId(), npcString));
                }
                this._commanders.remove((Object)spawn);
                if (this._commanders.isEmpty()) {
                    this.spawnFlag(this.getFort().getResidenceId());
                    if (this._siegeRestore != null) {
                        this._siegeRestore.cancel(true);
                    }
                    for (L2DoorInstance door : this.getFort().getDoors()) {
                        if (door.getIsShowHp()) continue;
                        door.openMe();
                    }
                    this.getFort().getSiege().announceToPlayer(SystemMessage.getSystemMessage(SystemMessageId.ALL_BARRACKS_OCCUPIED));
                } else if (this._siegeRestore == null) {
                    this.getFort().getSiege().announceToPlayer(SystemMessage.getSystemMessage(SystemMessageId.SEIZED_BARRACKS));
                    this._siegeRestore = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleSiegeRestore(), (long)(FortSiegeManager.getInstance().getCountDownLength() * 60) * 1000L);
                } else {
                    this.getFort().getSiege().announceToPlayer(SystemMessage.getSystemMessage(SystemMessageId.SEIZED_BARRACKS));
                }
            } else {
                _log.warning("FortSiege.killedCommander(): killed commander, but commander not registered for fortress. NpcId: " + instance.getId() + " FortId: " + this.getFort().getResidenceId());
            }
        }
    }

    public void killedFlag(L2Npc flag) {
        if (flag == null) {
            return;
        }
        for (L2SiegeClan clan : this.getAttackerClans()) {
            if (!clan.removeFlag(flag)) continue;
            return;
        }
    }

    public int addAttacker(L2PcInstance player, boolean checkConditions) {
        if (player.getClan() == null) {
            return 0;
        }
        if (checkConditions) {
            if (this.getFort().getSiege().getAttackerClans().isEmpty() && player.getInventory().getAdena() < 250000L) {
                return 1;
            }
            if (System.currentTimeMillis() < TerritoryWarManager.getInstance().getTWStartTimeInMillis() && TerritoryWarManager.getInstance().getIsRegistrationOver()) {
                return 2;
            }
            if (System.currentTimeMillis() > TerritoryWarManager.getInstance().getTWStartTimeInMillis() && TerritoryWarManager.getInstance().isTWChannelOpen()) {
                return 2;
            }
            for (Fort fort : FortManager.getInstance().getForts()) {
                if (fort.getSiege().getAttackerClan(player.getClanId()) != null) {
                    return 3;
                }
                if (fort.getOwnerClan() != player.getClan() || !fort.getSiege().isInProgress() && fort.getSiege()._siegeStartTask == null) continue;
                return 3;
            }
        }
        this.saveSiegeClan(player.getClan());
        if (this.getAttackerClans().size() == 1) {
            if (checkConditions) {
                player.reduceAdena("FortressSiege", 250000L, null, true);
            }
            this.startAutoTask(true);
        }
        return 4;
    }

    public void removeAttacker(L2Clan clan) {
        if (clan == null || clan.getFortId() == this.getFort().getResidenceId() || !FortSiegeManager.getInstance().checkIsRegistered(clan, this.getFort().getResidenceId())) {
            return;
        }
        this.removeSiegeClan(clan.getId());
    }

    private void removeSiegeClan(int clanId) {
        String query = clanId != 0 ? DELETE_FORT_SIEGECLANS_BY_CLAN_ID : DELETE_FORT_SIEGECLANS;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(query);){
            statement.setInt(1, this.getFort().getResidenceId());
            if (clanId != 0) {
                statement.setInt(2, clanId);
            }
            statement.execute();
            this.loadSiegeClan();
            if (this.getAttackerClans().isEmpty()) {
                if (this.isInProgress()) {
                    this.endSiege();
                } else {
                    this.saveFortSiege();
                }
                if (this._siegeStartTask != null) {
                    this._siegeStartTask.cancel(true);
                    this._siegeStartTask = null;
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on removeSiegeClan: " + e.getMessage(), e);
        }
    }

    public void checkAutoTask() {
        if (this._siegeStartTask != null) {
            return;
        }
        long delay = this.getFort().getSiegeDate().getTimeInMillis() - System.currentTimeMillis();
        if (delay < 0L) {
            this.saveFortSiege();
            this.clearSiegeClan();
            ThreadPoolManager.getInstance().executeGeneral(new ScheduleSuspiciousMerchantSpawn());
        } else {
            this.loadSiegeClan();
            if (this.getAttackerClans().isEmpty()) {
                ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleSuspiciousMerchantSpawn(), delay);
            } else {
                if (delay > 3600000L) {
                    ThreadPoolManager.getInstance().executeGeneral(new ScheduleSuspiciousMerchantSpawn());
                    this._siegeStartTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(3600), delay - 3600000L);
                }
                if (delay > 600000L) {
                    ThreadPoolManager.getInstance().executeGeneral(new ScheduleSuspiciousMerchantSpawn());
                    this._siegeStartTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(600), delay - 600000L);
                } else {
                    this._siegeStartTask = delay > 300000L ? ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(300), delay - 300000L) : (delay > 60000L ? ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(60), delay - 60000L) : ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(60), 0L));
                }
                _log.info("Siege of " + this.getFort().getName() + " fort: " + Util.dateFormat(this.getFort().getSiegeDate()));
            }
        }
    }

    public void startAutoTask(boolean setTime) {
        if (this._siegeStartTask != null) {
            return;
        }
        if (setTime) {
            this.setSiegeDateTime(false);
        }
        if (this.getFort().getOwnerClan() != null) {
            this.getFort().getOwnerClan().broadcastToOnlineMembers(SystemMessage.getSystemMessage(SystemMessageId.A_FORTRESS_IS_UNDER_ATTACK));
        }
        this._siegeStartTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(3600), 0L);
    }

    public void teleportPlayer(FortTeleportWhoType teleportWho, TeleportWhereType teleportWhere) {
        List<L2PcInstance> players;
        switch (teleportWho) {
            case Owner: {
                players = this.getOwnersInZone();
                break;
            }
            case Attacker: {
                players = this.getAttackersInZone();
                break;
            }
            default: {
                players = this.getPlayersInZone();
            }
        }
        for (L2PcInstance player : players) {
            if (player.canOverrideCond(PcCondOverride.FORTRESS_CONDITIONS) || player.isJailed()) continue;
            player.teleToLocation(teleportWhere);
        }
    }

    private void addAttacker(int clanId) {
        this.getAttackerClans().add(new L2SiegeClan(clanId, L2SiegeClan.SiegeClanType.ATTACKER));
    }

    public boolean checkIfAlreadyRegisteredForSameDay(L2Clan clan) {
        for (FortSiege siege : FortSiegeManager.getInstance().getSieges()) {
            if (siege == this || siege.getSiegeDate().get(7) != this.getSiegeDate().get(7)) continue;
            if (siege.checkIsAttacker(clan)) {
                return true;
            }
            if (!siege.checkIsDefender(clan)) continue;
            return true;
        }
        return false;
    }

    private void setSiegeDateTime(boolean merchant) {
        Calendar newDate = Calendar.getInstance();
        if (merchant) {
            newDate.add(12, FortSiegeManager.getInstance().getSuspiciousMerchantRespawnDelay());
        } else {
            newDate.add(12, 60);
        }
        this.getFort().setSiegeDate(newDate);
        this.saveSiegeDate();
    }

    private void loadSiegeClan() {
        this.getAttackerClans().clear();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("SELECT clan_id FROM fortsiege_clans WHERE fort_id=?");){
            ps.setInt(1, this.getFort().getResidenceId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    this.addAttacker(rs.getInt("clan_id"));
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: loadSiegeClan(): " + e.getMessage(), e);
        }
    }

    private void removeCommanders() {
        if (this._commanders != null && !this._commanders.isEmpty()) {
            for (L2Spawn spawn : this._commanders) {
                if (spawn == null) continue;
                spawn.stopRespawn();
                if (spawn.getLastSpawn() == null) continue;
                spawn.getLastSpawn().deleteMe();
            }
            this._commanders.clear();
        }
    }

    private void removeFlags() {
        for (L2SiegeClan sc : this.getAttackerClans()) {
            if (sc == null) continue;
            sc.removeFlags();
        }
    }

    private void saveFortSiege() {
        this.clearSiegeDate();
        this.saveSiegeDate();
    }

    private void saveSiegeDate() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("UPDATE fort SET siegeDate = ? WHERE id = ?");){
            ps.setLong(1, this.getSiegeDate().getTimeInMillis());
            ps.setInt(2, this.getFort().getResidenceId());
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: saveSiegeDate(): " + e.getMessage(), e);
        }
    }

    private void saveSiegeClan(L2Clan clan) {
        if (this.getAttackerClans().size() >= FortSiegeManager.getInstance().getAttackerMaxClans()) {
            return;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("INSERT INTO fortsiege_clans (clan_id,fort_id) values (?,?)");){
            statement.setInt(1, clan.getId());
            statement.setInt(2, this.getFort().getResidenceId());
            statement.execute();
            this.addAttacker(clan.getId());
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: saveSiegeClan(L2Clan clan): " + e.getMessage(), e);
        }
    }

    private void spawnCommanders() {
        try {
            this._commanders.clear();
            for (FortSiegeSpawn _sp : FortSiegeManager.getInstance().getCommanderSpawnList(this.getFort().getResidenceId())) {
                L2NpcTemplate template1 = NpcData.getInstance().getTemplate(_sp.getId());
                if (template1 != null) {
                    L2Spawn spawnDat = new L2Spawn(template1);
                    spawnDat.setAmount(1);
                    spawnDat.setX(_sp.getLocation().getX());
                    spawnDat.setY(_sp.getLocation().getY());
                    spawnDat.setZ(_sp.getLocation().getZ());
                    spawnDat.setHeading(_sp.getLocation().getHeading());
                    spawnDat.setRespawnDelay(60);
                    spawnDat.doSpawn();
                    spawnDat.stopRespawn();
                    this._commanders.add((Object)spawnDat);
                    continue;
                }
                _log.warning("FortSiege.spawnCommander: Data missing in NPC table for ID: " + _sp.getId() + ".");
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "FortSiege.spawnCommander: Spawn could not be initialized: " + e.getMessage(), e);
        }
    }

    private void spawnFlag(int Id2) {
        for (CombatFlag cf : FortSiegeManager.getInstance().getFlagList(Id2)) {
            cf.spawnMe();
        }
    }

    private void unSpawnFlags() {
        if (FortSiegeManager.getInstance().getFlagList(this.getFort().getResidenceId()) == null) {
            return;
        }
        for (CombatFlag cf : FortSiegeManager.getInstance().getFlagList(this.getFort().getResidenceId())) {
            cf.unSpawnMe();
        }
    }

    private void spawnSiegeGuard() {
        this.getSiegeGuardManager().spawnSiegeGuard();
    }

    @Override
    public final L2SiegeClan getAttackerClan(L2Clan clan) {
        if (clan == null) {
            return null;
        }
        return this.getAttackerClan(clan.getId());
    }

    @Override
    public final L2SiegeClan getAttackerClan(int clanId) {
        for (L2SiegeClan sc : this.getAttackerClans()) {
            if (sc == null || sc.getClanId() != clanId) continue;
            return sc;
        }
        return null;
    }

    @Override
    public final List<L2SiegeClan> getAttackerClans() {
        return this._attackerClans;
    }

    public final Fort getFort() {
        return this._fort;
    }

    public final boolean isInProgress() {
        return this._isInProgress;
    }

    @Override
    public final Calendar getSiegeDate() {
        return this.getFort().getSiegeDate();
    }

    @Override
    public List<L2Npc> getFlag(L2Clan clan) {
        L2SiegeClan sc;
        if (clan != null && (sc = this.getAttackerClan(clan)) != null) {
            return sc.getFlag();
        }
        return null;
    }

    public final FortSiegeGuardManager getSiegeGuardManager() {
        if (this._siegeGuardManager == null) {
            this._siegeGuardManager = new FortSiegeGuardManager(this.getFort());
        }
        return this._siegeGuardManager;
    }

    public void resetSiege() {
        this.removeCommanders();
        this.spawnCommanders();
        this.getFort().resetDoors();
    }

    public List<L2Spawn> getCommanders() {
        return this._commanders;
    }

    @Override
    public L2SiegeClan getDefenderClan(int clanId) {
        return null;
    }

    @Override
    public L2SiegeClan getDefenderClan(L2Clan clan) {
        return null;
    }

    @Override
    public List<L2SiegeClan> getDefenderClans() {
        return null;
    }

    @Override
    public boolean giveFame() {
        return true;
    }

    @Override
    public int getFameFrequency() {
        return Config.FORTRESS_ZONE_FAME_TASK_FREQUENCY;
    }

    @Override
    public int getFameAmount() {
        return Config.FORTRESS_ZONE_FAME_AQUIRE_POINTS;
    }

    @Override
    public void updateSiege() {
    }

    public class ScheduleSiegeRestore
    implements Runnable {
        @Override
        public void run() {
            if (!FortSiege.this.isInProgress()) {
                return;
            }
            try {
                FortSiege.this._siegeRestore = null;
                FortSiege.this.resetSiege();
                FortSiege.this.announceToPlayer(SystemMessage.getSystemMessage(SystemMessageId.BARRACKS_FUNCTION_RESTORED));
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception: ScheduleSiegeRestore() for Fort: " + FortSiege.this._fort.getName() + " " + e.getMessage(), e);
            }
        }
    }

    public class ScheduleSuspiciousMerchantSpawn
    implements Runnable {
        @Override
        public void run() {
            if (FortSiege.this.isInProgress()) {
                return;
            }
            try {
                FortSiege.this._fort.spawnSuspiciousMerchant();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception: ScheduleSuspicoiusMerchantSpawn() for Fort: " + FortSiege.this._fort.getName() + " " + e.getMessage(), e);
            }
        }
    }

    public class ScheduleStartSiegeTask
    implements Runnable {
        private final Fort _fortInst;
        private final int _time;

        public ScheduleStartSiegeTask(int time) {
            this._fortInst = FortSiege.this._fort;
            this._time = time;
        }

        @Override
        public void run() {
            if (FortSiege.this.isInProgress()) {
                return;
            }
            try {
                if (this._time == 3600) {
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(600), 3000000L);
                } else if (this._time == 600) {
                    FortSiege.this.getFort().despawnSuspiciousMerchant();
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_MINUTES_UNTIL_THE_FORTRESS_BATTLE_STARTS);
                    sm.addInt(10);
                    FortSiege.this.announceToPlayer(sm);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(300), 300000L);
                } else if (this._time == 300) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_MINUTES_UNTIL_THE_FORTRESS_BATTLE_STARTS);
                    sm.addInt(5);
                    FortSiege.this.announceToPlayer(sm);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(60), 240000L);
                } else if (this._time == 60) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_MINUTES_UNTIL_THE_FORTRESS_BATTLE_STARTS);
                    sm.addInt(1);
                    FortSiege.this.announceToPlayer(sm);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(30), 30000L);
                } else if (this._time == 30) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_SECONDS_UNTIL_THE_FORTRESS_BATTLE_STARTS);
                    sm.addInt(30);
                    FortSiege.this.announceToPlayer(sm);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(10), 20000L);
                } else if (this._time == 10) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_SECONDS_UNTIL_THE_FORTRESS_BATTLE_STARTS);
                    sm.addInt(10);
                    FortSiege.this.announceToPlayer(sm);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(5), 5000L);
                } else if (this._time == 5) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_SECONDS_UNTIL_THE_FORTRESS_BATTLE_STARTS);
                    sm.addInt(5);
                    FortSiege.this.announceToPlayer(sm);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(1), 4000L);
                } else if (this._time == 1) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_SECONDS_UNTIL_THE_FORTRESS_BATTLE_STARTS);
                    sm.addInt(1);
                    FortSiege.this.announceToPlayer(sm);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(0), 1000L);
                } else if (this._time == 0) {
                    this._fortInst.getSiege().startSiege();
                } else {
                    _log.warning("Exception: ScheduleStartSiegeTask(): unknown siege time: " + this._time);
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception: ScheduleStartSiegeTask() for Fort: " + this._fortInst.getName() + " " + e.getMessage(), e);
            }
        }
    }

    public class ScheduleEndSiegeTask
    implements Runnable {
        @Override
        public void run() {
            if (!FortSiege.this.isInProgress()) {
                return;
            }
            try {
                FortSiege.this._siegeEnd = null;
                FortSiege.this.endSiege();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception: ScheduleEndSiegeTask() for Fort: " + FortSiege.this._fort.getName() + " " + e.getMessage(), e);
            }
        }
    }
}

