/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.Config;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.instancemanager.AntiFeedManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.holders.PlayerEventHolder;
import com.l2jserver.gameserver.network.serverpackets.CharInfo;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.util.Util;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;
import jp.sf.l2j.troja.FastIntObjectMap;
import jp.sf.l2j.troja.IntObjectMap;

public class L2Event {
    protected static final Logger _log = Logger.getLogger(L2Event.class.getName());
    public static EventState eventState = EventState.OFF;
    public static String _eventName = "";
    public static String _eventCreator = "";
    public static String _eventInfo = "";
    public static int _teamsNumber = 0;
    public static final FastIntObjectMap<String> _teamNames = new FastIntObjectMap();
    public static final FastList<L2PcInstance> _registeredPlayers = new FastList();
    public static final FastIntObjectMap<List<L2PcInstance>> _teams = new FastIntObjectMap();
    public static int _npcId = 0;
    private static final FastMap<L2PcInstance, PlayerEventHolder> _connectionLossData = new FastMap();

    public static int getPlayerTeamId(L2PcInstance player) {
        if (player == null) {
            return -1;
        }
        for (IntObjectMap.Entry team : _teams.entrySet()) {
            if (!((List)team.getValue()).contains(player)) continue;
            return team.getKey();
        }
        return -1;
    }

    public static List<L2PcInstance> getTopNKillers(int n) {
        HashMap<L2PcInstance, Integer> tmp = new HashMap<L2PcInstance, Integer>();
        for (List teamList : _teams.values()) {
            for (L2PcInstance player : teamList) {
                if (player.getEventStatus() == null) continue;
                tmp.put(player, player.getEventStatus().getKills().size());
            }
        }
        ArrayList<L2PcInstance> toReturn = new ArrayList<L2PcInstance>(L2Event.sortByValue(tmp).keySet());
        if (toReturn.size() <= n) {
            return toReturn;
        }
        return toReturn.subList(0, n);
    }

    public static void showEventHtml(L2PcInstance player, String objectid) {
        if (eventState == EventState.STANDBY) {
            try {
                NpcHtmlMessage html = new NpcHtmlMessage(Integer.parseInt(objectid));
                String htmContent = _registeredPlayers.contains((Object)player) ? HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/mods/EventEngine/Participating.htm") : HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/mods/EventEngine/Participation.htm");
                if (htmContent != null) {
                    html.setHtml(htmContent);
                }
                html.replace((CharSequence)"%objectId%", objectid);
                html.replace((CharSequence)"%eventName%", _eventName);
                html.replace((CharSequence)"%eventCreator%", _eventCreator);
                html.replace((CharSequence)"%eventInfo%", _eventInfo);
                player.sendPacket(html);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception on showEventHtml(): " + e.getMessage(), e);
            }
        }
    }

    public static void spawnEventNpc(L2PcInstance target) {
        L2NpcTemplate template = NpcData.getInstance().getTemplate(_npcId);
        try {
            L2Spawn spawn = new L2Spawn(template);
            spawn.setX(target.getX() + 50);
            spawn.setY(target.getY() + 50);
            spawn.setZ(target.getZ());
            spawn.setAmount(1);
            spawn.setHeading(target.getHeading());
            spawn.stopRespawn();
            SpawnTable.getInstance().addNewSpawn(spawn, false);
            spawn.init();
            spawn.getLastSpawn().setCurrentHp(9.99999999E8);
            spawn.getLastSpawn().setTitle(_eventName);
            spawn.getLastSpawn().setEventMob(true);
            spawn.getLastSpawn().broadcastPacket(new MagicSkillUse(spawn.getLastSpawn(), spawn.getLastSpawn(), 1034, 1, 1, 1));
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on spawn(): " + e.getMessage(), e);
        }
    }

    public static void unspawnEventNpcs() {
        SpawnTable.getInstance().forEachSpawn(spawn -> {
            L2Npc npc = spawn.getLastSpawn();
            if (npc != null && npc.isEventMob()) {
                npc.deleteMe();
                spawn.stopRespawn();
                SpawnTable.getInstance().deleteSpawn((L2Spawn)spawn, false);
            }
            return true;
        });
    }

    public static boolean isParticipant(L2PcInstance player) {
        if (player == null || player.getEventStatus() == null) {
            return false;
        }
        switch (eventState) {
            case OFF: {
                return false;
            }
            case STANDBY: {
                return _registeredPlayers.contains((Object)player);
            }
            case ON: {
                for (List teamList : _teams.values()) {
                    if (!teamList.contains(player)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public static void registerPlayer(L2PcInstance player) {
        if (eventState != EventState.STANDBY) {
            player.sendMessage("The registration period for this event is over.");
            return;
        }
        if (Config.L2JMOD_DUALBOX_CHECK_MAX_L2EVENT_PARTICIPANTS_PER_IP != 0 && !AntiFeedManager.getInstance().tryAddPlayer(3, player, Config.L2JMOD_DUALBOX_CHECK_MAX_L2EVENT_PARTICIPANTS_PER_IP)) {
            player.sendMessage("You have reached the maximum allowed participants per IP.");
            return;
        }
        _registeredPlayers.add((Object)player);
    }

    public static void removeAndResetPlayer(L2PcInstance player) {
        try {
            if (L2Event.isParticipant(player)) {
                if (player.isDead()) {
                    player.restoreExp(100.0);
                    player.doRevive();
                    player.setCurrentHpMp(player.getMaxHp(), player.getMaxMp());
                    player.setCurrentCp(player.getMaxCp());
                }
                player.getPoly().setPolyInfo(null, "1");
                player.decayMe();
                player.spawnMe(player.getX(), player.getY(), player.getZ());
                CharInfo info1 = new CharInfo(player);
                player.broadcastPacket(info1);
                UserInfo info2 = new UserInfo(player);
                player.sendPacket(info2);
                player.broadcastPacket(new ExBrExtraUserInfo(player));
                player.stopTransformation(true);
            }
            if (player.getEventStatus() != null) {
                player.getEventStatus().restorePlayerStats();
            }
            player.setEventStatus(null);
            _registeredPlayers.remove((Object)player);
            int teamId = L2Event.getPlayerTeamId(player);
            if (_teams.containsKey(teamId)) {
                ((List)_teams.get(teamId)).remove(player);
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error at unregisterAndResetPlayer in the event:" + e.getMessage(), e);
        }
    }

    public static void savePlayerEventStatus(L2PcInstance player) {
        _connectionLossData.put((Object)player, (Object)player.getEventStatus());
    }

    public static void restorePlayerEventStatus(L2PcInstance player) {
        if (_connectionLossData.containsKey((Object)player)) {
            player.setEventStatus((PlayerEventHolder)_connectionLossData.get((Object)player));
            _connectionLossData.remove((Object)player);
        }
    }

    public static String startEventParticipation() {
        try {
            switch (eventState) {
                case ON: {
                    return "Cannot start event, it is already on.";
                }
                case STANDBY: {
                    return "Cannot start event, it is on standby mode.";
                }
                case OFF: {
                    eventState = EventState.STANDBY;
                }
            }
            AntiFeedManager.getInstance().registerEvent(3);
            AntiFeedManager.getInstance().clear(3);
            L2Event.unspawnEventNpcs();
            _registeredPlayers.clear();
            if (NpcData.getInstance().getTemplate(_npcId) == null) {
                return "Cannot start event, invalid npc id.";
            }
            BufferedReader br = Util.utf8BufferedReader(Config.DATAPACK_ROOT + "/data/events/" + _eventName);
            Object object = null;
            try {
                _eventCreator = br.readLine();
                _eventInfo = br.readLine();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (br != null) {
                    if (object != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        br.close();
                    }
                }
            }
            FastList temp = new FastList();
            for (L2PcInstance player : L2World.getInstance().getPlayers()) {
                if (!player.isOnline()) continue;
                if (!temp.contains(player)) {
                    L2Event.spawnEventNpc(player);
                    temp.add(player);
                }
                for (L2PcInstance playertemp : player.getKnownList().getKnownPlayers().values()) {
                    if (Math.abs(playertemp.getX() - player.getX()) >= 1000 || Math.abs(playertemp.getY() - player.getY()) >= 1000 || Math.abs(playertemp.getZ() - player.getZ()) >= 1000) continue;
                    temp.add(playertemp);
                }
            }
        }
        catch (Exception e) {
            _log.warning("L2Event: " + e.getMessage());
            return "Cannot start event participation, an error has occured.";
        }
        return "The event participation has been successfully started.";
    }

    public static String startEvent() {
        try {
            int i;
            switch (eventState) {
                case ON: {
                    return "Cannot start event, it is already on.";
                }
                case STANDBY: {
                    eventState = EventState.ON;
                    break;
                }
                case OFF: {
                    return "Cannot start event, it is off. Participation start is required.";
                }
            }
            L2Event.unspawnEventNpcs();
            _teams.clear();
            _connectionLossData.clear();
            for (i = 0; i < _teamsNumber; ++i) {
                _teams.put(i + 1, (Object)new FastList());
            }
            i = 0;
            while (!_registeredPlayers.isEmpty()) {
                int max = 0;
                L2PcInstance biggestLvlPlayer = null;
                for (L2PcInstance player : _registeredPlayers) {
                    if (player == null || max >= player.getLevel()) continue;
                    max = player.getLevel();
                    biggestLvlPlayer = player;
                }
                if (biggestLvlPlayer == null) continue;
                _registeredPlayers.remove(biggestLvlPlayer);
                ((List)_teams.get(i + 1)).add(biggestLvlPlayer);
                biggestLvlPlayer.setEventStatus();
                i = (i + 1) % _teamsNumber;
            }
        }
        catch (Exception e) {
            _log.warning("L2Event: " + e.getMessage());
            return "Cannot start event, an error has occured.";
        }
        return "The event has been successfully started.";
    }

    public static String finishEvent() {
        switch (eventState) {
            case OFF: {
                return "Cannot finish event, it is already off.";
            }
            case STANDBY: {
                for (L2PcInstance player : _registeredPlayers) {
                    L2Event.removeAndResetPlayer(player);
                }
                L2Event.unspawnEventNpcs();
                _registeredPlayers.clear();
                _teams.clear();
                _connectionLossData.clear();
                _teamsNumber = 0;
                _eventName = "";
                eventState = EventState.OFF;
                return "The event has been stopped at STANDBY mode, all players unregistered and all event npcs unspawned.";
            }
            case ON: {
                for (List teamList : _teams.values()) {
                    for (L2PcInstance player : teamList) {
                        L2Event.removeAndResetPlayer(player);
                    }
                }
                eventState = EventState.OFF;
                AntiFeedManager.getInstance().clear(2);
                L2Event.unspawnEventNpcs();
                _registeredPlayers.clear();
                _teams.clear();
                _connectionLossData.clear();
                _teamsNumber = 0;
                _eventName = "";
                _npcId = 0;
                _eventCreator = "";
                _eventInfo = "";
                return "The event has been stopped, all players unregistered and all event npcs unspawned.";
            }
        }
        return "The event has been successfully finished.";
    }

    private static final LinkedHashMap<L2PcInstance, Integer> sortByValue(Map<L2PcInstance, Integer> unsortMap) {
        ArrayList<Map.Entry<L2PcInstance, Integer>> list = new ArrayList<Map.Entry<L2PcInstance, Integer>>(unsortMap.entrySet());
        list.sort(Comparator.comparing(Map.Entry::getValue));
        LinkedHashMap<L2PcInstance, Integer> sortedMap = new LinkedHashMap<L2PcInstance, Integer>();
        for (Map.Entry<L2PcInstance, Integer> entry : list) {
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        return sortedMap;
    }

    public static enum EventState {
        OFF,
        STANDBY,
        ON;

    }
}

