/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.datatables.SiegeScheduleData;
import com.l2jserver.gameserver.enums.SiegeTeleportWhoType;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.MercTicketManager;
import com.l2jserver.gameserver.instancemanager.SiegeGuardManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2SiegeClan;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.SiegeScheduleDate;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.TowerSpawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2ControlTowerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FlameTowerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Hero;
import com.l2jserver.gameserver.model.entity.Siegable;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.sieges.castle.OnCastleSiegeFinish;
import com.l2jserver.gameserver.model.events.impl.sieges.castle.OnCastleSiegeOwnerChange;
import com.l2jserver.gameserver.model.events.impl.sieges.castle.OnCastleSiegeStart;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.RelationChanged;
import com.l2jserver.gameserver.network.serverpackets.SiegeInfo;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class Siege
implements Siegable {
    protected static final Logger _log = Logger.getLogger(Siege.class.getName());
    public static final byte OWNER = -1;
    public static final byte DEFENDER = 0;
    public static final byte ATTACKER = 1;
    public static final byte DEFENDER_NOT_APPROVED = 2;
    private int _controlTowerCount;
    private final List<L2SiegeClan> _attackerClans = new FastList();
    private final List<L2SiegeClan> _defenderClans = new FastList();
    private final List<L2SiegeClan> _defenderWaitingClans = new FastList();
    private final List<L2ControlTowerInstance> _controlTowers = new ArrayList<L2ControlTowerInstance>();
    private final List<L2FlameTowerInstance> _flameTowers = new ArrayList<L2FlameTowerInstance>();
    private final Castle _castle;
    private boolean _isInProgress = false;
    private boolean _isNormalSide = true;
    protected boolean _isRegistrationOver = false;
    protected Calendar _siegeEndDate;
    private SiegeGuardManager _siegeGuardManager;
    protected ScheduledFuture<?> _scheduledStartSiegeTask = null;
    protected int _firstOwnerClanId = -1;

    public Siege(Castle castle) {
        this._castle = castle;
        this._siegeGuardManager = new SiegeGuardManager(this.getCastle());
        this.startAutoTask();
    }

    @Override
    public void endSiege() {
        if (this.isInProgress()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.SIEGE_OF_S1_HAS_ENDED);
            sm.addCastleName(this.getCastle());
            Announcements.getInstance().announceToAll(sm);
            if (this.getCastle().getOwnerId() > 0) {
                L2Clan clan = ClanTable.getInstance().getClan(this.getCastle().getOwnerId());
                sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_S1_VICTORIOUS_OVER_S2_S_SIEGE);
                sm.addString(clan.getName());
                sm.addCastleName(this.getCastle());
                Announcements.getInstance().announceToAll(sm);
                if (clan.getId() == this._firstOwnerClanId) {
                    clan.increaseBloodAllianceCount();
                } else {
                    this.getCastle().setTicketBuyCount(0);
                    for (L2ClanMember member : clan.getMembers()) {
                        L2PcInstance player;
                        if (member == null || (player = member.getPlayerInstance()) == null || !player.isNoble()) continue;
                        Hero.getInstance().setCastleTaken(player.getObjectId(), this.getCastle().getResidenceId());
                    }
                }
            } else {
                sm = SystemMessage.getSystemMessage(SystemMessageId.SIEGE_S1_DRAW);
                sm.addCastleName(this.getCastle());
                Announcements.getInstance().announceToAll(sm);
            }
            for (L2SiegeClan attackerClan : this.getAttackerClans()) {
                L2Clan clan = ClanTable.getInstance().getClan(attackerClan.getClanId());
                if (clan == null) continue;
                clan.clearSiegeKills();
                clan.clearSiegeDeaths();
            }
            for (L2SiegeClan defenderClan : this.getDefenderClans()) {
                L2Clan clan = ClanTable.getInstance().getClan(defenderClan.getClanId());
                if (clan == null) continue;
                clan.clearSiegeKills();
                clan.clearSiegeDeaths();
            }
            this.getCastle().updateClansReputation();
            this.removeFlags();
            this.teleportPlayer(SiegeTeleportWhoType.NotOwner, TeleportWhereType.TOWN);
            this._isInProgress = false;
            this.updatePlayerSiegeStateFlags(true);
            this.saveCastleSiege();
            this.clearSiegeClan();
            this.removeTowers();
            this._siegeGuardManager.unspawnSiegeGuard();
            if (this.getCastle().getOwnerId() > 0) {
                this._siegeGuardManager.removeMercs();
            }
            this.getCastle().spawnDoor();
            this.getCastle().getZone().setIsActive(false);
            this.getCastle().getZone().updateZoneStatusForCharactersInside();
            this.getCastle().getZone().setSiegeInstance(null);
            EventDispatcher.getInstance().notifyEventAsync(new OnCastleSiegeFinish(this), this.getCastle());
        }
    }

    private void removeDefender(L2SiegeClan sc) {
        if (sc != null) {
            this.getDefenderClans().remove(sc);
        }
    }

    private void removeAttacker(L2SiegeClan sc) {
        if (sc != null) {
            this.getAttackerClans().remove(sc);
        }
    }

    private void addDefender(L2SiegeClan sc, L2SiegeClan.SiegeClanType type) {
        if (sc == null) {
            return;
        }
        sc.setType(type);
        this.getDefenderClans().add(sc);
    }

    private void addAttacker(L2SiegeClan sc) {
        if (sc == null) {
            return;
        }
        sc.setType(L2SiegeClan.SiegeClanType.ATTACKER);
        this.getAttackerClans().add(sc);
    }

    public void midVictory() {
        if (this.isInProgress()) {
            if (this.getCastle().getOwnerId() > 0) {
                this._siegeGuardManager.removeMercs();
            }
            if (this.getDefenderClans().isEmpty() && this.getAttackerClans().size() == 1) {
                L2SiegeClan sc_newowner = this.getAttackerClan(this.getCastle().getOwnerId());
                this.removeAttacker(sc_newowner);
                this.addDefender(sc_newowner, L2SiegeClan.SiegeClanType.OWNER);
                this.endSiege();
                return;
            }
            if (this.getCastle().getOwnerId() > 0) {
                int allyId = ClanTable.getInstance().getClan(this.getCastle().getOwnerId()).getAllyId();
                if (this.getDefenderClans().isEmpty() && allyId != 0) {
                    boolean allinsamealliance = true;
                    for (L2SiegeClan sc : this.getAttackerClans()) {
                        if (sc == null || ClanTable.getInstance().getClan(sc.getClanId()).getAllyId() == allyId) continue;
                        allinsamealliance = false;
                    }
                    if (allinsamealliance) {
                        L2SiegeClan sc_newowner = this.getAttackerClan(this.getCastle().getOwnerId());
                        this.removeAttacker(sc_newowner);
                        this.addDefender(sc_newowner, L2SiegeClan.SiegeClanType.OWNER);
                        this.endSiege();
                        return;
                    }
                }
                for (L2SiegeClan sc : this.getDefenderClans()) {
                    if (sc == null) continue;
                    this.removeDefender(sc);
                    this.addAttacker(sc);
                }
                L2SiegeClan sc_newowner = this.getAttackerClan(this.getCastle().getOwnerId());
                this.removeAttacker(sc_newowner);
                this.addDefender(sc_newowner, L2SiegeClan.SiegeClanType.OWNER);
                for (L2Clan clan : ClanTable.getInstance().getClanAllies(allyId)) {
                    L2SiegeClan sc = this.getAttackerClan(clan.getId());
                    if (sc == null) continue;
                    this.removeAttacker(sc);
                    this.addDefender(sc, L2SiegeClan.SiegeClanType.DEFENDER);
                }
                this.teleportPlayer(SiegeTeleportWhoType.Attacker, TeleportWhereType.SIEGEFLAG);
                this.teleportPlayer(SiegeTeleportWhoType.Spectator, TeleportWhereType.TOWN);
                this.removeDefenderFlags();
                this.getCastle().removeUpgrade();
                this.getCastle().spawnDoor(true);
                this.removeTowers();
                this._controlTowerCount = 0;
                this.spawnControlTower();
                this.spawnFlameTower();
                this.updatePlayerSiegeStateFlags(false);
                EventDispatcher.getInstance().notifyEventAsync(new OnCastleSiegeOwnerChange(this), this.getCastle());
            }
        }
    }

    @Override
    public void startSiege() {
        if (!this.isInProgress()) {
            this._firstOwnerClanId = this.getCastle().getOwnerId();
            if (this.getAttackerClans().isEmpty()) {
                SystemMessage sm;
                if (this._firstOwnerClanId <= 0) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.SIEGE_OF_S1_HAS_BEEN_CANCELED_DUE_TO_LACK_OF_INTEREST);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S1_SIEGE_WAS_CANCELED_BECAUSE_NO_CLANS_PARTICIPATED);
                    L2Clan ownerClan = ClanTable.getInstance().getClan(this._firstOwnerClanId);
                    ownerClan.increaseBloodAllianceCount();
                }
                sm.addCastleName(this.getCastle());
                Announcements.getInstance().announceToAll(sm);
                this.saveCastleSiege();
                return;
            }
            this._isNormalSide = true;
            this._isInProgress = true;
            this.loadSiegeClan();
            this.updatePlayerSiegeStateFlags(false);
            this.teleportPlayer(SiegeTeleportWhoType.NotOwner, TeleportWhereType.TOWN);
            this._controlTowerCount = 0;
            this.spawnControlTower();
            this.spawnFlameTower();
            this.getCastle().spawnDoor();
            this.spawnSiegeGuard();
            MercTicketManager.getInstance().deleteTickets(this.getCastle().getResidenceId());
            this.getCastle().getZone().setSiegeInstance(this);
            this.getCastle().getZone().setIsActive(true);
            this.getCastle().getZone().updateZoneStatusForCharactersInside();
            this._siegeEndDate = Calendar.getInstance();
            this._siegeEndDate.add(12, SiegeManager.getInstance().getSiegeLength());
            ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndSiegeTask(this.getCastle()), 1000L);
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.SIEGE_OF_S1_HAS_STARTED);
            sm.addCastleName(this.getCastle());
            Announcements.getInstance().announceToAll(sm);
            EventDispatcher.getInstance().notifyEventAsync(new OnCastleSiegeStart(this), this.getCastle());
        }
    }

    public void announceToPlayer(SystemMessage message, boolean bothSides) {
        L2Clan clan;
        for (L2SiegeClan siegeClans : this.getDefenderClans()) {
            clan = ClanTable.getInstance().getClan(siegeClans.getClanId());
            for (L2PcInstance member : clan.getOnlineMembers(0)) {
                if (member == null) continue;
                member.sendPacket(message);
            }
        }
        if (bothSides) {
            for (L2SiegeClan siegeClans : this.getAttackerClans()) {
                clan = ClanTable.getInstance().getClan(siegeClans.getClanId());
                for (L2PcInstance member : clan.getOnlineMembers(0)) {
                    if (member == null) continue;
                    member.sendPacket(message);
                }
            }
        }
    }

    public void updatePlayerSiegeStateFlags(boolean clear) {
        L2Clan clan;
        for (L2SiegeClan siegeclan : this.getAttackerClans()) {
            if (siegeclan == null) continue;
            clan = ClanTable.getInstance().getClan(siegeclan.getClanId());
            for (L2PcInstance member : clan.getOnlineMembers(0)) {
                if (member == null) continue;
                if (clear) {
                    member.setSiegeState((byte)0);
                    member.setSiegeSide(0);
                    member.setIsInSiege(false);
                    member.stopFameTask();
                } else {
                    member.setSiegeState((byte)1);
                    member.setSiegeSide(this.getCastle().getResidenceId());
                    if (this.checkIfInZone(member)) {
                        member.setIsInSiege(true);
                        member.startFameTask(Config.CASTLE_ZONE_FAME_TASK_FREQUENCY * 1000, Config.CASTLE_ZONE_FAME_AQUIRE_POINTS);
                    }
                }
                member.sendPacket(new UserInfo(member));
                member.sendPacket(new ExBrExtraUserInfo(member));
                for (L2PcInstance player : member.getKnownList().getKnownPlayers().values()) {
                    if (player == null) continue;
                    player.sendPacket(new RelationChanged(member, member.getRelation(player), member.isAutoAttackable(player)));
                    if (!member.hasSummon()) continue;
                    player.sendPacket(new RelationChanged(member.getSummon(), member.getRelation(player), member.isAutoAttackable(player)));
                }
            }
        }
        for (L2SiegeClan siegeclan : this.getDefenderClans()) {
            if (siegeclan == null) continue;
            clan = ClanTable.getInstance().getClan(siegeclan.getClanId());
            for (L2PcInstance member : clan.getOnlineMembers(0)) {
                if (member == null) continue;
                if (clear) {
                    member.setSiegeState((byte)0);
                    member.setSiegeSide(0);
                    member.setIsInSiege(false);
                    member.stopFameTask();
                } else {
                    member.setSiegeState((byte)2);
                    member.setSiegeSide(this.getCastle().getResidenceId());
                    if (this.checkIfInZone(member)) {
                        member.setIsInSiege(true);
                        member.startFameTask(Config.CASTLE_ZONE_FAME_TASK_FREQUENCY * 1000, Config.CASTLE_ZONE_FAME_AQUIRE_POINTS);
                    }
                }
                member.sendPacket(new UserInfo(member));
                member.sendPacket(new ExBrExtraUserInfo(member));
                for (L2PcInstance player : member.getKnownList().getKnownPlayers().values()) {
                    if (player == null) continue;
                    player.sendPacket(new RelationChanged(member, member.getRelation(player), member.isAutoAttackable(player)));
                    if (!member.hasSummon()) continue;
                    player.sendPacket(new RelationChanged(member.getSummon(), member.getRelation(player), member.isAutoAttackable(player)));
                }
            }
        }
    }

    public void approveSiegeDefenderClan(int clanId) {
        if (clanId <= 0) {
            return;
        }
        this.saveSiegeClan(ClanTable.getInstance().getClan(clanId), (byte)0, true);
        this.loadSiegeClan();
    }

    public boolean checkIfInZone(L2Object object) {
        return this.checkIfInZone(object.getX(), object.getY(), object.getZ());
    }

    public boolean checkIfInZone(int x, int y, int z) {
        return this.isInProgress() && this.getCastle().checkIfInZone(x, y, z);
    }

    @Override
    public boolean checkIsAttacker(L2Clan clan) {
        return this.getAttackerClan(clan) != null;
    }

    @Override
    public boolean checkIsDefender(L2Clan clan) {
        return this.getDefenderClan(clan) != null;
    }

    public boolean checkIsDefenderWaiting(L2Clan clan) {
        return this.getDefenderWaitingClan(clan) != null;
    }

    public void clearSiegeClan() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("DELETE FROM siege_clans WHERE castle_id=?");){
            statement.setInt(1, this.getCastle().getResidenceId());
            statement.execute();
            if (this.getCastle().getOwnerId() > 0) {
                try (PreparedStatement delete = con.prepareStatement("DELETE FROM siege_clans WHERE clan_id=?");){
                    delete.setInt(1, this.getCastle().getOwnerId());
                    delete.execute();
                }
            }
            this.getAttackerClans().clear();
            this.getDefenderClans().clear();
            this.getDefenderWaitingClans().clear();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: clearSiegeClan(): " + e.getMessage(), e);
        }
    }

    public void clearSiegeWaitingClan() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("DELETE FROM siege_clans WHERE castle_id=? and type = 2");){
            statement.setInt(1, this.getCastle().getResidenceId());
            statement.execute();
            this.getDefenderWaitingClans().clear();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: clearSiegeWaitingClan(): " + e.getMessage(), e);
        }
    }

    @Override
    public List<L2PcInstance> getAttackersInZone() {
        ArrayList<L2PcInstance> players = new ArrayList<L2PcInstance>();
        for (L2SiegeClan siegeclan : this.getAttackerClans()) {
            L2Clan clan = ClanTable.getInstance().getClan(siegeclan.getClanId());
            for (L2PcInstance player : clan.getOnlineMembers(0)) {
                if (player == null || !player.isInSiege()) continue;
                players.add(player);
            }
        }
        return players;
    }

    public List<L2PcInstance> getPlayersInZone() {
        return this.getCastle().getZone().getPlayersInside();
    }

    public List<L2PcInstance> getOwnersInZone() {
        ArrayList<L2PcInstance> players = new ArrayList<L2PcInstance>();
        for (L2SiegeClan siegeclan : this.getDefenderClans()) {
            L2Clan clan = ClanTable.getInstance().getClan(siegeclan.getClanId());
            if (clan.getId() != this.getCastle().getOwnerId()) continue;
            for (L2PcInstance player : clan.getOnlineMembers(0)) {
                if (player == null || !player.isInSiege()) continue;
                players.add(player);
            }
        }
        return players;
    }

    public List<L2PcInstance> getSpectatorsInZone() {
        ArrayList<L2PcInstance> players = new ArrayList<L2PcInstance>();
        for (L2PcInstance player : this.getCastle().getZone().getPlayersInside()) {
            if (player == null || player.isInSiege()) continue;
            players.add(player);
        }
        return players;
    }

    public void killedCT(L2Npc ct) {
        --this._controlTowerCount;
        if (this._controlTowerCount < 0) {
            this._controlTowerCount = 0;
        }
    }

    public void killedFlag(L2Npc flag) {
        if (flag == null) {
            return;
        }
        for (L2SiegeClan clan : this.getAttackerClans()) {
            if (!clan.removeFlag(flag)) continue;
            return;
        }
    }

    public void listRegisterClan(L2PcInstance player) {
        player.sendPacket(new SiegeInfo(this.getCastle()));
    }

    public void registerAttacker(L2PcInstance player) {
        this.registerAttacker(player, false);
    }

    public void registerAttacker(L2PcInstance player, boolean force) {
        if (player.getClan() == null) {
            return;
        }
        int allyId = 0;
        if (this.getCastle().getOwnerId() != 0) {
            allyId = ClanTable.getInstance().getClan(this.getCastle().getOwnerId()).getAllyId();
        }
        if (allyId != 0 && player.getClan().getAllyId() == allyId && !force) {
            player.sendPacket(SystemMessageId.CANNOT_ATTACK_ALLIANCE_CASTLE);
            return;
        }
        if (force) {
            if (SiegeManager.getInstance().checkIsRegistered(player.getClan(), this.getCastle().getResidenceId())) {
                player.sendPacket(SystemMessageId.ALREADY_REQUESTED_SIEGE_BATTLE);
            } else {
                this.saveSiegeClan(player.getClan(), (byte)1, false);
            }
            return;
        }
        if (this.checkIfCanRegister(player, (byte)1)) {
            this.saveSiegeClan(player.getClan(), (byte)1, false);
        }
    }

    public void registerDefender(L2PcInstance player) {
        this.registerDefender(player, false);
    }

    public void registerDefender(L2PcInstance player, boolean force) {
        if (this.getCastle().getOwnerId() <= 0) {
            player.sendMessage(this.getCastle().getCastleName() + "\u306fNPC\u304c\u6240\u6709\u3057\u3066\u3044\u308b\u306e\u3067\u5b88\u5099\u5074\u306b\u306f\u767b\u9332\u3067\u304d\u307e\u305b\u3093\u3002");
            return;
        }
        if (force) {
            if (SiegeManager.getInstance().checkIsRegistered(player.getClan(), this.getCastle().getResidenceId())) {
                player.sendPacket(SystemMessageId.ALREADY_REQUESTED_SIEGE_BATTLE);
            } else {
                this.saveSiegeClan(player.getClan(), (byte)2, false);
            }
            return;
        }
        if (this.checkIfCanRegister(player, (byte)2)) {
            this.saveSiegeClan(player.getClan(), (byte)2, false);
        }
    }

    public void removeSiegeClan(int clanId) {
        if (clanId <= 0) {
            return;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("DELETE FROM siege_clans WHERE castle_id=? and clan_id=?");){
            statement.setInt(1, this.getCastle().getResidenceId());
            statement.setInt(2, clanId);
            statement.execute();
            this.loadSiegeClan();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: removeSiegeClan(): " + e.getMessage(), e);
        }
    }

    public void removeSiegeClan(L2Clan clan) {
        if (clan == null || clan.getCastleId() == this.getCastle().getResidenceId() || !SiegeManager.getInstance().checkIsRegistered(clan, this.getCastle().getResidenceId())) {
            return;
        }
        this.removeSiegeClan(clan.getId());
    }

    public void removeSiegeClan(L2PcInstance player) {
        this.removeSiegeClan(player.getClan());
    }

    public void startAutoTask() {
        this.correctSiegeDateTime();
        _log.info("Siege of " + this.getCastle().getCastleName() + ": " + Util.dateFormat(this.getCastle().getSiegeDate()));
        this.loadSiegeClan();
        if (this._scheduledStartSiegeTask != null) {
            this._scheduledStartSiegeTask.cancel(false);
        }
        this._scheduledStartSiegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(this.getCastle()), 1000L);
    }

    public void teleportPlayer(SiegeTeleportWhoType teleportWho, TeleportWhereType teleportWhere) {
        List<Object> players;
        switch (teleportWho) {
            case Owner: {
                players = this.getOwnersInZone();
                break;
            }
            case NotOwner: {
                players = this.getPlayersInZone();
                Iterator<Object> it = players.iterator();
                while (it.hasNext()) {
                    L2PcInstance l2PcInstance = (L2PcInstance)it.next();
                    if (l2PcInstance != null && !l2PcInstance.inObserverMode() && (l2PcInstance.getClanId() <= 0 || l2PcInstance.getClanId() != this.getCastle().getOwnerId())) continue;
                    it.remove();
                }
                break;
            }
            case Attacker: {
                players = this.getAttackersInZone();
                break;
            }
            case Spectator: {
                players = this.getSpectatorsInZone();
                break;
            }
            default: {
                players = Collections.emptyList();
            }
        }
        for (L2PcInstance l2PcInstance : players) {
            if (l2PcInstance.canOverrideCond(PcCondOverride.CASTLE_CONDITIONS) || l2PcInstance.isJailed()) continue;
            l2PcInstance.teleToLocation(teleportWhere);
        }
    }

    private void addAttacker(int clanId) {
        this.getAttackerClans().add(new L2SiegeClan(clanId, L2SiegeClan.SiegeClanType.ATTACKER));
    }

    private void addDefender(int clanId) {
        this.getDefenderClans().add(new L2SiegeClan(clanId, L2SiegeClan.SiegeClanType.DEFENDER));
    }

    private void addDefender(int clanId, L2SiegeClan.SiegeClanType type) {
        this.getDefenderClans().add(new L2SiegeClan(clanId, type));
    }

    private void addDefenderWaiting(int clanId) {
        this.getDefenderWaitingClans().add(new L2SiegeClan(clanId, L2SiegeClan.SiegeClanType.DEFENDER_PENDING));
    }

    private boolean checkIfCanRegister(L2PcInstance player, byte typeId) {
        if (this.getIsRegistrationOver()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.DEADLINE_FOR_SIEGE_S1_PASSED);
            sm.addCastleName(this.getCastle());
            player.sendPacket(sm);
        } else if (this.isInProgress()) {
            player.sendPacket(SystemMessageId.NOT_SIEGE_REGISTRATION_TIME2);
        } else if (player.getClan() == null || player.getClan().getLevel() < SiegeManager.getInstance().getSiegeClanMinLevel()) {
            player.sendPacket(SystemMessageId.ONLY_CLAN_LEVEL_5_ABOVE_MAY_SIEGE);
        } else if (player.getClan().getId() == this.getCastle().getOwnerId()) {
            player.sendPacket(SystemMessageId.CLAN_THAT_OWNS_CASTLE_IS_AUTOMATICALLY_REGISTERED_DEFENDING);
        } else if (player.getClan().getCastleId() > 0) {
            player.sendPacket(SystemMessageId.CLAN_THAT_OWNS_CASTLE_CANNOT_PARTICIPATE_OTHER_SIEGE);
        } else if (SiegeManager.getInstance().checkIsRegistered(player.getClan(), this.getCastle().getResidenceId())) {
            player.sendPacket(SystemMessageId.ALREADY_REQUESTED_SIEGE_BATTLE);
        } else if (this.checkIfAlreadyRegisteredForSameDay(player.getClan())) {
            player.sendPacket(SystemMessageId.APPLICATION_DENIED_BECAUSE_ALREADY_SUBMITTED_A_REQUEST_FOR_ANOTHER_SIEGE_BATTLE);
        } else if (typeId == 1 && this.getAttackerClans().size() >= SiegeManager.getInstance().getAttackerMaxClans()) {
            player.sendPacket(SystemMessageId.ATTACKER_SIDE_FULL);
        } else if ((typeId == 0 || typeId == 2 || typeId == -1) && this.getDefenderClans().size() + this.getDefenderWaitingClans().size() >= SiegeManager.getInstance().getDefenderMaxClans()) {
            player.sendPacket(SystemMessageId.DEFENDER_SIDE_FULL);
        } else {
            return true;
        }
        return false;
    }

    public boolean checkIfAlreadyRegisteredForSameDay(L2Clan clan) {
        for (Siege siege : SiegeManager.getInstance().getSieges()) {
            if (siege == this || siege.getSiegeDate().get(7) != this.getSiegeDate().get(7)) continue;
            if (siege.checkIsAttacker(clan)) {
                return true;
            }
            if (siege.checkIsDefender(clan)) {
                return true;
            }
            if (!siege.checkIsDefenderWaiting(clan)) continue;
            return true;
        }
        return false;
    }

    public void correctSiegeDateTime() {
        boolean corrected = false;
        if (this.getCastle().getSiegeDate().getTimeInMillis() < System.currentTimeMillis()) {
            corrected = true;
            this.setNextSiegeDate();
        }
        if (corrected) {
            this.saveSiegeDate();
        }
    }

    private void loadSiegeClan() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT clan_id,type FROM siege_clans where castle_id=?");){
            this.getAttackerClans().clear();
            this.getDefenderClans().clear();
            this.getDefenderWaitingClans().clear();
            if (this.getCastle().getOwnerId() > 0) {
                this.addDefender(this.getCastle().getOwnerId(), L2SiegeClan.SiegeClanType.OWNER);
            }
            statement.setInt(1, this.getCastle().getResidenceId());
            try (ResultSet rs = statement.executeQuery();){
                while (rs.next()) {
                    int typeId = rs.getInt("type");
                    if (typeId == 0) {
                        this.addDefender(rs.getInt("clan_id"));
                        continue;
                    }
                    if (typeId == 1) {
                        this.addAttacker(rs.getInt("clan_id"));
                        continue;
                    }
                    if (typeId != 2) continue;
                    this.addDefenderWaiting(rs.getInt("clan_id"));
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: loadSiegeClan(): " + e.getMessage(), e);
        }
    }

    private void removeTowers() {
        for (L2FlameTowerInstance l2FlameTowerInstance : this._flameTowers) {
            l2FlameTowerInstance.deleteMe();
        }
        for (L2ControlTowerInstance l2ControlTowerInstance : this._controlTowers) {
            l2ControlTowerInstance.deleteMe();
        }
        this._flameTowers.clear();
        this._controlTowers.clear();
    }

    private void removeFlags() {
        for (L2SiegeClan sc : this.getAttackerClans()) {
            if (sc == null) continue;
            sc.removeFlags();
        }
        for (L2SiegeClan sc : this.getDefenderClans()) {
            if (sc == null) continue;
            sc.removeFlags();
        }
    }

    private void removeDefenderFlags() {
        for (L2SiegeClan sc : this.getDefenderClans()) {
            if (sc == null) continue;
            sc.removeFlags();
        }
    }

    private void saveCastleSiege() {
        this.setNextSiegeDate();
        this.getTimeRegistrationOverDate().setTimeInMillis(System.currentTimeMillis());
        this.getTimeRegistrationOverDate().add(5, 1);
        this.getCastle().setIsTimeRegistrationOver(false);
        this.saveSiegeDate();
        this.startAutoTask();
    }

    public void saveSiegeDate() {
        if (this._scheduledStartSiegeTask != null) {
            this._scheduledStartSiegeTask.cancel(true);
            this._scheduledStartSiegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(this.getCastle()), 1000L);
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("UPDATE castle SET siegeDate = ?, regTimeEnd = ?, regTimeOver = ?  WHERE id = ?");){
            statement.setLong(1, this.getSiegeDate().getTimeInMillis());
            statement.setLong(2, this.getTimeRegistrationOverDate().getTimeInMillis());
            statement.setString(3, String.valueOf(this.getIsTimeRegistrationOver()));
            statement.setInt(4, this.getCastle().getResidenceId());
            statement.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: saveSiegeDate(): " + e.getMessage(), e);
        }
    }

    private void saveSiegeClan(L2Clan clan, byte typeId, boolean isUpdateRegistration) {
        if (clan.getCastleId() > 0) {
            return;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            PreparedStatement statement;
            if (typeId == 0 || typeId == 2 || typeId == -1 ? this.getDefenderClans().size() + this.getDefenderWaitingClans().size() >= SiegeManager.getInstance().getDefenderMaxClans() : this.getAttackerClans().size() >= SiegeManager.getInstance().getAttackerMaxClans()) {
                return;
            }
            if (!isUpdateRegistration) {
                statement = con.prepareStatement("INSERT INTO siege_clans (clan_id,castle_id,type,castle_owner) values (?,?,?,0)");
                Throwable throwable = null;
                try {
                    statement.setInt(1, clan.getId());
                    statement.setInt(2, this.getCastle().getResidenceId());
                    statement.setInt(3, typeId);
                    statement.execute();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement != null) {
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            statement.close();
                        }
                    }
                }
            }
            statement = con.prepareStatement("UPDATE siege_clans SET type = ? WHERE castle_id = ? AND clan_id = ?");
            Throwable throwable = null;
            try {
                statement.setInt(1, typeId);
                statement.setInt(2, this.getCastle().getResidenceId());
                statement.setInt(3, clan.getId());
                statement.execute();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
            if (typeId == 0 || typeId == -1) {
                this.addDefender(clan.getId());
            } else if (typeId == 1) {
                this.addAttacker(clan.getId());
            } else if (typeId == 2) {
                this.addDefenderWaiting(clan.getId());
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: saveSiegeClan(L2Clan clan, int typeId, boolean isUpdateRegistration): " + e.getMessage(), e);
        }
    }

    private void setNextSiegeDate() {
        Calendar cal = this.getCastle().getSiegeDate();
        long now = System.currentTimeMillis();
        if (cal.getTimeInMillis() < now) {
            cal.setTimeInMillis(now);
        }
        for (SiegeScheduleDate holder : SiegeScheduleData.getInstance().getScheduleDates()) {
            cal.set(7, holder.getDay());
            cal.set(11, holder.getHour());
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            if (cal.before(Calendar.getInstance())) {
                cal.add(3, 2);
            }
            if (CastleManager.getInstance().getSiegeDates(cal.getTimeInMillis()) >= holder.getMaxConcurrent()) continue;
            CastleManager.getInstance().registerSiegeDate(this.getCastle().getResidenceId(), cal.getTimeInMillis());
            break;
        }
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_ANNOUNCED_SIEGE_TIME);
        sm.addCastleId(this.getCastle().getResidenceId());
        Broadcast.toAllOnlinePlayers(sm);
        this._isRegistrationOver = false;
    }

    private void spawnControlTower() {
        for (TowerSpawn ts : SiegeManager.getInstance().getControlTowers(this.getCastle().getResidenceId())) {
            try {
                L2Spawn spawn = new L2Spawn(NpcData.getInstance().getTemplate(ts.getId()));
                spawn.setLocation(ts.getLocation());
                this._controlTowers.add((L2ControlTowerInstance)spawn.doSpawn());
            }
            catch (Exception e) {
                _log.warning(this.getClass().getName() + ": Cannot spawn control tower! " + e);
            }
        }
        this._controlTowerCount = this._controlTowers.size();
    }

    private void spawnFlameTower() {
        for (TowerSpawn ts : SiegeManager.getInstance().getFlameTowers(this.getCastle().getResidenceId())) {
            try {
                L2Spawn spawn = new L2Spawn(NpcData.getInstance().getTemplate(ts.getId()));
                spawn.setLocation(ts.getLocation());
                L2FlameTowerInstance tower = (L2FlameTowerInstance)spawn.doSpawn();
                tower.setUpgradeLevel(ts.getUpgradeLevel());
                tower.setZoneList(ts.getZoneList());
                this._flameTowers.add(tower);
            }
            catch (Exception e) {
                _log.warning(this.getClass().getName() + ": Cannot spawn flame tower! " + e);
            }
        }
    }

    private void spawnSiegeGuard() {
        this.getSiegeGuardManager().spawnSiegeGuard();
        if (!this.getSiegeGuardManager().getSiegeGuardSpawn().isEmpty()) {
            double distanceClosest = 0.0;
            for (L2Spawn spawn : this.getSiegeGuardManager().getSiegeGuardSpawn()) {
                if (spawn == null) continue;
                L2ControlTowerInstance closestCt = null;
                distanceClosest = 2.147483647E9;
                for (L2ControlTowerInstance ct : this._controlTowers) {
                    double distance;
                    if (ct == null || !((distance = ct.calculateDistance(spawn, true, true)) < distanceClosest)) continue;
                    closestCt = ct;
                    distanceClosest = distance;
                }
                if (closestCt == null) continue;
                closestCt.registerGuard(spawn);
            }
        }
    }

    @Override
    public final L2SiegeClan getAttackerClan(L2Clan clan) {
        if (clan == null) {
            return null;
        }
        return this.getAttackerClan(clan.getId());
    }

    @Override
    public final L2SiegeClan getAttackerClan(int clanId) {
        for (L2SiegeClan sc : this.getAttackerClans()) {
            if (sc == null || sc.getClanId() != clanId) continue;
            return sc;
        }
        return null;
    }

    @Override
    public final List<L2SiegeClan> getAttackerClans() {
        if (this._isNormalSide) {
            return this._attackerClans;
        }
        return this._defenderClans;
    }

    public final int getAttackerRespawnDelay() {
        return SiegeManager.getInstance().getAttackerRespawnDelay();
    }

    public final Castle getCastle() {
        if (this._castle == null) {
            return null;
        }
        return this._castle;
    }

    @Override
    public final L2SiegeClan getDefenderClan(L2Clan clan) {
        if (clan == null) {
            return null;
        }
        return this.getDefenderClan(clan.getId());
    }

    @Override
    public final L2SiegeClan getDefenderClan(int clanId) {
        for (L2SiegeClan sc : this.getDefenderClans()) {
            if (sc == null || sc.getClanId() != clanId) continue;
            return sc;
        }
        return null;
    }

    @Override
    public final List<L2SiegeClan> getDefenderClans() {
        if (this._isNormalSide) {
            return this._defenderClans;
        }
        return this._attackerClans;
    }

    public final L2SiegeClan getDefenderWaitingClan(L2Clan clan) {
        if (clan == null) {
            return null;
        }
        return this.getDefenderWaitingClan(clan.getId());
    }

    public final L2SiegeClan getDefenderWaitingClan(int clanId) {
        for (L2SiegeClan sc : this.getDefenderWaitingClans()) {
            if (sc == null || sc.getClanId() != clanId) continue;
            return sc;
        }
        return null;
    }

    public final List<L2SiegeClan> getDefenderWaitingClans() {
        return this._defenderWaitingClans;
    }

    public final boolean isInProgress() {
        return this._isInProgress;
    }

    public final boolean getIsRegistrationOver() {
        return this._isRegistrationOver;
    }

    public final boolean getIsTimeRegistrationOver() {
        return this.getCastle().getIsTimeRegistrationOver();
    }

    @Override
    public final Calendar getSiegeDate() {
        return this.getCastle().getSiegeDate();
    }

    public final Calendar getTimeRegistrationOverDate() {
        return this.getCastle().getTimeRegistrationOverDate();
    }

    public void endTimeRegistration(boolean automatic) {
        this.getCastle().setIsTimeRegistrationOver(true);
        if (!automatic) {
            this.saveSiegeDate();
        }
    }

    @Override
    public List<L2Npc> getFlag(L2Clan clan) {
        L2SiegeClan sc;
        if (clan != null && (sc = this.getAttackerClan(clan)) != null) {
            return sc.getFlag();
        }
        return null;
    }

    public final SiegeGuardManager getSiegeGuardManager() {
        if (this._siegeGuardManager == null) {
            this._siegeGuardManager = new SiegeGuardManager(this.getCastle());
        }
        return this._siegeGuardManager;
    }

    public int getControlTowerCount() {
        return this._controlTowerCount;
    }

    @Override
    public boolean giveFame() {
        return true;
    }

    @Override
    public int getFameFrequency() {
        return Config.CASTLE_ZONE_FAME_TASK_FREQUENCY;
    }

    @Override
    public int getFameAmount() {
        return Config.CASTLE_ZONE_FAME_AQUIRE_POINTS;
    }

    @Override
    public void updateSiege() {
    }

    public class ScheduleStartSiegeTask
    implements Runnable {
        private final Castle _castleInst;

        public ScheduleStartSiegeTask(Castle pCastle) {
            this._castleInst = pCastle;
        }

        @Override
        public void run() {
            Siege.this._scheduledStartSiegeTask.cancel(false);
            if (Siege.this.isInProgress()) {
                return;
            }
            try {
                long timeRemaining;
                if (!Siege.this.getIsTimeRegistrationOver()) {
                    long regTimeRemaining = Siege.this.getTimeRegistrationOverDate().getTimeInMillis() - System.currentTimeMillis();
                    if (regTimeRemaining > 0L) {
                        Siege.this._scheduledStartSiegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(this._castleInst), regTimeRemaining);
                        return;
                    }
                    Siege.this.endTimeRegistration(true);
                }
                if ((timeRemaining = Siege.this.getSiegeDate().getTimeInMillis() - System.currentTimeMillis()) > 86400000L) {
                    Siege.this._scheduledStartSiegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(this._castleInst), timeRemaining - 86400000L);
                } else if (timeRemaining <= 86400000L && timeRemaining > 13600000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.REGISTRATION_TERM_FOR_S1_ENDED);
                    sm.addCastleName(Siege.this.getCastle());
                    Announcements.getInstance().announceToAll(sm);
                    Siege.this._isRegistrationOver = true;
                    Siege.this.clearSiegeWaitingClan();
                    Siege.this._scheduledStartSiegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(this._castleInst), timeRemaining - 13600000L);
                } else if (timeRemaining <= 13600000L && timeRemaining > 600000L) {
                    Siege.this._scheduledStartSiegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(this._castleInst), timeRemaining - 600000L);
                } else if (timeRemaining <= 600000L && timeRemaining > 300000L) {
                    Siege.this._scheduledStartSiegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(this._castleInst), timeRemaining - 300000L);
                } else if (timeRemaining <= 300000L && timeRemaining > 10000L) {
                    Siege.this._scheduledStartSiegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(this._castleInst), timeRemaining - 10000L);
                } else if (timeRemaining <= 10000L && timeRemaining > 0L) {
                    Siege.this._scheduledStartSiegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleStartSiegeTask(this._castleInst), timeRemaining);
                } else {
                    this._castleInst.getSiege().startSiege();
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    public class ScheduleEndSiegeTask
    implements Runnable {
        private final Castle _castleInst;

        public ScheduleEndSiegeTask(Castle pCastle) {
            this._castleInst = pCastle;
        }

        @Override
        public void run() {
            if (!Siege.this.isInProgress()) {
                return;
            }
            try {
                long timeRemaining = Siege.this._siegeEndDate.getTimeInMillis() - System.currentTimeMillis();
                if (timeRemaining > 3600000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_HOURS_UNTIL_SIEGE_CONCLUSION);
                    sm.addInt(2);
                    Siege.this.announceToPlayer(sm, true);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndSiegeTask(this._castleInst), timeRemaining - 3600000L);
                } else if (timeRemaining <= 3600000L && timeRemaining > 600000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_MINUTES_UNTIL_SIEGE_CONCLUSION);
                    sm.addInt((int)timeRemaining / 60000);
                    Siege.this.announceToPlayer(sm, true);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndSiegeTask(this._castleInst), timeRemaining - 600000L);
                } else if (timeRemaining <= 600000L && timeRemaining > 300000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_MINUTES_UNTIL_SIEGE_CONCLUSION);
                    sm.addInt((int)timeRemaining / 60000);
                    Siege.this.announceToPlayer(sm, true);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndSiegeTask(this._castleInst), timeRemaining - 300000L);
                } else if (timeRemaining <= 300000L && timeRemaining > 10000L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_MINUTES_UNTIL_SIEGE_CONCLUSION);
                    sm.addInt((int)timeRemaining / 60000);
                    Siege.this.announceToPlayer(sm, true);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndSiegeTask(this._castleInst), timeRemaining - 10000L);
                } else if (timeRemaining <= 10000L && timeRemaining > 0L) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.CASTLE_SIEGE_S1_SECONDS_LEFT);
                    sm.addInt((int)timeRemaining / 1000);
                    Siege.this.announceToPlayer(sm, true);
                    ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleEndSiegeTask(this._castleInst), timeRemaining);
                } else {
                    this._castleInst.getSiege().endSiege();
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }
}

