/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.Config;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.instancemanager.AntiFeedManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2ServitorInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.model.entity.TvTEventListener;
import com.l2jserver.gameserver.model.entity.TvTEventTeam;
import com.l2jserver.gameserver.model.entity.TvTEventTeleporter;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.ListenersContainer;
import com.l2jserver.gameserver.model.events.impl.events.OnTvTEventFinish;
import com.l2jserver.gameserver.model.events.impl.events.OnTvTEventKill;
import com.l2jserver.gameserver.model.events.impl.events.OnTvTEventRegistrationStart;
import com.l2jserver.gameserver.model.events.impl.events.OnTvTEventStart;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.util.Rnd;
import com.l2jserver.util.StringUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class TvTEvent {
    protected static final Logger _log = Logger.getLogger(TvTEvent.class.getName());
    private static final String htmlPath = "data/scripts/custom/events/TvT/TvTManager/";
    private static TvTEventTeam[] _teams = new TvTEventTeam[2];
    private static EventState _state = EventState.INACTIVE;
    private static L2Spawn _npcSpawn = null;
    private static L2Npc _lastNpcSpawn = null;
    private static int _TvTEventInstance = 0;

    private TvTEvent() {
    }

    public static void init() {
        AntiFeedManager.getInstance().registerEvent(2);
        TvTEvent._teams[0] = new TvTEventTeam(Config.TVT_EVENT_TEAM_1_NAME, Config.TVT_EVENT_TEAM_1_COORDINATES);
        TvTEvent._teams[1] = new TvTEventTeam(Config.TVT_EVENT_TEAM_2_NAME, Config.TVT_EVENT_TEAM_2_COORDINATES);
    }

    public static boolean startParticipation() {
        L2NpcTemplate tmpl = NpcData.getInstance().getTemplate(Config.TVT_EVENT_PARTICIPATION_NPC_ID);
        try {
            _npcSpawn = new L2Spawn(tmpl);
            _npcSpawn.setX(Config.TVT_EVENT_PARTICIPATION_NPC_COORDINATES[0]);
            _npcSpawn.setY(Config.TVT_EVENT_PARTICIPATION_NPC_COORDINATES[1]);
            _npcSpawn.setZ(Config.TVT_EVENT_PARTICIPATION_NPC_COORDINATES[2]);
            _npcSpawn.setAmount(1);
            _npcSpawn.setHeading(Config.TVT_EVENT_PARTICIPATION_NPC_COORDINATES[3]);
            _npcSpawn.setRespawnDelay(1);
            SpawnTable.getInstance().addNewSpawn(_npcSpawn, false);
            _lastNpcSpawn = _npcSpawn.doSpawn();
            _lastNpcSpawn.setTitle("TvT \u30a4\u30d9\u30f3\u30c8\u53d7\u4ed8");
            _lastNpcSpawn.broadcastPacket(new AbstractNpcInfo.NpcInfo(_lastNpcSpawn, null));
            _lastNpcSpawn.broadcastPacket(new MagicSkillUse(_lastNpcSpawn, _lastNpcSpawn, 1034, 1, 1, 1));
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "TvTEventEngine[TvTEvent.startParticipation()]: exception: " + e.getMessage(), e);
            return false;
        }
        TvTEvent.setState(EventState.PARTICIPATING);
        EventDispatcher.getInstance().notifyEventAsync(new OnTvTEventRegistrationStart(), new ListenersContainer[0]);
        return true;
    }

    private static int highestLevelPcInstanceOf(Map<Integer, L2PcInstance> players) {
        int maxLevel = Integer.MIN_VALUE;
        int maxLevelId = -1;
        for (L2PcInstance player : players.values()) {
            if (player.getLevel() < maxLevel) continue;
            maxLevel = player.getLevel();
            maxLevelId = player.getObjectId();
        }
        return maxLevelId;
    }

    public static boolean startFight() {
        L2PcInstance player;
        Iterator<Object> iter;
        TvTEvent.setState(EventState.STARTING);
        FastMap allParticipants = new FastMap();
        allParticipants.putAll(_teams[0].getParticipatedPlayers());
        allParticipants.putAll(_teams[1].getParticipatedPlayers());
        _teams[0].cleanMe();
        _teams[1].cleanMe();
        if (TvTEvent.needParticipationFee()) {
            iter = allParticipants.values().iterator();
            while (iter.hasNext()) {
                player = (L2PcInstance)iter.next();
                if (TvTEvent.hasParticipationFee(player)) continue;
                iter.remove();
            }
        }
        int[] balance = new int[]{0, 0};
        int priority = 0;
        while (!allParticipants.isEmpty()) {
            int highestLevelPlayerId = TvTEvent.highestLevelPcInstanceOf((Map<Integer, L2PcInstance>)allParticipants);
            L2PcInstance highestLevelPlayer = (L2PcInstance)allParticipants.get(highestLevelPlayerId);
            allParticipants.remove(highestLevelPlayerId);
            _teams[priority].addPlayer(highestLevelPlayer);
            int n = priority;
            balance[n] = balance[n] + highestLevelPlayer.getLevel();
            if (allParticipants.isEmpty()) break;
            priority = 1 - priority;
            highestLevelPlayerId = TvTEvent.highestLevelPcInstanceOf((Map<Integer, L2PcInstance>)allParticipants);
            highestLevelPlayer = (L2PcInstance)allParticipants.get(highestLevelPlayerId);
            allParticipants.remove(highestLevelPlayerId);
            _teams[priority].addPlayer(highestLevelPlayer);
            int n2 = priority;
            balance[n2] = balance[n2] + highestLevelPlayer.getLevel();
            priority = balance[0] > balance[1] ? 1 : 0;
        }
        if (_teams[0].getParticipatedPlayerCount() < Config.TVT_EVENT_MIN_PLAYERS_IN_TEAMS || _teams[1].getParticipatedPlayerCount() < Config.TVT_EVENT_MIN_PLAYERS_IN_TEAMS) {
            TvTEvent.setState(EventState.INACTIVE);
            _teams[0].cleanMe();
            _teams[1].cleanMe();
            TvTEvent.unSpawnNpc();
            AntiFeedManager.getInstance().clear(2);
            return false;
        }
        if (TvTEvent.needParticipationFee()) {
            iter = _teams[0].getParticipatedPlayers().values().iterator();
            while (iter.hasNext()) {
                player = (L2PcInstance)iter.next();
                if (TvTEvent.payParticipationFee(player)) continue;
                iter.remove();
            }
            iter = _teams[1].getParticipatedPlayers().values().iterator();
            while (iter.hasNext()) {
                player = (L2PcInstance)iter.next();
                if (TvTEvent.payParticipationFee(player)) continue;
                iter.remove();
            }
        }
        if (Config.TVT_EVENT_IN_INSTANCE) {
            try {
                _TvTEventInstance = InstanceManager.getInstance().createDynamicInstance(Config.TVT_EVENT_INSTANCE_FILE);
                InstanceManager.getInstance().getInstance(_TvTEventInstance).setAllowSummon(false);
                InstanceManager.getInstance().getInstance(_TvTEventInstance).setPvPInstance(true);
                InstanceManager.getInstance().getInstance(_TvTEventInstance).setEmptyDestroyTime((long)(Config.TVT_EVENT_START_LEAVE_TELEPORT_DELAY * 1000) + 60000L);
            }
            catch (Exception e) {
                _TvTEventInstance = 0;
                _log.log(Level.WARNING, "TvTEventEngine[TvTEvent.createDynamicInstance]: exception: " + e.getMessage(), e);
            }
        }
        TvTEvent.openDoors(Config.TVT_DOORS_IDS_TO_OPEN);
        TvTEvent.closeDoors(Config.TVT_DOORS_IDS_TO_CLOSE);
        TvTEvent.setState(EventState.STARTED);
        for (TvTEventTeam team : _teams) {
            for (L2PcInstance playerInstance : team.getParticipatedPlayers().values()) {
                if (playerInstance == null) continue;
                playerInstance.setCanRevive(false);
                new TvTEventTeleporter(playerInstance, team.getCoordinates(), false, false);
            }
        }
        EventDispatcher.getInstance().notifyEventAsync(new OnTvTEventStart(), new ListenersContainer[0]);
        return true;
    }

    public static String calculateRewards() {
        if (_teams[0].getPoints() == _teams[1].getPoints()) {
            if (_teams[0].getParticipatedPlayerCount() == 0 || _teams[1].getParticipatedPlayerCount() == 0) {
                TvTEvent.setState(EventState.REWARDING);
                return "TvT Event: \u30a4\u30d9\u30f3\u30c8\u306f\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002\u52dd\u8005\u306f\u3044\u307e\u305b\u3093\u3002";
            }
            TvTEvent.sysMsgToAllParticipants("TvT Event: \u30a4\u30d9\u30f3\u30c8\u306f\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002\u7d50\u679c\u306f\u5f15\u304d\u5206\u3051\u3067\u3059\u3002");
            if (Config.TVT_REWARD_TEAM_TIE) {
                TvTEvent.rewardTeam(_teams[0]);
                TvTEvent.rewardTeam(_teams[1]);
                return "TvT Event: \u30a4\u30d9\u30f3\u30c8\u306f\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002\u7d50\u679c\u306f\u5f15\u304d\u5206\u3051\u3067\u3059\u3002";
            }
            return "TvT Event: \u30a4\u30d9\u30f3\u30c8\u306f\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002\u7d50\u679c\u306f\u5f15\u304d\u5206\u3051\u3067\u3059\u3002";
        }
        TvTEvent.setState(EventState.REWARDING);
        TvTEventTeam team = _teams[_teams[0].getPoints() > _teams[1].getPoints() ? 0 : 1];
        TvTEvent.rewardTeam(team);
        EventDispatcher.getInstance().notifyEventAsync(new OnTvTEventFinish(), new ListenersContainer[0]);
        return "TvT Event: \u30a4\u30d9\u30f3\u30c8\u306f\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002\u52dd\u8005\u306f " + team.getName() + " \u3067 " + team.getPoints() + " \u30dd\u30a4\u30f3\u30c8\u3092\u7372\u5f97\u3057\u307e\u3057\u305f\u3002";
    }

    private static void rewardTeam(TvTEventTeam team) {
        for (L2PcInstance playerInstance : team.getParticipatedPlayers().values()) {
            if (playerInstance == null) continue;
            SystemMessage systemMessage = null;
            for (int[] reward : Config.TVT_EVENT_REWARDS) {
                PcInventory inv = playerInstance.getInventory();
                if (ItemTable.getInstance().createDummyItem(reward[0]).isStackable()) {
                    inv.addItem("TvT Event", reward[0], reward[1], playerInstance, playerInstance);
                    if (reward[1] > 1) {
                        systemMessage = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S2_S1_S);
                        systemMessage.addItemName(reward[0]);
                        systemMessage.addItemNumber(reward[1]);
                    } else {
                        systemMessage = SystemMessage.getSystemMessage(SystemMessageId.EARNED_ITEM_S1);
                        systemMessage.addItemName(reward[0]);
                    }
                    playerInstance.sendPacket(systemMessage);
                    continue;
                }
                for (int i = 0; i < reward[1]; ++i) {
                    inv.addItem("TvT Event", reward[0], 1L, playerInstance, playerInstance);
                    systemMessage = SystemMessage.getSystemMessage(SystemMessageId.EARNED_ITEM_S1);
                    systemMessage.addItemName(reward[0]);
                    playerInstance.sendPacket(systemMessage);
                }
            }
            StatusUpdate statusUpdate = new StatusUpdate(playerInstance);
            NpcHtmlMessage npcHtmlMessage = new NpcHtmlMessage();
            statusUpdate.addAttribute(14, playerInstance.getCurrentLoad());
            npcHtmlMessage.setHtml(HtmCache.getInstance().getHtm(playerInstance.getHtmlPrefix(), "data/scripts/custom/events/TvT/TvTManager/Reward.html"));
            playerInstance.sendPacket(statusUpdate);
            playerInstance.sendPacket(npcHtmlMessage);
        }
    }

    public static void stopFight() {
        TvTEvent.setState(EventState.INACTIVATING);
        TvTEvent.unSpawnNpc();
        TvTEvent.openDoors(Config.TVT_DOORS_IDS_TO_CLOSE);
        TvTEvent.closeDoors(Config.TVT_DOORS_IDS_TO_OPEN);
        for (TvTEventTeam team : _teams) {
            for (L2PcInstance playerInstance : team.getParticipatedPlayers().values()) {
                if (playerInstance == null) continue;
                playerInstance.setCanRevive(true);
                new TvTEventTeleporter(playerInstance, Config.TVT_EVENT_PARTICIPATION_NPC_COORDINATES, false, false);
            }
        }
        _teams[0].cleanMe();
        _teams[1].cleanMe();
        TvTEvent.setState(EventState.INACTIVE);
        AntiFeedManager.getInstance().clear(2);
    }

    public static synchronized boolean addParticipant(L2PcInstance playerInstance) {
        if (playerInstance == null) {
            return false;
        }
        byte teamId = 0;
        teamId = _teams[0].getParticipatedPlayerCount() == _teams[1].getParticipatedPlayerCount() ? (byte)Rnd.get(2) : (byte)(_teams[0].getParticipatedPlayerCount() > _teams[1].getParticipatedPlayerCount() ? 1 : 0);
        playerInstance.addEventListener(new TvTEventListener(playerInstance));
        return _teams[teamId].addPlayer(playerInstance);
    }

    public static boolean removeParticipant(int playerObjectId) {
        byte teamId = TvTEvent.getParticipantTeamId(playerObjectId);
        if (teamId != -1) {
            _teams[teamId].removePlayer(playerObjectId);
            L2PcInstance player = L2World.getInstance().getPlayer(playerObjectId);
            if (player != null) {
                player.removeEventListener(TvTEventListener.class);
            }
            return true;
        }
        return false;
    }

    public static boolean needParticipationFee() {
        return Config.TVT_EVENT_PARTICIPATION_FEE[0] != 0 && Config.TVT_EVENT_PARTICIPATION_FEE[1] != 0;
    }

    public static boolean hasParticipationFee(L2PcInstance playerInstance) {
        return playerInstance.getInventory().getInventoryItemCount(Config.TVT_EVENT_PARTICIPATION_FEE[0], -1) >= (long)Config.TVT_EVENT_PARTICIPATION_FEE[1];
    }

    public static boolean payParticipationFee(L2PcInstance playerInstance) {
        return playerInstance.destroyItemByItemId("TvT Participation Fee", Config.TVT_EVENT_PARTICIPATION_FEE[0], Config.TVT_EVENT_PARTICIPATION_FEE[1], _lastNpcSpawn, true);
    }

    public static String getParticipationFee() {
        int itemId = Config.TVT_EVENT_PARTICIPATION_FEE[0];
        int itemNum = Config.TVT_EVENT_PARTICIPATION_FEE[1];
        if (itemId == 0 || itemNum == 0) {
            return "-";
        }
        return StringUtil.concat(String.valueOf(itemNum), " ", ItemTable.getInstance().getTemplate(itemId).getName());
    }

    public static void sysMsgToAllParticipants(String message) {
        for (L2PcInstance playerInstance : _teams[0].getParticipatedPlayers().values()) {
            if (playerInstance == null) continue;
            playerInstance.sendMessage(message);
        }
        for (L2PcInstance playerInstance : _teams[1].getParticipatedPlayers().values()) {
            if (playerInstance == null) continue;
            playerInstance.sendMessage(message);
        }
    }

    private static L2DoorInstance getDoor(int doorId) {
        L2DoorInstance door = null;
        if (_TvTEventInstance <= 0) {
            door = DoorTable.getInstance().getDoor(doorId);
        } else {
            Instance inst = InstanceManager.getInstance().getInstance(_TvTEventInstance);
            if (inst != null) {
                door = inst.getDoor(doorId);
            }
        }
        return door;
    }

    private static void closeDoors(List<Integer> doors) {
        for (int doorId : doors) {
            L2DoorInstance doorInstance = TvTEvent.getDoor(doorId);
            if (doorInstance == null) continue;
            doorInstance.closeMe();
        }
    }

    private static void openDoors(List<Integer> doors) {
        for (int doorId : doors) {
            L2DoorInstance doorInstance = TvTEvent.getDoor(doorId);
            if (doorInstance == null) continue;
            doorInstance.openMe();
        }
    }

    private static void unSpawnNpc() {
        _lastNpcSpawn.deleteMe();
        SpawnTable.getInstance().deleteSpawn(_lastNpcSpawn.getSpawn(), false);
        _npcSpawn.stopRespawn();
        _npcSpawn = null;
        _lastNpcSpawn = null;
    }

    public static void onLogin(L2PcInstance playerInstance) {
        if (playerInstance == null || !TvTEvent.isStarting() && !TvTEvent.isStarted()) {
            return;
        }
        byte teamId = TvTEvent.getParticipantTeamId(playerInstance.getObjectId());
        if (teamId == -1) {
            return;
        }
        _teams[teamId].addPlayer(playerInstance);
        new TvTEventTeleporter(playerInstance, _teams[teamId].getCoordinates(), true, false);
    }

    public static void onLogout(L2PcInstance playerInstance) {
        if (playerInstance != null && (TvTEvent.isStarting() || TvTEvent.isStarted() || TvTEvent.isParticipating()) && TvTEvent.removeParticipant(playerInstance.getObjectId())) {
            playerInstance.setXYZInvisible(Config.TVT_EVENT_PARTICIPATION_NPC_COORDINATES[0] + Rnd.get(101) - 50, Config.TVT_EVENT_PARTICIPATION_NPC_COORDINATES[1] + Rnd.get(101) - 50, Config.TVT_EVENT_PARTICIPATION_NPC_COORDINATES[2]);
        }
    }

    public static boolean onAction(L2PcInstance playerInstance, int targetedPlayerObjectId) {
        if (playerInstance == null || !TvTEvent.isStarted()) {
            return true;
        }
        if (playerInstance.isGM()) {
            return true;
        }
        byte playerTeamId = TvTEvent.getParticipantTeamId(playerInstance.getObjectId());
        byte targetedPlayerTeamId = TvTEvent.getParticipantTeamId(targetedPlayerObjectId);
        if (playerTeamId != -1 && targetedPlayerTeamId == -1 || playerTeamId == -1 && targetedPlayerTeamId != -1) {
            return false;
        }
        return playerTeamId == -1 || targetedPlayerTeamId == -1 || playerTeamId != targetedPlayerTeamId || playerInstance.getObjectId() == targetedPlayerObjectId || Config.TVT_EVENT_TARGET_TEAM_MEMBERS_ALLOWED;
    }

    public static boolean onScrollUse(int playerObjectId) {
        if (!TvTEvent.isStarted()) {
            return true;
        }
        return !TvTEvent.isPlayerParticipant(playerObjectId) || Config.TVT_EVENT_SCROLL_ALLOWED;
    }

    public static boolean onPotionUse(int playerObjectId) {
        if (!TvTEvent.isStarted()) {
            return true;
        }
        return !TvTEvent.isPlayerParticipant(playerObjectId) || Config.TVT_EVENT_POTIONS_ALLOWED;
    }

    public static boolean onEscapeUse(int playerObjectId) {
        if (!TvTEvent.isStarted()) {
            return true;
        }
        return !TvTEvent.isPlayerParticipant(playerObjectId);
    }

    public static boolean onItemSummon(int playerObjectId) {
        if (!TvTEvent.isStarted()) {
            return true;
        }
        return !TvTEvent.isPlayerParticipant(playerObjectId) || Config.TVT_EVENT_SUMMON_BY_ITEM_ALLOWED;
    }

    public static void onKill(L2Character killerCharacter, L2PcInstance killedPlayerInstance) {
        byte killerTeamId;
        if (killedPlayerInstance == null || !TvTEvent.isStarted()) {
            return;
        }
        byte killedTeamId = TvTEvent.getParticipantTeamId(killedPlayerInstance.getObjectId());
        if (killedTeamId == -1) {
            return;
        }
        new TvTEventTeleporter(killedPlayerInstance, _teams[killedTeamId].getCoordinates(), false, false);
        if (killerCharacter == null) {
            return;
        }
        L2PcInstance killerPlayerInstance = null;
        if (killerCharacter instanceof L2PetInstance || killerCharacter instanceof L2ServitorInstance) {
            killerPlayerInstance = ((L2Summon)killerCharacter).getOwner();
            if (killerPlayerInstance == null) {
                return;
            }
        } else if (killerCharacter instanceof L2PcInstance) {
            killerPlayerInstance = (L2PcInstance)killerCharacter;
        } else {
            return;
        }
        if ((killerTeamId = TvTEvent.getParticipantTeamId(killerPlayerInstance.getObjectId())) != -1 && killedTeamId != -1 && killerTeamId != killedTeamId) {
            TvTEventTeam killerTeam = _teams[killerTeamId];
            killerTeam.increasePoints();
            CreatureSay cs = new CreatureSay(killerPlayerInstance.getObjectId(), 2, killerPlayerInstance.getName(), killedPlayerInstance.getName() + " \u3092\u5012\u3057\u305f\uff01");
            for (L2PcInstance playerInstance : _teams[killerTeamId].getParticipatedPlayers().values()) {
                if (playerInstance == null) continue;
                playerInstance.sendPacket(cs);
            }
            EventDispatcher.getInstance().notifyEventAsync(new OnTvTEventKill(killerPlayerInstance, killedPlayerInstance, killerTeam), new ListenersContainer[0]);
        }
    }

    public static void onTeleported(L2PcInstance playerInstance) {
        block5: {
            block4: {
                if (!TvTEvent.isStarted() || playerInstance == null || !TvTEvent.isPlayerParticipant(playerInstance.getObjectId())) {
                    return;
                }
                if (!playerInstance.isMageClass()) break block4;
                if (Config.TVT_EVENT_MAGE_BUFFS == null || Config.TVT_EVENT_MAGE_BUFFS.isEmpty()) break block5;
                for (Map.Entry<Integer, Integer> e : Config.TVT_EVENT_MAGE_BUFFS.entrySet()) {
                    Skill skill = SkillData.getInstance().getSkill(e.getKey(), e.getValue());
                    if (skill == null) continue;
                    skill.applyEffects(playerInstance, playerInstance);
                }
                break block5;
            }
            if (Config.TVT_EVENT_FIGHTER_BUFFS != null && !Config.TVT_EVENT_FIGHTER_BUFFS.isEmpty()) {
                for (Map.Entry<Integer, Integer> e : Config.TVT_EVENT_FIGHTER_BUFFS.entrySet()) {
                    Skill skill = SkillData.getInstance().getSkill(e.getKey(), e.getValue());
                    if (skill == null) continue;
                    skill.applyEffects(playerInstance, playerInstance);
                }
            }
        }
    }

    public static final boolean checkForTvTSkill(L2PcInstance source, L2PcInstance target, Skill skill) {
        if (!TvTEvent.isStarted()) {
            return true;
        }
        int sourcePlayerId = source.getObjectId();
        int targetPlayerId = target.getObjectId();
        boolean isSourceParticipant = TvTEvent.isPlayerParticipant(sourcePlayerId);
        boolean isTargetParticipant = TvTEvent.isPlayerParticipant(targetPlayerId);
        if (!isSourceParticipant && !isTargetParticipant) {
            return true;
        }
        if (!isSourceParticipant || !isTargetParticipant) {
            return false;
        }
        return TvTEvent.getParticipantTeamId(sourcePlayerId) == TvTEvent.getParticipantTeamId(targetPlayerId) || skill.isBad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setState(EventState state) {
        EventState eventState = _state;
        synchronized (eventState) {
            _state = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInactive() {
        boolean isInactive;
        EventState eventState = _state;
        synchronized (eventState) {
            isInactive = _state == EventState.INACTIVE;
        }
        return isInactive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInactivating() {
        boolean isInactivating;
        EventState eventState = _state;
        synchronized (eventState) {
            isInactivating = _state == EventState.INACTIVATING;
        }
        return isInactivating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isParticipating() {
        boolean isParticipating;
        EventState eventState = _state;
        synchronized (eventState) {
            isParticipating = _state == EventState.PARTICIPATING;
        }
        return isParticipating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isStarting() {
        boolean isStarting;
        EventState eventState = _state;
        synchronized (eventState) {
            isStarting = _state == EventState.STARTING;
        }
        return isStarting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isStarted() {
        boolean isStarted;
        EventState eventState = _state;
        synchronized (eventState) {
            isStarted = _state == EventState.STARTED;
        }
        return isStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRewarding() {
        boolean isRewarding;
        EventState eventState = _state;
        synchronized (eventState) {
            isRewarding = _state == EventState.REWARDING;
        }
        return isRewarding;
    }

    public static byte getParticipantTeamId(int playerObjectId) {
        return (byte)(_teams[0].containsPlayer(playerObjectId) ? 0 : (_teams[1].containsPlayer(playerObjectId) ? 1 : -1));
    }

    public static TvTEventTeam getParticipantTeam(int playerObjectId) {
        return _teams[0].containsPlayer(playerObjectId) ? _teams[0] : (_teams[1].containsPlayer(playerObjectId) ? _teams[1] : null);
    }

    public static TvTEventTeam getParticipantEnemyTeam(int playerObjectId) {
        return _teams[0].containsPlayer(playerObjectId) ? _teams[1] : (_teams[1].containsPlayer(playerObjectId) ? _teams[0] : null);
    }

    public static int[] getParticipantTeamCoordinates(int playerObjectId) {
        return _teams[0].containsPlayer(playerObjectId) ? _teams[0].getCoordinates() : (int[])(_teams[1].containsPlayer(playerObjectId) ? _teams[1].getCoordinates() : null);
    }

    public static boolean isPlayerParticipant(int playerObjectId) {
        if (!(TvTEvent.isParticipating() || TvTEvent.isStarting() || TvTEvent.isStarted())) {
            return false;
        }
        return _teams[0].containsPlayer(playerObjectId) || _teams[1].containsPlayer(playerObjectId);
    }

    public static int getParticipatedPlayersCount() {
        if (!(TvTEvent.isParticipating() || TvTEvent.isStarting() || TvTEvent.isStarted())) {
            return 0;
        }
        return _teams[0].getParticipatedPlayerCount() + _teams[1].getParticipatedPlayerCount();
    }

    public static String[] getTeamNames() {
        return new String[]{_teams[0].getName(), _teams[1].getName()};
    }

    public static int[] getTeamsPlayerCounts() {
        return new int[]{_teams[0].getParticipatedPlayerCount(), _teams[1].getParticipatedPlayerCount()};
    }

    public static int[] getTeamsPoints() {
        return new int[]{_teams[0].getPoints(), _teams[1].getPoints()};
    }

    public static int getTvTEventInstance() {
        return _TvTEventInstance;
    }

    static enum EventState {
        INACTIVE,
        INACTIVATING,
        PARTICIPATING,
        STARTING,
        STARTED,
        REWARDING;

    }
}

