/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity.clanhall;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.instancemanager.CHSiegeManager;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2SiegeClan;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.entity.Siegable;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.model.entity.clanhall.SiegeStatus;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public abstract class ClanHallSiegeEngine
extends Quest
implements Siegable {
    private static final String SQL_LOAD_ATTACKERS = "SELECT attacker_id FROM clanhall_siege_attackers WHERE clanhall_id = ?";
    private static final String SQL_SAVE_ATTACKERS = "INSERT INTO clanhall_siege_attackers VALUES (?,?)";
    private static final String SQL_LOAD_GUARDS = "SELECT * FROM clanhall_siege_guards WHERE clanHallId = ?";
    public static final int FORTRESS_RESSISTANCE = 21;
    public static final int DEVASTATED_CASTLE = 34;
    public static final int BANDIT_STRONGHOLD = 35;
    public static final int RAINBOW_SPRINGS = 62;
    public static final int BEAST_FARM = 63;
    public static final int FORTRESS_OF_DEAD = 64;
    protected final Logger _log;
    private final FastMap<Integer, L2SiegeClan> _attackers = new FastMap();
    private FastList<L2Spawn> _guards;
    public SiegableHall _hall;
    public ScheduledFuture<?> _siegeTask;
    public boolean _missionAccomplished = false;

    public ClanHallSiegeEngine(String name, String descr, int hallId) {
        super(-1, name, descr);
        this._log = Logger.getLogger(this.getClass().getName());
        this._hall = CHSiegeManager.getInstance().getSiegableHall(hallId);
        this._hall.setSiege(this);
        this._siegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new PrepareOwner(), this._hall.getNextSiegeTime() - System.currentTimeMillis() - 3600000L);
        this._log.config(this._hall.getName() + " siege scheduled for: " + SiegableHall.dateFormat(this.getSiegeDate()));
        this.loadAttackers();
    }

    public void loadAttackers() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(SQL_LOAD_ATTACKERS);){
            statement.setInt(1, this._hall.getId());
            try (ResultSet rset = statement.executeQuery();){
                while (rset.next()) {
                    int id = rset.getInt("attacker_id");
                    L2SiegeClan clan = new L2SiegeClan(id, L2SiegeClan.SiegeClanType.ATTACKER);
                    this._attackers.put((Object)id, (Object)clan);
                }
            }
        }
        catch (Exception e) {
            this._log.warning(this.getName() + ": Could not load siege attackers!:");
        }
    }

    public final void saveAttackers() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement delStatement = con.prepareStatement("DELETE FROM clanhall_siege_attackers WHERE clanhall_id = ?");){
            delStatement.setInt(1, this._hall.getId());
            delStatement.execute();
            if (this.getAttackers().size() > 0) {
                try (PreparedStatement insert = con.prepareStatement(SQL_SAVE_ATTACKERS);){
                    for (L2SiegeClan clan : this.getAttackers().values()) {
                        insert.setInt(1, this._hall.getId());
                        insert.setInt(2, clan.getClanId());
                        insert.execute();
                        insert.clearParameters();
                    }
                }
            }
            this._log.config(this.getName() + ": Sucessfully saved attackers down to database!");
        }
        catch (Exception e) {
            this._log.warning(this.getName() + ": Couldnt save attacker list!");
        }
    }

    public final void loadGuards() {
        if (this._guards == null) {
            this._guards = new FastList();
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement statement = con.prepareStatement(SQL_LOAD_GUARDS);){
                statement.setInt(1, this._hall.getId());
                try (ResultSet rset = statement.executeQuery();){
                    while (rset.next()) {
                        int npcId = rset.getInt("npcId");
                        L2NpcTemplate template = NpcData.getInstance().getTemplate(npcId);
                        L2Spawn spawn = new L2Spawn(template);
                        spawn.setX(rset.getInt("x"));
                        spawn.setY(rset.getInt("y"));
                        spawn.setZ(rset.getInt("z"));
                        spawn.setHeading(rset.getInt("heading"));
                        spawn.setRespawnDelay(rset.getInt("respawnDelay"));
                        spawn.setAmount(1);
                        this._guards.add((Object)spawn);
                    }
                }
            }
            catch (Exception e) {
                this._log.warning(this.getName() + ": Couldnt load siege guards!:");
            }
        }
    }

    private final void spawnSiegeGuards() {
        for (L2Spawn guard : this._guards) {
            if (guard == null) continue;
            guard.init();
        }
    }

    private final void unSpawnSiegeGuards() {
        if (this._guards != null && this._guards.size() > 0) {
            for (L2Spawn guard : this._guards) {
                if (guard == null) continue;
                guard.stopRespawn();
                guard.getLastSpawn().deleteMe();
            }
        }
    }

    @Override
    public List<L2Npc> getFlag(L2Clan clan) {
        List<L2Npc> result = null;
        L2SiegeClan sClan = this.getAttackerClan(clan);
        if (sClan != null) {
            result = sClan.getFlag();
        }
        return result;
    }

    public final FastMap<Integer, L2SiegeClan> getAttackers() {
        return this._attackers;
    }

    @Override
    public boolean checkIsAttacker(L2Clan clan) {
        if (clan == null) {
            return false;
        }
        return this._attackers.containsKey((Object)clan.getId());
    }

    @Override
    public boolean checkIsDefender(L2Clan clan) {
        return false;
    }

    @Override
    public L2SiegeClan getAttackerClan(int clanId) {
        return (L2SiegeClan)this._attackers.get((Object)clanId);
    }

    @Override
    public L2SiegeClan getAttackerClan(L2Clan clan) {
        return this.getAttackerClan(clan.getId());
    }

    @Override
    public List<L2SiegeClan> getAttackerClans() {
        FastList result = new FastList();
        result.addAll(this._attackers.values());
        return result;
    }

    @Override
    public List<L2PcInstance> getAttackersInZone() {
        List<L2PcInstance> list = this._hall.getSiegeZone().getPlayersInside();
        FastList attackers = new FastList();
        for (L2PcInstance pc : list) {
            L2Clan clan = pc.getClan();
            if (clan == null || !this.getAttackers().containsKey((Object)clan.getId())) continue;
            attackers.add(pc);
        }
        return attackers;
    }

    @Override
    public L2SiegeClan getDefenderClan(int clanId) {
        return null;
    }

    @Override
    public L2SiegeClan getDefenderClan(L2Clan clan) {
        return null;
    }

    @Override
    public List<L2SiegeClan> getDefenderClans() {
        return null;
    }

    public void prepareOwner() {
        if (this._hall.getOwnerId() > 0) {
            L2SiegeClan clan = new L2SiegeClan(this._hall.getOwnerId(), L2SiegeClan.SiegeClanType.ATTACKER);
            this.getAttackers().put((Object)clan.getClanId(), (Object)new L2SiegeClan(clan.getClanId(), L2SiegeClan.SiegeClanType.ATTACKER));
        }
        this._hall.free();
        this._hall.banishForeigners();
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.REGISTRATION_TERM_FOR_S1_ENDED);
        msg.addSiegableHallName(this._hall);
        Announcements.getInstance().announceToAll(msg);
        this._hall.updateSiegeStatus(SiegeStatus.WAITING_BATTLE);
        this._siegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new SiegeStarts(), 3600000L);
    }

    @Override
    public void startSiege() {
        if (this.getAttackers().size() < 1 && this._hall.getId() != 21) {
            this.onSiegeEnds();
            this.getAttackers().clear();
            this._hall.updateNextSiege();
            this._siegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new PrepareOwner(), this._hall.getSiegeDate().getTimeInMillis());
            this._hall.updateSiegeStatus(SiegeStatus.WAITING_BATTLE);
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.SIEGE_OF_S1_HAS_BEEN_CANCELED_DUE_TO_LACK_OF_INTEREST);
            sm.addSiegableHallName(this._hall);
            Announcements.getInstance().announceToAll(sm);
            return;
        }
        this._hall.spawnDoor();
        this.loadGuards();
        this.spawnSiegeGuards();
        this._hall.updateSiegeZone(true);
        boolean state = true;
        for (L2SiegeClan sClan : this.getAttackerClans()) {
            L2Clan clan = ClanTable.getInstance().getClan(sClan.getClanId());
            if (clan == null) continue;
            for (L2PcInstance pc : clan.getOnlineMembers(0)) {
                if (pc == null) continue;
                pc.setSiegeState((byte)1);
                pc.broadcastUserInfo();
                pc.setIsInHideoutSiege(true);
            }
        }
        this._hall.updateSiegeStatus(SiegeStatus.RUNNING);
        this.onSiegeStarts();
        this._siegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new SiegeEnds(), this._hall.getSiegeLenght());
    }

    @Override
    public void endSiege() {
        SystemMessage end = SystemMessage.getSystemMessage(SystemMessageId.SIEGE_OF_S1_HAS_ENDED);
        end.addSiegableHallName(this._hall);
        Announcements.getInstance().announceToAll(end);
        L2Clan winner = this.getWinner();
        SystemMessage finalMsg = null;
        if (this._missionAccomplished && winner != null) {
            this._hall.setOwner(winner);
            winner.setHideoutId(this._hall.getId());
            finalMsg = SystemMessage.getSystemMessage(SystemMessageId.CLAN_S1_VICTORIOUS_OVER_S2_S_SIEGE);
            finalMsg.addString(winner.getName());
            finalMsg.addSiegableHallName(this._hall);
            Announcements.getInstance().announceToAll(finalMsg);
        } else {
            finalMsg = SystemMessage.getSystemMessage(SystemMessageId.SIEGE_S1_DRAW);
            finalMsg.addSiegableHallName(this._hall);
            Announcements.getInstance().announceToAll(finalMsg);
        }
        this._missionAccomplished = false;
        this._hall.updateSiegeZone(false);
        this._hall.updateNextSiege();
        this._hall.spawnDoor(false);
        this._hall.banishForeigners();
        boolean state = false;
        for (L2SiegeClan sClan : this.getAttackerClans()) {
            L2Clan clan = ClanTable.getInstance().getClan(sClan.getClanId());
            if (clan == null) continue;
            for (L2PcInstance player : clan.getOnlineMembers(0)) {
                player.setSiegeState((byte)0);
                player.broadcastUserInfo();
                player.setIsInHideoutSiege(false);
            }
        }
        for (L2Character chr : this._hall.getSiegeZone().getCharactersInside()) {
            if (chr == null || !chr.isPlayer()) continue;
            chr.getActingPlayer().startPvPFlag();
        }
        this.getAttackers().clear();
        this.onSiegeEnds();
        this._siegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new PrepareOwner(), this._hall.getNextSiegeTime() - System.currentTimeMillis() - 3600000L);
        this._log.config("Siege of " + this._hall.getName() + " scheduled for: " + SiegableHall.dateFormat(this._hall.getSiegeDate()));
        this._hall.updateSiegeStatus(SiegeStatus.REGISTERING);
        this.unSpawnSiegeGuards();
    }

    @Override
    public void updateSiege() {
        this.cancelSiegeTask();
        this._siegeTask = ThreadPoolManager.getInstance().scheduleGeneral(new PrepareOwner(), this._hall.getNextSiegeTime() - 3600000L);
        this._log.config(this._hall.getName() + " siege scheduled for: " + SiegableHall.dateFormat(this._hall.getSiegeDate()));
    }

    public void cancelSiegeTask() {
        if (this._siegeTask != null) {
            this._siegeTask.cancel(false);
        }
    }

    @Override
    public Calendar getSiegeDate() {
        return this._hall.getSiegeDate();
    }

    @Override
    public boolean giveFame() {
        return Config.CHS_ENABLE_FAME;
    }

    @Override
    public int getFameAmount() {
        return Config.CHS_FAME_AMOUNT;
    }

    @Override
    public int getFameFrequency() {
        return Config.CHS_FAME_FREQUENCY;
    }

    public final void broadcastNpcSay(L2Npc npc, int type, NpcStringId messageId) {
        NpcSay npcSay = new NpcSay(npc.getObjectId(), type, npc.getId(), messageId);
        int sourceRegion = MapRegionManager.getInstance().getMapRegionLocId(npc);
        for (L2PcInstance pc : L2World.getInstance().getPlayers()) {
            if (pc == null || MapRegionManager.getInstance().getMapRegionLocId(pc) != sourceRegion) continue;
            pc.sendPacket(npcSay);
        }
    }

    public Location getInnerSpawnLoc(L2PcInstance player) {
        return null;
    }

    public boolean canPlantFlag() {
        return true;
    }

    public boolean doorIsAutoAttackable() {
        return true;
    }

    public void onSiegeStarts() {
    }

    public void onSiegeEnds() {
    }

    public abstract L2Clan getWinner();

    public class SiegeEnds
    implements Runnable {
        @Override
        public void run() {
            ClanHallSiegeEngine.this.endSiege();
        }
    }

    public class SiegeStarts
    implements Runnable {
        @Override
        public void run() {
            ClanHallSiegeEngine.this.startSiege();
        }
    }

    public class PrepareOwner
    implements Runnable {
        @Override
        public void run() {
            ClanHallSiegeEngine.this.prepareOwner();
        }
    }
}

