/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.events;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.enums.QuestSound;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TrapInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.model.events.Containers;
import com.l2jserver.gameserver.model.events.EventType;
import com.l2jserver.gameserver.model.events.ListenerRegisterType;
import com.l2jserver.gameserver.model.events.ListenersContainer;
import com.l2jserver.gameserver.model.events.annotations.Id;
import com.l2jserver.gameserver.model.events.annotations.Ids;
import com.l2jserver.gameserver.model.events.annotations.NpcLevelRange;
import com.l2jserver.gameserver.model.events.annotations.NpcLevelRanges;
import com.l2jserver.gameserver.model.events.annotations.Priority;
import com.l2jserver.gameserver.model.events.annotations.Range;
import com.l2jserver.gameserver.model.events.annotations.Ranges;
import com.l2jserver.gameserver.model.events.annotations.RegisterEvent;
import com.l2jserver.gameserver.model.events.annotations.RegisterType;
import com.l2jserver.gameserver.model.events.impl.IBaseEvent;
import com.l2jserver.gameserver.model.events.impl.character.OnCreatureKill;
import com.l2jserver.gameserver.model.events.impl.character.OnCreatureZoneEnter;
import com.l2jserver.gameserver.model.events.impl.character.OnCreatureZoneExit;
import com.l2jserver.gameserver.model.events.impl.character.npc.OnNpcCanBeSeen;
import com.l2jserver.gameserver.model.events.impl.character.npc.OnNpcCreatureSee;
import com.l2jserver.gameserver.model.events.impl.character.npc.OnNpcEventReceived;
import com.l2jserver.gameserver.model.events.impl.character.npc.OnNpcFirstTalk;
import com.l2jserver.gameserver.model.events.impl.character.npc.OnNpcMoveFinished;
import com.l2jserver.gameserver.model.events.impl.character.npc.OnNpcMoveNodeArrived;
import com.l2jserver.gameserver.model.events.impl.character.npc.OnNpcMoveRouteFinished;
import com.l2jserver.gameserver.model.events.impl.character.npc.OnNpcSkillFinished;
import com.l2jserver.gameserver.model.events.impl.character.npc.OnNpcSkillSee;
import com.l2jserver.gameserver.model.events.impl.character.npc.OnNpcSpawn;
import com.l2jserver.gameserver.model.events.impl.character.npc.OnNpcTeleport;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.OnAttackableAggroRangeEnter;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.OnAttackableAttack;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.OnAttackableFactionCall;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.OnAttackableHate;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.OnAttackableKill;
import com.l2jserver.gameserver.model.events.impl.character.player.OnPlayerLogin;
import com.l2jserver.gameserver.model.events.impl.character.player.OnPlayerLogout;
import com.l2jserver.gameserver.model.events.impl.character.player.OnPlayerProfessionChange;
import com.l2jserver.gameserver.model.events.impl.character.player.OnPlayerSkillLearn;
import com.l2jserver.gameserver.model.events.impl.character.player.OnPlayerSummonSpawn;
import com.l2jserver.gameserver.model.events.impl.character.player.OnPlayerSummonTalk;
import com.l2jserver.gameserver.model.events.impl.character.trap.OnTrapAction;
import com.l2jserver.gameserver.model.events.impl.item.OnItemBypassEvent;
import com.l2jserver.gameserver.model.events.impl.item.OnItemTalk;
import com.l2jserver.gameserver.model.events.impl.olympiad.OnOlympiadMatchResult;
import com.l2jserver.gameserver.model.events.impl.sieges.castle.OnCastleSiegeFinish;
import com.l2jserver.gameserver.model.events.impl.sieges.castle.OnCastleSiegeOwnerChange;
import com.l2jserver.gameserver.model.events.impl.sieges.castle.OnCastleSiegeStart;
import com.l2jserver.gameserver.model.events.listeners.AbstractEventListener;
import com.l2jserver.gameserver.model.events.listeners.AnnotationEventListener;
import com.l2jserver.gameserver.model.events.listeners.ConsumerEventListener;
import com.l2jserver.gameserver.model.events.listeners.DummyEventListener;
import com.l2jserver.gameserver.model.events.listeners.FunctionEventListener;
import com.l2jserver.gameserver.model.events.listeners.RunnableEventListener;
import com.l2jserver.gameserver.model.events.returns.AbstractEventReturn;
import com.l2jserver.gameserver.model.events.returns.TerminateReturn;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.olympiad.Olympiad;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExShowScreenMessage;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.SpecialCamera;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.scripting.ManagedScript;
import com.l2jserver.gameserver.util.MinionList;
import com.l2jserver.util.Rnd;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastSet;

public abstract class AbstractScript
extends ManagedScript {
    private static final boolean CHECK_TAKEITEMS = true;
    protected static final Logger _log = Logger.getLogger(AbstractScript.class.getName());
    private final ConcurrentHashMap<ListenerRegisterType, FastSet<Integer>> _registeredIds = new ConcurrentHashMap();
    private final FastList<AbstractEventListener> _listeners = new FastList().shared();

    public AbstractScript() {
        this.initializeAnnotationListeners();
    }

    private void initializeAnnotationListeners() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (Method method : this.getClass().getMethods()) {
            if (!method.isAnnotationPresent(RegisterEvent.class) || !method.isAnnotationPresent(RegisterType.class)) continue;
            RegisterEvent listener = method.getAnnotation(RegisterEvent.class);
            RegisterType regType = method.getAnnotation(RegisterType.class);
            ListenerRegisterType type = regType.value();
            EventType eventType = listener.value();
            if (method.getParameterCount() != 1) {
                _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Non properly defined annotation listener on method: " + method.getName() + " expected parameter count is 1 but found: " + method.getParameterCount());
                continue;
            }
            if (!eventType.isEventClass(method.getParameterTypes()[0])) {
                _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Non properly defined annotation listener on method: " + method.getName() + " expected parameter to be type of: " + eventType.getEventClass().getSimpleName() + " but found: " + method.getParameterTypes()[0].getSimpleName());
                continue;
            }
            if (!eventType.isReturnClass(method.getReturnType())) {
                _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Non properly defined annotation listener on method: " + method.getName() + " expected return type to be one of: " + Arrays.toString(eventType.getReturnClasses()) + " but found: " + method.getReturnType().getSimpleName());
                continue;
            }
            int priority = 0;
            ids.clear();
            for (Annotation annotation : method.getAnnotations()) {
                Annotation ranges;
                Annotation range;
                if (annotation instanceof Id) {
                    Id npc = (Id)annotation;
                    for (int id : npc.value()) {
                        ids.add(id);
                    }
                    continue;
                }
                if (annotation instanceof Ids) {
                    Ids npcs = (Ids)annotation;
                    for (Id npc : npcs.value()) {
                        for (int id : npc.value()) {
                            ids.add(id);
                        }
                    }
                    continue;
                }
                if (annotation instanceof Range) {
                    range = (Range)annotation;
                    if (range.from() > range.to()) {
                        _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Wrong " + annotation.getClass().getSimpleName() + " from is higher then to!");
                        continue;
                    }
                    for (int id = range.from(); id <= range.to(); ++id) {
                        ids.add(id);
                    }
                    continue;
                }
                if (annotation instanceof Ranges) {
                    ranges = (Ranges)annotation;
                    for (Range range2 : ranges.value()) {
                        if (range2.from() > range2.to()) {
                            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Wrong " + annotation.getClass().getSimpleName() + " from is higher then to!");
                            continue;
                        }
                        for (int id = range2.from(); id <= range2.to(); ++id) {
                            ids.add(id);
                        }
                    }
                    continue;
                }
                if (annotation instanceof NpcLevelRange) {
                    range = (NpcLevelRange)annotation;
                    if (range.from() > range.to()) {
                        _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Wrong " + annotation.getClass().getSimpleName() + " from is higher then to!");
                        continue;
                    }
                    if (type != ListenerRegisterType.NPC) {
                        _log.log(Level.WARNING, this.getClass().getSimpleName() + ": ListenerRegisterType " + (Object)((Object)type) + " for " + annotation.getClass().getSimpleName() + " NPC is expected!");
                        continue;
                    }
                    for (int level = range.from(); level <= range.to(); ++level) {
                        List<L2NpcTemplate> templates = NpcData.getInstance().getAllOfLevel(level);
                        templates.forEach(template -> ids.add(template.getId()));
                    }
                    continue;
                }
                if (annotation instanceof NpcLevelRanges) {
                    ranges = (NpcLevelRanges)annotation;
                    for (NpcLevelRange range3 : ranges.value()) {
                        if (range3.from() > range3.to()) {
                            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Wrong " + annotation.getClass().getSimpleName() + " from is higher then to!");
                            continue;
                        }
                        if (type != ListenerRegisterType.NPC) {
                            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": ListenerRegisterType " + (Object)((Object)type) + " for " + annotation.getClass().getSimpleName() + " NPC is expected!");
                            continue;
                        }
                        for (int level = range3.from(); level <= range3.to(); ++level) {
                            List<L2NpcTemplate> templates = NpcData.getInstance().getAllOfLevel(level);
                            templates.forEach(template -> ids.add(template.getId()));
                        }
                    }
                    continue;
                }
                if (!(annotation instanceof Priority)) continue;
                Priority p = (Priority)annotation;
                priority = p.value();
            }
            if (!ids.isEmpty()) {
                this._registeredIds.computeIfAbsent(ListenerRegisterType.NPC, v -> new FastSet().shared()).addAll(ids);
            }
            this.registerAnnotation(method, eventType, type, priority, ids);
        }
    }

    @Override
    public boolean unload() {
        this._listeners.forEach(AbstractEventListener::unregisterMe);
        this._listeners.clear();
        return true;
    }

    protected final List<AbstractEventListener> setAttackableKillId(Consumer<OnAttackableKill> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_ATTACKABLE_KILL, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setAttackableKillId(Consumer<OnAttackableKill> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_ATTACKABLE_KILL, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> addCreatureKillId(Function<OnCreatureKill, ? extends AbstractEventReturn> callback, int ... npcIds) {
        return this.registerFunction(callback, EventType.ON_CREATURE_KILL, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setCreatureKillId(Consumer<OnCreatureKill> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_CREATURE_KILL, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setCreatureKillId(Consumer<OnCreatureKill> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_CREATURE_KILL, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcFirstTalkId(Consumer<OnNpcFirstTalk> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_NPC_FIRST_TALK, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcFirstTalkId(Consumer<OnNpcFirstTalk> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_NPC_FIRST_TALK, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcTalkId(Collection<Integer> npcIds) {
        return this.registerDummy(EventType.ON_NPC_TALK, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcTalkId(int ... npcIds) {
        return this.registerDummy(EventType.ON_NPC_TALK, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcTeleportId(Consumer<OnNpcTeleport> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_NPC_TELEPORT, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcTeleportId(Consumer<OnNpcTeleport> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_NPC_TELEPORT, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcQuestStartId(int ... npcIds) {
        return this.registerDummy(EventType.ON_NPC_QUEST_START, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcQuestStartId(Collection<Integer> npcIds) {
        return this.registerDummy(EventType.ON_NPC_QUEST_START, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcSkillSeeId(Consumer<OnNpcSkillSee> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_NPC_SKILL_SEE, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcSkillSeeId(Consumer<OnNpcSkillSee> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_NPC_SKILL_SEE, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcSkillFinishedId(Consumer<OnNpcSkillFinished> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_NPC_SKILL_FINISHED, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcSkillFinishedId(Consumer<OnNpcSkillFinished> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_NPC_SKILL_FINISHED, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcSpawnId(Consumer<OnNpcSpawn> callback, int ... npcIds) {
        List<AbstractEventListener> r = this.registerConsumer(callback, EventType.ON_NPC_SPAWN, ListenerRegisterType.NPC, npcIds);
        for (int npcId : npcIds) {
            this.fix_onSpawn_for_SpawnTable(npcId);
        }
        return r;
    }

    protected final List<AbstractEventListener> setNpcSpawnId(Consumer<OnNpcSpawn> callback, Collection<Integer> npcIds) {
        List<AbstractEventListener> r = this.registerConsumer(callback, EventType.ON_NPC_SPAWN, ListenerRegisterType.NPC, npcIds);
        for (Integer npcId : npcIds) {
            this.fix_onSpawn_for_SpawnTable(npcId);
        }
        return r;
    }

    private final void fix_onSpawn_for_SpawnTable(int npcId) {
        Quest q = (Quest)this;
        for (L2Object o : L2World.getInstance().getVisibleObjects()) {
            if (!o.isNpc() || o.getId() != npcId) continue;
            q.onSpawn((L2Npc)o);
        }
    }

    protected final List<AbstractEventListener> setNpcEventReceivedId(Consumer<OnNpcEventReceived> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_NPC_EVENT_RECEIVED, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcEventReceivedId(Consumer<OnNpcEventReceived> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_NPC_EVENT_RECEIVED, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcMoveFinishedId(Consumer<OnNpcMoveFinished> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_NPC_MOVE_FINISHED, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcMoveFinishedId(Consumer<OnNpcMoveFinished> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_NPC_MOVE_FINISHED, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcMoveNodeArrivedId(Consumer<OnNpcMoveNodeArrived> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_NPC_MOVE_NODE_ARRIVED, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcMoveNodeArrivedId(Consumer<OnNpcMoveNodeArrived> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_NPC_MOVE_NODE_ARRIVED, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcMoveRouteFinishedId(Consumer<OnNpcMoveRouteFinished> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_NPC_MOVE_ROUTE_FINISHED, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcMoveRouteFinishedId(Consumer<OnNpcMoveRouteFinished> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_NPC_MOVE_ROUTE_FINISHED, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcHateId(Consumer<OnAttackableHate> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_NPC_HATE, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcHateId(Consumer<OnAttackableHate> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_NPC_HATE, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> addNpcHateId(Function<OnAttackableHate, TerminateReturn> callback, int ... npcIds) {
        return this.registerFunction(callback, EventType.ON_NPC_HATE, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> addNpcHateId(Function<OnAttackableHate, TerminateReturn> callback, Collection<Integer> npcIds) {
        return this.registerFunction(callback, EventType.ON_NPC_HATE, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcCanBeSeenId(Consumer<OnNpcCanBeSeen> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_NPC_CAN_BE_SEEN, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcCanBeSeenId(Consumer<OnNpcCanBeSeen> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_NPC_CAN_BE_SEEN, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcCanBeSeenId(Function<OnNpcCanBeSeen, TerminateReturn> callback, int ... npcIds) {
        return this.registerFunction(callback, EventType.ON_NPC_CAN_BE_SEEN, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcCanBeSeenId(Function<OnNpcCanBeSeen, TerminateReturn> callback, Collection<Integer> npcIds) {
        return this.registerFunction(callback, EventType.ON_NPC_CAN_BE_SEEN, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcCreatureSeeId(Consumer<OnNpcCreatureSee> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_NPC_CREATURE_SEE, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setNpcCreatureSeeId(Consumer<OnNpcCreatureSee> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_NPC_CREATURE_SEE, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setAttackableFactionIdId(Consumer<OnAttackableFactionCall> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_ATTACKABLE_FACTION_CALL, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setAttackableFactionIdId(Consumer<OnAttackableFactionCall> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_ATTACKABLE_FACTION_CALL, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setAttackableAttackId(Consumer<OnAttackableAttack> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_ATTACKABLE_ATTACK, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setAttackableAttackId(Consumer<OnAttackableAttack> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_ATTACKABLE_ATTACK, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setAttackableAggroRangeEnterId(Consumer<OnAttackableAggroRangeEnter> callback, int ... npcIds) {
        for (int i = 0; i < npcIds.length; ++i) {
            int npcId = npcIds[i];
            L2NpcTemplate t = NpcData.getInstance().getTemplate(npcId);
            if (t.getAggroRange() != 0) continue;
            _log.log(Level.WARNING, this.getScriptName() + ".addAggroRangeEnterId(" + npcId + ") - " + t.getName() + " aggro range is 0");
            npcIds[i] = 0;
        }
        return this.registerConsumer(callback, EventType.ON_ATTACKABLE_AGGRO_RANGE_ENTER, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setAttackableAggroRangeEnterId(Consumer<OnAttackableAggroRangeEnter> callback, Collection<Integer> npcIds) {
        int[] a = new int[npcIds.size()];
        int i = 0;
        for (Integer npcId : npcIds) {
            a[i] = npcId;
        }
        return this.setAttackableAggroRangeEnterId(callback, a);
    }

    protected final List<AbstractEventListener> setPlayerSkillLearnId(Consumer<OnPlayerSkillLearn> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_PLAYER_SKILL_LEARN, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setPlayerSkillLearnId(Consumer<OnPlayerSkillLearn> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_PLAYER_SKILL_LEARN, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setPlayerSummonSpawnId(Consumer<OnPlayerSummonSpawn> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_PLAYER_SUMMON_SPAWN, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setPlayerSummonSpawnId(Consumer<OnPlayerSummonSpawn> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_PLAYER_SUMMON_SPAWN, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setPlayerSummonTalkId(Consumer<OnPlayerSummonTalk> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_PLAYER_SUMMON_TALK, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setPlayerSummonTalkId(Consumer<OnPlayerSummonSpawn> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_PLAYER_SUMMON_TALK, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setPlayerLoginId(Consumer<OnPlayerLogin> callback) {
        return this.registerConsumer(callback, EventType.ON_PLAYER_LOGIN, ListenerRegisterType.GLOBAL, new int[0]);
    }

    protected final List<AbstractEventListener> setPlayerLogoutId(Consumer<OnPlayerLogout> callback) {
        return this.registerConsumer(callback, EventType.ON_PLAYER_LOGOUT, ListenerRegisterType.GLOBAL, new int[0]);
    }

    protected final List<AbstractEventListener> setCreatureZoneEnterId(Consumer<OnCreatureZoneEnter> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_CREATURE_ZONE_ENTER, ListenerRegisterType.ZONE, npcIds);
    }

    protected final List<AbstractEventListener> setCreatureZoneEnterId(Consumer<OnCreatureZoneEnter> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_CREATURE_ZONE_ENTER, ListenerRegisterType.ZONE, npcIds);
    }

    protected final List<AbstractEventListener> setCreatureZoneExitId(Consumer<OnCreatureZoneExit> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_CREATURE_ZONE_EXIT, ListenerRegisterType.ZONE, npcIds);
    }

    protected final List<AbstractEventListener> setCreatureZoneExitId(Consumer<OnCreatureZoneExit> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_CREATURE_ZONE_EXIT, ListenerRegisterType.ZONE, npcIds);
    }

    protected final List<AbstractEventListener> setTrapActionId(Consumer<OnTrapAction> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_TRAP_ACTION, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setTrapActionId(Consumer<OnTrapAction> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_TRAP_ACTION, ListenerRegisterType.NPC, npcIds);
    }

    protected final List<AbstractEventListener> setItemBypassEvenId(Consumer<OnItemBypassEvent> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_ITEM_BYPASS_EVENT, ListenerRegisterType.ITEM, npcIds);
    }

    protected final List<AbstractEventListener> setItemBypassEvenId(Consumer<OnItemBypassEvent> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_ITEM_BYPASS_EVENT, ListenerRegisterType.ITEM, npcIds);
    }

    protected final List<AbstractEventListener> setItemTalkId(Consumer<OnItemTalk> callback, int ... npcIds) {
        return this.registerConsumer(callback, EventType.ON_ITEM_TALK, ListenerRegisterType.ITEM, npcIds);
    }

    protected final List<AbstractEventListener> setItemTalkId(Consumer<OnItemTalk> callback, Collection<Integer> npcIds) {
        return this.registerConsumer(callback, EventType.ON_ITEM_TALK, ListenerRegisterType.ITEM, npcIds);
    }

    protected final List<AbstractEventListener> setOlympiadMatchResult(Consumer<OnOlympiadMatchResult> callback) {
        return this.registerConsumer(callback, EventType.ON_OLYMPIAD_MATCH_RESULT, ListenerRegisterType.OLYMPIAD, new int[0]);
    }

    protected final List<AbstractEventListener> setCastleSiegeStartId(Consumer<OnCastleSiegeStart> callback, int ... castleIds) {
        return this.registerConsumer(callback, EventType.ON_CASTLE_SIEGE_START, ListenerRegisterType.CASTLE, castleIds);
    }

    protected final List<AbstractEventListener> setCastleSiegeStartId(Consumer<OnCastleSiegeStart> callback, Collection<Integer> castleIds) {
        return this.registerConsumer(callback, EventType.ON_CASTLE_SIEGE_START, ListenerRegisterType.CASTLE, castleIds);
    }

    protected final List<AbstractEventListener> setCastleSiegeOwnerChangeId(Consumer<OnCastleSiegeOwnerChange> callback, int ... castleIds) {
        return this.registerConsumer(callback, EventType.ON_CASTLE_SIEGE_OWNER_CHANGE, ListenerRegisterType.CASTLE, castleIds);
    }

    protected final List<AbstractEventListener> setCastleSiegeOwnerChangeId(Consumer<OnCastleSiegeOwnerChange> callback, Collection<Integer> castleIds) {
        return this.registerConsumer(callback, EventType.ON_CASTLE_SIEGE_OWNER_CHANGE, ListenerRegisterType.CASTLE, castleIds);
    }

    protected final List<AbstractEventListener> setCastleSiegeFinishId(Consumer<OnCastleSiegeFinish> callback, int ... castleIds) {
        return this.registerConsumer(callback, EventType.ON_CASTLE_SIEGE_FINISH, ListenerRegisterType.CASTLE, castleIds);
    }

    protected final List<AbstractEventListener> setCastleSiegeFinishId(Consumer<OnCastleSiegeFinish> callback, Collection<Integer> castleIds) {
        return this.registerConsumer(callback, EventType.ON_CASTLE_SIEGE_FINISH, ListenerRegisterType.CASTLE, castleIds);
    }

    protected final List<AbstractEventListener> setPlayerProfessionChangeId(Consumer<OnPlayerProfessionChange> callback) {
        return this.registerConsumer(callback, EventType.ON_PLAYER_PROFESSION_CHANGE, ListenerRegisterType.GLOBAL, new int[0]);
    }

    protected final List<AbstractEventListener> registerConsumer(Consumer<? extends IBaseEvent> callback, EventType type, ListenerRegisterType registerType, int ... npcIds) {
        return this.registerListener((ListenersContainer container) -> new ConsumerEventListener((ListenersContainer)container, type, callback, this), registerType, npcIds);
    }

    protected final List<AbstractEventListener> registerConsumer(Consumer<? extends IBaseEvent> callback, EventType type, ListenerRegisterType registerType, Collection<Integer> npcIds) {
        return this.registerListener((ListenersContainer container) -> new ConsumerEventListener((ListenersContainer)container, type, callback, this), registerType, npcIds);
    }

    protected final List<AbstractEventListener> registerFunction(Function<? extends IBaseEvent, ? extends AbstractEventReturn> callback, EventType type, ListenerRegisterType registerType, int ... npcIds) {
        return this.registerListener((ListenersContainer container) -> new FunctionEventListener((ListenersContainer)container, type, callback, this), registerType, npcIds);
    }

    protected final List<AbstractEventListener> registerFunction(Function<? extends IBaseEvent, ? extends AbstractEventReturn> callback, EventType type, ListenerRegisterType registerType, Collection<Integer> npcIds) {
        return this.registerListener((ListenersContainer container) -> new FunctionEventListener((ListenersContainer)container, type, callback, this), registerType, npcIds);
    }

    protected final List<AbstractEventListener> registerRunnable(Runnable callback, EventType type, ListenerRegisterType registerType, int ... npcIds) {
        return this.registerListener((ListenersContainer container) -> new RunnableEventListener((ListenersContainer)container, type, callback, this), registerType, npcIds);
    }

    protected final List<AbstractEventListener> registerRunnable(Runnable callback, EventType type, ListenerRegisterType registerType, Collection<Integer> npcIds) {
        return this.registerListener((ListenersContainer container) -> new RunnableEventListener((ListenersContainer)container, type, callback, this), registerType, npcIds);
    }

    protected final List<AbstractEventListener> registerAnnotation(Method callback, EventType type, ListenerRegisterType registerType, int priority, int ... npcIds) {
        return this.registerListener((ListenersContainer container) -> new AnnotationEventListener((ListenersContainer)container, type, callback, this, priority), registerType, npcIds);
    }

    protected final List<AbstractEventListener> registerAnnotation(Method callback, EventType type, ListenerRegisterType registerType, int priority, Collection<Integer> npcIds) {
        return this.registerListener((ListenersContainer container) -> new AnnotationEventListener((ListenersContainer)container, type, callback, this, priority), registerType, npcIds);
    }

    protected final List<AbstractEventListener> registerDummy(EventType type, ListenerRegisterType registerType, int ... npcIds) {
        return this.registerListener((ListenersContainer container) -> new DummyEventListener((ListenersContainer)container, type, this), registerType, npcIds);
    }

    protected final List<AbstractEventListener> registerDummy(EventType type, ListenerRegisterType registerType, Collection<Integer> npcIds) {
        return this.registerListener((ListenersContainer container) -> new DummyEventListener((ListenersContainer)container, type, this), registerType, npcIds);
    }

    protected final List<AbstractEventListener> registerListener(Function<ListenersContainer, AbstractEventListener> action, ListenerRegisterType registerType, int ... ids) {
        ArrayList<AbstractEventListener> listeners = new ArrayList<AbstractEventListener>(ids.length > 0 ? ids.length : 1);
        if (ids.length > 0) {
            for (int id : ids) {
                switch (registerType) {
                    case NPC: {
                        ListenersContainer template = NpcData.getInstance().getTemplate(id);
                        if (template == null) break;
                        listeners.add(template.addListener(action.apply(template)));
                        break;
                    }
                    case ZONE: {
                        ListenersContainer template = ZoneManager.getInstance().getZoneById(id);
                        if (template == null) break;
                        listeners.add(template.addListener(action.apply(template)));
                        break;
                    }
                    case ITEM: {
                        ListenersContainer template = ItemTable.getInstance().getTemplate(id);
                        if (template == null) break;
                        listeners.add(template.addListener(action.apply(template)));
                        break;
                    }
                    case CASTLE: {
                        ListenersContainer template = CastleManager.getInstance().getCastleById(id);
                        if (template == null) break;
                        listeners.add(template.addListener(action.apply(template)));
                        break;
                    }
                    case FORTRESS: {
                        ListenersContainer template = FortManager.getInstance().getFortById(id);
                        if (template == null) break;
                        listeners.add(template.addListener(action.apply(template)));
                        break;
                    }
                    default: {
                        _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Unhandled register type: " + (Object)((Object)registerType));
                    }
                }
                this._registeredIds.computeIfAbsent(registerType, v -> new FastSet().shared()).add((Object)id);
            }
        } else {
            switch (registerType) {
                case OLYMPIAD: {
                    Olympiad template = Olympiad.getInstance();
                    listeners.add(template.addListener(action.apply(template)));
                    break;
                }
                case GLOBAL: {
                    ListenersContainer template = Containers.Global();
                    listeners.add(template.addListener(action.apply(template)));
                    break;
                }
                case GLOBAL_NPCS: {
                    ListenersContainer template = Containers.Npcs();
                    listeners.add(template.addListener(action.apply(template)));
                    break;
                }
                case GLOBAL_MONSTERS: {
                    ListenersContainer template = Containers.Monsters();
                    listeners.add(template.addListener(action.apply(template)));
                    break;
                }
                case GLOBAL_PLAYERS: {
                    ListenersContainer template = Containers.Players();
                    listeners.add(template.addListener(action.apply(template)));
                    break;
                }
            }
        }
        this._listeners.addAll(listeners);
        return listeners;
    }

    protected final List<AbstractEventListener> registerListener(Function<ListenersContainer, AbstractEventListener> action, ListenerRegisterType registerType, Collection<Integer> ids) {
        ArrayList<AbstractEventListener> listeners = new ArrayList<AbstractEventListener>(!ids.isEmpty() ? ids.size() : 1);
        if (!ids.isEmpty()) {
            block14: for (int id : ids) {
                switch (registerType) {
                    case NPC: {
                        ListenersContainer template = NpcData.getInstance().getTemplate(id);
                        if (template == null) continue block14;
                        listeners.add(template.addListener(action.apply(template)));
                        continue block14;
                    }
                    case ZONE: {
                        ListenersContainer template = ZoneManager.getInstance().getZoneById(id);
                        if (template == null) continue block14;
                        listeners.add(template.addListener(action.apply(template)));
                        continue block14;
                    }
                    case ITEM: {
                        ListenersContainer template = ItemTable.getInstance().getTemplate(id);
                        if (template == null) continue block14;
                        listeners.add(template.addListener(action.apply(template)));
                        continue block14;
                    }
                    case CASTLE: {
                        ListenersContainer template = CastleManager.getInstance().getCastleById(id);
                        if (template == null) continue block14;
                        listeners.add(template.addListener(action.apply(template)));
                        continue block14;
                    }
                    case FORTRESS: {
                        ListenersContainer template = FortManager.getInstance().getFortById(id);
                        if (template == null) continue block14;
                        listeners.add(template.addListener(action.apply(template)));
                        continue block14;
                    }
                }
                _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Unhandled register type: " + (Object)((Object)registerType));
            }
            this._registeredIds.computeIfAbsent(registerType, v -> new FastSet().shared()).addAll(ids);
        } else {
            switch (registerType) {
                case OLYMPIAD: {
                    Olympiad template = Olympiad.getInstance();
                    listeners.add(template.addListener(action.apply(template)));
                    break;
                }
                case GLOBAL: {
                    ListenersContainer template = Containers.Global();
                    listeners.add(template.addListener(action.apply(template)));
                    break;
                }
                case GLOBAL_NPCS: {
                    ListenersContainer template = Containers.Npcs();
                    listeners.add(template.addListener(action.apply(template)));
                    break;
                }
                case GLOBAL_MONSTERS: {
                    ListenersContainer template = Containers.Monsters();
                    listeners.add(template.addListener(action.apply(template)));
                    break;
                }
                case GLOBAL_PLAYERS: {
                    ListenersContainer template = Containers.Players();
                    listeners.add(template.addListener(action.apply(template)));
                    break;
                }
            }
        }
        this._listeners.addAll(listeners);
        return listeners;
    }

    public Set<Integer> getRegisteredIds(ListenerRegisterType type) {
        FastSet<Integer> set = this._registeredIds.get((Object)type);
        return set != null ? set : Collections.emptySet();
    }

    public List<AbstractEventListener> getListeners() {
        return this._listeners;
    }

    public void removeListener(int npcId) {
        L2NpcTemplate template = NpcData.getInstance().getTemplate(npcId);
        Iterator it = this._listeners.iterator();
        while (it.hasNext()) {
            AbstractEventListener listener = (AbstractEventListener)it.next();
            Queue<AbstractEventListener> eventQuests = template.getListeners(listener.getType());
            if (eventQuests == null || eventQuests.isEmpty() || !eventQuests.remove(listener)) continue;
            it.remove();
        }
        FastSet<Integer> set = this._registeredIds.get((Object)ListenerRegisterType.NPC);
        if (set != null) {
            Integer obj = npcId;
            while (set.remove((Object)obj)) {
            }
        }
    }

    public static void showOnScreenMsg(L2PcInstance player, String text, int time) {
        player.sendPacket(new ExShowScreenMessage(text, time));
    }

    public static void showOnScreenMsg(L2PcInstance player, NpcStringId npcString, int position, int time, String ... params) {
        player.sendPacket(new ExShowScreenMessage(npcString, position, time, params));
    }

    public static void showOnScreenMsg(L2PcInstance player, SystemMessageId systemMsg, int position, int time, String ... params) {
        player.sendPacket(new ExShowScreenMessage(systemMsg, position, time, params));
    }

    public static L2Npc addSpawn(int npcId, ILocational pos) {
        return AbstractScript.addSpawn(npcId, pos.getX(), pos.getY(), pos.getZ(), pos.getHeading(), false, 0L, false, 0);
    }

    public static L2Npc addSpawn(int npcId, ILocational pos, boolean isSummonSpawn) {
        return AbstractScript.addSpawn(npcId, pos.getX(), pos.getY(), pos.getZ(), pos.getHeading(), false, 0L, isSummonSpawn, 0);
    }

    public static L2Npc addSpawn(int npcId, ILocational pos, boolean randomOffset, long despawnDelay) {
        return AbstractScript.addSpawn(npcId, pos.getX(), pos.getY(), pos.getZ(), pos.getHeading(), randomOffset, despawnDelay, false, 0);
    }

    public static L2Npc addSpawn(int npcId, ILocational pos, boolean randomOffset, long despawnDelay, boolean isSummonSpawn) {
        return AbstractScript.addSpawn(npcId, pos.getX(), pos.getY(), pos.getZ(), pos.getHeading(), randomOffset, despawnDelay, isSummonSpawn, 0);
    }

    public static L2Npc addSpawn(int npcId, ILocational pos, boolean randomOffset, long despawnDelay, boolean isSummonSpawn, int instanceId) {
        return AbstractScript.addSpawn(npcId, pos.getX(), pos.getY(), pos.getZ(), pos.getHeading(), randomOffset, despawnDelay, isSummonSpawn, instanceId);
    }

    public static L2Npc addSpawn(int npcId, int x, int y, int z, int heading, boolean randomOffset, long despawnDelay) {
        return AbstractScript.addSpawn(npcId, x, y, z, heading, randomOffset, despawnDelay, false, 0);
    }

    public static L2Npc addSpawn(int npcId, int x, int y, int z, int heading, boolean randomOffset, long despawnDelay, boolean isSummonSpawn) {
        return AbstractScript.addSpawn(npcId, x, y, z, heading, randomOffset, despawnDelay, isSummonSpawn, 0);
    }

    public static L2Npc addSpawn(int npcId, int x, int y, int z, int heading, boolean randomOffset, long despawnDelay, boolean isSummonSpawn, int instanceId) {
        block6: {
            try {
                L2NpcTemplate template = NpcData.getInstance().getTemplate(npcId);
                if (template == null) {
                    _log.log(Level.SEVERE, "addSpawn(): no NPC template found for NPC #" + npcId + "!");
                    break block6;
                }
                if (x == 0 && y == 0) {
                    _log.log(Level.SEVERE, "addSpawn(): invalid spawn coordinates for NPC #" + npcId + "!");
                    break block6;
                }
                if (randomOffset) {
                    double radius = 50.0 + 50.0 * Rnd.nextDouble();
                    double angle = Math.PI * 2 * Rnd.nextDouble();
                    x = (int)((double)x + radius * Math.cos(angle));
                    y = (int)((double)y + radius * Math.sin(angle));
                }
                L2Spawn spawn = new L2Spawn(template);
                spawn.setInstanceId(instanceId);
                spawn.setHeading(heading);
                spawn.setX(x);
                spawn.setY(y);
                spawn.setZ(z);
                spawn.stopRespawn();
                L2Npc result = spawn.spawnOne(isSummonSpawn);
                if (despawnDelay > 0L) {
                    result.scheduleDespawn(despawnDelay);
                }
                return result;
            }
            catch (Exception e1) {
                _log.warning("Could not spawn NPC #" + npcId + "; error: " + e1.getMessage());
            }
        }
        return null;
    }

    public L2TrapInstance addTrap(int trapId, int x, int y, int z, int heading, Skill skill, int instanceId) {
        L2NpcTemplate npcTemplate = NpcData.getInstance().getTemplate(trapId);
        L2TrapInstance trap = new L2TrapInstance(IdFactory.getInstance().getNextId(), npcTemplate, instanceId, -1);
        trap.setCurrentHp(trap.getMaxHp());
        trap.setCurrentMp(trap.getMaxMp());
        trap.setIsInvul(true);
        trap.setHeading(heading);
        trap.spawnMe(x, y, z);
        return trap;
    }

    public L2Npc addMinion(L2MonsterInstance master, int minionId) {
        return MinionList.spawnMinion(master, minionId);
    }

    public static long getQuestItemsCount(L2PcInstance player, int itemId) {
        return player.getInventory().getInventoryItemCount(itemId, -1);
    }

    public long getQuestItemsCount(L2PcInstance player, int ... itemIds) {
        long count = 0L;
        for (L2ItemInstance item : player.getInventory().getItems()) {
            if (item == null) continue;
            for (int itemId : itemIds) {
                if (item.getId() != itemId) continue;
                if (count + item.getCount() > Long.MAX_VALUE) {
                    return Long.MAX_VALUE;
                }
                count += item.getCount();
            }
        }
        return count;
    }

    protected static boolean hasItem(L2PcInstance player, ItemHolder item) {
        return AbstractScript.hasItem(player, item, true);
    }

    protected static boolean hasItem(L2PcInstance player, ItemHolder item, boolean checkCount) {
        if (item == null) {
            return false;
        }
        if (checkCount) {
            return AbstractScript.getQuestItemsCount(player, item.getId()) >= item.getCount();
        }
        return AbstractScript.hasQuestItems(player, item.getId());
    }

    protected static boolean hasAllItems(L2PcInstance player, boolean checkCount, ItemHolder ... itemList) {
        if (itemList == null || itemList.length == 0) {
            return false;
        }
        for (ItemHolder item : itemList) {
            if (AbstractScript.hasItem(player, item, checkCount)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasQuestItems(L2PcInstance player, int itemId) {
        return player.getInventory().getItemByItemId(itemId) != null;
    }

    public static boolean hasQuestItems(L2PcInstance player, int ... itemIds) {
        if (itemIds == null || itemIds.length == 0) {
            return false;
        }
        PcInventory inv = player.getInventory();
        for (int itemId : itemIds) {
            if (inv.getItemByItemId(itemId) != null) continue;
            return false;
        }
        return true;
    }

    public boolean hasAtLeastOneQuestItem(L2PcInstance player, int ... itemIds) {
        PcInventory inv = player.getInventory();
        for (int itemId : itemIds) {
            if (inv.getItemByItemId(itemId) == null) continue;
            return true;
        }
        return false;
    }

    public static int getEnchantLevel(L2PcInstance player, int itemId) {
        L2ItemInstance enchantedItem = player.getInventory().getItemByItemId(itemId);
        if (enchantedItem == null) {
            return 0;
        }
        return enchantedItem.getEnchantLevel();
    }

    public void giveAdena(L2PcInstance player, long count, boolean applyRates) {
        if (applyRates) {
            AbstractScript.rewardItems(player, 57, count);
        } else {
            AbstractScript.giveItems(player, 57, count);
        }
    }

    public static void rewardItems(L2PcInstance player, ItemHolder holder) {
        AbstractScript.rewardItems(player, holder.getId(), holder.getCount());
    }

    public static void rewardItems(L2PcInstance player, int itemId, long count) {
        if (count <= 0L) {
            return;
        }
        L2ItemInstance _tmpItem = ItemTable.getInstance().createDummyItem(itemId);
        if (_tmpItem == null) {
            return;
        }
        try {
            if (itemId == 57) {
                count = (long)((float)count * Config.RATE_QUEST_REWARD_ADENA);
            } else if (Config.RATE_QUEST_REWARD_USE_MULTIPLIERS) {
                if (_tmpItem.isEtcItem()) {
                    switch (_tmpItem.getEtcItem().getItemType()) {
                        case POTION: {
                            count = (long)((float)count * Config.RATE_QUEST_REWARD_POTION);
                            break;
                        }
                        case SCRL_ENCHANT_WP: 
                        case SCRL_ENCHANT_AM: 
                        case SCROLL: {
                            count = (long)((float)count * Config.RATE_QUEST_REWARD_SCROLL);
                            break;
                        }
                        case RECIPE: {
                            count = (long)((float)count * Config.RATE_QUEST_REWARD_RECIPE);
                            break;
                        }
                        case MATERIAL: {
                            count = (long)((float)count * Config.RATE_QUEST_REWARD_MATERIAL);
                            break;
                        }
                        default: {
                            count = (long)((float)count * Config.RATE_QUEST_REWARD);
                            break;
                        }
                    }
                }
            } else {
                count = (long)((float)count * Config.RATE_QUEST_REWARD);
            }
        }
        catch (Exception e) {
            count = Long.MAX_VALUE;
        }
        L2ItemInstance item = player.getInventory().addItem("Quest", itemId, count, player, player.getTarget());
        if (item == null) {
            return;
        }
        AbstractScript.sendItemGetMessage(player, item, count);
    }

    private static void sendItemGetMessage(L2PcInstance player, L2ItemInstance item, long count) {
        SystemMessage smsg;
        if (item.getId() == 57) {
            smsg = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S1_ADENA);
            smsg.addLong(count);
            player.sendPacket(smsg);
        } else if (count > 1L) {
            smsg = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S2_S1_S);
            smsg.addItemName(item);
            smsg.addLong(count);
            player.sendPacket(smsg);
        } else {
            smsg = SystemMessage.getSystemMessage(SystemMessageId.EARNED_ITEM_S1);
            smsg.addItemName(item);
            player.sendPacket(smsg);
        }
        StatusUpdate su = new StatusUpdate(player);
        su.addAttribute(14, player.getCurrentLoad());
        player.sendPacket(su);
    }

    public static void giveItems(L2PcInstance player, int itemId, long count) {
        AbstractScript.giveItems(player, itemId, count, 0);
    }

    protected static void giveItems(L2PcInstance player, ItemHolder holder) {
        AbstractScript.giveItems(player, holder.getId(), holder.getCount());
    }

    public static void giveItems(L2PcInstance player, int itemId, long count, int enchantlevel) {
        if (count <= 0L) {
            return;
        }
        L2ItemInstance item = player.getInventory().addItem("Quest", itemId, count, player, player.getTarget());
        if (item == null) {
            return;
        }
        if (enchantlevel > 0 && itemId != 57) {
            item.setEnchantLevel(enchantlevel);
        }
        AbstractScript.sendItemGetMessage(player, item, count);
    }

    public static void giveItems(L2PcInstance player, int itemId, long count, byte attributeId, int attributeLevel) {
        if (count <= 0L) {
            return;
        }
        L2ItemInstance item = player.getInventory().addItem("Quest", itemId, count, player, player.getTarget());
        if (item == null) {
            return;
        }
        if (attributeId >= 0 && attributeLevel > 0) {
            item.setElementAttr(attributeId, attributeLevel);
            if (item.isEquipped()) {
                item.updateElementAttrBonus(player);
            }
            InventoryUpdate iu = new InventoryUpdate();
            iu.addModifiedItem(item);
            player.sendPacket(iu);
        }
        AbstractScript.sendItemGetMessage(player, item, count);
    }

    public static boolean giveItemRandomly(L2PcInstance player, int itemId, long amountToGive, long limit, double dropChance, boolean playSound) {
        return AbstractScript.giveItemRandomly(player, null, itemId, amountToGive, amountToGive, limit, dropChance, playSound);
    }

    public static boolean giveItemRandomly(L2PcInstance player, L2Npc npc, int itemId, long amountToGive, long limit, double dropChance, boolean playSound) {
        return AbstractScript.giveItemRandomly(player, npc, itemId, amountToGive, amountToGive, limit, dropChance, playSound);
    }

    public static boolean giveItemRandomly(L2PcInstance player, L2Npc npc, int itemId, long minAmount, long maxAmount, long limit, double dropChance, boolean playSound) {
        long currentCount = AbstractScript.getQuestItemsCount(player, itemId);
        if (limit > 0L && currentCount >= limit) {
            return true;
        }
        minAmount = (long)((float)minAmount * Config.RATE_QUEST_DROP);
        maxAmount = (long)((float)maxAmount * Config.RATE_QUEST_DROP);
        dropChance *= (double)Config.RATE_QUEST_DROP;
        if (npc != null && Config.L2JMOD_CHAMPION_ENABLE && npc.isChampion()) {
            dropChance *= (double)Config.L2JMOD_CHAMPION_REWARDS;
            if (itemId == 57 || itemId == 5575) {
                minAmount = (long)((float)minAmount * Config.L2JMOD_CHAMPION_ADENAS_REWARDS);
                maxAmount = (long)((float)maxAmount * Config.L2JMOD_CHAMPION_ADENAS_REWARDS);
            } else {
                minAmount *= (long)Config.L2JMOD_CHAMPION_REWARDS;
                maxAmount *= (long)Config.L2JMOD_CHAMPION_REWARDS;
            }
        }
        long amountToGive = minAmount == maxAmount ? minAmount : Rnd.get(minAmount, maxAmount);
        double random = Rnd.nextDouble();
        if (dropChance >= random && amountToGive > 0L && player.getInventory().validateCapacityByItemId(itemId)) {
            L2ItemInstance item;
            if (limit > 0L && currentCount + amountToGive > limit) {
                amountToGive = limit - currentCount;
            }
            if ((item = player.addItem("Quest", itemId, amountToGive, npc, true)) != null) {
                if (currentCount + amountToGive == limit) {
                    if (playSound) {
                        AbstractScript.playSound(player, QuestSound.ITEMSOUND_QUEST_MIDDLE);
                    }
                    return true;
                }
                if (playSound) {
                    AbstractScript.playSound(player, QuestSound.ITEMSOUND_QUEST_ITEMGET);
                }
                if (limit <= 0L) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean takeItems(L2PcInstance player, int itemId, long amount) {
        L2ItemInstance item = player.getInventory().getItemByItemId(itemId);
        if (item == null) {
            if (itemId == -1) {
                _log.log(Level.WARNING, "takeItems(player," + itemId + "," + amount + ")");
            }
            return false;
        }
        if (amount < 0L || amount > item.getCount()) {
            amount = item.getCount();
        }
        if (item.isEquipped()) {
            L2ItemInstance[] unequiped = player.getInventory().unEquipItemInBodySlotAndRecord(item.getItem().getBodyPart());
            InventoryUpdate iu = new InventoryUpdate();
            for (L2ItemInstance itm : unequiped) {
                iu.addModifiedItem(itm);
            }
            player.sendPacket(iu);
            player.broadcastUserInfo();
        }
        return player.destroyItemByItemId("Quest", itemId, amount, player, true);
    }

    protected static boolean takeItem(L2PcInstance player, ItemHolder holder) {
        if (holder == null) {
            return false;
        }
        return AbstractScript.takeItems(player, holder.getId(), holder.getCount());
    }

    protected static boolean takeAllItems(L2PcInstance player, ItemHolder ... itemList) {
        if (itemList == null || itemList.length == 0) {
            return false;
        }
        if (!AbstractScript.hasAllItems(player, true, itemList)) {
            return false;
        }
        for (ItemHolder item : itemList) {
            if (AbstractScript.takeItem(player, item)) continue;
            return false;
        }
        return true;
    }

    public static boolean takeItems(L2PcInstance player, int amount, int ... itemIds) {
        if (amount != -1) {
            StringBuilder sb = new StringBuilder(256).append("takeItems(player,").append(amount);
            if (itemIds == null) {
                sb.append("NULL");
            } else {
                for (int item : itemIds) {
                    sb.append(',').append(item);
                }
            }
            sb.append(')');
            _log.log(Level.WARNING, sb.toString());
        }
        boolean check = true;
        if (itemIds != null) {
            for (int item : itemIds) {
                check &= AbstractScript.takeItems(player, item, (long)amount);
            }
        }
        return check;
    }

    public static void playSound(L2PcInstance player, String sound) {
        player.sendPacket(QuestSound.getSound(sound));
    }

    public static void playSound(L2PcInstance player, QuestSound sound) {
        player.sendPacket(sound.getPacket());
    }

    public static void addExpAndSp(L2PcInstance player, long exp, int sp) {
        player.addExpAndSp((long)player.calcStat(Stats.EXPSP_RATE, (float)exp * Config.RATE_QUEST_REWARD_XP, null, null), (int)player.calcStat(Stats.EXPSP_RATE, (float)sp * Config.RATE_QUEST_REWARD_SP, null, null));
    }

    public static int getRandom(int max) {
        return Rnd.get(max);
    }

    public static int getRandom(int min, int max) {
        return Rnd.get(min, max);
    }

    public static boolean getRandomBoolean() {
        return Rnd.nextBoolean();
    }

    public static int getItemEquipped(L2PcInstance player, int slot) {
        return player.getInventory().getPaperdollItemId(slot);
    }

    public static int getGameTicks() {
        return GameTimeController.getInstance().getGameTicks();
    }

    public final void executeForEachPlayer(L2PcInstance player, L2Npc npc, boolean isSummon, boolean includeParty, boolean includeCommandChannel) {
        if ((includeParty || includeCommandChannel) && player.isInParty()) {
            if (includeCommandChannel && player.getParty().isInCommandChannel()) {
                player.getParty().getCommandChannel().forEachMember(member -> {
                    this.actionForEachPlayer((L2PcInstance)member, npc, isSummon);
                    return true;
                });
            } else if (includeParty) {
                player.getParty().forEachMember(member -> {
                    this.actionForEachPlayer((L2PcInstance)member, npc, isSummon);
                    return true;
                });
            }
        } else {
            this.actionForEachPlayer(player, npc, isSummon);
        }
    }

    public void actionForEachPlayer(L2PcInstance player, L2Npc npc, boolean isSummon) {
    }

    public void openDoor(int doorId, int instanceId) {
        L2DoorInstance door = this.getDoor(doorId, instanceId);
        if (door == null) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": called openDoor(" + doorId + ", " + instanceId + "); but door wasnt found!", new NullPointerException());
        } else if (!door.getOpen()) {
            door.openMe();
        }
    }

    public void closeDoor(int doorId, int instanceId) {
        L2DoorInstance door = this.getDoor(doorId, instanceId);
        if (door == null) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": called closeDoor(" + doorId + ", " + instanceId + "); but door wasnt found!", new NullPointerException());
        } else if (door.getOpen()) {
            door.closeMe();
        }
    }

    public L2DoorInstance getDoor(int doorId, int instanceId) {
        L2DoorInstance door = null;
        if (instanceId <= 0) {
            door = DoorTable.getInstance().getDoor(doorId);
        } else {
            Instance inst = InstanceManager.getInstance().getInstance(instanceId);
            if (inst != null) {
                door = inst.getDoor(doorId);
            }
        }
        return door;
    }

    public void teleportPlayer(L2PcInstance player, Location loc, int instanceId) {
        this.teleportPlayer(player, loc, instanceId, true);
    }

    public void teleportPlayer(L2PcInstance player, Location loc, int instanceId, boolean allowRandomOffset) {
        loc.setInstanceId(instanceId);
        player.teleToLocation((ILocational)loc, allowRandomOffset);
    }

    public static final void specialCamera(L2PcInstance player, L2Character creature, int force, int angle1, int angle2, int time, int range, int duration, int relYaw, int relPitch, int isWide, int relAngle) {
        player.sendPacket(new SpecialCamera(creature, force, angle1, angle2, time, range, duration, relYaw, relPitch, isWide, relAngle, 0));
    }

    public static final void specialCameraEx(L2PcInstance player, L2Character creature, int force, int angle1, int angle2, int time, int duration, int relYaw, int relPitch, int isWide, int relAngle) {
        player.sendPacket(new SpecialCamera(creature, force, angle1, angle2, time, 0, duration, relYaw, relPitch, isWide, relAngle, 0));
    }

    public static final void specialCamera3(L2PcInstance player, L2Character creature, int force, int angle1, int angle2, int time, int range, int duration, int relYaw, int relPitch, int isWide, int relAngle, int unk) {
        player.sendPacket(new SpecialCamera(creature, force, angle1, angle2, time, range, duration, relYaw, relPitch, isWide, relAngle, unk));
    }
}

