/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.events;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.events.Containers;
import com.l2jserver.gameserver.model.events.ListenersContainer;
import com.l2jserver.gameserver.model.events.impl.IBaseEvent;
import com.l2jserver.gameserver.model.events.listeners.AbstractEventListener;
import com.l2jserver.gameserver.model.events.returns.AbstractEventReturn;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class EventDispatcher {
    private static final Logger _log = Logger.getLogger(EventDispatcher.class.getName());

    protected EventDispatcher() {
    }

    public <T extends AbstractEventReturn> T notifyEvent(IBaseEvent event) {
        return Containers.Global().hasListener(event.getType()) ? (T)this.notifyEvent(event, null, null) : null;
    }

    public <T extends AbstractEventReturn> T notifyEvent(IBaseEvent event, Class<T> callbackClass) {
        return Containers.Global().hasListener(event.getType()) ? (T)this.notifyEvent(event, null, callbackClass) : null;
    }

    public <T extends AbstractEventReturn> T notifyEvent(IBaseEvent event, ListenersContainer container) {
        return Containers.Global().hasListener(event.getType()) ? (T)this.notifyEvent(event, container, null) : null;
    }

    public <T extends AbstractEventReturn> T notifyEvent(IBaseEvent event, ListenersContainer container, Class<T> callbackClass) {
        try {
            return (T)(Containers.Global().hasListener(event.getType()) || container.hasListener(event.getType()) ? this.notifyEventImpl(event, container, callbackClass) : null);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Couldn't notify event " + event.getClass().getSimpleName(), e);
            return null;
        }
    }

    public void notifyEventAsync(IBaseEvent event, ListenersContainer ... containers) {
        if (event == null) {
            throw new NullPointerException("Event cannot be null!");
        }
        boolean hasListeners = Containers.Global().hasListener(event.getType());
        if (!hasListeners) {
            for (ListenersContainer container : containers) {
                if (!container.hasListener(event.getType())) continue;
                hasListeners = true;
                break;
            }
        }
        if (hasListeners) {
            ThreadPoolManager.getInstance().executeEvent(() -> this.notifyEventToMultipleContainers(event, containers, null));
        }
    }

    public void notifyEventAsyncDelayed(IBaseEvent event, ListenersContainer container, long delay) {
        if (Containers.Global().hasListener(event.getType()) || container.hasListener(event.getType())) {
            ThreadPoolManager.getInstance().scheduleEvent(() -> this.notifyEvent(event, container, null), delay);
        }
    }

    public void notifyEventAsyncDelayed(IBaseEvent event, ListenersContainer container, long delay, TimeUnit unit) {
        if (Containers.Global().hasListener(event.getType()) || container.hasListener(event.getType())) {
            ThreadPoolManager.getInstance().scheduleEvent(() -> this.notifyEvent(event, container, null), delay, unit);
        }
    }

    private <T extends AbstractEventReturn> T notifyEventToMultipleContainers(IBaseEvent event, ListenersContainer[] containers, Class<T> callbackClass) {
        try {
            if (event == null) {
                throw new NullPointerException("Event cannot be null!");
            }
            AbstractEventReturn callback = null;
            if (containers != null) {
                for (ListenersContainer container : containers) {
                    if (callback != null && callback.abort()) continue;
                    callback = this.notifyToListeners(container.getListeners(event.getType()), event, callbackClass, callback);
                }
            }
            if (callback == null || !callback.abort()) {
                callback = this.notifyToListeners(Containers.Global().getListeners(event.getType()), event, callbackClass, callback);
            }
            return (T)callback;
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Couldn't notify event " + event.getClass().getSimpleName(), e);
            return null;
        }
    }

    private <T extends AbstractEventReturn> T notifyEventImpl(IBaseEvent event, ListenersContainer container, Class<T> callbackClass) {
        if (event == null) {
            throw new NullPointerException("Event cannot be null!");
        }
        AbstractEventReturn callback = null;
        if (container != null) {
            callback = this.notifyToListeners(container.getListeners(event.getType()), event, callbackClass, callback);
        }
        if (callback == null || !callback.abort()) {
            callback = this.notifyToListeners(Containers.Global().getListeners(event.getType()), event, callbackClass, callback);
        }
        return (T)callback;
    }

    private <T extends AbstractEventReturn> T notifyToListeners(Queue<AbstractEventListener> listeners, IBaseEvent event, Class<T> returnBackClass, T callback) {
        for (AbstractEventListener listener : listeners) {
            try {
                T rb = listener.executeEvent(event, returnBackClass);
                if (rb == null) continue;
                if (callback == null || ((AbstractEventReturn)rb).override()) {
                    callback = rb;
                    continue;
                }
                if (!((AbstractEventReturn)rb).abort()) continue;
                break;
            }
            catch (Exception e) {
                _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Exception during notification of event: " + event.getClass().getSimpleName() + " listener: " + listener.getClass().getSimpleName(), e);
            }
        }
        return callback;
    }

    public static EventDispatcher getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final EventDispatcher _instance = new EventDispatcher();

        private SingletonHolder() {
        }
    }
}

