/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.events;

import com.l2jserver.gameserver.model.events.EventType;
import com.l2jserver.gameserver.model.events.listeners.AbstractEventListener;
import com.l2jserver.util.EmptyQueue;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.function.Predicate;

public class ListenersContainer {
    private volatile Map<EventType, Queue<AbstractEventListener>> _listeners = null;

    public AbstractEventListener addListener(AbstractEventListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null!");
        }
        this.getListeners().computeIfAbsent(listener.getType(), k -> new PriorityBlockingQueue()).add(listener);
        return listener;
    }

    public AbstractEventListener removeListener(AbstractEventListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener cannot be null!");
        }
        if (this._listeners == null) {
            throw new NullPointerException("Listeners container is not initialized!");
        }
        Queue<AbstractEventListener> eventQuests = this._listeners.get((Object)listener.getType());
        if (eventQuests == null) {
            throw new IllegalAccessError("Listeners container doesn't had " + (Object)((Object)listener.getType()) + " event type added!");
        }
        eventQuests.remove(listener);
        return listener;
    }

    public Queue<AbstractEventListener> getListeners(EventType type) {
        Queue<AbstractEventListener> eventQuests;
        return this._listeners != null && (eventQuests = this._listeners.get((Object)type)) != null ? eventQuests : EmptyQueue.emptyQueue();
    }

    public void removeListenerIf(EventType type, Predicate<? super AbstractEventListener> filter) {
        this.getListeners(type).stream().filter(filter).forEach(AbstractEventListener::unregisterMe);
    }

    public void removeListenerIf(Predicate<? super AbstractEventListener> filter) {
        if (this._listeners != null) {
            this.getListeners().values().forEach(queue -> queue.stream().filter(filter).forEach(AbstractEventListener::unregisterMe));
        }
    }

    public boolean hasListener(EventType type) {
        return !this.getListeners(type).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<EventType, Queue<AbstractEventListener>> getListeners() {
        if (this._listeners == null) {
            ListenersContainer listenersContainer = this;
            synchronized (listenersContainer) {
                if (this._listeners == null) {
                    this._listeners = new ConcurrentHashMap<EventType, Queue<AbstractEventListener>>();
                    return this._listeners;
                }
            }
        }
        return this._listeners;
    }
}

