/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.events.listeners;

import com.l2jserver.gameserver.model.events.EventType;
import com.l2jserver.gameserver.model.events.ListenersContainer;
import com.l2jserver.gameserver.model.events.impl.IBaseEvent;
import com.l2jserver.gameserver.model.events.listeners.AbstractEventListener;
import com.l2jserver.gameserver.model.events.returns.AbstractEventReturn;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnnotationEventListener
extends AbstractEventListener {
    private static final Logger _log = Logger.getLogger(AnnotationEventListener.class.getName());
    private final Method _callback;

    public AnnotationEventListener(ListenersContainer container, EventType type, Method callback, Object owner, int priority) {
        super(container, type, owner);
        this._callback = callback;
        this.setPriority(priority);
    }

    @Override
    public <R extends AbstractEventReturn> R executeEvent(IBaseEvent event, Class<R> returnBackClass) {
        try {
            Object result = this._callback.invoke(this.getOwner(), event);
            if (this._callback.getReturnType() == returnBackClass) {
                return (R)((AbstractEventReturn)returnBackClass.cast(result));
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Error while invoking " + this._callback.getName() + " on " + this.getOwner(), e);
        }
        return null;
    }
}

