/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.itemcontainer;

import com.l2jserver.Config;
import com.l2jserver.gameserver.enums.ItemLocation;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.character.player.clanwh.OnPlayerClanWHItemAdd;
import com.l2jserver.gameserver.model.events.impl.character.player.clanwh.OnPlayerClanWHItemDestroy;
import com.l2jserver.gameserver.model.events.impl.character.player.clanwh.OnPlayerClanWHItemTransfer;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.model.itemcontainer.Warehouse;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;

public final class ClanWarehouse
extends Warehouse {
    private final L2Clan _clan;

    public ClanWarehouse(L2Clan clan) {
        this._clan = clan;
    }

    @Override
    public String getName() {
        return "ClanWarehouse";
    }

    @Override
    public int getOwnerId() {
        return this._clan.getId();
    }

    @Override
    public L2PcInstance getOwner() {
        return this._clan.getLeader().getPlayerInstance();
    }

    @Override
    public ItemLocation getBaseLocation() {
        return ItemLocation.CLANWH;
    }

    public String getLocationId() {
        return "0";
    }

    public int getLocationId(boolean dummy) {
        return 0;
    }

    public void setLocationId(L2PcInstance dummy) {
    }

    @Override
    public boolean validateCapacity(long slots) {
        return (long)this._items.size() + slots <= (long)Config.WAREHOUSE_SLOTS_CLAN;
    }

    @Override
    public L2ItemInstance addItem(String process, int itemId, long count, L2PcInstance actor, Object reference) {
        L2ItemInstance item = super.addItem(process, itemId, count, actor, reference);
        EventDispatcher.getInstance().notifyEventAsync(new OnPlayerClanWHItemAdd(process, actor, item, this), item.getItem());
        return item;
    }

    @Override
    public L2ItemInstance addItem(String process, L2ItemInstance item, L2PcInstance actor, Object reference) {
        EventDispatcher.getInstance().notifyEventAsync(new OnPlayerClanWHItemAdd(process, actor, item, this), item.getItem());
        return super.addItem(process, item, actor, reference);
    }

    @Override
    public L2ItemInstance destroyItem(String process, L2ItemInstance item, long count, L2PcInstance actor, Object reference) {
        EventDispatcher.getInstance().notifyEventAsync(new OnPlayerClanWHItemDestroy(process, actor, item, count, this), item.getItem());
        return super.destroyItem(process, item, count, actor, reference);
    }

    @Override
    public L2ItemInstance transferItem(String process, int objectId, long count, ItemContainer target, L2PcInstance actor, Object reference) {
        L2ItemInstance item = this.getItemByObjectId(objectId);
        EventDispatcher.getInstance().notifyEventAsync(new OnPlayerClanWHItemTransfer(process, actor, item, count, target), item.getItem());
        return super.transferItem(process, objectId, count, target, actor, reference);
    }
}

