/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.olympiad;

import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.olympiad.AbstractOlympiadGame;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;

final class OlympiadAnnouncer {
    private static final int OLY_MANAGER = 31688;

    OlympiadAnnouncer() {
    }

    public static void announce(AbstractOlympiadGame game) {
        NpcStringId npcString;
        String arenaId = String.valueOf(game.getStadiumId() + 1);
        switch (game.getType()) {
            case NON_CLASSED: {
                npcString = NpcStringId.OLYMPIAD_CLASS_FREE_INDIVIDUAL_MATCH_IS_GOING_TO_BEGIN_IN_ARENA_S1_IN_A_MOMENT;
                break;
            }
            case CLASSED: {
                npcString = NpcStringId.OLYMPIAD_CLASS_INDIVIDUAL_MATCH_IS_GOING_TO_BEGIN_IN_ARENA_S1_IN_A_MOMENT;
                break;
            }
            case TEAMS: {
                npcString = NpcStringId.OLYMPIAD_CLASS_FREE_TEAM_MATCH_IS_GOING_TO_BEGIN_IN_ARENA_S1_IN_A_MOMENT;
                break;
            }
            default: {
                return;
            }
        }
        for (L2Spawn spawn : SpawnTable.getInstance().getSpawns(31688)) {
            L2Npc manager = spawn.getLastSpawn();
            if (manager == null) continue;
            manager.broadcastPacket(new NpcSay(manager.getObjectId(), 23, manager.getId(), npcString).addStringParameter(arenaId));
        }
    }
}

