/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.olympiad;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.olympiad.OnOlympiadMatchResult;
import com.l2jserver.gameserver.model.olympiad.AbstractOlympiadGame;
import com.l2jserver.gameserver.model.olympiad.CompetitionType;
import com.l2jserver.gameserver.model.olympiad.Olympiad;
import com.l2jserver.gameserver.model.olympiad.OlympiadInfo;
import com.l2jserver.gameserver.model.olympiad.Participant;
import com.l2jserver.gameserver.model.zone.type.L2OlympiadStadiumZone;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadMatchResult;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadUserInfo;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.util.Rnd;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public abstract class OlympiadGameNormal
extends AbstractOlympiadGame {
    protected int _damageP1 = 0;
    protected int _damageP2 = 0;
    protected Participant _playerOne;
    protected Participant _playerTwo;

    protected OlympiadGameNormal(int id, Participant[] opponents) {
        super(id);
        this._playerOne = opponents[0];
        this._playerTwo = opponents[1];
        this._playerOne.getPlayer().setOlympiadGameId(id);
        this._playerTwo.getPlayer().setOlympiadGameId(id);
    }

    protected static final Participant[] createListOfParticipants(List<Integer> list) {
        if (list == null || list.isEmpty() || list.size() < 2) {
            return null;
        }
        int playerOneObjectId = 0;
        L2PcInstance playerOne = null;
        L2PcInstance playerTwo = null;
        while (list.size() > 1) {
            playerOneObjectId = list.remove(Rnd.nextInt(list.size()));
            playerOne = L2World.getInstance().getPlayer(playerOneObjectId);
            if (playerOne == null || !playerOne.isOnline()) continue;
            playerTwo = L2World.getInstance().getPlayer(list.remove(Rnd.nextInt(list.size())));
            if (playerTwo == null || !playerTwo.isOnline()) {
                list.add(playerOneObjectId);
                continue;
            }
            Participant[] result = new Participant[]{new Participant(playerOne, 1), new Participant(playerTwo, 2)};
            return result;
        }
        return null;
    }

    @Override
    public final boolean containsParticipant(int playerId) {
        return this._playerOne != null && this._playerOne.getObjectId() == playerId || this._playerTwo != null && this._playerTwo.getObjectId() == playerId;
    }

    @Override
    public final void sendOlympiadInfo(L2Character player) {
        player.sendPacket(new ExOlympiadUserInfo(this._playerOne));
        player.sendPacket(new ExOlympiadUserInfo(this._playerTwo));
    }

    @Override
    public final void broadcastOlympiadInfo(L2OlympiadStadiumZone stadium) {
        stadium.broadcastPacket(new ExOlympiadUserInfo(this._playerOne));
        stadium.broadcastPacket(new ExOlympiadUserInfo(this._playerTwo));
    }

    @Override
    protected final void broadcastPacket(L2GameServerPacket packet) {
        if (this._playerOne.updatePlayer()) {
            this._playerOne.getPlayer().sendPacket(packet);
        }
        if (this._playerTwo.updatePlayer()) {
            this._playerTwo.getPlayer().sendPacket(packet);
        }
    }

    @Override
    protected final boolean portPlayersToArena(List<Location> spawns) {
        boolean result = true;
        try {
            result &= OlympiadGameNormal.portPlayerToArena(this._playerOne, spawns.get(0), this._stadiumID);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "", e);
            return false;
        }
        return result &= OlympiadGameNormal.portPlayerToArena(this._playerTwo, spawns.get(spawns.size() / 2), this._stadiumID);
    }

    @Override
    protected boolean needBuffers() {
        return true;
    }

    @Override
    protected final void removals() {
        if (this._aborted) {
            return;
        }
        OlympiadGameNormal.removals(this._playerOne.getPlayer(), true);
        OlympiadGameNormal.removals(this._playerTwo.getPlayer(), true);
    }

    @Override
    protected final boolean makeCompetitionStart() {
        if (!super.makeCompetitionStart()) {
            return false;
        }
        if (this._playerOne.getPlayer() == null || this._playerTwo.getPlayer() == null) {
            return false;
        }
        this._playerOne.getPlayer().setIsOlympiadStart(true);
        this._playerOne.getPlayer().updateEffectIcons();
        this._playerTwo.getPlayer().setIsOlympiadStart(true);
        this._playerTwo.getPlayer().updateEffectIcons();
        return true;
    }

    @Override
    protected final void cleanEffects() {
        if (this._playerOne.getPlayer() != null && !this._playerOne.isDefaulted() && !this._playerOne.isDisconnected() && this._playerOne.getPlayer().getOlympiadGameId() == this._stadiumID) {
            OlympiadGameNormal.cleanEffects(this._playerOne.getPlayer());
        }
        if (this._playerTwo.getPlayer() != null && !this._playerTwo.isDefaulted() && !this._playerTwo.isDisconnected() && this._playerTwo.getPlayer().getOlympiadGameId() == this._stadiumID) {
            OlympiadGameNormal.cleanEffects(this._playerTwo.getPlayer());
        }
    }

    @Override
    protected final void portPlayersBack() {
        if (this._playerOne.getPlayer() != null && !this._playerOne.isDefaulted() && !this._playerOne.isDisconnected()) {
            OlympiadGameNormal.portPlayerBack(this._playerOne.getPlayer());
        }
        if (this._playerTwo.getPlayer() != null && !this._playerTwo.isDefaulted() && !this._playerTwo.isDisconnected()) {
            OlympiadGameNormal.portPlayerBack(this._playerTwo.getPlayer());
        }
    }

    @Override
    protected final void playersStatusBack() {
        if (this._playerOne.getPlayer() != null && !this._playerOne.isDefaulted() && !this._playerOne.isDisconnected() && this._playerOne.getPlayer().getOlympiadGameId() == this._stadiumID) {
            OlympiadGameNormal.playerStatusBack(this._playerOne.getPlayer());
        }
        if (this._playerTwo.getPlayer() != null && !this._playerTwo.isDefaulted() && !this._playerTwo.isDisconnected() && this._playerTwo.getPlayer().getOlympiadGameId() == this._stadiumID) {
            OlympiadGameNormal.playerStatusBack(this._playerTwo.getPlayer());
        }
    }

    @Override
    protected final void clearPlayers() {
        this._playerOne.setPlayer(null);
        this._playerOne = null;
        this._playerTwo.setPlayer(null);
        this._playerTwo = null;
    }

    @Override
    protected final void handleDisconnect(L2PcInstance player) {
        if (player.getObjectId() == this._playerOne.getObjectId()) {
            this._playerOne.setDisconnected(true);
        } else if (player.getObjectId() == this._playerTwo.getObjectId()) {
            this._playerTwo.setDisconnected(true);
        }
    }

    @Override
    protected final boolean checkBattleStatus() {
        if (this._aborted) {
            return false;
        }
        if (this._playerOne.getPlayer() == null || this._playerOne.isDisconnected()) {
            return false;
        }
        return this._playerTwo.getPlayer() != null && !this._playerTwo.isDisconnected();
    }

    @Override
    protected final boolean haveWinner() {
        if (!this.checkBattleStatus()) {
            return true;
        }
        boolean playerOneLost = true;
        try {
            if (this._playerOne.getPlayer().getOlympiadGameId() == this._stadiumID) {
                playerOneLost = this._playerOne.getPlayer().isDead();
            }
        }
        catch (Exception e) {
            playerOneLost = true;
        }
        boolean playerTwoLost = true;
        try {
            if (this._playerTwo.getPlayer().getOlympiadGameId() == this._stadiumID) {
                playerTwoLost = this._playerTwo.getPlayer().isDead();
            }
        }
        catch (Exception e) {
            playerTwoLost = true;
        }
        return playerOneLost || playerTwoLost;
    }

    @Override
    protected void validateWinner(L2OlympiadStadiumZone stadium) {
        int playerTwoPoints;
        if (this._aborted) {
            return;
        }
        ExOlympiadMatchResult result = null;
        boolean tie = false;
        int winside = 0;
        ArrayList<OlympiadInfo> list1 = new ArrayList<OlympiadInfo>(1);
        ArrayList<OlympiadInfo> list2 = new ArrayList<OlympiadInfo>(1);
        boolean _pOneCrash = this._playerOne.getPlayer() == null || this._playerOne.isDisconnected();
        boolean _pTwoCrash = this._playerTwo.getPlayer() == null || this._playerTwo.isDisconnected();
        int playerOnePoints = this._playerOne.getStats().getInt("olympiad_points");
        int pointDiff = Math.min(playerOnePoints, playerTwoPoints = this._playerTwo.getStats().getInt("olympiad_points")) / this.getDivider();
        if (pointDiff <= 0) {
            pointDiff = 1;
        } else if (pointDiff > Config.ALT_OLY_MAX_POINTS) {
            pointDiff = Config.ALT_OLY_MAX_POINTS;
        }
        if (this._playerOne.isDefaulted() || this._playerTwo.isDefaulted()) {
            try {
                LogRecord record;
                int points;
                if (this._playerOne.isDefaulted()) {
                    try {
                        points = Math.min(playerOnePoints / 3, Config.ALT_OLY_MAX_POINTS);
                        this.removePointsFromParticipant(this._playerOne, points);
                        list1.add(new OlympiadInfo(this._playerOne.getName(), this._playerOne.getClanName(), this._playerOne.getClanId(), this._playerOne.getBaseClass(), this._damageP1, playerOnePoints - points, -points));
                        winside = 2;
                        if (Config.ALT_OLY_LOG_FIGHTS) {
                            record = new LogRecord(Level.INFO, this._playerOne.getName() + " default");
                            record.setParameters(new Object[]{this._playerOne.getName(), this._playerTwo.getName(), 0, 0, 0, 0, points, this.getType().toString()});
                            _logResults.log(record);
                        }
                    }
                    catch (Exception e) {
                        _log.log(Level.WARNING, "Exception on validateWinner(): " + e.getMessage(), e);
                    }
                }
                if (this._playerTwo.isDefaulted()) {
                    try {
                        points = Math.min(playerTwoPoints / 3, Config.ALT_OLY_MAX_POINTS);
                        this.removePointsFromParticipant(this._playerTwo, points);
                        list2.add(new OlympiadInfo(this._playerTwo.getName(), this._playerTwo.getClanName(), this._playerTwo.getClanId(), this._playerTwo.getBaseClass(), this._damageP2, playerTwoPoints - points, -points));
                        if (winside == 2) {
                            tie = true;
                        } else {
                            winside = 1;
                        }
                        if (Config.ALT_OLY_LOG_FIGHTS) {
                            record = new LogRecord(Level.INFO, this._playerTwo.getName() + " default");
                            record.setParameters(new Object[]{this._playerOne.getName(), this._playerTwo.getName(), 0, 0, 0, 0, points, this.getType().toString()});
                            _logResults.log(record);
                        }
                    }
                    catch (Exception e) {
                        _log.log(Level.WARNING, "Exception on validateWinner(): " + e.getMessage(), e);
                    }
                }
                result = winside == 1 ? new ExOlympiadMatchResult(tie, winside, list1, list2) : new ExOlympiadMatchResult(tie, winside, list2, list1);
                stadium.broadcastPacket(result);
                return;
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception on validateWinner(): " + e.getMessage(), e);
                return;
            }
        }
        if (_pOneCrash || _pTwoCrash) {
            try {
                if (_pTwoCrash && !_pOneCrash) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_WON_THE_GAME);
                    sm.addString(this._playerOne.getName());
                    stadium.broadcastPacket(sm);
                    this._playerOne.updateStat("competitions_won", 1);
                    this.addPointsToParticipant(this._playerOne, pointDiff);
                    list1.add(new OlympiadInfo(this._playerOne.getName(), this._playerOne.getClanName(), this._playerOne.getClanId(), this._playerOne.getBaseClass(), this._damageP1, playerOnePoints + pointDiff, pointDiff));
                    this._playerTwo.updateStat("competitions_lost", 1);
                    this.removePointsFromParticipant(this._playerTwo, pointDiff);
                    list2.add(new OlympiadInfo(this._playerTwo.getName(), this._playerTwo.getClanName(), this._playerTwo.getClanId(), this._playerTwo.getBaseClass(), this._damageP2, playerTwoPoints - pointDiff, -pointDiff));
                    winside = 1;
                    OlympiadGameNormal.rewardParticipant(this._playerOne.getPlayer(), this.getReward());
                    if (Config.ALT_OLY_LOG_FIGHTS) {
                        LogRecord record = new LogRecord(Level.INFO, this._playerTwo.getName() + " crash");
                        record.setParameters(new Object[]{this._playerOne.getName(), this._playerTwo.getName(), 0, 0, 0, 0, pointDiff, this.getType().toString()});
                        _logResults.log(record);
                    }
                    EventDispatcher.getInstance().notifyEventAsync(new OnOlympiadMatchResult(this._playerOne, this._playerTwo, this.getType()), Olympiad.getInstance());
                } else if (_pOneCrash && !_pTwoCrash) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_WON_THE_GAME);
                    sm.addString(this._playerTwo.getName());
                    stadium.broadcastPacket(sm);
                    this._playerTwo.updateStat("competitions_won", 1);
                    this.addPointsToParticipant(this._playerTwo, pointDiff);
                    list2.add(new OlympiadInfo(this._playerTwo.getName(), this._playerTwo.getClanName(), this._playerTwo.getClanId(), this._playerTwo.getBaseClass(), this._damageP2, playerTwoPoints + pointDiff, pointDiff));
                    this._playerOne.updateStat("competitions_lost", 1);
                    this.removePointsFromParticipant(this._playerOne, pointDiff);
                    list1.add(new OlympiadInfo(this._playerOne.getName(), this._playerOne.getClanName(), this._playerOne.getClanId(), this._playerOne.getBaseClass(), this._damageP1, playerOnePoints - pointDiff, -pointDiff));
                    winside = 2;
                    OlympiadGameNormal.rewardParticipant(this._playerTwo.getPlayer(), this.getReward());
                    if (Config.ALT_OLY_LOG_FIGHTS) {
                        LogRecord record = new LogRecord(Level.INFO, this._playerOne.getName() + " crash");
                        record.setParameters(new Object[]{this._playerOne.getName(), this._playerTwo.getName(), 0, 0, 0, 0, pointDiff, this.getType().toString()});
                        _logResults.log(record);
                    }
                    EventDispatcher.getInstance().notifyEventAsync(new OnOlympiadMatchResult(this._playerTwo, this._playerOne, this.getType()), Olympiad.getInstance());
                } else if (_pOneCrash && _pTwoCrash) {
                    stadium.broadcastPacket(SystemMessage.getSystemMessage(SystemMessageId.THE_GAME_ENDED_IN_A_TIE));
                    this._playerOne.updateStat("competitions_lost", 1);
                    this.removePointsFromParticipant(this._playerOne, pointDiff);
                    list1.add(new OlympiadInfo(this._playerOne.getName(), this._playerOne.getClanName(), this._playerOne.getClanId(), this._playerOne.getBaseClass(), this._damageP1, playerOnePoints - pointDiff, -pointDiff));
                    this._playerTwo.updateStat("competitions_lost", 1);
                    this.removePointsFromParticipant(this._playerTwo, pointDiff);
                    list2.add(new OlympiadInfo(this._playerTwo.getName(), this._playerTwo.getClanName(), this._playerTwo.getClanId(), this._playerTwo.getBaseClass(), this._damageP2, playerTwoPoints - pointDiff, -pointDiff));
                    tie = true;
                    if (Config.ALT_OLY_LOG_FIGHTS) {
                        LogRecord record = new LogRecord(Level.INFO, "both crash");
                        record.setParameters(new Object[]{this._playerOne.getName(), this._playerTwo.getName(), 0, 0, 0, 0, pointDiff, this.getType().toString()});
                        _logResults.log(record);
                    }
                }
                this._playerOne.updateStat("competitions_done", 1);
                this._playerTwo.updateStat("competitions_done", 1);
                this._playerOne.updateStat("competitions_done_week", 1);
                this._playerTwo.updateStat("competitions_done_week", 1);
                this._playerOne.updateStat(this.getWeeklyMatchType(), 1);
                this._playerTwo.updateStat(this.getWeeklyMatchType(), 1);
                result = winside == 1 ? new ExOlympiadMatchResult(tie, winside, list1, list2) : new ExOlympiadMatchResult(tie, winside, list2, list1);
                stadium.broadcastPacket(result);
                EventDispatcher.getInstance().notifyEventAsync(new OnOlympiadMatchResult(null, this._playerOne, this.getType()), Olympiad.getInstance());
                EventDispatcher.getInstance().notifyEventAsync(new OnOlympiadMatchResult(null, this._playerTwo, this.getType()), Olympiad.getInstance());
                return;
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception on validateWinner(): " + e.getMessage(), e);
                return;
            }
        }
        try {
            String winner = "\u5f15\u5206";
            long _fightTime = System.currentTimeMillis() - this._startTime;
            double playerOneHp = 0.0;
            if (this._playerOne.getPlayer() != null && !this._playerOne.getPlayer().isDead() && (playerOneHp = this._playerOne.getPlayer().getCurrentHp() + this._playerOne.getPlayer().getCurrentCp()) < 0.5) {
                playerOneHp = 0.0;
            }
            double playerTwoHp = 0.0;
            if (this._playerTwo.getPlayer() != null && !this._playerTwo.getPlayer().isDead() && (playerTwoHp = this._playerTwo.getPlayer().getCurrentHp() + this._playerTwo.getPlayer().getCurrentCp()) < 0.5) {
                playerTwoHp = 0.0;
            }
            this._playerOne.updatePlayer();
            this._playerTwo.updatePlayer();
            if (!(this._playerOne.getPlayer() != null && this._playerOne.getPlayer().isOnline() || this._playerTwo.getPlayer() != null && this._playerTwo.getPlayer().isOnline())) {
                this._playerOne.updateStat("competitions_drawn", 1);
                this._playerTwo.updateStat("competitions_drawn", 1);
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_GAME_ENDED_IN_A_TIE);
                stadium.broadcastPacket(sm);
            } else if (this._playerTwo.getPlayer() == null || !this._playerTwo.getPlayer().isOnline() || playerTwoHp == 0.0 && playerOneHp != 0.0 || this._damageP1 > this._damageP2 && playerTwoHp != 0.0 && playerOneHp != 0.0) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_WON_THE_GAME);
                sm.addString(this._playerOne.getName());
                stadium.broadcastPacket(sm);
                this._playerOne.updateStat("competitions_won", 1);
                this._playerTwo.updateStat("competitions_lost", 1);
                this.addPointsToParticipant(this._playerOne, pointDiff);
                list1.add(new OlympiadInfo(this._playerOne.getName(), this._playerOne.getClanName(), this._playerOne.getClanId(), this._playerOne.getBaseClass(), this._damageP1, playerOnePoints + pointDiff, pointDiff));
                this.removePointsFromParticipant(this._playerTwo, pointDiff);
                list2.add(new OlympiadInfo(this._playerTwo.getName(), this._playerTwo.getClanName(), this._playerTwo.getClanId(), this._playerTwo.getBaseClass(), this._damageP2, playerTwoPoints - pointDiff, -pointDiff));
                winner = this._playerOne.getName() + " \u52dd\u5229";
                winside = 1;
                OlympiadGameNormal.saveResults(this._playerOne, this._playerTwo, 1, this._startTime, _fightTime, this.getType());
                OlympiadGameNormal.rewardParticipant(this._playerOne.getPlayer(), this.getReward());
                EventDispatcher.getInstance().notifyEventAsync(new OnOlympiadMatchResult(this._playerOne, this._playerTwo, this.getType()), Olympiad.getInstance());
            } else if (this._playerOne.getPlayer() == null || !this._playerOne.getPlayer().isOnline() || playerOneHp == 0.0 && playerTwoHp != 0.0 || this._damageP2 > this._damageP1 && playerOneHp != 0.0 && playerTwoHp != 0.0) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_WON_THE_GAME);
                sm.addString(this._playerTwo.getName());
                stadium.broadcastPacket(sm);
                this._playerTwo.updateStat("competitions_won", 1);
                this._playerOne.updateStat("competitions_lost", 1);
                this.addPointsToParticipant(this._playerTwo, pointDiff);
                list2.add(new OlympiadInfo(this._playerTwo.getName(), this._playerTwo.getClanName(), this._playerTwo.getClanId(), this._playerTwo.getBaseClass(), this._damageP2, playerTwoPoints + pointDiff, pointDiff));
                this.removePointsFromParticipant(this._playerOne, pointDiff);
                list1.add(new OlympiadInfo(this._playerOne.getName(), this._playerOne.getClanName(), this._playerOne.getClanId(), this._playerOne.getBaseClass(), this._damageP1, playerOnePoints - pointDiff, -pointDiff));
                winner = this._playerTwo.getName() + " \u52dd\u5229";
                winside = 2;
                OlympiadGameNormal.saveResults(this._playerOne, this._playerTwo, 2, this._startTime, _fightTime, this.getType());
                OlympiadGameNormal.rewardParticipant(this._playerTwo.getPlayer(), this.getReward());
                EventDispatcher.getInstance().notifyEventAsync(new OnOlympiadMatchResult(this._playerTwo, this._playerOne, this.getType()), Olympiad.getInstance());
            } else {
                OlympiadGameNormal.saveResults(this._playerOne, this._playerTwo, 0, this._startTime, _fightTime, this.getType());
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_GAME_ENDED_IN_A_TIE);
                stadium.broadcastPacket(sm);
                int value = Math.min(playerOnePoints / this.getDivider(), Config.ALT_OLY_MAX_POINTS);
                this.removePointsFromParticipant(this._playerOne, value);
                list1.add(new OlympiadInfo(this._playerOne.getName(), this._playerOne.getClanName(), this._playerOne.getClanId(), this._playerOne.getBaseClass(), this._damageP1, playerOnePoints - value, -value));
                value = Math.min(playerTwoPoints / this.getDivider(), Config.ALT_OLY_MAX_POINTS);
                this.removePointsFromParticipant(this._playerTwo, value);
                list2.add(new OlympiadInfo(this._playerTwo.getName(), this._playerTwo.getClanName(), this._playerTwo.getClanId(), this._playerTwo.getBaseClass(), this._damageP2, playerTwoPoints - value, -value));
                tie = true;
            }
            this._playerOne.updateStat("competitions_done", 1);
            this._playerTwo.updateStat("competitions_done", 1);
            this._playerOne.updateStat("competitions_done_week", 1);
            this._playerTwo.updateStat("competitions_done_week", 1);
            this._playerOne.updateStat(this.getWeeklyMatchType(), 1);
            this._playerTwo.updateStat(this.getWeeklyMatchType(), 1);
            result = winside == 1 ? new ExOlympiadMatchResult(tie, winside, list1, list2) : new ExOlympiadMatchResult(tie, winside, list2, list1);
            stadium.broadcastPacket(result);
            if (Config.ALT_OLY_LOG_FIGHTS) {
                LogRecord record = new LogRecord(Level.INFO, winner);
                record.setParameters(new Object[]{this._playerOne.getName(), this._playerTwo.getName(), playerOneHp, playerTwoHp, this._damageP1, this._damageP2, pointDiff, this.getType().toString()});
                _logResults.log(record);
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on validateWinner(): " + e.getMessage(), e);
        }
    }

    @Override
    protected final void addDamage(L2PcInstance player, int damage) {
        if (this._playerOne.getPlayer() == null || this._playerTwo.getPlayer() == null) {
            return;
        }
        if (player == this._playerOne.getPlayer()) {
            this._damageP1 += damage;
        } else if (player == this._playerTwo.getPlayer()) {
            this._damageP2 += damage;
        }
    }

    @Override
    public final String[] getPlayerNames() {
        return new String[]{this._playerOne.getName(), this._playerTwo.getName()};
    }

    @Override
    public boolean checkDefaulted() {
        this._playerOne.updatePlayer();
        this._playerTwo.updatePlayer();
        SystemMessage reason = OlympiadGameNormal.checkDefaulted(this._playerOne.getPlayer());
        if (reason != null) {
            this._playerOne.setDefaulted(true);
            if (this._playerTwo.getPlayer() != null) {
                this._playerTwo.getPlayer().sendPacket(reason);
            }
        }
        if ((reason = OlympiadGameNormal.checkDefaulted(this._playerTwo.getPlayer())) != null) {
            this._playerTwo.setDefaulted(true);
            if (this._playerOne.getPlayer() != null) {
                this._playerOne.getPlayer().sendPacket(reason);
            }
        }
        return this._playerOne.isDefaulted() || this._playerTwo.isDefaulted();
    }

    @Override
    public final void resetDamage() {
        this._damageP1 = 0;
        this._damageP2 = 0;
    }

    protected static final void saveResults(Participant one, Participant two, int _winner, long _startTime, long _fightTime, CompetitionType type) {
        block26: {
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement statement = con.prepareStatement("INSERT INTO olympiad_fights (charOneId, charTwoId, charOneClass, charTwoClass, winner, start, time, classed) values(?,?,?,?,?,?,?,?)");){
                statement.setInt(1, one.getObjectId());
                statement.setInt(2, two.getObjectId());
                statement.setInt(3, one.getBaseClass());
                statement.setInt(4, two.getBaseClass());
                statement.setInt(5, _winner);
                statement.setLong(6, _startTime);
                statement.setLong(7, _fightTime);
                statement.setInt(8, type == CompetitionType.CLASSED ? 1 : 0);
                statement.execute();
            }
            catch (SQLException e) {
                if (!_log.isLoggable(Level.SEVERE)) break block26;
                _log.log(Level.SEVERE, "SQL exception while saving olympiad fight.", e);
            }
        }
    }
}

