/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.quest;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.enums.TrapAction;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TrapInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.base.AcquireSkillType;
import com.l2jserver.gameserver.model.events.AbstractScript;
import com.l2jserver.gameserver.model.events.EventType;
import com.l2jserver.gameserver.model.events.ListenerRegisterType;
import com.l2jserver.gameserver.model.events.impl.IBaseEvent;
import com.l2jserver.gameserver.model.events.impl.character.OnCreatureZoneEnter;
import com.l2jserver.gameserver.model.events.impl.character.OnCreatureZoneExit;
import com.l2jserver.gameserver.model.events.impl.character.npc.OnNpcCreatureSee;
import com.l2jserver.gameserver.model.events.impl.character.npc.OnNpcEventReceived;
import com.l2jserver.gameserver.model.events.impl.character.npc.OnNpcFirstTalk;
import com.l2jserver.gameserver.model.events.impl.character.npc.OnNpcMoveRouteFinished;
import com.l2jserver.gameserver.model.events.impl.character.npc.OnNpcSkillFinished;
import com.l2jserver.gameserver.model.events.impl.character.npc.OnNpcSkillSee;
import com.l2jserver.gameserver.model.events.impl.character.npc.OnNpcSpawn;
import com.l2jserver.gameserver.model.events.impl.character.npc.OnNpcTeleport;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.OnAttackableAggroRangeEnter;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.OnAttackableAttack;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.OnAttackableFactionCall;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.OnAttackableHate;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.OnAttackableKill;
import com.l2jserver.gameserver.model.events.impl.character.player.OnPlayerSkillLearn;
import com.l2jserver.gameserver.model.events.impl.character.player.OnPlayerSummonSpawn;
import com.l2jserver.gameserver.model.events.impl.character.player.OnPlayerSummonTalk;
import com.l2jserver.gameserver.model.events.impl.character.trap.OnTrapAction;
import com.l2jserver.gameserver.model.events.impl.item.OnItemBypassEvent;
import com.l2jserver.gameserver.model.events.impl.item.OnItemTalk;
import com.l2jserver.gameserver.model.events.listeners.AbstractEventListener;
import com.l2jserver.gameserver.model.events.listeners.DummyEventListener;
import com.l2jserver.gameserver.model.events.returns.TerminateReturn;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.olympiad.CompetitionType;
import com.l2jserver.gameserver.model.olympiad.Participant;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.quest.QuestTimer;
import com.l2jserver.gameserver.model.quest.State;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.NpcQuestHtmlMessage;
import com.l2jserver.gameserver.scripting.ScriptManager;
import com.l2jserver.util.ConcurrentFastMap;
import com.l2jserver.util.Rnd;
import com.l2jserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Quest
extends AbstractScript
implements IIdentifiable {
    public static final Logger _log = Logger.getLogger(Quest.class.getName());
    private final ConcurrentFastMap<String, ArrayList<QuestTimer>> _allEventTimers = new ConcurrentFastMap();
    private final ReentrantReadWriteLock _rwLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock _writeLock = this._rwLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock _readLock = this._rwLock.readLock();
    private final int _questId;
    private final String _name;
    private final String _descr;
    private final byte _initialState = 0;
    protected boolean _onEnterWorld = false;
    public int[] questItemIds = null;
    private static final String DEFAULT_NO_QUEST_MSG = "<html><body>\u30af\u30a8\u30b9\u30c8\u3092\u9042\u884c\u3057\u3066\u3044\u306a\u3044\u304b\u6761\u4ef6\u304c\u5408\u3044\u307e\u305b\u3093\u3002</body></html>";
    private static final String DEFAULT_ALREADY_COMPLETED_MSG = "<html><body>\u3059\u3067\u306b\u9042\u884c\u3057\u305f\u30af\u30a8\u30b9\u30c8\u3067\u3059\u3002</body></html>";
    private static final String QUEST_DELETE_FROM_CHAR_QUERY = "DELETE FROM character_quests WHERE charId=? AND name=?";
    private static final String QUEST_DELETE_FROM_CHAR_QUERY_NON_REPEATABLE_QUERY = "DELETE FROM character_quests WHERE charId=? AND name=? AND var!=?";
    private static final int RESET_HOUR = 6;
    private static final int RESET_MINUTES = 30;
    private static String[] COND_CHACHE = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};

    public int getResetHour() {
        return 6;
    }

    public int getResetMinutes() {
        return 30;
    }

    public Quest(int questId, String name, String descr) {
        this._questId = questId;
        this._name = name;
        this._descr = descr;
        if (questId > 0) {
            QuestManager.getInstance().addQuest(this);
        } else {
            QuestManager.getInstance().addScript(this);
        }
        this.loadGlobalData();
    }

    protected void loadGlobalData() {
    }

    public void saveGlobalData() {
    }

    @Override
    public int getId() {
        return this._questId;
    }

    public int getQuestIntId() {
        return this.getId();
    }

    public QuestState newQuestState(L2PcInstance player) {
        return new QuestState(this, player, 0);
    }

    public QuestState getQuestState(L2PcInstance player, boolean initIfNone) {
        QuestState qs = player.getQuestState(this._name);
        if (qs != null || !initIfNone) {
            return qs;
        }
        return this.newQuestState(player);
    }

    public byte getInitialState() {
        return 0;
    }

    public String getName() {
        return this._name;
    }

    public String getDescr() {
        return this._descr;
    }

    public String getDescrHtm() {
        int id = this._questId;
        if (id > 0 && id < 20000) {
            if (id > 10000) {
                id -= 5000;
            }
            return "<fstring>" + id + "01</fstring>";
        }
        return this._descr;
    }

    public boolean isQuests() {
        int questId = this._questId;
        return questId > 0 && questId < 20000;
    }

    public void startQuestTimer(String name, long time, L2Npc npc, L2PcInstance player) {
        this.startQuestTimer(name, time, npc, player, false);
    }

    public void startQuestTimer(String name, long time, L2Npc npc, L2PcInstance player, boolean repeating) {
        this.startQuestTimer(name, time, npc, player, repeating, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startQuestTimer(String name, long time, L2Npc npc, L2PcInstance player, boolean repeating, boolean withFixedDelay) {
        if (this.getQuestTimer(name, npc, player) == null) {
            ArrayList timers = this._allEventTimers.computeIfAbsent(name, k -> new ArrayList());
            this._writeLock.lock();
            try {
                timers.add(new QuestTimer(this, name, time, npc, player, repeating, withFixedDelay));
            }
            finally {
                this._writeLock.unlock();
            }
        }
    }

    public void startQuestTimer(String name, long time, L2Npc npc, L2PcInstance player, Repeating repeating) {
        switch (repeating) {
            default: {
                this.startQuestTimer(name, time, npc, player, false, false);
                break;
            }
            case AtFixedRate: {
                this.startQuestTimer(name, time, npc, player, true, false);
                break;
            }
            case WithFixedDelay: {
                this.startQuestTimer(name, time, npc, player, true, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuestTimer getQuestTimer(String name, L2Npc npc, L2PcInstance player) {
        ArrayList timers = (ArrayList)this._allEventTimers.get(name);
        if (timers != null) {
            this._readLock.lock();
            try {
                for (QuestTimer timer : timers) {
                    if (timer == null || !timer.isMatch(this, name, npc, player)) continue;
                    QuestTimer questTimer = timer;
                    return questTimer;
                }
            }
            finally {
                this._readLock.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelQuestTimers(String name) {
        ArrayList timers = (ArrayList)this._allEventTimers.get(name);
        if (timers != null) {
            this._writeLock.lock();
            try {
                for (QuestTimer timer : timers) {
                    if (timer == null) continue;
                    timer.cancel();
                }
                timers.clear();
            }
            finally {
                this._writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelQuestTimers(String name, int instanceId) {
        ArrayList timers = (ArrayList)this._allEventTimers.get(name);
        if (timers == null) {
            return;
        }
        this._writeLock.lock();
        try {
            Iterator it = timers.iterator();
            while (it.hasNext()) {
                QuestTimer timer = (QuestTimer)it.next();
                if (timer == null || timer.getInstanceId() != instanceId) continue;
                timer.cancel();
                it.remove();
            }
        }
        finally {
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelQuestTimers(L2Npc npc) {
        for (ArrayList timers : this._allEventTimers.values()) {
            this._writeLock.lock();
            try {
                Iterator it = timers.iterator();
                while (it.hasNext()) {
                    QuestTimer timer = (QuestTimer)it.next();
                    if (timer == null || timer.getNpc() != npc) continue;
                    timer.cancel();
                    it.remove();
                }
            }
            finally {
                this._writeLock.unlock();
            }
        }
    }

    public void cancelQuestTimer(String name, L2Npc npc, L2PcInstance player) {
        QuestTimer timer = this.getQuestTimer(name, npc, player);
        if (timer != null) {
            timer.cancelAndRemove();
        }
    }

    public void removeQuestTimer(QuestTimer timer) {
        ArrayList timers;
        if (timer != null && (timers = (ArrayList)this._allEventTimers.get(timer.getName())) != null) {
            this._writeLock.lock();
            try {
                timers.remove(timer);
            }
            finally {
                this._writeLock.unlock();
            }
        }
    }

    public Map<String, ArrayList<QuestTimer>> getQuestTimers() {
        return this._allEventTimers;
    }

    public final void notifyAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isSummon, Skill skill) {
        String res;
        try {
            res = this.onAttack(npc, attacker, damage, isSummon, skill);
        }
        catch (Exception e) {
            this.showError(attacker, e);
            return;
        }
        this.showResult(attacker, res);
    }

    public final void notifyDeath(L2Character killer, L2Character victim, QuestState qs) {
        String res;
        try {
            res = this.onDeath(killer, victim, qs);
        }
        catch (Exception e) {
            this.showError(qs.getPlayer(), e);
            return;
        }
        this.showResult(qs.getPlayer(), res);
    }

    public final void notifyItemUse(L2Item item, L2PcInstance player) {
        String res;
        try {
            res = this.onItemUse(item, player);
        }
        catch (Exception e) {
            this.showError(player, e);
            return;
        }
        this.showResult(player, res);
    }

    public final void notifySpellFinished(L2Npc instance, L2PcInstance player, Skill skill) {
        String res;
        try {
            res = this.onSpellFinished(instance, player, skill);
        }
        catch (Exception e) {
            this.showError(player, e);
            return;
        }
        this.showResult(player, res);
    }

    public final void notifyTrapAction(L2TrapInstance trap, L2Character trigger, TrapAction action) {
        String res;
        try {
            res = this.onTrapAction(trap, trigger, action);
        }
        catch (Exception e) {
            this.showError(trigger.getActingPlayer(), e);
            _log.log(Level.WARNING, "Exception on onTrapAction() in notifyTrapAction(): " + e.getMessage(), e);
            return;
        }
        this.showResult(trigger.getActingPlayer(), res);
    }

    public final void notifySpawn(L2Npc npc) {
        try {
            this.onSpawn(npc);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on onSpawn() in notifySpawn(): " + e.getMessage(), e);
        }
    }

    public final void notifyTeleport(L2Npc npc) {
        try {
            this.onTeleport(npc);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on onTeleport() in notifyTeleport(): " + e.getMessage(), e);
        }
    }

    public final boolean notifyEvent(String event, L2Npc npc, L2PcInstance player) {
        String res;
        try {
            res = this.onAdvEvent(event, npc, player);
        }
        catch (Exception e) {
            return this.showError(player, e);
        }
        return this.showResult(player, res, npc);
    }

    public final void notifyEnterWorld(L2PcInstance player) {
        String res;
        try {
            res = this.onEnterWorld(player);
        }
        catch (Exception e) {
            this.showError(player, e);
            return;
        }
        this.showResult(player, res);
    }

    public final void notifyKill(L2Npc npc, L2PcInstance killer, boolean isSummon) {
        String res;
        try {
            res = this.onKill(npc, killer, isSummon);
        }
        catch (Exception e) {
            this.showError(killer, e);
            return;
        }
        this.showResult(killer, res);
    }

    public final boolean notifyTalk(L2Npc npc, L2PcInstance activeChar) {
        String res;
        try {
            res = this.onTalk(npc, activeChar);
        }
        catch (Exception e) {
            return this.showError(activeChar, e);
        }
        activeChar.setLastQuestNpcObject(npc.getObjectId());
        return this.showResult(activeChar, res, npc);
    }

    public final void notifyFirstTalk(L2Npc npc, L2PcInstance player) {
        String res;
        try {
            res = this.onFirstTalk(npc, player);
        }
        catch (Exception e) {
            this.showError(player, e);
            return;
        }
        this.showResult(player, res, npc);
    }

    public final void notifyAcquireSkill(L2Npc npc, L2PcInstance player, Skill skill, AcquireSkillType type) {
        String res;
        try {
            res = this.onAcquireSkill(npc, player, skill, type);
        }
        catch (Exception e) {
            this.showError(player, e);
            return;
        }
        this.showResult(player, res);
    }

    public final boolean notifyItemTalk(L2ItemInstance item, L2PcInstance player) {
        String res;
        try {
            res = this.onItemTalk(item, player);
            if (res != null) {
                if (res.equalsIgnoreCase("true")) {
                    return true;
                }
                if (res.equalsIgnoreCase("false")) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            return this.showError(player, e);
        }
        return this.showResult(player, res);
    }

    public String onItemTalk(L2ItemInstance item, L2PcInstance player) {
        return null;
    }

    public final boolean notifyItemEvent(L2ItemInstance item, L2PcInstance player, String event) {
        String res;
        try {
            res = this.onItemEvent(item, player, event);
            if (res != null) {
                if (res.equalsIgnoreCase("true")) {
                    return true;
                }
                if (res.equalsIgnoreCase("false")) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            return this.showError(player, e);
        }
        return this.showResult(player, res);
    }

    public final void notifySkillSee(L2Npc npc, L2PcInstance caster, Skill skill, L2Object[] targets, boolean isSummon) {
        String res = null;
        try {
            res = this.onSkillSee(npc, caster, skill, targets, isSummon);
        }
        catch (Exception e) {
            this.showError(caster, e);
            return;
        }
        this.showResult(caster, res);
    }

    public final void notifyFactionCall(L2Npc npc, L2Npc caller, L2PcInstance attacker, boolean isSummon) {
        String res;
        try {
            res = this.onFactionCall(npc, caller, attacker, isSummon);
        }
        catch (Exception e) {
            this.showError(attacker, e);
            return;
        }
        this.showResult(attacker, res);
    }

    public final void notifyAggroRangeEnter(L2Npc npc, L2PcInstance player, boolean isSummon) {
        String res = null;
        try {
            res = this.onAggroRangeEnter(npc, player, isSummon);
        }
        catch (Exception e) {
            this.showError(player, e);
            return;
        }
        this.showResult(player, res);
    }

    public final void notifySeeCreature(L2Npc npc, L2Character creature, boolean isSummon) {
        String res;
        L2PcInstance player = null;
        if (isSummon || creature.isPlayer()) {
            player = creature.getActingPlayer();
        }
        try {
            res = this.onSeeCreature(npc, creature, isSummon);
        }
        catch (Exception e) {
            this.showError(player, e);
            return;
        }
        this.showResult(player, res);
    }

    public final void notifyEventReceived(String eventName, L2Npc sender, L2Npc receiver, L2Object reference) {
        try {
            this.onEventReceived(eventName, sender, receiver, reference);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on onEventReceived() in notifyEventReceived(): " + e.getMessage(), e);
        }
    }

    public void broadcastEvent(String eventName, L2Npc sender, int radius, L2Object reference) {
        int sqRadius = radius * radius;
        for (L2WorldRegion regi : sender.getWorldRegion().getSurroundingRegions()) {
            for (L2Object obj : regi.getVisibleObjects().values()) {
                Queue<AbstractEventListener> eventQuests;
                if (obj == null || !obj.isNpc() || obj.equals(sender) || !(sender.calculateDistance(obj, false, true) <= (double)sqRadius) || (eventQuests = ((L2Npc)obj).getTemplate().getListeners(EventType.ON_NPC_EVENT_RECEIVED)) == null) continue;
                for (AbstractEventListener event : eventQuests) {
                    if (event.getOwner() != this) continue;
                    this.notifyEventReceived(eventName, sender, (L2Npc)obj, reference);
                }
            }
        }
    }

    public final void notifyEnterZone(L2Character character, L2ZoneType zone) {
        String res;
        L2PcInstance player = character.getActingPlayer();
        try {
            res = this.onEnterZone(character, zone);
        }
        catch (Exception e) {
            this.showError(player, e);
            return;
        }
        this.showResult(player, res);
    }

    public final void notifyExitZone(L2Character character, L2ZoneType zone) {
        String res;
        L2PcInstance player = character.getActingPlayer();
        try {
            res = this.onExitZone(character, zone);
        }
        catch (Exception e) {
            this.showError(player, e);
            return;
        }
        this.showResult(player, res);
    }

    public final void notifyOlympiadMatch(Participant winner, Participant looser, CompetitionType type) {
        try {
            this.onOlympiadMatchFinish(winner, looser, type);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Execution on onOlympiadMatchFinish() in notifyOlympiadMatch(): " + e.getMessage(), e);
            return;
        }
    }

    public final boolean notifyMoveFinished(L2Npc npc) {
        try {
            return this.onMoveFinished(npc);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on onMoveFinished() in notifyMoveFinished(): " + e.getMessage(), e);
            return false;
        }
    }

    public final boolean notifyNodeArrived(L2Npc npc) {
        try {
            return this.onNodeArrived(npc);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on onNodeArrived() in notifyNodeArrived(): " + e.getMessage(), e);
            return false;
        }
    }

    public final void notifyRouteFinished(L2Npc npc) {
        try {
            this.onRouteFinished(npc);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on onRouteFinished() in notifyRouteFinished(): " + e.getMessage(), e);
        }
    }

    public final boolean notifyOnCanSeeMe(L2Npc npc, L2PcInstance player) {
        try {
            return this.onCanSeeMe(npc, player);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on onCanSeeMe() in notifyOnCanSeeMe(): " + e.getMessage(), e);
            return false;
        }
    }

    public String onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isSummon) {
        return null;
    }

    public String onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isSummon, Skill skill) {
        return this.onAttack(npc, attacker, damage, isSummon);
    }

    public String onDeath(L2Character killer, L2Character victim, QuestState qs) {
        return this.onAdvEvent("", killer instanceof L2Npc ? (L2Npc)killer : null, qs.getPlayer());
    }

    public String onAdvEvent(String event, L2Npc npc, L2PcInstance player) {
        QuestState qs;
        if (player != null && (qs = player.getQuestState(this.getName())) != null) {
            return this.onEvent(event, qs);
        }
        return null;
    }

    public String onEvent(String event, QuestState qs) {
        return null;
    }

    public String onKill(L2Npc npc, L2PcInstance killer, boolean isSummon) {
        return null;
    }

    public String onTalk(L2Npc npc, L2PcInstance talker) {
        return null;
    }

    public String onFirstTalk(L2Npc npc, L2PcInstance player) {
        return null;
    }

    public String onItemEvent(L2ItemInstance item, L2PcInstance player, String event) {
        return null;
    }

    public String onAcquireSkillList(L2Npc npc, L2PcInstance player) {
        return null;
    }

    public String onAcquireSkillInfo(L2Npc npc, L2PcInstance player, Skill skill) {
        return null;
    }

    public String onAcquireSkill(L2Npc npc, L2PcInstance player, Skill skill, AcquireSkillType type) {
        return null;
    }

    public String onItemUse(L2Item item, L2PcInstance player) {
        return null;
    }

    public String onSkillSee(L2Npc npc, L2PcInstance caster, Skill skill, L2Object[] targets, boolean isSummon) {
        return null;
    }

    public String onSpellFinished(L2Npc npc, L2PcInstance player, Skill skill) {
        return null;
    }

    public String onTrapAction(L2TrapInstance trap, L2Character trigger, TrapAction action) {
        return null;
    }

    public String onSpawn(L2Npc npc) {
        return null;
    }

    protected void onTeleport(L2Npc npc) {
    }

    public String onFactionCall(L2Npc npc, L2Npc caller, L2PcInstance attacker, boolean isSummon) {
        return null;
    }

    public String onAggroRangeEnter(L2Npc npc, L2PcInstance player, boolean isSummon) {
        return null;
    }

    public String onSeeCreature(L2Npc npc, L2Character creature, boolean isSummon) {
        return null;
    }

    public String onEnterWorld(L2PcInstance player) {
        return null;
    }

    public String onEnterZone(L2Character character, L2ZoneType zone) {
        return null;
    }

    public String onExitZone(L2Character character, L2ZoneType zone) {
        return null;
    }

    public String onEventReceived(String eventName, L2Npc sender, L2Npc receiver, L2Object reference) {
        return null;
    }

    public void onOlympiadMatchFinish(Participant winner, Participant looser, CompetitionType type) {
    }

    public void onOlympiadLose(L2PcInstance loser, CompetitionType type) {
    }

    public boolean onMoveFinished(L2Npc npc) {
        return false;
    }

    public boolean onNodeArrived(L2Npc npc) {
        return false;
    }

    public void onRouteFinished(L2Npc npc) {
    }

    public void addRegenerateId(int npcId) {
        this.addRegenerateId(new int[]{npcId});
    }

    public void addRegenerateId(int ... npcIds) {
        this.registerConsumer((? extends IBaseEvent event) -> this.notifyRegenerate(event.npc), EventType.ON_NPC_REGENERATE, ListenerRegisterType.NPC, npcIds);
    }

    public void addRegenerateId(Collection<Integer> npcIds) {
        this.registerConsumer((? extends IBaseEvent event) -> this.notifyRegenerate(event.npc), EventType.ON_NPC_REGENERATE, ListenerRegisterType.NPC, npcIds);
    }

    public final void notifyRegenerate(L2Npc npc) {
        this.onRegenerate(npc);
    }

    public String onRegenerate(L2Npc npc) {
        return null;
    }

    public boolean onNpcHate(L2Attackable mob, L2PcInstance player, boolean isSummon) {
        return true;
    }

    public void onSummonSpawn(L2Summon summon) {
    }

    public void onSummonTalk(L2Summon summon) {
    }

    public boolean onCanSeeMe(L2Npc npc, L2PcInstance player) {
        return false;
    }

    public boolean showError(L2PcInstance player, Throwable t) {
        _log.log(Level.WARNING, this.getScriptFile().getAbsolutePath(), t);
        if (t.getMessage() == null) {
            _log.warning(this.getClass().getSimpleName() + ": " + t.getMessage());
        }
        if (player != null && player.getAccessLevel().isGm()) {
            String res = "<html><body><title>Script error</title>" + Util.getStackTrace(t) + "</body></html>";
            return this.showResult(player, res);
        }
        t.printStackTrace();
        return false;
    }

    public boolean showResult(L2PcInstance player, String res) {
        return this.showResult(player, res, null);
    }

    public boolean showResult(L2PcInstance player, String res, L2Npc npc) {
        if (res == null || res.isEmpty() || player == null) {
            return true;
        }
        if (res.endsWith(".htm") || res.endsWith(".html")) {
            this.showHtmlFile(player, res, npc);
        } else if (res.startsWith("<html>")) {
            NpcHtmlMessage npcReply = new NpcHtmlMessage(npc != null ? npc.getObjectId() : 0, res);
            npcReply.replace((CharSequence)"%playername%", player.getName());
            player.sendPacket(npcReply);
            player.sendPacket(ActionFailed.STATIC_PACKET);
        } else {
            player.sendMessage(res);
        }
        return false;
    }

    public static final void playerEnter(L2PcInstance player) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement invalidQuestData = con.prepareStatement("DELETE FROM character_quests WHERE charId = ? AND name = ?");
             PreparedStatement invalidQuestDataVar = con.prepareStatement("DELETE FROM character_quests WHERE charId = ? AND name = ? AND var = ?");
             PreparedStatement ps1 = con.prepareStatement("SELECT name, value FROM character_quests WHERE charId = ? AND var = ?");){
            ps1.setInt(1, player.getObjectId());
            ps1.setString(2, "<state>");
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    String questId = rs.getString("name");
                    String statename = rs.getString("value");
                    Quest q = QuestManager.getInstance().getQuest(questId);
                    if (q == null) {
                        _log.finer("Unknown quest " + questId + " for player " + player.getName());
                        if (!Config.AUTODELETE_INVALID_QUEST_DATA) continue;
                        invalidQuestData.setInt(1, player.getObjectId());
                        invalidQuestData.setString(2, questId);
                        invalidQuestData.executeUpdate();
                        continue;
                    }
                    new QuestState(q, player, State.getStateId(statename));
                }
            }
            var10_19 = null;
            try (PreparedStatement ps2 = con.prepareStatement("SELECT name, var, value FROM character_quests WHERE charId = ? AND var <> ?");){
                ps2.setInt(1, player.getObjectId());
                ps2.setString(2, "<state>");
                try (ResultSet rs = ps2.executeQuery();){
                    while (rs.next()) {
                        String questId = rs.getString("name");
                        String var = rs.getString("var");
                        String value = rs.getString("value");
                        QuestState qs = player.getQuestState(questId);
                        if (qs == null) {
                            _log.finer("Lost variable " + var + " in quest " + questId + " for player " + player.getName());
                            if (!Config.AUTODELETE_INVALID_QUEST_DATA) continue;
                            invalidQuestDataVar.setInt(1, player.getObjectId());
                            invalidQuestDataVar.setString(2, questId);
                            invalidQuestDataVar.setString(3, var);
                            invalidQuestDataVar.executeUpdate();
                            continue;
                        }
                        qs.setInternal(var, value);
                    }
                }
            }
            catch (Throwable throwable) {
                var10_19 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not insert char quest:", e);
        }
        for (String name : QuestManager.getInstance().getScripts().keySet()) {
            player.processQuestEvent(name, "enter");
        }
    }

    public final void saveGlobalQuestVar(String var, String value) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("REPLACE INTO quest_global_data (quest_name,var,value) VALUES (?,?,?)");){
            statement.setString(1, this.getName());
            statement.setString(2, var);
            statement.setString(3, value);
            statement.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not insert global quest variable:", e);
        }
    }

    public final String loadGlobalQuestVar(String var) {
        String result = "";
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT value FROM quest_global_data WHERE quest_name = ? AND var = ?");){
            statement.setString(1, this.getName());
            statement.setString(2, var);
            try (ResultSet rs = statement.executeQuery();){
                if (rs.first()) {
                    result = rs.getString(1);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not load global quest variable:", e);
        }
        return result;
    }

    public final void deleteGlobalQuestVar(String var) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("DELETE FROM quest_global_data WHERE quest_name = ? AND var = ?");){
            statement.setString(1, this.getName());
            statement.setString(2, var);
            statement.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not delete global quest variable:", e);
        }
    }

    public final void deleteAllGlobalQuestVars() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("DELETE FROM quest_global_data WHERE quest_name = ?");){
            statement.setString(1, this.getName());
            statement.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not delete global quest variables:", e);
        }
    }

    public static void createQuestVarInDb(QuestState qs, String var, String value) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("INSERT INTO character_quests (charId,name,var,value) VALUES (?,?,?,?) ON DUPLICATE KEY UPDATE value=?");){
            statement.setInt(1, qs.getPlayer().getObjectId());
            statement.setString(2, qs.getQuestName());
            statement.setString(3, var);
            statement.setString(4, value);
            statement.setString(5, value);
            statement.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not insert char quest:", e);
        }
    }

    public static void updateQuestVarInDb(QuestState qs, String var, String value) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("UPDATE character_quests SET value=? WHERE charId=? AND name=? AND var = ?");){
            statement.setString(1, value);
            statement.setInt(2, qs.getPlayer().getObjectId());
            statement.setString(3, qs.getQuestName());
            statement.setString(4, var);
            statement.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not update char quest:", e);
        }
    }

    public static void deleteQuestVarInDb(QuestState qs, String var) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("DELETE FROM character_quests WHERE charId=? AND name=? AND var=?");){
            statement.setInt(1, qs.getPlayer().getObjectId());
            statement.setString(2, qs.getQuestName());
            statement.setString(3, var);
            statement.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not delete char quest:", e);
        }
    }

    public static void deleteQuestInDb(QuestState qs, boolean repeatable) {
        Quest.deleteQuestInDb(qs.getPlayer().getObjectId(), qs.getQuestName(), repeatable);
    }

    public static void deleteQuestInDb(int playerObjectId, String questName, boolean repeatable) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement(repeatable ? QUEST_DELETE_FROM_CHAR_QUERY : QUEST_DELETE_FROM_CHAR_QUERY_NON_REPEATABLE_QUERY);){
            ps.setInt(1, playerObjectId);
            ps.setString(2, questName);
            if (!repeatable) {
                ps.setString(3, "<state>");
            }
            ps.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not delete char quest:", e);
        }
    }

    public static void createQuestInDb(QuestState qs) {
        Quest.createQuestVarInDb(qs, "<state>", State.getStateName(qs.getState()));
    }

    public static void updateQuestInDb(QuestState qs) {
        Quest.updateQuestVarInDb(qs, "<state>", State.getStateName(qs.getState()));
    }

    public static String getNoQuestMsg(L2PcInstance player) {
        String result = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/noquest.htm");
        if (result != null && result.length() > 0) {
            return result;
        }
        return DEFAULT_NO_QUEST_MSG;
    }

    public static String getAlreadyCompletedMsg(L2PcInstance player) {
        String result = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/alreadycompleted.htm");
        if (result != null && result.length() > 0) {
            return result;
        }
        return DEFAULT_ALREADY_COMPLETED_MSG;
    }

    public void addStartNpc(int npcId) {
        this.addStartNpc(new int[]{npcId});
    }

    public void addStartNpc(int ... npcIds) {
        this.setNpcQuestStartId(npcIds);
    }

    public void addStartNpc(Collection<Integer> npcIds) {
        this.setNpcQuestStartId(npcIds);
    }

    public void addFirstTalkId(int npcId) {
        this.addFirstTalkId(new int[]{npcId});
    }

    public void addFirstTalkId(int ... npcIds) {
        this.setNpcFirstTalkId((OnNpcFirstTalk event) -> this.notifyFirstTalk(event.getNpc(), event.getActiveChar()), npcIds);
    }

    public void addFirstTalkId(Collection<Integer> npcIds) {
        this.setNpcFirstTalkId((OnNpcFirstTalk event) -> this.notifyFirstTalk(event.getNpc(), event.getActiveChar()), npcIds);
    }

    public void addAcquireSkillId(int npcId) {
        this.addAcquireSkillId(new int[]{npcId});
    }

    public void addAcquireSkillId(int ... npcIds) {
        this.setPlayerSkillLearnId((OnPlayerSkillLearn event) -> this.notifyAcquireSkill(event.getTrainer(), event.getActiveChar(), event.getSkill(), event.getAcquireType()), npcIds);
    }

    public void addAcquireSkillId(Collection<Integer> npcIds) {
        this.setPlayerSkillLearnId((OnPlayerSkillLearn event) -> this.notifyAcquireSkill(event.getTrainer(), event.getActiveChar(), event.getSkill(), event.getAcquireType()), npcIds);
    }

    public void addItemBypassEventId(int itemId) {
        this.addItemBypassEventId(new int[]{itemId});
    }

    public void addItemBypassEventId(int ... itemIds) {
        this.setItemBypassEvenId((OnItemBypassEvent event) -> this.notifyItemEvent(event.getItem(), event.getActiveChar(), event.getEvent()), itemIds);
    }

    public void addItemBypassEventId(Collection<Integer> itemIds) {
        this.setItemBypassEvenId((OnItemBypassEvent event) -> this.notifyItemEvent(event.getItem(), event.getActiveChar(), event.getEvent()), itemIds);
    }

    public void addItemTalkId(int itemId) {
        this.addItemTalkId(new int[]{itemId});
    }

    public void addItemTalkId(int ... itemIds) {
        this.setItemTalkId((OnItemTalk event) -> this.notifyItemTalk(event.getItem(), event.getActiveChar()), itemIds);
    }

    public void addItemTalkId(Collection<Integer> itemIds) {
        this.setItemTalkId((OnItemTalk event) -> this.notifyItemTalk(event.getItem(), event.getActiveChar()), itemIds);
    }

    public void addAttackId(int npcId) {
        this.addAttackId(new int[]{npcId});
    }

    public void addAttackId(int ... npcIds) {
        this.setAttackableAttackId((OnAttackableAttack attack) -> this.notifyAttack(attack.getTarget(), attack.getAttacker(), attack.getDamage(), attack.isSummon(), attack.getSkill()), npcIds);
    }

    public void addAttackId(Collection<Integer> npcIds) {
        this.setAttackableAttackId((OnAttackableAttack attack) -> this.notifyAttack(attack.getTarget(), attack.getAttacker(), attack.getDamage(), attack.isSummon(), attack.getSkill()), npcIds);
    }

    public void addKillId(int npcId) {
        this.addKillId(new int[]{npcId});
    }

    public void addKillId(int ... npcIds) {
        this.setAttackableKillId((OnAttackableKill kill) -> this.notifyKill(kill.getTarget(), kill.getAttacker(), kill.isSummon()), npcIds);
    }

    public void addKillId(Collection<Integer> npcIds) {
        this.setAttackableKillId((OnAttackableKill kill) -> this.notifyKill(kill.getTarget(), kill.getAttacker(), kill.isSummon()), npcIds);
    }

    public void addTalkId(int npcId) {
        this.addTalkId(new int[]{npcId});
    }

    public void addTalkId(int ... npcIds) {
        this.setNpcTalkId(npcIds);
    }

    public void addTalkId(Collection<Integer> npcIds) {
        this.setNpcTalkId(npcIds);
    }

    public void addTeleportId(int npcId) {
        this.addTeleportId(new int[]{npcId});
    }

    public void addTeleportId(int ... npcIds) {
        this.setNpcTeleportId((OnNpcTeleport event) -> this.notifyTeleport(event.getNpc()), npcIds);
    }

    public void addTeleportId(Collection<Integer> npcIds) {
        this.setNpcTeleportId((OnNpcTeleport event) -> this.notifyTeleport(event.getNpc()), npcIds);
    }

    public void addSpawnId(int npcId) {
        this.addSpawnId(new int[]{npcId});
    }

    public void addSpawnId(int ... npcIds) {
        this.setNpcSpawnId((OnNpcSpawn event) -> this.notifySpawn(event.getNpc()), npcIds);
    }

    public void addSpawnId(Collection<Integer> npcIds) {
        this.setNpcSpawnId((OnNpcSpawn event) -> this.notifySpawn(event.getNpc()), npcIds);
    }

    public void addSkillSeeId(int npcId) {
        this.addSkillSeeId(new int[]{npcId});
    }

    public void addSkillSeeId(int ... npcIds) {
        this.setNpcSkillSeeId((OnNpcSkillSee event) -> this.notifySkillSee(event.getTarget(), event.getCaster(), event.getSkill(), event.getTargets(), event.isSummon()), npcIds);
    }

    public void addSkillSeeId(Collection<Integer> npcIds) {
        this.setNpcSkillSeeId((OnNpcSkillSee event) -> this.notifySkillSee(event.getTarget(), event.getCaster(), event.getSkill(), event.getTargets(), event.isSummon()), npcIds);
    }

    public void addSpellFinishedId(int npcId) {
        this.addSpellFinishedId(new int[]{npcId});
    }

    public void addSpellFinishedId(int ... npcIds) {
        this.setNpcSkillFinishedId((OnNpcSkillFinished event) -> this.notifySpellFinished(event.getCaster(), event.getTarget(), event.getSkill()), npcIds);
    }

    public void addSpellFinishedId(Collection<Integer> npcIds) {
        this.setNpcSkillFinishedId((OnNpcSkillFinished event) -> this.notifySpellFinished(event.getCaster(), event.getTarget(), event.getSkill()), npcIds);
    }

    public void addTrapActionId(int npcId) {
        this.addTrapActionId(new int[]{npcId});
    }

    public void addTrapActionId(int ... npcIds) {
        this.setTrapActionId((OnTrapAction event) -> this.notifyTrapAction(event.getTrap(), event.getTrigger(), event.getAction()), npcIds);
    }

    public void addTrapActionId(Collection<Integer> npcIds) {
        this.setTrapActionId((OnTrapAction event) -> this.notifyTrapAction(event.getTrap(), event.getTrigger(), event.getAction()), npcIds);
    }

    public void addFactionCallId(int npcId) {
        this.addFactionCallId(new int[]{npcId});
    }

    public void addFactionCallId(int ... npcIds) {
        this.setAttackableFactionIdId((OnAttackableFactionCall event) -> this.notifyFactionCall(event.getNpc(), event.getCaller(), event.getAttacker(), event.isSummon()), npcIds);
    }

    public void addFactionCallId(Collection<Integer> npcIds) {
        this.setAttackableFactionIdId((OnAttackableFactionCall event) -> this.notifyFactionCall(event.getNpc(), event.getCaller(), event.getAttacker(), event.isSummon()), npcIds);
    }

    public void addAggroRangeEnterId(int npcId) {
        this.addAggroRangeEnterId(new int[]{npcId});
    }

    public void addAggroRangeEnterId(int ... npcIds) {
        this.setAttackableAggroRangeEnterId((OnAttackableAggroRangeEnter event) -> this.notifyAggroRangeEnter(event.getNpc(), event.getActiveChar(), event.isSummon()), npcIds);
    }

    public void addAggroRangeEnterId(Collection<Integer> npcIds) {
        this.setAttackableAggroRangeEnterId((OnAttackableAggroRangeEnter event) -> this.notifyAggroRangeEnter(event.getNpc(), event.getActiveChar(), event.isSummon()), npcIds);
    }

    public void addSeeCreatureId(int npcId) {
        this.addSeeCreatureId(new int[]{npcId});
    }

    public void addSeeCreatureId(int ... npcIds) {
        this.setNpcCreatureSeeId((OnNpcCreatureSee event) -> this.notifySeeCreature(event.getNpc(), event.getCreature(), event.isSummon()), npcIds);
    }

    public void addSeeCreatureId(Collection<Integer> npcIds) {
        this.setNpcCreatureSeeId((OnNpcCreatureSee event) -> this.notifySeeCreature(event.getNpc(), event.getCreature(), event.isSummon()), npcIds);
    }

    public void addEnterZoneId(int zoneId) {
        this.setCreatureZoneEnterId((OnCreatureZoneEnter event) -> this.notifyEnterZone(event.getCreature(), event.getZone()), zoneId);
    }

    public void addEnterZoneId(int ... zoneIds) {
        this.setCreatureZoneEnterId((OnCreatureZoneEnter event) -> this.notifyEnterZone(event.getCreature(), event.getZone()), zoneIds);
    }

    public void addEnterZoneId(Collection<Integer> zoneIds) {
        this.setCreatureZoneEnterId((OnCreatureZoneEnter event) -> this.notifyEnterZone(event.getCreature(), event.getZone()), zoneIds);
    }

    public void addExitZoneId(int zoneId) {
        this.setCreatureZoneExitId((OnCreatureZoneExit event) -> this.notifyExitZone(event.getCreature(), event.getZone()), zoneId);
    }

    public void addExitZoneId(int ... zoneIds) {
        this.setCreatureZoneExitId((OnCreatureZoneExit event) -> this.notifyExitZone(event.getCreature(), event.getZone()), zoneIds);
    }

    public void addExitZoneId(Collection<Integer> zoneIds) {
        this.setCreatureZoneExitId((OnCreatureZoneExit event) -> this.notifyExitZone(event.getCreature(), event.getZone()), zoneIds);
    }

    public void addEventReceivedId(int npcId) {
        this.addEventReceivedId(new int[]{npcId});
    }

    public void addEventReceivedId(int ... npcIds) {
        this.setNpcEventReceivedId((OnNpcEventReceived event) -> this.notifyEventReceived(event.getEventName(), event.getSender(), event.getReceiver(), event.getReference()), npcIds);
    }

    public void addEventReceivedId(Collection<Integer> npcIds) {
        this.setNpcEventReceivedId((OnNpcEventReceived event) -> this.notifyEventReceived(event.getEventName(), event.getSender(), event.getReceiver(), event.getReference()), npcIds);
    }

    public void addMoveFinishedId(int npcId) {
        L2NpcTemplate npcTemplate = NpcData.getInstance().getTemplate(npcId);
        npcTemplate.addListener(new DummyEventListener(npcTemplate, EventType.ON_NPC_MOVE_FINISHED, this));
    }

    public void addMoveFinishedId(int ... npcIds) {
        for (int npcId : npcIds) {
            this.addMoveFinishedId(npcId);
        }
    }

    public void addMoveFinishedId(Collection<Integer> npcIds) {
        for (int npcId : npcIds) {
            this.addMoveFinishedId(npcId);
        }
    }

    public void addNodeArrivedId(int npcId) {
        L2NpcTemplate npcTemplate = NpcData.getInstance().getTemplate(npcId);
        npcTemplate.addListener(new DummyEventListener(npcTemplate, EventType.ON_NPC_MOVE_NODE_ARRIVED, this));
    }

    public void addNodeArrivedId(int ... npcIds) {
        for (int npcId : npcIds) {
            this.addNodeArrivedId(npcId);
        }
    }

    public void addNodeArrivedId(Collection<Integer> npcIds) {
        for (int npcId : npcIds) {
            this.addNodeArrivedId(npcId);
        }
    }

    public void addRouteFinishedId(int npcId) {
        this.addRouteFinishedId(new int[]{npcId});
    }

    public void addRouteFinishedId(int ... npcIds) {
        this.setNpcMoveRouteFinishedId((OnNpcMoveRouteFinished event) -> this.notifyRouteFinished(event.getNpc()), npcIds);
    }

    public void addRouteFinishedId(Collection<Integer> npcIds) {
        this.setNpcMoveRouteFinishedId((OnNpcMoveRouteFinished event) -> this.notifyRouteFinished(event.getNpc()), npcIds);
    }

    public void addNpcHateId(int npcId) {
        this.addNpcHateId(new int[]{npcId});
    }

    public void addNpcHateId(int ... npcIds) {
        this.addNpcHateId((OnAttackableHate event) -> new TerminateReturn(!this.onNpcHate(event.getNpc(), event.getActiveChar(), event.isSummon()), false, false), npcIds);
    }

    public void addNpcHateId(Collection<Integer> npcIds) {
        this.addNpcHateId((OnAttackableHate event) -> new TerminateReturn(!this.onNpcHate(event.getNpc(), event.getActiveChar(), event.isSummon()), false, false), npcIds);
    }

    public void addSummonSpawnId(int npcId) {
        this.addSummonSpawnId(new int[]{npcId});
    }

    public void addSummonSpawnId(int ... npcIds) {
        this.setPlayerSummonSpawnId((OnPlayerSummonSpawn event) -> this.onSummonSpawn(event.getSummon()), npcIds);
    }

    public void addSummonSpawnId(Collection<Integer> npcIds) {
        this.setPlayerSummonSpawnId((OnPlayerSummonSpawn event) -> this.onSummonSpawn(event.getSummon()), npcIds);
    }

    public void addSummonTalkId(int npcId) {
        this.addSummonTalkId(new int[]{npcId});
    }

    public void addSummonTalkId(int ... npcIds) {
        this.setPlayerSummonTalkId((OnPlayerSummonTalk event) -> this.onSummonTalk(event.getSummon()), npcIds);
    }

    public void addSummonTalkId(Collection<Integer> npcIds) {
        this.setPlayerSummonTalkId((OnPlayerSummonSpawn event) -> this.onSummonTalk(event.getSummon()), npcIds);
    }

    public void addCanSeeMeId(int npcId) {
        this.addCanSeeMeId(new int[]{npcId});
    }

    public void addCanSeeMeId(int ... npcIds) {
        this.addNpcHateId((OnAttackableHate event) -> new TerminateReturn(!this.notifyOnCanSeeMe(event.getNpc(), event.getActiveChar()), false, false), npcIds);
    }

    public void addCanSeeMeId(Collection<Integer> npcIds) {
        this.addNpcHateId((OnAttackableHate event) -> new TerminateReturn(!this.notifyOnCanSeeMe(event.getNpc(), event.getActiveChar()), false, false), npcIds);
    }

    public void addOlympiadMatchFinishId() {
        this.setOlympiadMatchResult(event -> this.notifyOlympiadMatch(event.getWinner(), event.getLoser(), event.getCompetitionType()));
    }

    public L2PcInstance getRandomPartyMember(L2PcInstance player) {
        if (player == null) {
            return null;
        }
        L2Party party = player.getParty();
        if (party == null || party.getMembers().isEmpty()) {
            return player;
        }
        return party.getMembers().get(Rnd.get(party.getMembers().size()));
    }

    public L2PcInstance getRandomPartyMember(L2PcInstance player, String cond) {
        return this.getRandomPartyMember(player, "cond", cond);
    }

    public L2PcInstance getRandomPartyMember(L2PcInstance player, int cond) {
        return this.getRandomPartyMember(player, cond >= 0 && cond <= 20 ? COND_CHACHE[cond] : String.valueOf(cond));
    }

    public L2PcInstance getRandomPartyMember(L2PcInstance player, String var, String value) {
        if (player == null) {
            return null;
        }
        if (var == null) {
            return this.getRandomPartyMember(player);
        }
        QuestState temp = null;
        L2Party party = player.getParty();
        if (party == null || party.getMembers().isEmpty()) {
            temp = player.getQuestState(this.getName());
            if (temp != null && value.equalsIgnoreCase(temp.get(var))) {
                return player;
            }
            return null;
        }
        ArrayList<L2PcInstance> candidates = new ArrayList<L2PcInstance>();
        L2Object target = player.getTarget();
        if (target == null) {
            target = player;
        }
        for (L2PcInstance partyMember : party.getMembers()) {
            if (partyMember == null || (temp = partyMember.getQuestState(this.getName())) == null || !value.equalsIgnoreCase(temp.get(var)) || !partyMember.isInsideRadius(target, 1500, true, false)) continue;
            candidates.add(partyMember);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        return (L2PcInstance)candidates.get(Rnd.get(candidates.size()));
    }

    public L2PcInstance getRandomPartyMemberState(L2PcInstance player, byte state) {
        if (player == null) {
            return null;
        }
        QuestState temp = null;
        L2Party party = player.getParty();
        if (party == null || party.getMembers().isEmpty()) {
            temp = player.getQuestState(this.getName());
            if (temp != null && temp.getState() == state) {
                return player;
            }
            return null;
        }
        ArrayList<L2PcInstance> candidates = new ArrayList<L2PcInstance>();
        L2Object target = player.getTarget();
        if (target == null) {
            target = player;
        }
        for (L2PcInstance partyMember : party.getMembers()) {
            if (partyMember == null || (temp = partyMember.getQuestState(this.getName())) == null || temp.getState() != state || !partyMember.isInsideRadius(target, 1500, true, false)) continue;
            candidates.add(partyMember);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        return (L2PcInstance)candidates.get(Rnd.get(candidates.size()));
    }

    public L2PcInstance getRandomPartyMember(L2PcInstance player, L2Npc npc) {
        if (player == null || !Quest.checkDistanceToTarget(player, npc)) {
            return null;
        }
        L2Party party = player.getParty();
        L2PcInstance luckyPlayer = null;
        if (party == null) {
            if (this.checkPartyMember(player, npc)) {
                luckyPlayer = player;
            }
        } else {
            int highestRoll = 0;
            for (L2PcInstance member : party.getMembers()) {
                int rnd = Quest.getRandom(1000);
                if (rnd <= highestRoll || !this.checkPartyMember(member, npc)) continue;
                highestRoll = rnd;
                luckyPlayer = member;
            }
        }
        if (luckyPlayer != null && Quest.checkDistanceToTarget(luckyPlayer, npc)) {
            return luckyPlayer;
        }
        return null;
    }

    public boolean checkPartyMember(L2PcInstance player, L2Npc npc) {
        return true;
    }

    public QuestState getRandomPartyMemberState(L2PcInstance player, int condition, int playerChance, L2Npc target) {
        if (player == null || playerChance < 1) {
            return null;
        }
        QuestState qs = player.getQuestState(this.getName());
        if (!player.isInParty()) {
            if (!this.checkPartyMemberConditions(qs, condition, target)) {
                return null;
            }
            if (!Quest.checkDistanceToTarget(player, target)) {
                return null;
            }
            return qs;
        }
        ArrayList<QuestState> candidates = new ArrayList<QuestState>();
        if (this.checkPartyMemberConditions(qs, condition, target) && playerChance > 0) {
            for (int i = 0; i < playerChance; ++i) {
                candidates.add(qs);
            }
        }
        for (L2PcInstance member : player.getParty().getMembers()) {
            if (member == player || !this.checkPartyMemberConditions(qs = member.getQuestState(this.getName()), condition, target)) continue;
            candidates.add(qs);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        qs = (QuestState)candidates.get(Quest.getRandom(candidates.size()));
        if (!Quest.checkDistanceToTarget(qs.getPlayer(), target)) {
            return null;
        }
        return qs;
    }

    private boolean checkPartyMemberConditions(QuestState qs, int condition, L2Npc npc) {
        return qs != null && (condition == -1 ? qs.isStarted() : qs.isCond(condition)) && this.checkPartyMember(qs, npc);
    }

    private static boolean checkDistanceToTarget(L2PcInstance player, L2Npc target) {
        return target == null || com.l2jserver.gameserver.util.Util.checkIfInRange(1500, player, target, true);
    }

    public boolean checkPartyMember(QuestState qs, L2Npc npc) {
        return true;
    }

    public String showHtmlFile(L2PcInstance player, String filename) {
        return this.showHtmlFile(player, filename, null, !filename.endsWith(".html"));
    }

    public String showHtmlFile(L2PcInstance player, String filename, L2Npc npc) {
        return this.showHtmlFile(player, filename, npc, !filename.endsWith(".html"));
    }

    public String showHtmlFile(L2PcInstance player, String filename, L2Npc npc, boolean questwindow) {
        int questId = this.getId();
        String content = this.getHtm(player.getHtmlPrefix(), filename);
        if (content != null) {
            if (npc != null) {
                content = content.replaceAll("%objectId%", Integer.toString(npc.getObjectId()));
            }
            if (questwindow && this.isQuests() && questId != 999) {
                NpcQuestHtmlMessage npcReply = new NpcQuestHtmlMessage(npc != null ? npc.getObjectId() : 0, questId);
                npcReply.setHtml(content);
                npcReply.replace((CharSequence)"%playername%", player.getName());
                player.sendPacket(npcReply);
            } else {
                NpcHtmlMessage npcReply = new NpcHtmlMessage(npc != null ? npc.getObjectId() : 0, content);
                npcReply.replace((CharSequence)"%playername%", player.getName());
                player.sendPacket(npcReply);
            }
            player.sendPacket(ActionFailed.STATIC_PACKET);
        }
        return content;
    }

    public String getHtm(String prefix, String fileName) {
        HtmCache hc = HtmCache.getInstance();
        String content = hc.getHtm(prefix, fileName.startsWith("data/") ? fileName : "data/scripts/" + this.getDescr().toLowerCase() + "/" + this.getName() + "/" + fileName);
        if (content == null && (content = hc.getHtm(prefix, "data/scripts/" + this.getDescr() + "/" + this.getName() + "/" + fileName)) == null) {
            content = hc.getHtmForce(prefix, "data/scripts/quests/" + this.getName() + "/" + fileName);
        }
        return content;
    }

    public int[] getRegisteredItemIds() {
        return this.questItemIds;
    }

    public void registerQuestItems(int item) {
        this.registerQuestItems(new int[]{item});
    }

    public void registerQuestItems(int ... items) {
        this.questItemIds = items;
    }

    public void removeRegisteredQuestItems(L2PcInstance player) {
        Quest.takeItems(player, -1, this.questItemIds);
    }

    @Override
    public String getScriptName() {
        return this.getName();
    }

    @Override
    public void setActive(boolean status) {
    }

    @Override
    public boolean reload() {
        this.unload();
        return super.reload();
    }

    @Override
    public boolean unload() {
        return this.unload(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelAllQuestTimers() {
        for (ArrayList timers : this._allEventTimers.values()) {
            this._readLock.lock();
            try {
                for (QuestTimer timer : timers) {
                    timer.cancel();
                }
            }
            finally {
                this._readLock.unlock();
            }
            timers.clear();
        }
        this._allEventTimers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unload(boolean removeFromList) {
        this.saveGlobalData();
        for (ArrayList timers : this._allEventTimers.values()) {
            this._readLock.lock();
            try {
                for (QuestTimer timer : timers) {
                    timer.cancel();
                }
            }
            finally {
                this._readLock.unlock();
            }
            timers.clear();
        }
        this._allEventTimers.clear();
        if (removeFromList) {
            return QuestManager.getInstance().removeScript(this) && super.unload();
        }
        return super.unload();
    }

    @Override
    public ScriptManager<?> getScriptManager() {
        return QuestManager.getInstance();
    }

    public void setOnEnterWorld(boolean state) {
        if (state) {
            this.setPlayerLoginId(event -> this.notifyEnterWorld(event.getActiveChar()));
        } else {
            this.getListeners().stream().filter(listener -> listener.getType() == EventType.ON_PLAYER_LOGIN).forEach(AbstractEventListener::unregisterMe);
        }
    }

    protected static class OnNpcRegenerate
    implements IBaseEvent {
        final L2Npc npc;

        public OnNpcRegenerate(L2Npc npc) {
            this.npc = npc;
        }

        @Override
        public EventType getType() {
            return EventType.ON_NPC_REGENERATE;
        }
    }

    public static enum Repeating {
        None,
        AtFixedRate,
        WithFixedDelay;

    }
}

