/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.skills;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.datatables.StringIntern;
import com.l2jserver.gameserver.enums.ShotType;
import com.l2jserver.gameserver.handler.ITargetTypeHandler;
import com.l2jserver.gameserver.handler.TargetHandler;
import com.l2jserver.gameserver.model.L2ExtractableProductItem;
import com.l2jserver.gameserver.model.L2ExtractableSkill;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2BlockInstance;
import com.l2jserver.gameserver.model.actor.instance.L2CubicInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TamedBeastInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.effects.AbstractEffect;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.AbnormalVisualEffect;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.CommonSkill;
import com.l2jserver.gameserver.model.skills.EffectScope;
import com.l2jserver.gameserver.model.skills.SkillOperateType;
import com.l2jserver.gameserver.model.skills.funcs.Func;
import com.l2jserver.gameserver.model.skills.funcs.FuncTemplate;
import com.l2jserver.gameserver.model.skills.targets.L2TargetType;
import com.l2jserver.gameserver.model.stats.BaseStats;
import com.l2jserver.gameserver.model.stats.Env;
import com.l2jserver.gameserver.model.stats.Formulas;
import com.l2jserver.gameserver.model.stats.TraitType;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.serverpackets.FlyToLocation;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Skill
implements IIdentifiable {
    private static final Logger _log = Logger.getLogger(Skill.class.getName());
    public static final Skill[] EMPTY_SKILL_LIST = new Skill[0];
    private static final L2Object[] EMPTY_TARGET_LIST = new L2Object[0];
    private final int _id;
    private final int _level;
    private final int _displayId;
    private final int _displayLevel;
    private final String _name;
    private final SkillOperateType _operateType;
    private final int _magic;
    private final TraitType _traitType;
    private final boolean _staticReuse;
    private final int _mpConsume;
    private final int _mpInitialConsume;
    private final int _mpPerChanneling;
    private final int _hpConsume;
    private final int _itemConsumeCount;
    private final int _itemConsumeId;
    private final int _castRange;
    private final int _effectRange;
    private final boolean _isAbnormalInstant;
    private final int _abnormalLvl;
    private final AbnormalType _abnormalType;
    private final int _abnormalTime;
    private AbnormalVisualEffect[] _abnormalVisualEffects = null;
    private AbnormalVisualEffect[] _abnormalVisualEffectsSpecial = null;
    private AbnormalVisualEffect[] _abnormalVisualEffectsEvent = null;
    private final boolean _stayAfterDeath;
    private final boolean _stayOnSubclassChange;
    private final boolean _isRecoveryHerb;
    private final int _refId;
    private final int _hitTime;
    private final int _coolTime;
    private final int _reuseHashCode;
    private final int _reuseDelay;
    private final L2TargetType _targetType;
    private final int _feed;
    private final double _power;
    private final double _pvpPower;
    private final double _pvePower;
    private final int _magicLevel;
    private final int _lvlBonusRate;
    private final int _activateRate;
    private final int _minChance;
    private final int _maxChance;
    private final int _blowChance;
    private final int _affectRange;
    private final int[] _affectLimit;
    private static final int[] DEFAULT_AFFECT_LIMIT = new int[2];
    private final boolean _nextActionIsAttack;
    private final boolean _removedOnAnyActionExceptMove;
    private final boolean _removedOnDamage;
    private final boolean _blockedInOlympiad;
    private final byte _element;
    private final int _elementPower;
    private final BaseStats _basicProperty;
    private final boolean _overhit;
    private final int _minPledgeClass;
    private final int _chargeConsume;
    private final int _soulMaxConsume;
    private final boolean _isHeroSkill;
    private final boolean _isGMSkill;
    private final boolean _isSevenSigns;
    private final int _baseCritRate;
    private final boolean _directHpDmg;
    private final boolean _isTriggeredSkill;
    private final int _effectPoint;
    private List<Condition> _preCondition;
    private List<Condition> _itemPreCondition;
    private List<FuncTemplate> _funcTemplates;
    private final EnumMap<EffectScope, List<AbstractEffect>> _effectLists = new EnumMap(EffectScope.class);
    private final FlyToLocation.FlyType _flyType;
    private final int _flyRadius;
    private final float _flyCourse;
    private final boolean _isDebuff;
    private final String _attribute;
    private final boolean _ignoreShield;
    private final boolean _isSuicideAttack;
    private final boolean _canBeDispeled;
    private final boolean _isClanSkill;
    private final boolean _excludedFromCheck;
    private final boolean _simultaneousCast;
    private L2ExtractableSkill _extractableItems = null;
    private final String _icon;
    private volatile byte[] _effectTypes;
    private final int _channelingSkillId;
    private final int _channelingTickInitialDelay;
    private final int _channelingTickInterval;

    public Skill(StatsSet set) {
        Integer v;
        this._id = set.getInt("skill_id");
        this._level = set.getInt("level");
        this._refId = set.getInt("referenceId", 0);
        this._displayId = set.getInt("displayId", this._id);
        this._displayLevel = set.getInt("displayLevel", this._level);
        this._name = set.getString("name", "");
        this._operateType = set.getEnum("operateType", SkillOperateType.class);
        this._magic = set.getInt("isMagic", 0);
        this._traitType = set.getEnum("trait", TraitType.class, TraitType.NONE);
        this._staticReuse = set.getBoolean("staticReuse", false);
        this._mpConsume = set.getInt("mpConsume", 0);
        this._mpInitialConsume = set.getInt("mpInitialConsume", 0);
        this._mpPerChanneling = set.getInt("mpPerChanneling", this._mpConsume);
        this._hpConsume = set.getInt("hpConsume", 0);
        this._itemConsumeCount = set.getInt("itemConsumeCount", 0);
        this._itemConsumeId = set.getInt("itemConsumeId", 0);
        this._castRange = set.getInt("castRange", -1);
        this._effectRange = set.getInt("effectRange", -1);
        this._abnormalLvl = set.getInt("abnormalLvl", 0);
        this._abnormalType = set.getEnum("abnormalType", AbnormalType.class, AbnormalType.NONE);
        int abnormalTime = set.getInt("abnormalTime", 0);
        if (Config.ENABLE_MODIFY_SKILL_DURATION && (v = Config.SKILL_DURATION_LIST.get(this.getId())) != null) {
            if (this.getLevel() < 100 || this.getLevel() > 140) {
                abnormalTime = v;
            } else if (this.getLevel() >= 100 && this.getLevel() < 140) {
                abnormalTime += v.intValue();
            }
        }
        this._abnormalTime = abnormalTime;
        this._isAbnormalInstant = set.getBoolean("abnormalInstant", false);
        this.parseAbnormalVisualEffect(set.getString("abnormalVisualEffect", null));
        this._attribute = StringIntern.intern(set.getString("attribute", ""));
        this._stayAfterDeath = set.getBoolean("stayAfterDeath", false);
        this._stayOnSubclassChange = set.getBoolean("stayOnSubclassChange", true);
        this._hitTime = set.getInt("hitTime", 0);
        this._coolTime = set.getInt("coolTime", 0);
        this._isDebuff = set.getBoolean("isDebuff", false);
        this._isRecoveryHerb = set.getBoolean("isRecoveryHerb", false);
        this._feed = set.getInt("feed", 0);
        this._reuseHashCode = SkillData.getSkillHashCode(this._id, this._level);
        if (Config.ENABLE_MODIFY_SKILL_REUSE && Config.SKILL_REUSE_LIST.containsKey(this._id)) {
            if (Config.DEBUG) {
                _log.info("*** Skill " + this._name + " (" + this._level + ") changed reuse from " + set.getInt("reuseDelay", 0) + " to " + Config.SKILL_REUSE_LIST.get(this._id) + " seconds.");
            }
            this._reuseDelay = Config.SKILL_REUSE_LIST.get(this._id);
        } else {
            this._reuseDelay = set.getInt("reuseDelay", 0);
        }
        this._affectRange = set.getInt("affectRange", 0);
        String affectLimit = set.getString("affectLimit", null);
        if (affectLimit != null) {
            try {
                String[] valuesSplit = affectLimit.split("-");
                this._affectLimit = new int[2];
                this._affectLimit[0] = Integer.parseInt(valuesSplit[0]);
                this._affectLimit[1] = Integer.parseInt(valuesSplit[1]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("SkillId: " + this._id + " invalid affectLimit value: " + affectLimit + ", \"percent-percent\" required");
            }
        } else {
            this._affectLimit = DEFAULT_AFFECT_LIMIT;
        }
        this._targetType = set.getEnum("targetType", L2TargetType.class, L2TargetType.SELF);
        this._power = set.getFloat("power", 0.0f);
        this._pvpPower = set.getFloat("pvpPower", (float)this.getPower());
        this._pvePower = set.getFloat("pvePower", (float)this.getPower());
        this._magicLevel = set.getInt("magicLvl", 0);
        this._lvlBonusRate = set.getInt("lvlBonusRate", 0);
        this._activateRate = set.getInt("activateRate", -1);
        this._minChance = set.getInt("minChance", Config.MIN_ABNORMAL_STATE_SUCCESS_RATE);
        this._maxChance = set.getInt("maxChance", Config.MAX_ABNORMAL_STATE_SUCCESS_RATE);
        this._ignoreShield = set.getBoolean("ignoreShld", false);
        this._nextActionIsAttack = set.getBoolean("nextActionAttack", false);
        this._removedOnAnyActionExceptMove = set.getBoolean("removedOnAnyActionExceptMove", false);
        this._removedOnDamage = set.getBoolean("removedOnDamage", false);
        this._blockedInOlympiad = set.getBoolean("blockedInOlympiad", false);
        this._element = set.getByte("element", (byte)-1);
        this._elementPower = set.getInt("elementPower", 0);
        this._basicProperty = set.getEnum("basicProperty", BaseStats.class, BaseStats.NONE);
        this._overhit = set.getBoolean("overHit", false);
        this._isSuicideAttack = set.getBoolean("isSuicideAttack", false);
        this._minPledgeClass = set.getInt("minPledgeClass", 0);
        this._chargeConsume = set.getInt("chargeConsume", 0);
        this._soulMaxConsume = set.getInt("soulMaxConsumeCount", 0);
        this._blowChance = set.getInt("blowChance", 0);
        this._isHeroSkill = SkillTreesData.getInstance().isHeroSkill(this._id, this._level);
        this._isGMSkill = SkillTreesData.getInstance().isGMSkill(this._id, this._level);
        this._isSevenSigns = this._id > 4360 && this._id < 4367;
        this._isClanSkill = SkillTreesData.getInstance().isClanSkill(this._id, this._level);
        this._baseCritRate = set.getInt("baseCritRate", 0);
        this._directHpDmg = set.getBoolean("dmgDirectlyToHp", false);
        this._isTriggeredSkill = set.getBoolean("isTriggeredSkill", false);
        this._effectPoint = set.getInt("effectPoint", 0);
        this._flyType = set.getEnum("flyType", FlyToLocation.FlyType.class, null);
        this._flyRadius = set.getInt("flyRadius", 0);
        this._flyCourse = set.getFloat("flyCourse", 0.0f);
        this._canBeDispeled = set.getBoolean("canBeDispeled", true);
        this._excludedFromCheck = set.getBoolean("excludedFromCheck", false);
        this._simultaneousCast = set.getBoolean("simultaneousCast", false);
        String capsuled_items = set.getString("capsuled_items_skill", null);
        if (capsuled_items != null) {
            if (capsuled_items.isEmpty()) {
                _log.warning("Empty Extractable Item Skill data in Skill Id: " + this._id);
            }
            this._extractableItems = this.parseExtractableSkill(this._id, this._level, capsuled_items);
        }
        this._icon = StringIntern.intern(set.getString("icon", "icon.skill0000"));
        this._channelingSkillId = set.getInt("channelingSkillId", 0);
        this._channelingTickInterval = set.getInt("channelingTickInterval", 2) * 1000;
        this._channelingTickInitialDelay = set.getInt("channelingTickInitialDelay", this._channelingTickInterval / 1000) * 1000;
    }

    public TraitType getTraitType() {
        return this._traitType;
    }

    public byte getElement() {
        return this._element;
    }

    public int getElementPower() {
        return this._elementPower;
    }

    public L2TargetType getTargetType() {
        return this._targetType;
    }

    public boolean isAOE() {
        switch (this._targetType) {
            case AREA: 
            case AURA: 
            case BEHIND_AREA: 
            case BEHIND_AURA: 
            case FRONT_AREA: 
            case FRONT_AURA: {
                return true;
            }
        }
        return false;
    }

    public boolean isDamage() {
        return this.hasEffectType(L2EffectType.MAGICAL_ATTACK, L2EffectType.HP_DRAIN, L2EffectType.PHYSICAL_ATTACK, L2EffectType.PHYSICAL_ATTACK_HP_LINK);
    }

    public boolean isOverhit() {
        return this._overhit;
    }

    public boolean isSuicideAttack() {
        return this._isSuicideAttack;
    }

    public boolean allowOnTransform() {
        return this.isPassive();
    }

    public double getPower(L2Character activeChar, L2Character target, boolean isPvP, boolean isPvE) {
        if (activeChar == null) {
            return this.getPower(isPvP, isPvE);
        }
        if (this.hasEffectType(L2EffectType.DEATH_LINK)) {
            return this.getPower(isPvP, isPvE) * (-(activeChar.getCurrentHp() * 2.0 / (double)activeChar.getMaxHp()) + 2.0);
        }
        if (this.hasEffectType(L2EffectType.PHYSICAL_ATTACK_HP_LINK)) {
            return this.getPower(isPvP, isPvE) * (-(target.getCurrentHp() * 2.0 / (double)target.getMaxHp()) + 2.0);
        }
        return this.getPower(isPvP, isPvE);
    }

    public double getPower() {
        return this._power;
    }

    public double getPower(boolean isPvP, boolean isPvE) {
        return isPvE ? this._pvePower : (isPvP ? this._pvpPower : this._power);
    }

    public boolean isAbnormalInstant() {
        return this._isAbnormalInstant;
    }

    public AbnormalType getAbnormalType() {
        return this._abnormalType;
    }

    public int getAbnormalLvl() {
        return this._abnormalLvl;
    }

    public int getAbnormalTime() {
        return this._abnormalTime;
    }

    public AbnormalVisualEffect[] getAbnormalVisualEffects() {
        return this._abnormalVisualEffects;
    }

    public boolean hasAbnormalVisualEffects() {
        return this._abnormalVisualEffects != null && this._abnormalVisualEffects.length > 0;
    }

    public AbnormalVisualEffect[] getAbnormalVisualEffectsSpecial() {
        return this._abnormalVisualEffectsSpecial;
    }

    public boolean hasAbnormalVisualEffectsSpecial() {
        return this._abnormalVisualEffectsSpecial != null && this._abnormalVisualEffectsSpecial.length > 0;
    }

    public AbnormalVisualEffect[] getAbnormalVisualEffectsEvent() {
        return this._abnormalVisualEffectsEvent;
    }

    public boolean hasAbnormalVisualEffectsEvent() {
        return this._abnormalVisualEffectsEvent != null && this._abnormalVisualEffectsEvent.length > 0;
    }

    public int getMagicLevel() {
        return this._magicLevel;
    }

    public int getLvlBonusRate() {
        return this._lvlBonusRate;
    }

    public int getActivateRate() {
        return this._activateRate;
    }

    public int getMinChance() {
        return this._minChance;
    }

    public int getMaxChance() {
        return this._maxChance;
    }

    public boolean isRemovedOnAnyActionExceptMove() {
        return this._removedOnAnyActionExceptMove;
    }

    public boolean isRemovedOnDamage() {
        return this._removedOnDamage;
    }

    public boolean isBlockedInOlympiad() {
        return this._blockedInOlympiad;
    }

    public int getChannelingSkillId() {
        return this._channelingSkillId;
    }

    public boolean nextActionIsAttack() {
        return this._nextActionIsAttack;
    }

    public int getCastRange() {
        return this._castRange;
    }

    public int getEffectRange() {
        return this._effectRange;
    }

    public int getHpConsume() {
        return this._hpConsume;
    }

    @Override
    public int getId() {
        return this._id;
    }

    public boolean isDebuff() {
        return this._isDebuff;
    }

    public final boolean isBuff() {
        return this.isContinuous() && !this.isDebuff();
    }

    public boolean isRecoveryHerb() {
        return this._isRecoveryHerb;
    }

    public int getDisplayId() {
        return this._displayId;
    }

    public int getDisplayLevel() {
        return this._displayLevel;
    }

    public BaseStats getBasicProperty() {
        return this._basicProperty;
    }

    public int getItemConsumeCount() {
        return this._itemConsumeCount;
    }

    public int getItemConsumeId() {
        return this._itemConsumeId;
    }

    public int getLevel() {
        return this._level;
    }

    public boolean isPhysical() {
        return this._magic == 0;
    }

    public boolean isMagic() {
        return this._magic == 1;
    }

    public boolean isStatic() {
        return this._magic == 2;
    }

    public boolean isDance() {
        return this._magic == 3;
    }

    public boolean isStaticReuse() {
        return this._staticReuse;
    }

    public int getMpConsume() {
        return this._mpConsume;
    }

    public int getMpInitialConsume() {
        return this._mpInitialConsume;
    }

    public int getMpPerChanneling() {
        return this._mpPerChanneling;
    }

    public String getName() {
        return this._name;
    }

    public int getReuseDelay() {
        return this._reuseDelay;
    }

    public int getReuseHashCode() {
        return this._reuseHashCode;
    }

    public int getHitTime() {
        return this._hitTime;
    }

    public int getCoolTime() {
        return this._coolTime;
    }

    public int getAffectRange() {
        return this._affectRange;
    }

    public int getAffectLimit() {
        return this._affectLimit[0] + Rnd.get(this._affectLimit[1]);
    }

    public boolean isActive() {
        return this._operateType != null && this._operateType.isActive();
    }

    public boolean isPassive() {
        return this._operateType != null && this._operateType.isPassive();
    }

    public boolean isToggle() {
        return this._operateType != null && this._operateType.isToggle();
    }

    public boolean isContinuous() {
        return this._operateType != null && this._operateType.isContinuous() || this.isSelfContinuous();
    }

    public boolean isSelfContinuous() {
        return this._operateType != null && this._operateType.isSelfContinuous();
    }

    public boolean isChanneling() {
        return this._operateType != null && this._operateType.isChanneling();
    }

    public boolean isTriggeredSkill() {
        return this._isTriggeredSkill;
    }

    public boolean isTransformation() {
        return this._abnormalType == AbnormalType.TRANSFORM;
    }

    public int getEffectPoint() {
        return this._effectPoint;
    }

    public boolean useSoulShot() {
        return this.hasEffectType(L2EffectType.PHYSICAL_ATTACK, L2EffectType.PHYSICAL_ATTACK_HP_LINK);
    }

    public boolean useSpiritShot() {
        return this._magic == 1;
    }

    public boolean useFishShot() {
        return this.hasEffectType(L2EffectType.FISHING);
    }

    public int getMinPledgeClass() {
        return this._minPledgeClass;
    }

    public boolean isHeroSkill() {
        return this._isHeroSkill;
    }

    public boolean isGMSkill() {
        return this._isGMSkill;
    }

    public boolean is7Signs() {
        return this._isSevenSigns;
    }

    public boolean isHealingPotionSkill() {
        return this.getAbnormalType() == AbnormalType.HP_RECOVER;
    }

    public int getChargeConsume() {
        return this._chargeConsume;
    }

    public int getMaxSoulConsumeCount() {
        return this._soulMaxConsume;
    }

    public int getBaseCritRate() {
        return this._baseCritRate;
    }

    public boolean getDmgDirectlyToHP() {
        return this._directHpDmg;
    }

    public FlyToLocation.FlyType getFlyType() {
        return this._flyType;
    }

    public int getFlyRadius() {
        return this._flyRadius;
    }

    public float getFlyCourse() {
        return this._flyCourse;
    }

    public boolean isStayAfterDeath() {
        return this._stayAfterDeath;
    }

    public boolean isStayOnSubclassChange() {
        return this._stayOnSubclassChange;
    }

    public boolean isBad() {
        return this._effectPoint < 0;
    }

    public boolean checkCondition(L2Character activeChar, L2Object target, boolean itemOrWeapon) {
        List<Condition> preCondition;
        if (activeChar.canOverrideCond(PcCondOverride.SKILL_CONDITIONS) && !Config.GM_SKILL_RESTRICTION) {
            return true;
        }
        List<Condition> list = preCondition = itemOrWeapon ? this._itemPreCondition : this._preCondition;
        if (preCondition == null || preCondition.isEmpty()) {
            return true;
        }
        Env env = new Env();
        env.setCharacter(activeChar);
        if (target instanceof L2Character) {
            env.setTarget((L2Character)target);
        }
        env.setSkill(this);
        for (Condition cond : preCondition) {
            if (cond.test(env)) continue;
            String msg = cond.getMessage();
            int msgId = cond.getMessageId();
            if (msgId != 0) {
                SystemMessage sm = SystemMessage.getSystemMessage(msgId);
                if (cond.isAddName()) {
                    sm.addSkillName(this._id);
                }
                activeChar.sendPacket(sm);
            } else if (msg != null) {
                activeChar.sendMessage(msg);
            }
            return false;
        }
        return true;
    }

    public L2Object[] getTargetList(L2Character activeChar, boolean onlyFirst) {
        L2Character target = null;
        L2Object objTarget = activeChar.getTarget();
        if (objTarget instanceof L2Character) {
            target = (L2Character)objTarget;
        }
        return this.getTargetList(activeChar, onlyFirst, target);
    }

    public L2Object[] getTargetList(L2Character activeChar, boolean onlyFirst, L2Character target) {
        ITargetTypeHandler handler = TargetHandler.getInstance().getHandler(this.getTargetType());
        if (handler != null) {
            try {
                return handler.getTargetList(this, activeChar, onlyFirst, target);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Exception in L2Skill.getTargetList(): " + e.getMessage(), e);
            }
        }
        activeChar.sendMessage("Target type of skill is not currently handled.");
        return EMPTY_TARGET_LIST;
    }

    public L2Object[] getTargetList(L2Character activeChar) {
        return this.getTargetList(activeChar, false);
    }

    public L2Object getFirstOfTargetList(L2Character activeChar) {
        L2Object[] targets = this.getTargetList(activeChar, true);
        if (targets.length == 0) {
            return null;
        }
        return targets[0];
    }

    public static final boolean checkForAreaOffensiveSkills(L2Character caster, L2Character target, Skill skill, boolean sourceInArena) {
        if (target == null || target.isDead() || target == caster) {
            return false;
        }
        L2PcInstance player = caster.getActingPlayer();
        L2PcInstance targetPlayer = target.getActingPlayer();
        if (player != null) {
            if (targetPlayer != null) {
                if (targetPlayer == caster || targetPlayer == player) {
                    return false;
                }
                if (targetPlayer.inObserverMode()) {
                    return false;
                }
                if (skill.isBad() && player.getSiegeState() > 0 && player.isInsideZone(ZoneId.SIEGE) && player.getSiegeState() == targetPlayer.getSiegeState() && player.getSiegeSide() == targetPlayer.getSiegeSide()) {
                    return false;
                }
                if (skill.isBad() && target.isInsideZone(ZoneId.PEACE)) {
                    return false;
                }
                if (player.isInParty() && targetPlayer.isInParty()) {
                    if (player.getParty().getLeaderObjectId() == targetPlayer.getParty().getLeaderObjectId()) {
                        return false;
                    }
                    if (player.getParty().isInCommandChannel() && player.getParty().getCommandChannel() == targetPlayer.getParty().getCommandChannel()) {
                        return false;
                    }
                }
                if (!TvTEvent.checkForTvTSkill(player, targetPlayer, skill)) {
                    return false;
                }
                if (!(sourceInArena || targetPlayer.isInsideZone(ZoneId.PVP) && !targetPlayer.isInsideZone(ZoneId.SIEGE))) {
                    if (player.getAllyId() != 0 && player.getAllyId() == targetPlayer.getAllyId()) {
                        return false;
                    }
                    if (player.getClanId() != 0 && player.getClanId() == targetPlayer.getClanId()) {
                        return false;
                    }
                    if (!player.checkPvpSkill(targetPlayer, skill)) {
                        return false;
                    }
                }
            } else if (skill.isBad() && target instanceof L2TamedBeastInstance) {
                return false;
            }
        } else if (targetPlayer == null && target instanceof L2Attackable && caster instanceof L2Attackable) {
            return false;
        }
        return Config.GEODATA <= 0 || GeoData.getInstance().canSeeTarget((L2Object)caster, target);
    }

    public static final boolean addSummon(L2Character caster, L2PcInstance owner, int radius, boolean isDead) {
        if (!owner.hasSummon()) {
            return false;
        }
        return Skill.addCharacter(caster, owner.getSummon(), radius, isDead);
    }

    public static final boolean addCharacter(L2Character caster, L2Character target, int radius, boolean isDead) {
        if (isDead != target.isDead()) {
            return false;
        }
        return radius <= 0 || Util.checkIfInRange(radius, caster, target, true);
    }

    public List<Func> getStatFuncs(AbstractEffect effect, L2Character player) {
        if (this._funcTemplates == null) {
            return Collections.emptyList();
        }
        if (!(player instanceof L2Playable) && !(player instanceof L2Attackable)) {
            return Collections.emptyList();
        }
        ArrayList<Func> funcs = new ArrayList<Func>(this._funcTemplates.size());
        Env env = new Env();
        env.setCharacter(player);
        env.setSkill(this);
        for (FuncTemplate t : this._funcTemplates) {
            Func f = t.getFunc(env, this);
            if (f == null) continue;
            funcs.add(f);
        }
        return funcs;
    }

    public List<AbstractEffect> getEffects(EffectScope effectScope) {
        return this._effectLists.get((Object)effectScope);
    }

    public boolean hasEffects(EffectScope effectScope) {
        List<AbstractEffect> effects = this._effectLists.get((Object)effectScope);
        return effects != null && !effects.isEmpty();
    }

    public void applyEffectScope(EffectScope effectScope, BuffInfo info, boolean applyInstantEffects, boolean addContinuousEffects) {
        if (effectScope != null && this.hasEffects(effectScope)) {
            for (AbstractEffect effect : this.getEffects(effectScope)) {
                if (effect == null) continue;
                if (effect.isInstant()) {
                    if (!applyInstantEffects || !effect.calcSuccess(info)) continue;
                    effect.onStart(info);
                    continue;
                }
                if (!addContinuousEffects || !effect.canStart(info)) continue;
                info.addEffect(effect);
            }
        }
    }

    public void applyEffects(L2Character effector, L2Character effected) {
        this.applyEffects(effector, null, effected, false, false, true, 0);
    }

    public void applyEffects(L2Character character) {
        this.applyEffects(character, null, character, false, false, true, 0);
    }

    @Deprecated
    public final void getEffects(L2Character effector, L2Character effected) {
        this.applyEffects(effector, effected);
    }

    public void applyEffects(L2Character effector, L2Character effected, boolean instant, int abnormalTime) {
        this.applyEffects(effector, null, effected, false, false, instant, abnormalTime);
    }

    public void applyEffects(L2Character effector, L2CubicInstance cubic, L2Character effected, boolean self, boolean passive, boolean instant, int abnormalTime) {
        BuffInfo info;
        boolean addContinuousEffects;
        if (effected == null) {
            return;
        }
        if (effector != effected && this.isBad() && (effected.isInvul() || effector.isGM() && !effector.getAccessLevel().canGiveDamage())) {
            return;
        }
        if (effected.isInvulAgainst(this.getId(), this.getLevel())) {
            effected.sendDebugMessage("Skill " + this.toString() + " has been ignored (invul against)");
            return;
        }
        Env env = new Env();
        env.setSkillMastery(Formulas.calcSkillMastery(effector, this));
        env.setCharacter(effector);
        env.setCubic(cubic);
        env.setTarget(effected);
        env.setSkill(this);
        boolean bl = addContinuousEffects = !passive && (this._operateType.isToggle() || this._operateType.isContinuous() && Formulas.calcEffectSuccess(env));
        if (!self && !passive) {
            info = new BuffInfo(env);
            if (addContinuousEffects && abnormalTime > 0) {
                info.setAbnormalTime(abnormalTime);
            }
            this.applyEffectScope(EffectScope.GENERAL, info, instant, addContinuousEffects);
            EffectScope pvpOrPveEffectScope = effector.isPlayable() && effected.isAttackable() ? EffectScope.PVE : (effector.isPlayable() && effected.isPlayable() ? EffectScope.PVP : null);
            this.applyEffectScope(pvpOrPveEffectScope, info, instant, addContinuousEffects);
            this.applyEffectScope(EffectScope.CHANNELING, info, instant, addContinuousEffects);
            if (addContinuousEffects) {
                effected.getEffectList().add(info);
            }
            if (effected.isPlayer() && effected.hasServitor() && (addContinuousEffects && this.isContinuous() && !this.isDebuff() || this.isRecoveryHerb())) {
                this.applyEffects(effector, effected.getSummon(), this.isRecoveryHerb(), 0);
            }
        }
        if (self) {
            addContinuousEffects = !passive && (this._operateType.isToggle() || (this._operateType.isContinuous() || this._operateType.isSelfContinuous()) && Formulas.calcEffectSuccess(env));
            env.setTarget(effector);
            info = new BuffInfo(env);
            if (addContinuousEffects && abnormalTime > 0) {
                info.setAbnormalTime(abnormalTime);
            }
            this.applyEffectScope(EffectScope.SELF, info, instant, addContinuousEffects);
            if (addContinuousEffects && this.hasEffectType(L2EffectType.BUFF)) {
                info.getEffector().getEffectList().add(info);
            }
            if (addContinuousEffects && info.getEffected().isPlayer() && info.getEffected().hasServitor() && this.isContinuous() && !this.isDebuff() && this.getId() != CommonSkill.SERVITOR_SHARE.getId()) {
                this.applyEffects(effector, info.getEffected().getSummon(), false, 0);
            }
        }
        if (passive) {
            env.setTarget(effector);
            info = new BuffInfo(env);
            this.applyEffectScope(EffectScope.PASSIVE, info, false, true);
            effector.getEffectList().add(info);
        }
    }

    public void activateSkill(L2Character caster, L2Object[] targets) {
        switch (this.getId()) {
            case 2616: 
            case 2617: 
            case 5852: 
            case 5853: {
                L2BlockInstance.useSkill(caster, this, targets);
                break;
            }
            case 2188: 
            case 2189: 
            case 8362: 
            case 8363: 
            case 8364: 
            case 8378: {
                L2TamedBeastInstance.useSkill(caster, this, targets);
                break;
            }
            default: {
                for (L2Character target : (L2Character[])targets) {
                    if (Formulas.calcBuffDebuffReflection(target, this)) {
                        this.applyEffects(target, caster, false, 0);
                        Env env = new Env();
                        env.setCharacter(caster);
                        env.setTarget(target);
                        env.setSkill(this);
                        BuffInfo info = new BuffInfo(env);
                        this.applyEffectScope(EffectScope.GENERAL, info, true, false);
                        EffectScope pvpOrPveEffectScope = caster.isPlayable() && target.isAttackable() ? EffectScope.PVE : (caster.isPlayable() && target.isPlayable() ? EffectScope.PVP : null);
                        this.applyEffectScope(pvpOrPveEffectScope, info, true, false);
                        this.applyEffectScope(EffectScope.CHANNELING, info, true, false);
                        continue;
                    }
                    this.applyEffects(caster, target);
                }
            }
        }
        if (this.hasEffects(EffectScope.SELF)) {
            if (caster.isAffectedBySkill(this.getId())) {
                caster.stopSkillEffects(true, this.getId());
            }
            this.applyEffects(caster, null, caster, true, false, true, 0);
        }
        if (this.useSpiritShot()) {
            caster.setChargedShot(caster.isChargedShot(ShotType.BLESSED_SPIRITSHOTS) ? ShotType.BLESSED_SPIRITSHOTS : ShotType.SPIRITSHOTS, false);
        } else if (this.useSoulShot()) {
            caster.setChargedShot(ShotType.SOULSHOTS, false);
        }
    }

    public void attach(FuncTemplate f) {
        if (this._funcTemplates == null) {
            this._funcTemplates = new ArrayList<FuncTemplate>(1);
        }
        this._funcTemplates.add(f);
    }

    public void addEffect(EffectScope effectScope, AbstractEffect effect) {
        List<AbstractEffect> effects = this._effectLists.get((Object)effectScope);
        if (effects == null) {
            effects = new ArrayList<AbstractEffect>(1);
            this._effectLists.put(effectScope, effects);
        }
        effects.add(effect);
    }

    public void attach(Condition c, boolean itemOrWeapon) {
        if (itemOrWeapon) {
            if (this._itemPreCondition == null) {
                this._itemPreCondition = new ArrayList<Condition>();
            }
            this._itemPreCondition.add(c);
        } else {
            if (this._preCondition == null) {
                this._preCondition = new ArrayList<Condition>();
            }
            this._preCondition.add(c);
        }
    }

    public String toString() {
        return "Skill " + this._name + "(" + this._id + "," + this._level + ")";
    }

    public int getFeed() {
        return this._feed;
    }

    public int getReferenceItemId() {
        return this._refId;
    }

    public String getAttributeName() {
        return this._attribute;
    }

    public int getBlowChance() {
        return this._blowChance;
    }

    public boolean ignoreShield() {
        return this._ignoreShield;
    }

    public boolean canBeDispeled() {
        return this._canBeDispeled;
    }

    public boolean canBeStolen() {
        return !this.isPassive() && !this.isToggle() && !this.isDebuff() && !this.isHeroSkill() && !this.isGMSkill() && (!this.isStatic() || this.getId() == CommonSkill.CARAVANS_SECRET_MEDICINE.getId()) && this.canBeDispeled() && this.getId() != CommonSkill.SERVITOR_SHARE.getId();
    }

    public boolean isClanSkill() {
        return this._isClanSkill;
    }

    public boolean isExcludedFromCheck() {
        return this._excludedFromCheck;
    }

    public boolean isSimultaneousCast() {
        return this._simultaneousCast;
    }

    private L2ExtractableSkill parseExtractableSkill(int skillId, int skillLvl, String values) {
        String[] prodLists = values.split(";");
        ArrayList<L2ExtractableProductItem> products = new ArrayList<L2ExtractableProductItem>();
        for (String prodList : prodLists) {
            String[] prodData = prodList.split(",");
            if (prodData.length < 3) {
                _log.warning("Extractable skills data: Error in Skill Id: " + skillId + " Level: " + skillLvl + " -> wrong seperator!");
            }
            ArrayList<ItemHolder> items = null;
            double chance = 0.0;
            int prodId = 0;
            int quantity = 0;
            int lenght = prodData.length - 1;
            try {
                items = new ArrayList<ItemHolder>(lenght / 2);
                for (int j = 0; j < lenght; ++j) {
                    prodId = Integer.parseInt(prodData[j]);
                    quantity = Integer.parseInt(prodData[++j]);
                    if (prodId <= 0 || quantity <= 0) {
                        _log.warning("Extractable skills data: Error in Skill Id: " + skillId + " Level: " + skillLvl + " wrong production Id: " + prodId + " or wrond quantity: " + quantity + "!");
                    }
                    items.add(new ItemHolder(prodId, quantity));
                }
                chance = Double.parseDouble(prodData[lenght]);
            }
            catch (Exception e) {
                _log.warning("Extractable skills data: Error in Skill Id: " + skillId + " Level: " + skillLvl + " -> incomplete/invalid production data or wrong seperator!");
            }
            products.add(new L2ExtractableProductItem(items, chance));
        }
        if (products.isEmpty()) {
            _log.warning("Extractable skills data: Error in Skill Id: " + skillId + " Level: " + skillLvl + " -> There are no production items!");
        }
        return new L2ExtractableSkill(SkillData.getSkillHashCode(skillId, skillLvl), products);
    }

    private void parseAbnormalVisualEffect(String abnormalVisualEffects) {
        if (abnormalVisualEffects != null) {
            String[] data = abnormalVisualEffects.split(";");
            ArrayList<AbnormalVisualEffect> avesEvent = null;
            ArrayList<AbnormalVisualEffect> avesSpecial = null;
            ArrayList<AbnormalVisualEffect> aves = null;
            for (String ave2 : data) {
                AbnormalVisualEffect ave = AbnormalVisualEffect.valueOf(ave2);
                if (ave == null) continue;
                if (ave.isEvent()) {
                    if (avesEvent == null) {
                        avesEvent = new ArrayList<AbnormalVisualEffect>(1);
                    }
                    avesEvent.add(ave);
                    continue;
                }
                if (ave.isSpecial()) {
                    if (avesSpecial == null) {
                        avesSpecial = new ArrayList<AbnormalVisualEffect>(1);
                    }
                    avesSpecial.add(ave);
                    continue;
                }
                if (aves == null) {
                    aves = new ArrayList<AbnormalVisualEffect>(1);
                }
                aves.add(ave);
            }
            if (avesEvent != null) {
                this._abnormalVisualEffectsEvent = avesEvent.toArray(new AbnormalVisualEffect[avesEvent.size()]);
            }
            if (avesSpecial != null) {
                this._abnormalVisualEffectsSpecial = avesSpecial.toArray(new AbnormalVisualEffect[avesSpecial.size()]);
            }
            if (aves != null) {
                this._abnormalVisualEffects = aves.toArray(new AbnormalVisualEffect[aves.size()]);
            }
        }
    }

    public L2ExtractableSkill getExtractableSkill() {
        return this._extractableItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] effectTypes() {
        if (this._effectTypes == null) {
            Skill skill = this;
            synchronized (skill) {
                if (this._effectTypes == null) {
                    List<AbstractEffect> _effects = this.getEffects(EffectScope.GENERAL);
                    byte[] effectTypes = new byte[_effects.size()];
                    Env env = new Env();
                    env.setSkill(this);
                    int i = 0;
                    for (AbstractEffect effect : _effects) {
                        if (effect == null) continue;
                        effectTypes[i++] = (byte)effect.getEffectType().ordinal();
                    }
                    if (i != effectTypes.length) {
                        effectTypes = Arrays.copyOf(effectTypes, i);
                    }
                    Arrays.sort(effectTypes);
                    this._effectTypes = effectTypes;
                }
            }
        }
        return this._effectTypes;
    }

    @Deprecated
    public boolean hasEffectType(L2EffectType ... types) {
        if (this.hasEffects(EffectScope.GENERAL) && types != null && types.length > 0) {
            byte[] effectTypes = this.effectTypes();
            for (L2EffectType type : types) {
                if (Arrays.binarySearch(effectTypes, (byte)type.ordinal()) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasEffect(L2EffectType type) {
        return Arrays.binarySearch(this.effectTypes(), (byte)type.ordinal()) >= 0;
    }

    public boolean hasEffectType(L2EffectType type1) {
        return this.hasEffects(EffectScope.GENERAL) && this.hasEffect(type1);
    }

    public boolean hasEffectType(L2EffectType type1, L2EffectType type2) {
        return this.hasEffects(EffectScope.GENERAL) && (this.hasEffect(type1) || this.hasEffect(type2));
    }

    public boolean hasEffectType(L2EffectType type1, L2EffectType type2, L2EffectType type3) {
        return this.hasEffects(EffectScope.GENERAL) && (this.hasEffect(type1) || this.hasEffect(type2) || this.hasEffect(type3));
    }

    public boolean hasEffectType(L2EffectType type1, L2EffectType type2, L2EffectType type3, L2EffectType type4) {
        return this.hasEffects(EffectScope.GENERAL) && (this.hasEffect(type1) || this.hasEffect(type2) || this.hasEffect(type3) || this.hasEffect(type4));
    }

    public boolean hasEffectType(L2EffectType type1, L2EffectType type2, L2EffectType type3, L2EffectType type4, L2EffectType type5) {
        return this.hasEffects(EffectScope.GENERAL) && (this.hasEffect(type1) || this.hasEffect(type2) || this.hasEffect(type3) || this.hasEffect(type4) || this.hasEffect(type5));
    }

    public boolean hasEffectType(L2EffectType type1, L2EffectType type2, L2EffectType type3, L2EffectType type4, L2EffectType type5, L2EffectType type6, L2EffectType type7, L2EffectType type8) {
        return this.hasEffects(EffectScope.GENERAL) && (this.hasEffect(type1) || this.hasEffect(type2) || this.hasEffect(type3) || this.hasEffect(type4) || this.hasEffect(type5) || this.hasEffect(type6) || this.hasEffect(type7) || this.hasEffect(type8));
    }

    public String getIcon() {
        return this._icon;
    }

    public int getChannelingTickInterval() {
        return this._channelingTickInterval;
    }

    public int getChannelingTickInitialDelay() {
        return this._channelingTickInitialDelay;
    }
}

