/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.skills;

import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.enums.ShotType;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillLaunched;
import com.l2jserver.gameserver.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SkillChannelizer
implements Runnable {
    private static final Logger _log = Logger.getLogger(SkillChannelizer.class.getName());
    private final L2Character _channelizer;
    private List<L2Character> _channelized;
    private Skill _skill;
    private volatile ScheduledFuture<?> _task = null;

    public SkillChannelizer(L2Character channelizer) {
        this._channelizer = channelizer;
    }

    public L2Character getChannelizer() {
        return this._channelizer;
    }

    public List<L2Character> getChannelized() {
        return this._channelized;
    }

    public boolean hasChannelized() {
        return this._channelized != null;
    }

    public void startChanneling(Skill skill) {
        if (this.isChanneling()) {
            _log.log(Level.WARNING, "Character: " + this.toString() + " is attempting to channel skill but he already does!");
            return;
        }
        this._skill = skill;
        this._task = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(this, skill.getChannelingTickInitialDelay(), skill.getChannelingTickInterval());
    }

    public void stopChanneling() {
        if (!this.isChanneling()) {
            _log.log(Level.WARNING, "Character: " + this.toString() + " is attempting to stop channel skill but he does not!");
            return;
        }
        this._task.cancel(false);
        this._task = null;
        if (this._channelized != null) {
            for (L2Character chars : this._channelized) {
                chars.getSkillChannelized().removeChannelizer(this._skill.getChannelingSkillId(), this.getChannelizer());
            }
            this._channelized = null;
        }
        this._skill = null;
    }

    public Skill getSkill() {
        return this._skill;
    }

    public boolean isChanneling() {
        return this._task != null;
    }

    @Override
    public void run() {
        if (!this.isChanneling()) {
            return;
        }
        try {
            if (this._skill.getMpPerChanneling() > 0) {
                if (this._channelizer.getCurrentMp() < (double)this._skill.getMpPerChanneling()) {
                    if (this._channelizer.isPlayer()) {
                        this._channelizer.sendPacket(SystemMessageId.SKILL_REMOVED_DUE_LACK_MP);
                    }
                    this._channelizer.abortCast();
                    return;
                }
                this._channelizer.reduceCurrentMp(this._skill.getMpPerChanneling());
            }
            if (this._skill.getChannelingSkillId() > 0) {
                Skill baseSkill = SkillData.getInstance().getSkill(this._skill.getChannelingSkillId(), 1);
                if (baseSkill == null) {
                    _log.log(Level.WARNING, this.getClass().getSimpleName() + ": skill " + this._skill + " couldn't find effect id skill: " + this._skill.getChannelingSkillId() + " !");
                    this._channelizer.abortCast();
                    return;
                }
                ArrayList<L2Character> targetList = new ArrayList<L2Character>();
                for (L2Object chars : this._skill.getTargetList(this._channelizer)) {
                    if (!chars.isCharacter()) continue;
                    targetList.add((L2Character)chars);
                    ((L2Character)chars).getSkillChannelized().addChannelizer(this._skill.getChannelingSkillId(), this.getChannelizer());
                }
                if (targetList.isEmpty()) {
                    return;
                }
                this._channelized = targetList;
                for (L2Character character : this._channelized) {
                    if (!Util.checkIfInRange(this._skill.getEffectRange(), this._channelizer, character, true) || !GeoData.getInstance().canSeeTarget((L2Object)this._channelizer, character)) continue;
                    int maxSkillLevel = SkillData.getInstance().getMaxLevel(this._skill.getChannelingSkillId());
                    int skillLevel = Math.min(character.getSkillChannelized().getChannerlizersSize(this._skill.getChannelingSkillId()), maxSkillLevel);
                    BuffInfo info = character.getEffectList().getBuffInfoBySkillId(this._skill.getChannelingSkillId());
                    if (info == null || info.getSkill().getLevel() < skillLevel) {
                        Skill skill = SkillData.getInstance().getSkill(this._skill.getChannelingSkillId(), skillLevel);
                        if (skill == null) {
                            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Non existent channeling skill requested: " + this._skill);
                            this._channelizer.abortCast();
                            return;
                        }
                        if (character.isPlayable() && this.getChannelizer().isPlayer()) {
                            ((L2PcInstance)this.getChannelizer()).updatePvPStatus(character);
                        }
                        skill.applyEffects(this.getChannelizer(), character);
                        if (this._skill.useSpiritShot()) {
                            this._channelizer.setChargedShot(this._channelizer.isChargedShot(ShotType.BLESSED_SPIRITSHOTS) ? ShotType.BLESSED_SPIRITSHOTS : ShotType.SPIRITSHOTS, false);
                        } else {
                            this._channelizer.setChargedShot(ShotType.SOULSHOTS, false);
                        }
                        this._channelizer.rechargeShots(this._skill.useSoulShot(), this._skill.useSpiritShot());
                    }
                    this._channelizer.broadcastPacket(new MagicSkillLaunched(this._channelizer, this._skill.getId(), this._skill.getLevel(), character));
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while channelizing skill: " + this._skill + " channelizer: " + this._channelizer + " channelized: " + this._channelized, e);
        }
    }
}

