/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.skills.funcs;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.WeaponType;
import com.l2jserver.gameserver.model.skills.funcs.Func;
import com.l2jserver.gameserver.model.stats.Env;
import com.l2jserver.gameserver.model.stats.Stats;

public class FuncEnchant
extends Func {
    public FuncEnchant(Stats pStat, int pOrder, Object owner, double value) {
        super(pStat, pOrder, owner, value);
    }

    @Override
    public void calc(Env env) {
        L2PcInstance player;
        if (this.cond != null && !this.cond.test(env)) {
            return;
        }
        L2ItemInstance item = (L2ItemInstance)this.funcOwner;
        int enchant = item.getEnchantLevel();
        if (enchant <= 0) {
            return;
        }
        int overenchant = 0;
        if (enchant > 3) {
            overenchant = enchant - 3;
            enchant = 3;
        }
        if (env.getPlayer() != null && (player = env.getPlayer()).isInOlympiadMode() && Config.ALT_OLY_ENCHANT_LIMIT >= 0 && enchant + overenchant > Config.ALT_OLY_ENCHANT_LIMIT) {
            if (Config.ALT_OLY_ENCHANT_LIMIT > 3) {
                overenchant = Config.ALT_OLY_ENCHANT_LIMIT - 3;
            } else {
                overenchant = 0;
                enchant = Config.ALT_OLY_ENCHANT_LIMIT;
            }
        }
        if (this.stat == Stats.MAGIC_DEFENCE || this.stat == Stats.POWER_DEFENCE) {
            env.addValue(enchant + 3 * overenchant);
            return;
        }
        if (this.stat == Stats.MAGIC_ATTACK) {
            switch (item.getItem().getItemGradeSPlus()) {
                case S: {
                    env.addValue(4 * enchant + 8 * overenchant);
                    break;
                }
                case A: 
                case B: 
                case C: {
                    env.addValue(3 * enchant + 6 * overenchant);
                    break;
                }
                case D: 
                case NONE: {
                    env.addValue(2 * enchant + 4 * overenchant);
                }
            }
            return;
        }
        if (item.isWeapon()) {
            WeaponType type = (WeaponType)item.getItemType();
            block5 : switch (item.getItem().getItemGradeSPlus()) {
                case S: {
                    if (item.getWeaponItem().getBodyPart() == 16384) {
                        if (type == WeaponType.BOW || type == WeaponType.CROSSBOW) {
                            env.addValue(10 * enchant + 20 * overenchant);
                            break;
                        }
                        env.addValue(6 * enchant + 12 * overenchant);
                        break;
                    }
                    env.addValue(5 * enchant + 10 * overenchant);
                    break;
                }
                case A: {
                    if (item.getWeaponItem().getBodyPart() == 16384) {
                        if (type == WeaponType.BOW || type == WeaponType.CROSSBOW) {
                            env.addValue(8 * enchant + 16 * overenchant);
                            break;
                        }
                        env.addValue(5 * enchant + 10 * overenchant);
                        break;
                    }
                    env.addValue(4 * enchant + 8 * overenchant);
                    break;
                }
                case B: 
                case C: {
                    if (item.getWeaponItem().getBodyPart() == 16384) {
                        if (type == WeaponType.BOW || type == WeaponType.CROSSBOW) {
                            env.addValue(6 * enchant + 12 * overenchant);
                            break;
                        }
                        env.addValue(4 * enchant + 8 * overenchant);
                        break;
                    }
                    env.addValue(3 * enchant + 6 * overenchant);
                    break;
                }
                case D: 
                case NONE: {
                    switch (type) {
                        case BOW: 
                        case CROSSBOW: {
                            env.addValue(4 * enchant + 8 * overenchant);
                            break block5;
                        }
                    }
                    env.addValue(2 * enchant + 4 * overenchant);
                }
            }
        }
    }
}

